/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.attribution.CheckJetifierBuildService;
import com.android.build.gradle.internal.component.TestComponentCreationConfig;
import com.android.build.gradle.internal.component.TestFixturesCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.CheckJetifierTask;
import com.android.build.gradle.internal.tasks.ConfigurationAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalGlobalTask;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.internal.variant.ComponentInfo;
import com.android.build.gradle.options.BooleanOption;
import com.android.buildanalyzer.common.CheckJetifierProjectResult;
import com.android.buildanalyzer.common.DependencyPath;
import com.android.buildanalyzer.common.FullDependencyPath;
import com.android.buildanalyzer.common.TaskCategory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.VERIFICATION)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0011H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckJetifierTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalGlobalTask;", "()V", "checkJetifierBuildService", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/attribution/CheckJetifierBuildService;", "getCheckJetifierBuildService", "()Lorg/gradle/api/provider/Property;", "configurationToResolveFirst", "Lorg/gradle/api/provider/ListProperty;", "", "getConfigurationToResolveFirst", "()Lorg/gradle/api/provider/ListProperty;", "jetifierEnabled", "", "getJetifierEnabled", "detect", "Lcom/android/buildanalyzer/common/CheckJetifierProjectResult;", "doTaskAction", "", "reportToConsole", "result", "CreationAction", "gradle-core"})
public abstract class CheckJetifierTask
extends NonIncrementalGlobalTask {
    @Internal
    @NotNull
    public abstract Property<Boolean> getJetifierEnabled();

    @Internal
    @NotNull
    public abstract Property<CheckJetifierBuildService> getCheckJetifierBuildService();

    @Internal
    @NotNull
    public abstract ListProperty<String> getConfigurationToResolveFirst();

    @Override
    protected void doTaskAction() {
        if (!((Boolean)this.getJetifierEnabled().get()).booleanValue()) {
            this.getLogger().quiet("Skipping '" + this.getPath() + "' task as Jetifier is already disabled (" + BooleanOption.ENABLE_JETIFIER.getPropertyName() + "=false).");
            return;
        }
        CheckJetifierProjectResult result2 = this.detect();
        this.reportToConsole(result2);
        ((CheckJetifierBuildService)this.getCheckJetifierBuildService().get()).addResult(result2);
    }

    /*
     * WARNING - void declaration
     */
    private final CheckJetifierProjectResult detect() {
        void $this$partition$iv;
        LinkedHashMap<String, FullDependencyPath> dependenciesDependingOnSupportLibs = new LinkedHashMap<String, FullDependencyPath>();
        List resolveFirstNames = (List)this.getConfigurationToResolveFirst().get();
        ConfigurationContainer configurationContainer = this.getProject().getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
        Iterable iterable = CollectionsKt.toList((Iterable)((Iterable)configurationContainer));
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            Configuration it = (Configuration)element$iv;
            boolean bl = false;
            if (resolveFirstNames.contains(it.getName())) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List handleFirst = (List)pair.component1();
        List theRest = (List)pair.component2();
        Function1 handler2 = (Function1)new Function1<Configuration, Unit>(dependenciesDependingOnSupportLibs, this){
            final /* synthetic */ LinkedHashMap<String, FullDependencyPath> $dependenciesDependingOnSupportLibs;
            final /* synthetic */ CheckJetifierTask this$0;
            {
                this.$dependenciesDependingOnSupportLibs = $dependenciesDependingOnSupportLibs;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Configuration configuration) {
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                for (DependencyPath pathToSupportLib : new ConfigurationAnalyzer(configuration).findPathsToSupportLibs()) {
                    String directDependency = (String)CollectionsKt.first(pathToSupportLib.getElements());
                    this.$dependenciesDependingOnSupportLibs.computeIfAbsent(directDependency, new Function(this.this$0, configuration, pathToSupportLib){
                        final /* synthetic */ CheckJetifierTask this$0;
                        final /* synthetic */ Configuration $configuration;
                        final /* synthetic */ DependencyPath $pathToSupportLib;
                        {
                            this.this$0 = $receiver;
                            this.$configuration = $configuration;
                            this.$pathToSupportLib = $pathToSupportLib;
                        }

                        @NotNull
                        public final FullDependencyPath apply(@NotNull String it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            String string = this.this$0.getProject().getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.path");
                            String string2 = this.$configuration.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"configuration.name");
                            return new FullDependencyPath(string, string2, this.$pathToSupportLib);
                        }
                    });
                }
            }
        };
        Iterable $this$forEach$iv = handleFirst;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Configuration it = (Configuration)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            handler2.invoke((Object)it);
        }
        $this$forEach$iv = theRest;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Configuration it = (Configuration)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            handler2.invoke((Object)it);
        }
        return new CheckJetifierProjectResult(dependenciesDependingOnSupportLibs);
    }

    private final void reportToConsole(CheckJetifierProjectResult result2) {
        if (result2.isEmpty()) {
            this.getLogger().quiet("Project '" + this.getProject().getPath() + "' does not use any legacy support libraries. If this is the case for all other projects, you can disable Jetifier by setting " + BooleanOption.ENABLE_JETIFIER.getPropertyName() + "=false in gradle.properties.");
        } else {
            this.getLogger().quiet("The following libraries used by project '" + this.getProject().getPath() + "' depend on legacy support libraries. To disable Jetifier, you will need to use AndroidX-supported versions of these libraries.");
            this.getLogger().quiet("\t" + StringsKt.replace$default((String)result2.getDisplayString(), (String)"\n", (String)"\n\t", (boolean)false, (int)4, null));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BM\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckJetifierTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/CheckJetifierTask;", "creationConfig", "Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;", "checkJetifierBuildService", "Lorg/gradle/api/provider/Provider;", "Lcom/android/build/gradle/internal/attribution/CheckJetifierBuildService;", "variants", "", "Lcom/android/build/gradle/internal/variant/ComponentInfo;", "testComponents", "Lcom/android/build/gradle/internal/component/TestComponentCreationConfig;", "testFixturesComponents", "Lcom/android/build/gradle/internal/component/TestFixturesCreationConfig;", "(Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;Lorg/gradle/api/provider/Provider;Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Collection;)V", "configurationsToResolveFirst", "", "", "kotlin.jvm.PlatformType", "name", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "gradle-core"})
    public static final class CreationAction
    extends GlobalTaskCreationAction<CheckJetifierTask> {
        @NotNull
        private final Provider<CheckJetifierBuildService> checkJetifierBuildService;
        @NotNull
        private final String name;
        @NotNull
        private final Class<CheckJetifierTask> type;
        @NotNull
        private final List<String> configurationsToResolveFirst;

        /*
         * WARNING - void declaration
         */
        public CreationAction(@NotNull GlobalTaskCreationConfig creationConfig, @NotNull Provider<CheckJetifierBuildService> checkJetifierBuildService, @NotNull Collection<? extends ComponentInfo<?, ?>> variants, @NotNull Collection<? extends TestComponentCreationConfig> testComponents, @NotNull Collection<? extends TestFixturesCreationConfig> testFixturesComponents) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Collection<VariantDependencies> collection;
            Object it;
            Collection collection2;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            Intrinsics.checkNotNullParameter(checkJetifierBuildService, (String)"checkJetifierBuildService");
            Intrinsics.checkNotNullParameter(variants, (String)"variants");
            Intrinsics.checkNotNullParameter(testComponents, (String)"testComponents");
            Intrinsics.checkNotNullParameter(testFixturesComponents, (String)"testFixturesComponents");
            super(creationConfig);
            this.checkJetifierBuildService = checkJetifierBuildService;
            this.name = "checkJetifier";
            this.type = CheckJetifierTask.class;
            Iterable iterable = variants;
            CreationAction creationAction = this;
            boolean $i$f$map = false;
            void var8_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ComponentInfo componentInfo = (ComponentInfo)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(((ComponentInfo)it).getVariant().getVariantDependencies());
            }
            $this$map$iv = testComponents;
            collection2 = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (TestComponentCreationConfig)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getVariantDependencies());
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = testFixturesComponents;
            collection2 = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (TestFixturesCreationConfig)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getVariantDependencies());
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
            boolean $i$f$flatMap = false;
            $this$mapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (VariantDependencies)element$iv$iv;
                boolean bl = false;
                Object[] objectArray = new String[]{((VariantDependencies)it).getCompileClasspath().getName(), ((VariantDependencies)it).getRuntimeClasspath().getName()};
                Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            creationAction.configurationsToResolveFirst = (List)destination$iv$iv;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<CheckJetifierTask> getType() {
            return this.type;
        }

        @Override
        public void configure(@NotNull CheckJetifierTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((BaseTask)task);
            task.setDescription("Checks whether Jetifier is needed for the current project");
            task.setGroup("verification");
            HasConfigurableValuesKt.setDisallowChanges(task.getJetifierEnabled(), this.creationConfig.getServices().getProjectOptions().get(BooleanOption.ENABLE_JETIFIER));
            HasConfigurableValuesKt.setDisallowChanges(task.getCheckJetifierBuildService(), this.checkJetifierBuildService);
            HasConfigurableValuesKt.setDisallowChanges(task.getConfigurationToResolveFirst(), (Iterable)this.configurationsToResolveFirst);
            task.getOutputs().upToDateWhen((Spec)configure.1.INSTANCE);
            task.notCompatibleWithConfigurationCache("See https://buganizer.corp.google.com/issues/219099391");
        }
    }
}

