/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.JdkImageTransformDelegateKt;
import com.android.build.gradle.internal.dependency.JdkTools;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0003J\r\u0010\u0013\u001a\u00020\u0003H\u0001\u00a2\u0006\u0002\b\u0014J\r\u0010\u0015\u001a\u00020\u0003H\u0001\u00a2\u0006\u0002\b\u0016J\r\u0010\u0017\u001a\u00020\u0003H\u0001\u00a2\u0006\u0002\b\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/android/build/gradle/internal/dependency/JdkImageTransformDelegate;", "", "systemModulesJar", "Ljava/io/File;", "workDir", "outDir", "jdkTools", "Lcom/android/build/gradle/internal/dependency/JdkTools;", "<init>", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;Lcom/android/build/gradle/internal/dependency/JdkTools;)V", "getSystemModulesJar", "()Ljava/io/File;", "getWorkDir", "getOutDir", "getJdkTools", "()Lcom/android/build/gradle/internal/dependency/JdkTools;", "run", "", "makeModuleDescriptorJava", "makeModuleInfoClass", "makeModuleInfoClass$gradle_core", "makeModuleJar", "makeModuleJar$gradle_core", "makeJmodFile", "makeJmodFile$gradle_core", "gradle-core"})
public final class JdkImageTransformDelegate {
    @NotNull
    private final File systemModulesJar;
    @NotNull
    private final File workDir;
    @NotNull
    private final File outDir;
    @NotNull
    private final JdkTools jdkTools;

    public JdkImageTransformDelegate(@NotNull File systemModulesJar, @NotNull File workDir, @NotNull File outDir, @NotNull JdkTools jdkTools) {
        Intrinsics.checkNotNullParameter((Object)systemModulesJar, (String)"systemModulesJar");
        Intrinsics.checkNotNullParameter((Object)workDir, (String)"workDir");
        Intrinsics.checkNotNullParameter((Object)outDir, (String)"outDir");
        Intrinsics.checkNotNullParameter((Object)jdkTools, (String)"jdkTools");
        this.systemModulesJar = systemModulesJar;
        this.workDir = workDir;
        this.outDir = outDir;
        this.jdkTools = jdkTools;
    }

    @NotNull
    public final File getSystemModulesJar() {
        return this.systemModulesJar;
    }

    @NotNull
    public final File getWorkDir() {
        return this.workDir;
    }

    @NotNull
    public final File getOutDir() {
        return this.outDir;
    }

    @NotNull
    public final JdkTools getJdkTools() {
        return this.jdkTools;
    }

    public final void run() {
        Preconditions.checkArgument((!this.outDir.exists() && this.outDir.getParentFile().isDirectory() ? 1 : 0) != 0);
        File jmodFile = this.makeJmodFile$gradle_core();
        File jmodDir = jmodFile.getParentFile();
        Intrinsics.checkNotNull((Object)jmodDir);
        this.jdkTools.linkJmodsIntoJdkImage(jmodDir, "java.base", this.outDir);
        JdkImageTransformDelegateKt.access$copyJrtFsJar(this.outDir, this.jdkTools);
    }

    @NotNull
    public final File makeModuleDescriptorJava() {
        String moduleInfoJavaContent = JdkImageTransformDelegateKt.generateModuleDescriptor("java.base", CollectionsKt.listOf((Object)this.systemModulesJar));
        File moduleInfoJava = FilesKt.resolve((File)this.workDir, (String)"module-info.java");
        FileUtils.writeToFile((File)moduleInfoJava, (String)moduleInfoJavaContent);
        return moduleInfoJava;
    }

    @VisibleForTesting
    @NotNull
    public final File makeModuleInfoClass$gradle_core() {
        File moduleInfoJava = this.makeModuleDescriptorJava();
        this.jdkTools.compileModuleDescriptor(moduleInfoJava, this.systemModulesJar, this.workDir);
        File moduleInfoClass = FilesKt.resolve((File)this.workDir, (String)"module-info.class");
        Preconditions.checkState((boolean)moduleInfoClass.exists(), (String)"Expected compiled module descriptor file to be created at %s", (Object)moduleInfoClass);
        return moduleInfoClass;
    }

    @VisibleForTesting
    @NotNull
    public final File makeModuleJar$gradle_core() {
        File moduleInfoClass = this.makeModuleInfoClass$gradle_core();
        File moduleJar = FilesKt.resolve((File)this.workDir, (String)"module.jar");
        JdkImageTransformDelegateKt.createJar(moduleInfoClass, CollectionsKt.listOf((Object)this.systemModulesJar), moduleJar);
        return moduleJar;
    }

    @VisibleForTesting
    @NotNull
    public final File makeJmodFile$gradle_core() {
        String moduleName = "java.base";
        String jlinkVersion2 = this.jdkTools.getJlinkVersion();
        File jmodDir = FilesKt.resolve((File)this.workDir, (String)"jmod");
        FileUtils.mkdirs((File)jmodDir);
        String[] stringArray = new String[]{moduleName + ".jmod"};
        File jmodFile = FileUtils.join((File)jmodDir, (String[])stringArray);
        File moduleJar = this.makeModuleJar$gradle_core();
        Intrinsics.checkNotNull((Object)jmodFile);
        this.jdkTools.createJmodFromModularJar(jmodFile, jlinkVersion2, moduleJar);
        return jmodFile;
    }
}

