/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.GenericTransformParameters;
import com.android.builder.testing.MockableJarGenerator;
import java.io.File;
import java.io.IOException;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;

@CacheableTransform
public abstract class MockableJarTransform
implements TransformAction<Parameters> {
    @Classpath
    @InputArtifact
    public abstract Provider<FileSystemLocation> getInputArtifact();

    public void transform(TransformOutputs transformOutputs) {
        File input = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
        File outputFile = transformOutputs.file((Object)input.getName());
        Logging.getLogger(MockableJarTransform.class).info("Calling mockable JAR artifact transform to create file: " + outputFile.getAbsolutePath() + " with input " + input.getAbsolutePath());
        MockableJarGenerator generator = new MockableJarGenerator(((Boolean)((Parameters)this.getParameters()).getReturnDefaultValues().get()).booleanValue());
        try {
            generator.createMockableJar(input, outputFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create mockable android.jar", e);
        }
    }

    public static interface Parameters
    extends GenericTransformParameters {
        @Input
        public Property<Boolean> getReturnDefaultValues();
    }
}

