/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.gradle.internal.ide.dependencies.LibraryUtils;
import com.android.build.gradle.internal.lint.ProjectKey;
import com.android.build.gradle.internal.lint.ProjectKeyKt;
import com.android.build.gradle.internal.lint.ProjectSourceSetKey;
import java.io.File;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u0007H\u0000\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u0007H\u0000\u00a8\u0006\u000b"}, d2={"asProjectKey", "Lcom/android/build/gradle/internal/lint/ProjectKey;", "artifact", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "asProjectKeyedMap", "", "Ljava/io/File;", "Lorg/gradle/api/artifacts/ArtifactCollection;", "asProjectSourceSetKey", "Lcom/android/build/gradle/internal/lint/ProjectSourceSetKey;", "asProjectSourceSetKeyedMap", "gradle-core"})
public final class ProjectKeyKt {
    @NotNull
    public static final ProjectKey asProjectKey(@NotNull ResolvedArtifactResult artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        ComponentIdentifier componentIdentifier = artifact.getId().getComponentIdentifier();
        Intrinsics.checkNotNull((Object)componentIdentifier, (String)"null cannot be cast to non-null type org.gradle.api.artifacts.component.ProjectComponentIdentifier");
        ProjectComponentIdentifier id = (ProjectComponentIdentifier)componentIdentifier;
        String string = id.getBuild().getBuildPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBuildPath(...)");
        String string2 = id.getProjectPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProjectPath(...)");
        return new ProjectKey(string, string2, LibraryUtils.getVariantName(artifact));
    }

    @NotNull
    public static final Map<ProjectKey, File> asProjectKeyedMap(@NotNull ArtifactCollection $this$asProjectKeyedMap) {
        Intrinsics.checkNotNullParameter((Object)$this$asProjectKeyedMap, (String)"<this>");
        Set set = $this$asProjectKeyedMap.getArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getArtifacts(...)");
        return MapsKt.toMap((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)set), (Function1)asProjectKeyedMap.1.INSTANCE));
    }

    @NotNull
    public static final ProjectSourceSetKey asProjectSourceSetKey(@NotNull ResolvedArtifactResult artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        ComponentIdentifier componentIdentifier = artifact.getId().getComponentIdentifier();
        Intrinsics.checkNotNull((Object)componentIdentifier, (String)"null cannot be cast to non-null type org.gradle.api.artifacts.component.ProjectComponentIdentifier");
        ProjectComponentIdentifier id = (ProjectComponentIdentifier)componentIdentifier;
        String string = id.getBuild().getBuildPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBuildPath(...)");
        String string2 = id.getProjectPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProjectPath(...)");
        return new ProjectSourceSetKey(string, string2, LibraryUtils.getVariantName(artifact), LibraryUtils.hasProjectTestFixturesCapability(artifact));
    }

    @NotNull
    public static final Map<ProjectSourceSetKey, File> asProjectSourceSetKeyedMap(@NotNull ArtifactCollection $this$asProjectSourceSetKeyedMap) {
        Intrinsics.checkNotNullParameter((Object)$this$asProjectSourceSetKeyedMap, (String)"<this>");
        Set set = $this$asProjectSourceSetKeyedMap.getArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getArtifacts(...)");
        return MapsKt.toMap((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)set), (Function1)asProjectSourceSetKeyedMap.1.INSTANCE));
    }
}

