/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ndk;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.configure.NdkAbiFile;
import com.android.build.gradle.internal.cxx.configure.NdkAbiFileKt;
import com.android.build.gradle.internal.cxx.configure.PlatformConfigurator;
import com.android.build.gradle.internal.ndk.AbiInfo;
import com.android.build.gradle.internal.ndk.DefaultNdkInfo;
import com.android.build.gradle.internal.ndk.NdkInfo;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.repository.Revision;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.gradle.api.InvalidUserDataException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J\u0010\u0010\"\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011H\u0014J\u0010\u0010$\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\u0010\u0010%\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\u0010\u0010&\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J\u0010\u00102\u001a\u0002002\u0006\u00103\u001a\u000204H\u0016J\u0018\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u0002002\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\n\u00107\u001a\u0004\u0018\u00010\u0011H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eRP\u0010\u000f\u001aB\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011 \u0012* \u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u001b\u0010\u001d\u001a\u00020\u00118DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001e\u0010\u001fR\"\u0010'\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u000eR\"\u0010)\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u000eR\"\u0010+\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u000eR\"\u0010-\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u000eR\u001a\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u000e\u00a8\u00068"}, d2={"Lcom/android/build/gradle/internal/ndk/DefaultNdkInfo;", "Lcom/android/build/gradle/internal/ndk/NdkInfo;", "rootDirectory", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "getRootDirectory", "()Ljava/io/File;", "platformConfigurator", "Lcom/android/build/gradle/internal/cxx/configure/PlatformConfigurator;", "abiInfoList", "", "Lcom/android/build/gradle/internal/ndk/AbiInfo;", "getAbiInfoList", "()Ljava/util/List;", "defaultToolchainVersions", "Ljava/util/HashMap;", "", "kotlin.jvm.PlatformType", "Ljava/util/HashMap;", "findSuitablePlatformVersion", "", "abi", "androidVersion", "Lcom/android/sdklib/AndroidVersion;", "ignoreMinSdkVersionFromDsl", "", "ignoreMinSdkVersionFromProperty", "getToolchainPrefix", "hostTag", "getHostTag", "()Ljava/lang/String;", "hostTag$delegate", "Lkotlin/Lazy;", "getToolchainPath", "getToolchainAbi", "getStripExecutable", "getObjcopyExecutable", "getDefaultToolchainVersion", "default32BitsAbis", "getDefault32BitsAbis", "defaultAbis", "getDefaultAbis", "supported32BitsAbis", "getSupported32BitsAbis", "supportedAbis", "getSupportedAbis", "supportedStls", "Lcom/android/build/gradle/internal/ndk/Stl;", "getSupportedStls", "getDefaultStl", "buildSystem", "Lcom/android/build/gradle/tasks/NativeBuildSystem;", "getStlSharedObjectFile", "stl", "validate", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nDefaultNdkInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultNdkInfo.kt\ncom/android/build/gradle/internal/ndk/DefaultNdkInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,240:1\n626#2,12:241\n626#2,12:253\n626#2,12:265\n*S KotlinDebug\n*F\n+ 1 DefaultNdkInfo.kt\ncom/android/build/gradle/internal/ndk/DefaultNdkInfo\n*L\n56#1:241,12\n115#1:253,12\n124#1:265,12\n*E\n"})
public class DefaultNdkInfo
implements NdkInfo {
    @NotNull
    private final File rootDirectory;
    @NotNull
    private final PlatformConfigurator platformConfigurator;
    @NotNull
    private final List<AbiInfo> abiInfoList;
    private final HashMap<String, String> defaultToolchainVersions;
    @NotNull
    private final Lazy hostTag$delegate;
    @NotNull
    private final List<Stl> supportedStls;

    public DefaultNdkInfo(@NotNull File rootDirectory) {
        Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
        this.rootDirectory = rootDirectory;
        this.platformConfigurator = new PlatformConfigurator(this.rootDirectory);
        this.abiInfoList = new NdkAbiFile(NdkAbiFileKt.ndkMetaAbisFile(this.rootDirectory)).getAbiInfoList();
        this.defaultToolchainVersions = Maps.newHashMap();
        this.hostTag$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ DefaultNdkInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final String invoke() {
                Object v3;
                List checkDirs;
                block4: {
                    void $this$mapTo$iv$iv;
                    String string = System.getProperty("os.name");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
                    String string2 = string;
                    Locale locale = Locale.ENGLISH;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                    String string3 = string2.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                    String osName = string3;
                    String osType = StringsKt.contains$default((CharSequence)osName, (CharSequence)"windows", (boolean)false, (int)2, null) ? "windows" : (StringsKt.contains$default((CharSequence)osName, (CharSequence)"mac", (boolean)false, (int)2, null) ? "darwin" : "linux");
                    Object[] objectArray = new String[]{osType + "-x86_64"};
                    List checkTags = CollectionsKt.mutableListOf((Object[])objectArray);
                    if (Intrinsics.areEqual((Object)osType, (Object)"windows")) {
                        checkTags.add("windows");
                    }
                    File prebuiltBase = FilesKt.resolve((File)this.this$0.getRootDirectory(), (String)"prebuilt");
                    Iterable $this$map$iv = checkTags;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string4 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(FilesKt.resolve((File)prebuiltBase, (String)it));
                    }
                    checkDirs = (List)destination$iv$iv;
                    iterable = checkTags;
                    for (T t : iterable) {
                        String it = (String)t;
                        boolean bl = false;
                        if (!FilesKt.resolve((File)prebuiltBase, (String)it).isDirectory()) continue;
                        v3 = t;
                        break block4;
                    }
                    v3 = null;
                }
                String string = v3;
                if (string == null) {
                    throw new InvalidUserDataException("Could not determine NDK host architecture. None of the following directories exist: " + CollectionsKt.joinToString$default((Iterable)checkDirs, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
                }
                return string;
            }
        }));
        this.supportedStls = ArraysKt.toList((Object[])Stl.values());
    }

    @NotNull
    protected final File getRootDirectory() {
        return this.rootDirectory;
    }

    @NotNull
    public final List<AbiInfo> getAbiInfoList() {
        return this.abiInfoList;
    }

    @Override
    public int findSuitablePlatformVersion(@NotNull String abi, @Nullable AndroidVersion androidVersion, @Nullable Object ignoreMinSdkVersionFromDsl, @Nullable String ignoreMinSdkVersionFromProperty) {
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        return this.platformConfigurator.findSuitablePlatformVersion(abi, this.abiInfoList, androidVersion, ignoreMinSdkVersionFromDsl, ignoreMinSdkVersionFromProperty);
    }

    private final String getToolchainPrefix(String abi) {
        String string;
        String string2 = abi;
        if (Intrinsics.areEqual((Object)string2, (Object)Abi.X86.getTag())) {
            string = "x86";
        } else if (Intrinsics.areEqual((Object)string2, (Object)Abi.X86_64.getTag())) {
            string = "x86_64";
        } else {
            Iterable $this$single$iv = this.abiInfoList;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                AbiInfo it = (AbiInfo)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)abi)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            string = ((AbiInfo)single$iv).getTriple();
        }
        return string;
    }

    @NotNull
    protected final String getHostTag() {
        Lazy lazy = this.hostTag$delegate;
        return (String)lazy.getValue();
    }

    private final File getToolchainPath(String abi) {
        String toolchainAbi = this.getToolchainAbi(abi);
        String it = this.getDefaultToolchainVersion(toolchainAbi);
        boolean bl = false;
        Object version = ((CharSequence)it).length() == 0 ? "" : "-" + it;
        File prebuiltFolder = FilesKt.resolve((File)this.rootDirectory, (String)("toolchains/" + this.getToolchainPrefix(toolchainAbi) + (String)version + "/prebuilt/" + this.getHostTag()));
        if (!prebuiltFolder.isDirectory()) {
            throw new InvalidUserDataException("Toolchain directory does not exist: " + prebuiltFolder);
        }
        return prebuiltFolder;
    }

    @NotNull
    protected String getToolchainAbi(@NotNull String abi) {
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        return abi;
    }

    @Override
    @NotNull
    public File getStripExecutable(@NotNull String abi) {
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        String toolchainAbi = this.getToolchainAbi(abi);
        Iterable $this$single$iv = this.abiInfoList;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            AbiInfo info2 = (AbiInfo)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)info2.getName(), (Object)toolchainAbi)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        String triple = ((AbiInfo)single$iv).getTriple();
        String[] stringArray = new String[]{"bin", triple + "-strip"};
        File file = FileUtils.join((File)this.getToolchainPath(toolchainAbi), (String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"join(...)");
        return file;
    }

    @Override
    @NotNull
    public File getObjcopyExecutable(@NotNull String abi) {
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        String toolchainAbi = this.getToolchainAbi(abi);
        Iterable $this$single$iv = this.abiInfoList;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            AbiInfo info2 = (AbiInfo)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)info2.getName(), (Object)toolchainAbi)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        String triple = ((AbiInfo)single$iv).getTriple();
        String[] stringArray = new String[]{"bin", triple + "-objcopy"};
        File file = FileUtils.join((File)this.getToolchainPath(toolchainAbi), (String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"join(...)");
        return file;
    }

    private final String getDefaultToolchainVersion(String abi) {
        String toolchainAbi = this.getToolchainAbi(abi);
        String defaultVersion = this.defaultToolchainVersions.get(toolchainAbi);
        if (defaultVersion != null) {
            return defaultVersion;
        }
        File toolchains = new File(this.rootDirectory, "toolchains");
        String toolchainPrefix = this.getToolchainPrefix(toolchainAbi);
        Object[] toolchainsForAbi2 = toolchains.listFiles(new FilenameFilter(toolchainPrefix){
            final /* synthetic */ String $toolchainPrefix;
            {
                this.$toolchainPrefix = $toolchainPrefix;
            }

            public final boolean accept(File file, String filename) {
                Intrinsics.checkNotNull((Object)filename);
                return StringsKt.startsWith$default((String)filename, (String)this.$toolchainPrefix, (boolean)false, (int)2, null);
            }
        });
        if (toolchainsForAbi2 == null || toolchainsForAbi2.length == 0) {
            throw new RuntimeException("No toolchains found in the NDK toolchains folder for ABI with prefix: " + toolchainPrefix);
        }
        Revision bestRevision = null;
        String bestVersionString = "";
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])toolchainsForAbi2);
        while (iterator2.hasNext()) {
            File toolchainFolder = (File)iterator2.next();
            String folderName = toolchainFolder.getName();
            Revision revision = new Revision(0);
            String versionString = "";
            if (folderName.length() > toolchainPrefix.length() + 1) {
                try {
                    Intrinsics.checkNotNull((Object)folderName);
                    String string = folderName.substring(toolchainPrefix.length() + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    versionString = string;
                    revision = Revision.parseRevision((String)versionString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (bestRevision != null && revision.compareTo(bestRevision) <= 0) continue;
            bestRevision = revision;
            bestVersionString = versionString;
        }
        HashMap<String, String> hashMap = this.defaultToolchainVersions;
        Intrinsics.checkNotNullExpressionValue(hashMap, (String)"defaultToolchainVersions");
        ((Map)hashMap).put(toolchainAbi, bestVersionString);
        return bestVersionString;
    }

    @NotNull
    public List<String> getDefault32BitsAbis() {
        Function1 function1 = default32BitsAbis.1.INSTANCE;
        Predicate predicate2 = new Predicate(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ boolean test(Object p0) {
                return (Boolean)this.function.invoke(p0);
            }
        };
        function1 = default32BitsAbis.2.INSTANCE;
        Stream stream2 = this.abiInfoList.stream().filter(predicate2).map(new Function(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object apply(Object p0) {
                return this.function.invoke(p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue(stream2, (String)"map(...)");
        return StreamsKt.toList(stream2);
    }

    @NotNull
    public List<String> getDefaultAbis() {
        Function1 function1 = defaultAbis.1.INSTANCE;
        Predicate predicate2 = new /* invalid duplicate definition of identical inner class */;
        function1 = defaultAbis.2.INSTANCE;
        Stream stream2 = this.abiInfoList.stream().filter(predicate2).map(new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue(stream2, (String)"map(...)");
        return StreamsKt.toList(stream2);
    }

    @NotNull
    public List<String> getSupported32BitsAbis() {
        Function1 function1 = supported32BitsAbis.1.INSTANCE;
        Predicate predicate2 = new /* invalid duplicate definition of identical inner class */;
        function1 = supported32BitsAbis.2.INSTANCE;
        Stream stream2 = this.abiInfoList.stream().filter(predicate2).map(new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue(stream2, (String)"map(...)");
        return StreamsKt.toList(stream2);
    }

    @NotNull
    public List<String> getSupportedAbis() {
        Function1 function1 = supportedAbis.1.INSTANCE;
        Stream stream2 = this.abiInfoList.stream().map(new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue(stream2, (String)"map(...)");
        return StreamsKt.toList(stream2);
    }

    @NotNull
    public List<Stl> getSupportedStls() {
        return this.supportedStls;
    }

    @Override
    @NotNull
    public Stl getDefaultStl(@NotNull NativeBuildSystem buildSystem) {
        Stl stl;
        Intrinsics.checkNotNullParameter((Object)((Object)buildSystem), (String)"buildSystem");
        switch (WhenMappings.$EnumSwitchMapping$0[buildSystem.ordinal()]) {
            case 1: {
                stl = Stl.GNUSTL_STATIC;
                break;
            }
            case 2: {
                stl = Stl.SYSTEM;
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf((Object)buildSystem).toString());
            }
        }
        return stl;
    }

    @Override
    @NotNull
    public File getStlSharedObjectFile(@NotNull Stl stl, @NotNull String abi) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)stl), (String)"stl");
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        switch (WhenMappings.$EnumSwitchMapping$1[stl.ordinal()]) {
            case 1: {
                string = "sources/cxx-stl/llvm-libc++";
                break;
            }
            case 2: {
                string = "sources/cxx-stl/gnu-libstdc++/4.9";
                break;
            }
            case 3: {
                string = "sources/cxx-stl/stlport";
                break;
            }
            default: {
                throw new RuntimeException("Unexpected STL for packaging: " + stl);
            }
        }
        File stlBasePath = FilesKt.resolve((File)this.rootDirectory, (String)string);
        File file = FilesKt.resolve((File)stlBasePath, (String)("libs/" + abi + "/" + stl.getLibraryName()));
        Preconditions.checkState((boolean)file.isFile(), (String)("Expected NDK STL shared object file at " + file), (Object[])new Object[0]);
        return file;
    }

    @Override
    @Nullable
    public String validate() {
        File platformsDir = FilesKt.resolve((File)this.rootDirectory, (String)"platforms");
        if (!platformsDir.isDirectory()) {
            return platformsDir + " is not a directory.";
        }
        File toolchainsDir = FilesKt.resolve((File)this.rootDirectory, (String)"toolchains");
        if (!toolchainsDir.isDirectory()) {
            return toolchainsDir + " is not a directory.";
        }
        return null;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[NativeBuildSystem.values().length];
            try {
                nArray[NativeBuildSystem.CMAKE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NativeBuildSystem.NDK_BUILD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Stl.values().length];
            try {
                nArray[Stl.LIBCXX_SHARED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Stl.GNUSTL_SHARED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Stl.STLPORT_SHARED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

