/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.ProjectInfo;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.LintModelMetadataTask;
import com.android.build.gradle.internal.tasks.LintModelMetadataTaskKt;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.utils.FileUtils;
import com.google.common.io.Files;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.LINT, secondaryTaskCategories={TaskCategory.METADATA})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/android/build/gradle/internal/tasks/LintModelMetadataTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "<init>", "()V", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "mavenGroupId", "Lorg/gradle/api/provider/Property;", "", "getMavenGroupId", "()Lorg/gradle/api/provider/Property;", "mavenArtifactId", "getMavenArtifactId", "mavenVersion", "getMavenVersion", "doTaskAction", "", "configureForStandalone", "project", "Lorg/gradle/api/Project;", "configureForStandalone$gradle_core", "CreationAction", "Companion", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nLintModelMetadataTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintModelMetadataTask.kt\ncom/android/build/gradle/internal/tasks/LintModelMetadataTask\n+ 2 buildServices.kt\ncom/android/build/gradle/internal/services/BuildServicesKt\n*L\n1#1,140:1\n78#2:141\n*S KotlinDebug\n*F\n+ 1 LintModelMetadataTask.kt\ncom/android/build/gradle/internal/tasks/LintModelMetadataTask\n*L\n104#1:141\n*E\n"})
public abstract class LintModelMetadataTask
extends NonIncrementalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    @Input
    @NotNull
    public abstract Property<String> getMavenGroupId();

    @Input
    @NotNull
    public abstract Property<String> getMavenArtifactId();

    @Input
    @NotNull
    public abstract Property<String> getMavenVersion();

    @Override
    protected void doTaskAction() {
        File lintModelMetadataFile = ((RegularFile)this.getOutputFile().get()).getAsFile();
        FileUtils.deleteIfExists((File)lintModelMetadataFile);
        Files.createParentDirs((File)lintModelMetadataFile);
        Intrinsics.checkNotNull((Object)lintModelMetadataFile);
        Object object = this.getMavenGroupId().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String string = (String)object;
        Object object2 = this.getMavenArtifactId().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        String string2 = (String)object2;
        Object object3 = this.getMavenVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        LintModelMetadataTaskKt.writeLintModelMetadataFile(lintModelMetadataFile, string, string2, (String)object3);
    }

    public final void configureForStandalone$gradle_core(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.setGroup("verification");
        this.setVariantName("");
        Property property = this.getAnalyticsService();
        BuildServiceRegistry buildServiceRegistry = project.getGradle().getSharedServices();
        Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"getSharedServices(...)");
        BuildServiceRegistry buildServiceRegistry$iv = buildServiceRegistry;
        boolean $i$f$getBuildService = false;
        HasConfigurableValuesKt.setDisallowChanges(property, BuildServicesKt.getBuildService(buildServiceRegistry$iv, AnalyticsService.class));
        HasConfigurableValuesKt.setDisallowChanges(this.getMavenGroupId(), project.getGroup().toString());
        HasConfigurableValuesKt.setDisallowChanges(this.getMavenArtifactId(), project.getName());
        HasConfigurableValuesKt.setDisallowChanges(this.getMavenVersion(), project.getVersion().toString());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/tasks/LintModelMetadataTask$Companion;", "", "<init>", "()V", "registerOutputArtifacts", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/android/build/gradle/internal/tasks/LintModelMetadataTask;", "artifacts", "Lcom/android/build/api/artifact/impl/ArtifactsImpl;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public final void registerOutputArtifacts(@NotNull TaskProvider<LintModelMetadataTask> taskProvider, @NotNull ArtifactsImpl artifacts2) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            Intrinsics.checkNotNullParameter((Object)artifacts2, (String)"artifacts");
            artifacts2.setInitialProvider(taskProvider, (Function1)registerOutputArtifacts.1.INSTANCE).withName("lint-model-metadata.properties").on(InternalArtifactType.LINT_MODEL_METADATA.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/tasks/LintModelMetadataTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/LintModelMetadataTask;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "creationConfig", "<init>", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "configure", "task", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<LintModelMetadataTask, ComponentCreationConfig> {
        public CreationAction(@NotNull ComponentCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig, false, 2, null);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("write", "LintModelMetadata");
        }

        @Override
        @NotNull
        public Class<LintModelMetadataTask> getType() {
            return LintModelMetadataTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<LintModelMetadataTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            Companion.registerOutputArtifacts(taskProvider, this.creationConfig.getArtifacts());
        }

        @Override
        public void configure(@NotNull LintModelMetadataTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            ProjectInfo projectInfo = this.creationConfig.getServices().getProjectInfo();
            HasConfigurableValuesKt.setDisallowChanges(task.getMavenGroupId(), projectInfo.getGroup());
            HasConfigurableValuesKt.setDisallowChanges(task.getMavenArtifactId(), projectInfo.getName());
            HasConfigurableValuesKt.setDisallowChanges(task.getMavenVersion(), projectInfo.getVersion());
        }
    }
}

