/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.gradle.internal.tasks.CheckAarMetadataWorkAction;
import com.android.repository.Revision;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003\u001a4\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002\"\u000e\u0010\u000f\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"checkDesugarJdkVariant", "", "variantFromAar", "", "variantFromConsumer", "errorMessages", "", "dependency", "projectPath", "checkDesugarJdkVersion", "versionFromAar", "versionFromConsumer", "parseDesugarJdkVariant", "Lcom/android/build/gradle/internal/tasks/CheckAarMetadataWorkAction$DesugarJdkVariant;", "variant", "DESUGAR_JDK_LIBS_MINIMAL", "DESUGAR_JDK_LIBS", "DESUGAR_JDK_LIBS_NIO", "gradle-core"})
public final class AarMetadataCheckKt {
    @NotNull
    public static final String DESUGAR_JDK_LIBS_MINIMAL = "desugar_jdk_libs_minimal";
    @NotNull
    public static final String DESUGAR_JDK_LIBS = "desugar_jdk_libs";
    @NotNull
    public static final String DESUGAR_JDK_LIBS_NIO = "desugar_jdk_libs_nio";

    public static final void checkDesugarJdkVariant(@NotNull String variantFromAar, @NotNull String variantFromConsumer, @NotNull List<String> errorMessages, @NotNull String dependency, @NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)variantFromAar, (String)"variantFromAar");
        Intrinsics.checkNotNullParameter((Object)variantFromConsumer, (String)"variantFromConsumer");
        Intrinsics.checkNotNullParameter(errorMessages, (String)"errorMessages");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        CheckAarMetadataWorkAction.DesugarJdkVariant parsedVariantFromAar = AarMetadataCheckKt.parseDesugarJdkVariant(variantFromAar);
        CheckAarMetadataWorkAction.DesugarJdkVariant parsedVariantFromConsumer = AarMetadataCheckKt.parseDesugarJdkVariant(variantFromConsumer);
        if (parsedVariantFromAar.getSize() > parsedVariantFromConsumer.getSize()) {
            errorMessages.add(StringsKt.trimIndent((String)("\n                        Dependency '" + dependency + "' requires desugar_jdk_libs flavor to be at least\n                        " + variantFromAar + " for " + projectPath + ", which is currently " + variantFromConsumer + "\n\n                        See https://d.android.com/r/tools/api-desugaring-flavors\n                        for more details.\n                    ")));
        }
    }

    public static final void checkDesugarJdkVersion(@NotNull String versionFromAar, @NotNull String versionFromConsumer, @NotNull List<String> errorMessages, @NotNull String dependency, @NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)versionFromAar, (String)"versionFromAar");
        Intrinsics.checkNotNullParameter((Object)versionFromConsumer, (String)"versionFromConsumer");
        Intrinsics.checkNotNullParameter(errorMessages, (String)"errorMessages");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Revision parsedVersionFromAar = Revision.parseRevision((String)versionFromAar);
        Revision parsedVersionFromConsumer = Revision.parseRevision((String)versionFromConsumer);
        if (parsedVersionFromAar.compareTo(parsedVersionFromConsumer) > 0) {
            errorMessages.add(StringsKt.trimIndent((String)("\n                        Dependency '" + dependency + "' requires desugar_jdk_libs version to be\n                        " + versionFromAar + " or above for " + projectPath + ", which is currently " + versionFromConsumer + "\n\n                        See https://d.android.com/studio/build/library-desugaring for more\n                        details.\n                    ")));
        }
    }

    private static final CheckAarMetadataWorkAction.DesugarJdkVariant parseDesugarJdkVariant(String variant) {
        CheckAarMetadataWorkAction.DesugarJdkVariant desugarJdkVariant;
        switch (variant) {
            case "desugar_jdk_libs_minimal": {
                desugarJdkVariant = CheckAarMetadataWorkAction.DesugarJdkVariant.MINIMAL;
                break;
            }
            case "desugar_jdk_libs": {
                desugarJdkVariant = CheckAarMetadataWorkAction.DesugarJdkVariant.BASIC;
                break;
            }
            case "desugar_jdk_libs_nio": {
                desugarJdkVariant = CheckAarMetadataWorkAction.DesugarJdkVariant.NIO;
                break;
            }
            default: {
                throw new RuntimeException("Failed to parse desugar_jdk_libs variant from desugarJdkLib property of AAR metadata: unknown variant");
            }
        }
        return desugarJdkVariant;
    }
}

