/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.variant.ApkInstallGroup;
import com.android.build.api.variant.ApkOutput;
import com.android.build.api.variant.DeviceSpec;
import com.android.build.api.variant.impl.VariantApiExtensionsKt;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.component.features.NativeBuildCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.utils.ApkSources;
import com.android.build.gradle.internal.utils.DefaultDeviceApkOutput;
import com.android.build.gradle.internal.utils.DeviceApkOutput;
import com.android.build.gradle.internal.utils.PrivacySandboxApkSources;
import com.android.build.gradle.internal.utils.ViaBundleDeviceApkOutput;
import com.android.build.gradle.options.BooleanOption;
import com.android.sdklib.AndroidVersion;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskInputs;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/android/build/gradle/internal/utils/DefaultApkOutput;", "Lcom/android/build/api/variant/ApkOutput;", "variant", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "deviceSpec", "Lcom/android/build/api/variant/DeviceSpec;", "<init>", "(Lcom/android/build/gradle/internal/component/VariantCreationConfig;Lcom/android/build/api/variant/DeviceSpec;)V", "getDeviceSpec", "()Lcom/android/build/api/variant/DeviceSpec;", "deviceApkOutput", "Lcom/android/build/gradle/internal/utils/DeviceApkOutput;", "apkInstallGroups", "", "Lcom/android/build/api/variant/ApkInstallGroup;", "getApkInstallGroups", "()Ljava/util/List;", "setInputs", "", "inputs", "Lorg/gradle/api/tasks/TaskInputs;", "getApkSources", "Lcom/android/build/gradle/internal/utils/ApkSources;", "privacySandboxApks", "Lorg/gradle/api/file/FileCollection;", "getPrivacySandboxApkSources", "Lcom/android/build/gradle/internal/utils/PrivacySandboxApkSources;", "gradle-core"})
public final class DefaultApkOutput
implements ApkOutput {
    @NotNull
    private final DeviceSpec deviceSpec;
    @NotNull
    private final DeviceApkOutput deviceApkOutput;

    public DefaultApkOutput(@NotNull VariantCreationConfig variant, @NotNull DeviceSpec deviceSpec) {
        DeviceApkOutput deviceApkOutput;
        boolean useViaBundleFlow;
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)deviceSpec, (String)"deviceSpec");
        this.deviceSpec = deviceSpec;
        boolean skipApksViaBundle = variant.getServices().getProjectOptions().get(BooleanOption.SKIP_APKS_VIA_BUNDLE_IF_POSSIBLE);
        boolean hasDynamicFeatures = variant.getGlobal().getHasDynamicFeatures();
        AndroidVersion minSdk2 = VariantApiExtensionsKt.toSharedAndroidVersion(variant.getMinSdk());
        String variantName = variant.getBaseName();
        String projectPath = variant.getServices().getProjectInfo().getPath();
        FileCollection privacySandboxApks = VariantDependencies.getArtifactFileCollection$default(variant.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.ANDROID_PRIVACY_SANDBOX_EXTRACTED_SDK_APKS, null, 8, null);
        boolean bl = useViaBundleFlow = !skipApksViaBundle || hasDynamicFeatures;
        if (useViaBundleFlow) {
            Provider apkBundle = variant.getArtifacts().get(InternalArtifactType.APKS_FROM_BUNDLE.INSTANCE);
            deviceApkOutput = new ViaBundleDeviceApkOutput(apkBundle, minSdk2, privacySandboxApks, variantName, projectPath, null, 32, null);
        } else {
            NativeBuildCreationConfig nativeBuildCreationConfig2 = variant.getNativeBuildCreationConfig();
            Set<String> supportedAbis2 = nativeBuildCreationConfig2 != null ? nativeBuildCreationConfig2.getSupportedAbis() : null;
            deviceApkOutput = new DefaultDeviceApkOutput(this.getApkSources(variant, privacySandboxApks), supportedAbis2, minSdk2, variantName, projectPath, null, 32, null);
        }
        this.deviceApkOutput = deviceApkOutput;
    }

    @NotNull
    public final DeviceSpec getDeviceSpec() {
        return this.deviceSpec;
    }

    @NotNull
    public List<ApkInstallGroup> getApkInstallGroups() {
        return this.deviceApkOutput.getApks(this.deviceSpec);
    }

    public final void setInputs(@NotNull TaskInputs inputs) {
        Intrinsics.checkNotNullParameter((Object)inputs, (String)"inputs");
        this.deviceApkOutput.setInputs(inputs, this.deviceSpec);
    }

    private final ApkSources getApkSources(VariantCreationConfig variant, FileCollection privacySandboxApks) {
        PrivacySandboxApkSources privacySandboxApkSources = this.getPrivacySandboxApkSources(variant, privacySandboxApks);
        return new ApkSources(variant.getArtifacts().get((SingleArtifact)SingleArtifact.APK.INSTANCE), privacySandboxApkSources.getPrivacySandboxSdksApksFiles(), privacySandboxApkSources.getAdditionalSupportedSdkApkSplits(), privacySandboxApkSources.getPrivacySandboxSdkSplitApksForLegacy(), variant.getArtifacts().get(InternalArtifactType.DEX_METADATA_DIRECTORY.INSTANCE));
    }

    private final PrivacySandboxApkSources getPrivacySandboxApkSources(VariantCreationConfig variant, FileCollection privacySandboxApks) {
        return new PrivacySandboxApkSources(privacySandboxApks, variant.getArtifacts().get(InternalArtifactType.USES_SDK_LIBRARY_SPLIT_FOR_LOCAL_DEPLOYMENT.INSTANCE), variant.getArtifacts().get(InternalArtifactType.EXTRACTED_SDK_APKS.INSTANCE));
    }
}

