/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.gradle.internal.lint.LintMode;
import com.android.build.gradle.internal.lint.SystemPropertyInputs;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Transformer;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\bR\u0014\u0010\u0015\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\bR\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\bR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\bR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\bR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\b\u00a8\u0006'"}, d2={"Lcom/android/build/gradle/internal/lint/SystemPropertyInputs;", "", "<init>", "()V", "androidLintLogJarProblems", "Lorg/gradle/api/provider/Property;", "", "getAndroidLintLogJarProblems", "()Lorg/gradle/api/provider/Property;", "javaHome", "getJavaHome", "javaVersion", "getJavaVersion", "lintApiDatabase", "Lorg/gradle/api/file/RegularFileProperty;", "getLintApiDatabase", "()Lorg/gradle/api/file/RegularFileProperty;", "lintAutofix", "getLintAutofix", "lintBaselinesContinue", "getLintBaselinesContinue", "lintConfigurationOverride", "getLintConfigurationOverride", "lintHtmlPrefs", "getLintHtmlPrefs", "lintNullnessIgnoreDeprecated", "getLintNullnessIgnoreDeprecated", "lintUnusedResourcesExcludeTests", "getLintUnusedResourcesExcludeTests", "lintUnusedResourcesIncludeTests", "getLintUnusedResourcesIncludeTests", "userHome", "getUserHome", "initialize", "", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "lintMode", "Lcom/android/build/gradle/internal/lint/LintMode;", "gradle-core"})
public abstract class SystemPropertyInputs {
    @Input
    @Optional
    @NotNull
    public abstract Property<String> getAndroidLintLogJarProblems();

    @Internal
    @NotNull
    public abstract Property<String> getJavaHome();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getJavaVersion();

    @InputFile
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @Optional
    @NotNull
    public abstract RegularFileProperty getLintApiDatabase();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getLintAutofix();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getLintBaselinesContinue();

    @InputFile
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @Optional
    @NotNull
    public abstract RegularFileProperty getLintConfigurationOverride();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getLintHtmlPrefs();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getLintNullnessIgnoreDeprecated();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getLintUnusedResourcesExcludeTests();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getLintUnusedResourcesIncludeTests();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getUserHome();

    public final void initialize(@NotNull ProviderFactory providerFactory, @NotNull LintMode lintMode) {
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        Intrinsics.checkNotNullParameter((Object)((Object)lintMode), (String)"lintMode");
        if (lintMode == LintMode.ANALYSIS) {
            this.getLintAutofix().disallowChanges();
            this.getLintBaselinesContinue().disallowChanges();
            this.getLintHtmlPrefs().disallowChanges();
            this.getUserHome().disallowChanges();
        } else {
            Property<String> property = this.getLintAutofix();
            Provider provider2 = providerFactory.systemProperty("lint.autofix");
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"systemProperty(...)");
            HasConfigurableValuesKt.setDisallowChanges(property, provider2);
            Property<String> property2 = this.getLintBaselinesContinue();
            Provider provider3 = providerFactory.systemProperty("lint.baselines.continue");
            Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"systemProperty(...)");
            HasConfigurableValuesKt.setDisallowChanges(property2, provider3);
            Property<String> property3 = this.getLintHtmlPrefs();
            Provider provider4 = providerFactory.systemProperty("lint.html.prefs");
            Intrinsics.checkNotNullExpressionValue((Object)provider4, (String)"systemProperty(...)");
            HasConfigurableValuesKt.setDisallowChanges(property3, provider4);
            Property<String> property4 = this.getUserHome();
            Provider provider5 = providerFactory.systemProperty("user.home");
            Intrinsics.checkNotNullExpressionValue((Object)provider5, (String)"systemProperty(...)");
            HasConfigurableValuesKt.setDisallowChanges(property4, provider5);
        }
        Property<String> property = this.getAndroidLintLogJarProblems();
        Provider provider6 = providerFactory.systemProperty("android.lint.log-jar-problems");
        Intrinsics.checkNotNullExpressionValue((Object)provider6, (String)"systemProperty(...)");
        HasConfigurableValuesKt.setDisallowChanges(property, provider6);
        Property<String> property5 = this.getJavaHome();
        Provider provider7 = providerFactory.systemProperty("java.home");
        Intrinsics.checkNotNullExpressionValue((Object)provider7, (String)"systemProperty(...)");
        HasConfigurableValuesKt.setDisallowChanges(property5, provider7);
        Property<String> property6 = this.getJavaVersion();
        Provider provider8 = providerFactory.systemProperty("java.version");
        Intrinsics.checkNotNullExpressionValue((Object)provider8, (String)"systemProperty(...)");
        HasConfigurableValuesKt.setDisallowChanges(property6, provider8);
        this.getLintApiDatabase().fileProvider(providerFactory.systemProperty("LINT_API_DATABASE").map((Transformer)initialize.1.INSTANCE).filter((Spec)initialize.2.INSTANCE));
        this.getLintApiDatabase().disallowChanges();
        this.getLintConfigurationOverride().fileProvider(providerFactory.systemProperty("lint.configuration.override").map((Transformer)initialize.3.INSTANCE).filter((Spec)initialize.4.INSTANCE));
        this.getLintConfigurationOverride().disallowChanges();
        Property<String> property7 = this.getLintNullnessIgnoreDeprecated();
        Provider provider9 = providerFactory.systemProperty("lint.nullness.ignore-deprecated");
        Intrinsics.checkNotNullExpressionValue((Object)provider9, (String)"systemProperty(...)");
        HasConfigurableValuesKt.setDisallowChanges(property7, provider9);
        Property<String> property8 = this.getLintUnusedResourcesExcludeTests();
        Provider provider10 = providerFactory.systemProperty("lint.unused-resources.exclude-tests");
        Intrinsics.checkNotNullExpressionValue((Object)provider10, (String)"systemProperty(...)");
        HasConfigurableValuesKt.setDisallowChanges(property8, provider10);
        Property<String> property9 = this.getLintUnusedResourcesIncludeTests();
        Provider provider11 = providerFactory.systemProperty("lint.unused-resources.include-tests");
        Intrinsics.checkNotNullExpressionValue((Object)provider11, (String)"systemProperty(...)");
        HasConfigurableValuesKt.setDisallowChanges(property9, provider11);
    }
}

