/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.variant.ApkInstallGroup;
import com.android.build.api.variant.ApkOutput;
import com.android.build.api.variant.DeviceSpec;
import com.android.build.api.variant.impl.DynamicFeatureVariantImpl;
import com.android.build.api.variant.impl.VariantApiExtensionsKt;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.component.DynamicFeatureCreationConfig;
import com.android.build.gradle.internal.component.features.NativeBuildCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.utils.DefaultDeviceApkOutput;
import com.android.build.gradle.internal.utils.DeviceApkOutput;
import com.android.build.gradle.internal.utils.ViaBundleDeviceApkOutput;
import com.android.builder.internal.InstallUtils;
import com.android.sdklib.AndroidVersion;
import com.android.utils.ILogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.ClasspathNormalizer;
import org.gradle.api.tasks.TaskInputs;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lcom/android/build/gradle/internal/utils/DynamicFeatureApkOutput;", "Lcom/android/build/api/variant/ApkOutput;", "variant", "Lcom/android/build/gradle/internal/component/DynamicFeatureCreationConfig;", "deviceSpec", "Lcom/android/build/api/variant/DeviceSpec;", "<init>", "(Lcom/android/build/gradle/internal/component/DynamicFeatureCreationConfig;Lcom/android/build/api/variant/DeviceSpec;)V", "getDeviceSpec", "()Lcom/android/build/api/variant/DeviceSpec;", "minSdkVersion", "Lcom/android/sdklib/AndroidVersion;", "projectPath", "", "variantName", "bundleFile", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "privacySandboxSdkApks", "Lorg/gradle/api/file/FileCollection;", "viaBundleDeviceApkOutput", "Lcom/android/build/gradle/internal/utils/DeviceApkOutput;", "supportedAbis", "", "logger", "Lorg/gradle/api/logging/Logger;", "iLogger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "mainApkArtifact", "Lorg/gradle/api/file/Directory;", "setInputs", "", "inputs", "Lorg/gradle/api/tasks/TaskInputs;", "apkInstallGroups", "", "Lcom/android/build/api/variant/ApkInstallGroup;", "getApkInstallGroups", "()Ljava/util/List;", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nDynamicFeatureApkOutput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamicFeatureApkOutput.kt\ncom/android/build/gradle/internal/utils/DynamicFeatureApkOutput\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1557#2:87\n1628#2,3:88\n*S KotlinDebug\n*F\n+ 1 DynamicFeatureApkOutput.kt\ncom/android/build/gradle/internal/utils/DynamicFeatureApkOutput\n*L\n79#1:87\n79#1:88,3\n*E\n"})
public final class DynamicFeatureApkOutput
implements ApkOutput {
    @NotNull
    private final DeviceSpec deviceSpec;
    @NotNull
    private final AndroidVersion minSdkVersion;
    @NotNull
    private final String projectPath;
    @NotNull
    private final String variantName;
    @NotNull
    private final Provider<RegularFile> bundleFile;
    @NotNull
    private final FileCollection privacySandboxSdkApks;
    @NotNull
    private final DeviceApkOutput viaBundleDeviceApkOutput;
    @Nullable
    private final Set<String> supportedAbis;
    @NotNull
    private final Logger logger;
    @NotNull
    private final LoggerWrapper iLogger;
    @NotNull
    private final Provider<Directory> mainApkArtifact;

    public DynamicFeatureApkOutput(@NotNull DynamicFeatureCreationConfig variant, @NotNull DeviceSpec deviceSpec) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)deviceSpec, (String)"deviceSpec");
        this.deviceSpec = deviceSpec;
        this.minSdkVersion = VariantApiExtensionsKt.toSharedAndroidVersion(variant.getMinSdk());
        this.projectPath = variant.getServices().getProjectInfo().getPath();
        this.variantName = variant.getBaseName();
        this.privacySandboxSdkApks = VariantDependencies.getArtifactFileCollection$default(variant.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.PROVIDED_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.ANDROID_PRIVACY_SANDBOX_EXTRACTED_SDK_APKS, null, 8, null);
        NativeBuildCreationConfig nativeBuildCreationConfig2 = variant.getNativeBuildCreationConfig();
        this.supportedAbis = nativeBuildCreationConfig2 != null ? nativeBuildCreationConfig2.getSupportedAbis() : null;
        Logger logger = Logging.getLogger(DynamicFeatureVariantImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.iLogger = new LoggerWrapper(this.logger);
        this.mainApkArtifact = variant.getArtifacts().get((SingleArtifact)SingleArtifact.APK.INSTANCE);
        FileCollection apkBundles = VariantDependencies.getArtifactCollection$default(variant.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.APKS_FROM_BUNDLE, null, 8, null).getArtifactFiles();
        Provider provider2 = apkBundles.getElements().map((Transformer)1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"map(...)");
        this.bundleFile = provider2;
        this.viaBundleDeviceApkOutput = new ViaBundleDeviceApkOutput(this.bundleFile, this.minSdkVersion, this.privacySandboxSdkApks, this.variantName, this.projectPath, null, 32, null);
    }

    @NotNull
    public final DeviceSpec getDeviceSpec() {
        return this.deviceSpec;
    }

    public final void setInputs(@NotNull TaskInputs inputs) {
        Intrinsics.checkNotNullParameter((Object)inputs, (String)"inputs");
        Object[] objectArray = new Object[]{this.mainApkArtifact, this.bundleFile, this.privacySandboxSdkApks};
        inputs.files(objectArray).withNormalizer(ClasspathNormalizer.class);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ApkInstallGroup> getApkInstallGroups() {
        List installGroups = new ArrayList();
        List<ApkInstallGroup> baseApkInstallGroup = this.viaBundleDeviceApkOutput.getApks(this.deviceSpec);
        installGroups.addAll((Collection)baseApkInstallGroup);
        if (InstallUtils.checkDeviceApiLevel((String)this.deviceSpec.getName(), (int)this.deviceSpec.getApiLevel(), (String)this.deviceSpec.getCodeName(), (AndroidVersion)this.minSdkVersion, (ILogger)this.iLogger, (String)this.projectPath, (String)this.variantName)) {
            void $this$mapTo$iv$iv;
            Object object = this.mainApkArtifact.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            List<File> apkFiles2 = DefaultDeviceApkOutput.Companion.getMainApks((Directory)object, this.supportedAbis, this.deviceSpec);
            Iterable $this$map$iv = apkFiles2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((RegularFile)new RegularFile((File)it){
                    final /* synthetic */ File $it;
                    {
                        this.$it = $it;
                    }

                    public final File getAsFile() {
                        return this.$it;
                    }
                });
            }
            String string = "Dynamic feature Apk Group";
            List list = (List)destination$iv$iv;
            DefaultDeviceApkOutput.DefaultApkInstallGroup featureApkInstallGroup2 = new DefaultDeviceApkOutput.DefaultApkInstallGroup(list, string);
            installGroups.add(featureApkInstallGroup2);
        }
        return installGroups;
    }
}

