/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.Version;
import com.android.build.api.dsl.Lint;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.lint.AndroidLintInputs;
import com.android.build.gradle.internal.lint.LintMode;
import com.android.build.gradle.internal.lint.LintOptionsInput;
import com.android.build.gradle.internal.lint.ProjectInputs;
import com.android.build.gradle.internal.lint.VariantWithTests;
import com.android.build.gradle.internal.privaysandboxsdk.PrivacySandboxSdkVariantScope;
import com.android.build.gradle.internal.scope.ProjectInfo;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.ide.common.repository.AgpVersion;
import com.android.tools.lint.model.DefaultLintModelMavenName;
import com.android.tools.lint.model.DefaultLintModelModule;
import com.android.tools.lint.model.LintModelLintOptions;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelModuleType;
import com.android.utils.FileUtils;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0000\u00a2\u0006\u0002\b<J\u001d\u00106\u001a\u0002072\u0006\u0010=\u001a\u00020>2\u0006\u0010:\u001a\u00020;H\u0000\u00a2\u0006\u0002\b<J\u001d\u00106\u001a\u0002072\u0006\u0010?\u001a\u00020@2\u0006\u0010:\u001a\u00020;H\u0000\u00a2\u0006\u0002\b<J-\u0010A\u001a\u0002072\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010:\u001a\u00020;H\u0000\u00a2\u0006\u0002\bHJ\u0018\u0010I\u001a\u0002072\u0006\u0010J\u001a\u00020K2\u0006\u0010:\u001a\u00020;H\u0002J\r\u0010L\u001a\u00020MH\u0000\u00a2\u0006\u0002\bNJ\u0010\u0010O\u001a\u0002072\u0006\u0010J\u001a\u00020KH\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\bR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\bR\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\bR\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\bR\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\bR\u0014\u0010\u001a\u001a\u00020\u001b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\bR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060!8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\bR\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\bR\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\bR\u0014\u00100\u001a\u00020%8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010'R\u0014\u00102\u001a\u0002038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u0006P"}, d2={"Lcom/android/build/gradle/internal/lint/ProjectInputs;", "", "<init>", "()V", "projectDirectoryPath", "Lorg/gradle/api/provider/Property;", "", "getProjectDirectoryPath", "()Lorg/gradle/api/provider/Property;", "projectDirectoryPathInput", "getProjectDirectoryPathInput", "projectGradlePath", "getProjectGradlePath", "projectType", "Lcom/android/tools/lint/model/LintModelModuleType;", "getProjectType", "mavenGroupId", "getMavenGroupId", "mavenArtifactId", "getMavenArtifactId", "mavenVersion", "getMavenVersion", "buildDirectoryPath", "getBuildDirectoryPath", "buildDirectoryPathInput", "getBuildDirectoryPathInput", "lintOptions", "Lcom/android/build/gradle/internal/lint/LintOptionsInput;", "getLintOptions", "()Lcom/android/build/gradle/internal/lint/LintOptionsInput;", "resourcePrefix", "getResourcePrefix", "dynamicFeatures", "Lorg/gradle/api/provider/ListProperty;", "getDynamicFeatures", "()Lorg/gradle/api/provider/ListProperty;", "bootClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getBootClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "javaSourceLevel", "Lorg/gradle/api/JavaVersion;", "getJavaSourceLevel", "compileTarget", "getCompileTarget", "neverShrinking", "", "getNeverShrinking", "lintConfigFiles", "getLintConfigFiles", "buildFile", "Lorg/gradle/api/file/RegularFileProperty;", "getBuildFile", "()Lorg/gradle/api/file/RegularFileProperty;", "initialize", "", "variant", "Lcom/android/build/gradle/internal/lint/VariantWithTests;", "lintMode", "Lcom/android/build/gradle/internal/lint/LintMode;", "initialize$gradle_core", "creationConfig", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "variantScope", "Lcom/android/build/gradle/internal/privaysandboxsdk/PrivacySandboxSdkVariantScope;", "initializeForStandalone", "project", "Lorg/gradle/api/Project;", "javaExtension", "Lorg/gradle/api/plugins/JavaPluginExtension;", "dslLintOptions", "Lcom/android/build/api/dsl/Lint;", "initializeForStandalone$gradle_core", "initializeFromProject", "projectInfo", "Lcom/android/build/gradle/internal/scope/ProjectInfo;", "convertToLintModelModule", "Lcom/android/tools/lint/model/LintModelModule;", "convertToLintModelModule$gradle_core", "initializeLintConfigFiles", "gradle-core"})
public abstract class ProjectInputs {
    @Internal
    @NotNull
    public abstract Property<String> getProjectDirectoryPath();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getProjectDirectoryPathInput();

    @Input
    @NotNull
    public abstract Property<String> getProjectGradlePath();

    @Input
    @NotNull
    public abstract Property<LintModelModuleType> getProjectType();

    @Input
    @NotNull
    public abstract Property<String> getMavenGroupId();

    @Input
    @NotNull
    public abstract Property<String> getMavenArtifactId();

    @Input
    @NotNull
    public abstract Property<String> getMavenVersion();

    @Internal
    @NotNull
    public abstract Property<String> getBuildDirectoryPath();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getBuildDirectoryPathInput();

    @Nested
    @NotNull
    public abstract LintOptionsInput getLintOptions();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getResourcePrefix();

    @Input
    @NotNull
    public abstract ListProperty<String> getDynamicFeatures();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getBootClasspath();

    @Input
    @NotNull
    public abstract Property<JavaVersion> getJavaSourceLevel();

    @Input
    @NotNull
    public abstract Property<String> getCompileTarget();

    @Input
    @NotNull
    public abstract Property<Boolean> getNeverShrinking();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract ConfigurableFileCollection getLintConfigFiles();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getBuildFile();

    public final void initialize$gradle_core(@NotNull VariantWithTests variant, @NotNull LintMode lintMode) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)((Object)lintMode), (String)"lintMode");
        this.initialize$gradle_core(variant.getMain(), lintMode);
    }

    public final void initialize$gradle_core(@NotNull ComponentCreationConfig creationConfig, @NotNull LintMode lintMode) {
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        Intrinsics.checkNotNullParameter((Object)((Object)lintMode), (String)"lintMode");
        GlobalTaskCreationConfig globalConfig2 = creationConfig.getGlobal();
        this.initializeFromProject(creationConfig.getServices().getProjectInfo(), lintMode);
        HasConfigurableValuesKt.setDisallowChanges(this.getProjectType(), AndroidLintInputs.toLintModelModuleType(creationConfig.getComponentType()));
        this.getLintOptions().initialize(globalConfig2.getLintOptions(), lintMode);
        HasConfigurableValuesKt.setDisallowChanges(this.getResourcePrefix(), globalConfig2.getResourcePrefix());
        HasConfigurableValuesKt.setDisallowChanges(this.getDynamicFeatures(), (Iterable)globalConfig2.getDynamicFeatures());
        Object[] objectArray = new Object[]{globalConfig2.getBootClasspath()};
        HasConfigurableValuesKt.fromDisallowChanges(this.getBootClasspath(), objectArray);
        HasConfigurableValuesKt.setDisallowChanges(this.getJavaSourceLevel(), globalConfig2.getCompileOptions().getSourceCompatibility());
        HasConfigurableValuesKt.setDisallowChanges(this.getCompileTarget(), globalConfig2.getCompileSdkHashString());
        HasConfigurableValuesKt.setDisallowChanges(this.getNeverShrinking(), globalConfig2.getHasNoBuildTypeMinified());
    }

    public final void initialize$gradle_core(@NotNull PrivacySandboxSdkVariantScope variantScope2, @NotNull LintMode lintMode) {
        Intrinsics.checkNotNullParameter((Object)variantScope2, (String)"variantScope");
        Intrinsics.checkNotNullParameter((Object)((Object)lintMode), (String)"lintMode");
        this.initializeFromProject(variantScope2.getServices().getProjectInfo(), lintMode);
        HasConfigurableValuesKt.setDisallowChanges(this.getProjectType(), LintModelModuleType.PRIVACY_SANDBOX_SDK);
        variantScope2.getLintOptions().setCheckDependencies(true);
        this.getLintOptions().initialize(variantScope2.getLintOptions(), lintMode);
        HasConfigurableValuesKt.setDisallowChanges(this.getResourcePrefix(), "");
        HasConfigurableValuesKt.setDisallowChanges(this.getDynamicFeatures(), (Iterable)SetsKt.emptySet());
        Object[] objectArray = new Object[]{variantScope2.getBootClasspath()};
        HasConfigurableValuesKt.fromDisallowChanges(this.getBootClasspath(), objectArray);
        HasConfigurableValuesKt.setDisallowChanges(this.getJavaSourceLevel(), JavaVersion.VERSION_HIGHER);
        HasConfigurableValuesKt.setDisallowChanges(this.getCompileTarget(), variantScope2.getCompileSdkVersion());
        HasConfigurableValuesKt.setDisallowChanges(this.getNeverShrinking(), true);
    }

    public final void initializeForStandalone$gradle_core(@NotNull Project project, @NotNull JavaPluginExtension javaExtension, @NotNull Lint dslLintOptions, @NotNull LintMode lintMode) {
        TaskProvider javaCompileTask;
        TaskProvider taskProvider;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)javaExtension, (String)"javaExtension");
        Intrinsics.checkNotNullParameter((Object)dslLintOptions, (String)"dslLintOptions");
        Intrinsics.checkNotNullParameter((Object)((Object)lintMode), (String)"lintMode");
        this.initializeFromProject(new ProjectInfo(project), lintMode);
        HasConfigurableValuesKt.setDisallowChanges(this.getProjectType(), LintModelModuleType.JAVA_LIBRARY);
        this.getLintOptions().initialize(dslLintOptions, lintMode);
        HasConfigurableValuesKt.setDisallowChanges(this.getResourcePrefix(), "");
        HasConfigurableValuesKt.setDisallowChanges(this.getDynamicFeatures(), (Iterable)SetsKt.emptySet());
        SourceSet sourceSet2 = (SourceSet)javaExtension.getSourceSets().findByName("main");
        if (sourceSet2 != null) {
            SourceSet it = sourceSet2;
            boolean bl = false;
            taskProvider = project.getTasks().named(it.getCompileJavaTaskName(), JavaCompile.class);
        } else {
            taskProvider = javaCompileTask = null;
        }
        if (javaCompileTask != null) {
            Object[] objectArray = new Object[]{javaCompileTask.map(new Transformer(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                }

                public final FileCollection transform(JavaCompile it) {
                    FileCollection fileCollection2 = it.getOptions().getBootstrapClasspath();
                    if (fileCollection2 == null) {
                        fileCollection2 = (FileCollection)this.$project.files(new Object[0]);
                    }
                    return fileCollection2;
                }
            })};
            this.getBootClasspath().from(objectArray);
        }
        this.getBootClasspath().disallowChanges();
        HasConfigurableValuesKt.setDisallowChanges(this.getJavaSourceLevel(), javaExtension.getSourceCompatibility());
        HasConfigurableValuesKt.setDisallowChanges(this.getCompileTarget(), "");
        HasConfigurableValuesKt.setDisallowChanges(this.getNeverShrinking(), true);
    }

    private final void initializeFromProject(ProjectInfo projectInfo, LintMode lintMode) {
        HasConfigurableValuesKt.setDisallowChanges(this.getProjectDirectoryPath(), projectInfo.getProjectDirectory().toString());
        HasConfigurableValuesKt.setDisallowChanges(this.getProjectGradlePath(), projectInfo.getPath());
        HasConfigurableValuesKt.setDisallowChanges(this.getMavenGroupId(), projectInfo.getGroup());
        HasConfigurableValuesKt.setDisallowChanges(this.getMavenArtifactId(), projectInfo.getName());
        HasConfigurableValuesKt.setDisallowChanges(this.getMavenVersion(), projectInfo.getVersion());
        Property<String> property = this.getBuildDirectoryPath();
        Provider provider2 = projectInfo.getBuildDirectory().map((Transformer)initializeFromProject.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"map(...)");
        HasConfigurableValuesKt.setDisallowChanges(property, provider2);
        if (lintMode != LintMode.ANALYSIS) {
            this.getProjectDirectoryPathInput().set((Provider)this.getProjectDirectoryPath());
            this.getBuildDirectoryPathInput().set((Provider)this.getBuildDirectoryPath());
        }
        this.getProjectDirectoryPathInput().disallowChanges();
        this.getBuildDirectoryPathInput().disallowChanges();
        this.initializeLintConfigFiles(projectInfo);
        this.getBuildFile().set(projectInfo.getBuildFile());
        this.getBuildFile().disallowChanges();
    }

    @NotNull
    public final LintModelModule convertToLintModelModule$gradle_core() {
        File file = new File((String)this.getProjectDirectoryPath().get());
        Object object = this.getProjectGradlePath().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String string = (String)object;
        Object object2 = this.getProjectType().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        LintModelModuleType lintModelModuleType = (LintModelModuleType)object2;
        Object object3 = this.getMavenGroupId().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        String string2 = (String)object3;
        Object object4 = this.getMavenArtifactId().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
        String string3 = (String)object4;
        Object object5 = this.getMavenVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
        LintModelMavenName lintModelMavenName = (LintModelMavenName)new DefaultLintModelMavenName(string2, string3, (String)object5);
        String string4 = Version.ANDROID_GRADLE_PLUGIN_VERSION;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"ANDROID_GRADLE_PLUGIN_VERSION");
        AgpVersion agpVersion = AgpVersion.Companion.tryParse(string4);
        File file2 = new File((String)this.getBuildDirectoryPath().get());
        LintModelLintOptions lintModelLintOptions = this.getLintOptions().toLintModel();
        List list = CollectionsKt.emptyList();
        String string5 = (String)this.getResourcePrefix().getOrNull();
        Object object6 = this.getDynamicFeatures().get();
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get(...)");
        Collection collection = (Collection)object6;
        Set set = this.getBootClasspath().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
        List list2 = CollectionsKt.toList((Iterable)set);
        String string6 = ((JavaVersion)this.getJavaSourceLevel().get()).toString();
        Object object7 = this.getCompileTarget().get();
        Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"get(...)");
        String string7 = (String)object7;
        List list3 = CollectionsKt.emptyList();
        Object object8 = this.getNeverShrinking().get();
        Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"get(...)");
        return (LintModelModule)new DefaultLintModelModule(null, file, string, lintModelModuleType, lintModelMavenName, agpVersion, file2, lintModelLintOptions, list, string5, collection, list2, string6, string7, list3, ((Boolean)object8).booleanValue());
    }

    private final void initializeLintConfigFiles(ProjectInfo projectInfo) {
        File currentDir = projectInfo.getProjectDirectory().getAsFile();
        File currentLintXml = new File(currentDir, "lint.xml");
        while (FileUtils.isFileInDirectory((File)currentLintXml, (File)projectInfo.getRootDir())) {
            Object[] objectArray = new Object[]{currentLintXml};
            this.getLintConfigFiles().from(objectArray);
            if (currentDir.getParentFile() == null) break;
            currentLintXml = new File(currentDir, "lint.xml");
        }
        this.getLintConfigFiles().disallowChanges();
    }
}

