/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.profile.AnalyticsConfiguratorService;
import com.android.build.gradle.internal.profile.AnalyticsResourceManager;
import com.android.build.gradle.internal.profile.AnalyticsServiceApi;
import com.android.build.gradle.internal.profile.ProjectData;
import com.android.build.gradle.internal.profile.TaskMetadata;
import com.android.build.gradle.internal.profile.TaskProfilingRecord;
import com.android.build.gradle.internal.profile.WorkerProfilingRecord;
import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.android.builder.profile.AnalyticsProfileWriter;
import com.android.builder.profile.NameAnonymizer;
import com.android.builder.profile.NameAnonymizerSerializer;
import com.android.builder.profile.Recorder;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleBuildMemorySample;
import com.google.wireless.android.sdk.stats.GradleBuildProfile;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleBuildProject;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import com.google.wireless.android.sdk.stats.GradleTransformExecution;
import java.io.File;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.build.event.BuildEventsListenerRegistry;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00060\u0004j\u0002`\u00052\u00020\u0006:\u0002<=B\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\nH\u0014J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0012\u0010\u000f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0014H\u0016J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0014H\u0016J\u001e\u0010!\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J2\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00142\u0006\u0010+\u001a\u00020,H\u0016J\u0016\u0010-\u001a\u00020\r2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0016J\u0010\u00101\u001a\u00020\r2\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\r2\u0006\u00105\u001a\u000206H\u0016J\u001a\u00107\u001a\u0004\u0018\u0001082\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u00109\u001a\u00020\u0014H\u0002J\b\u0010:\u001a\u00020;H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/android/build/gradle/internal/profile/AnalyticsService;", "Lcom/android/build/gradle/internal/profile/AnalyticsServiceApi;", "Lorg/gradle/api/services/BuildService;", "Lcom/android/build/gradle/internal/profile/AnalyticsService$Params;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "<init>", "()V", "resourceManager", "Lcom/android/build/gradle/internal/profile/AnalyticsResourceManager;", "initializeResourceManager", "initializeUsageTracker", "", "close", "onFinish", "finishEvent", "Lorg/gradle/tooling/events/FinishEvent;", "workerAdded", "taskPath", "", "workerKey", "workerStarted", "workerFinished", "registerSpan", "builder", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan$Builder;", "getProjectBuillder", "Lcom/google/wireless/android/sdk/stats/GradleBuildProject$Builder;", "projectPath", "getVariantBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;", "variantName", "mergeToVariantBuilder", "variant", "Lcom/google/wireless/android/sdk/stats/GradleBuildVariant;", "getTaskRecord", "Lcom/android/build/gradle/internal/profile/TaskProfilingRecord;", "recordBlock", "executionType", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan$ExecutionType;", "transform", "Lcom/google/wireless/android/sdk/stats/GradleTransformExecution;", "block", "Lcom/android/builder/profile/Recorder$VoidBlock;", "setConfigurationSpans", "spans", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan;", "setInitialMemorySampleForConfiguration", "sample", "Lcom/google/wireless/android/sdk/stats/GradleBuildMemorySample;", "recordEvent", "event", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "getWorkerRecord", "Lcom/android/build/gradle/internal/profile/WorkerProfilingRecord;", "worker", "reconstructProfileBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfile$Builder;", "Params", "RegistrationAction", "gradle-core"})
public abstract class AnalyticsService
implements AnalyticsServiceApi,
BuildService<Params>,
AutoCloseable,
OperationCompletionListener {
    @NotNull
    private final AnalyticsResourceManager resourceManager = this.initializeResourceManager();

    public AnalyticsService() {
        this.initializeUsageTracker();
    }

    @NotNull
    protected AnalyticsResourceManager initializeResourceManager() {
        GradleBuildProfile.Builder builder = this.reconstructProfileBuilder();
        ConcurrentHashMap<String, ProjectData> concurrentHashMap = new ConcurrentHashMap<String, ProjectData>((Map)((Params)this.getParameters()).getProjects().get());
        Object object = ((Params)this.getParameters()).getEnableProfileJson().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        boolean bl = (Boolean)object;
        File file = (File)((Params)this.getParameters()).getProfileDir().getOrNull();
        ConcurrentHashMap<String, TaskMetadata> concurrentHashMap2 = new ConcurrentHashMap<String, TaskMetadata>((Map)((Params)this.getParameters()).getTaskMetadata().get());
        String string = (String)((Params)this.getParameters()).getRootProjectPath().get();
        SetProperty<String> setProperty = ((Params)this.getParameters()).getApplicationId();
        Object object2 = new NameAnonymizerSerializer().fromJson((String)((Params)this.getParameters()).getAnonymizer().get());
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"fromJson(...)");
        return new AnalyticsResourceManager(builder, concurrentHashMap, bl, file, concurrentHashMap2, string, setProperty, (NameAnonymizer)object2);
    }

    protected void initializeUsageTracker() {
        new AnalyticsProfileWriter().initializeUsageTracker();
    }

    @Override
    public void close() {
        this.resourceManager.writeAndFinish();
    }

    public void onFinish(@Nullable FinishEvent finishEvent) {
        this.resourceManager.recordTaskExecutionSpan(finishEvent);
    }

    @Override
    public void workerAdded(@NotNull String taskPath, @NotNull String workerKey) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)taskPath, (String)"taskPath");
            Intrinsics.checkNotNullParameter((Object)workerKey, (String)"workerKey");
            TaskProfilingRecord taskProfilingRecord = this.getTaskRecord(taskPath);
            if (taskProfilingRecord == null) break block0;
            taskProfilingRecord.addWorker(workerKey);
        }
    }

    @Override
    public void workerStarted(@NotNull String taskPath, @NotNull String workerKey) {
        block0: {
            WorkerProfilingRecord workerRecord;
            Intrinsics.checkNotNullParameter((Object)taskPath, (String)"taskPath");
            Intrinsics.checkNotNullParameter((Object)workerKey, (String)"workerKey");
            WorkerProfilingRecord workerProfilingRecord = workerRecord = this.getWorkerRecord(taskPath, workerKey);
            if (workerProfilingRecord == null) break block0;
            workerProfilingRecord.executionStarted();
        }
    }

    @Override
    public void workerFinished(@NotNull String taskPath, @NotNull String workerKey) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)taskPath, (String)"taskPath");
            Intrinsics.checkNotNullParameter((Object)workerKey, (String)"workerKey");
            WorkerProfilingRecord workerRecord = this.getWorkerRecord(taskPath, workerKey);
            if (workerRecord == null) break block1;
            workerRecord.executionFinished();
            TaskProfilingRecord taskProfilingRecord = this.getTaskRecord(taskPath);
            if (taskProfilingRecord != null) {
                taskProfilingRecord.workerFinished(workerRecord);
            }
        }
    }

    @Override
    public void registerSpan(@NotNull String taskPath, @NotNull GradleBuildProfileSpan.Builder builder) {
        block0: {
            TaskProfilingRecord taskRecord2;
            Intrinsics.checkNotNullParameter((Object)taskPath, (String)"taskPath");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            TaskProfilingRecord taskProfilingRecord = taskRecord2 = this.getTaskRecord(taskPath);
            if (taskProfilingRecord == null) break block0;
            taskProfilingRecord.addSpan(builder);
        }
    }

    @Override
    @Nullable
    public synchronized GradleBuildProject.Builder getProjectBuillder(@NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        return this.resourceManager.getProjectBuilder(projectPath);
    }

    @Override
    @Nullable
    public synchronized GradleBuildVariant.Builder getVariantBuilder(@NotNull String projectPath, @NotNull String variantName) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        return this.resourceManager.getVariantBuilder(projectPath, variantName);
    }

    public final synchronized void mergeToVariantBuilder(@NotNull String projectPath, @NotNull String variantName, @NotNull GradleBuildVariant variant) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            GradleBuildVariant.Builder builder = this.getVariantBuilder(projectPath, variantName);
            if (builder == null) break block0;
            builder.mergeFrom(variant);
        }
    }

    @Override
    @Nullable
    public synchronized TaskProfilingRecord getTaskRecord(@NotNull String taskPath) {
        Intrinsics.checkNotNullParameter((Object)taskPath, (String)"taskPath");
        return this.resourceManager.getTaskRecord(taskPath);
    }

    @Override
    public void recordBlock(@NotNull GradleBuildProfileSpan.ExecutionType executionType, @Nullable GradleTransformExecution transform2, @NotNull String projectPath, @NotNull String variantName, @NotNull Recorder.VoidBlock block) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        this.resourceManager.recordBlockAtExecution(executionType, transform2, projectPath, variantName, block);
    }

    @Override
    public void setConfigurationSpans(@NotNull ConcurrentLinkedQueue<GradleBuildProfileSpan> spans) {
        Intrinsics.checkNotNullParameter(spans, (String)"spans");
        this.resourceManager.getConfigurationSpans().addAll((Collection<GradleBuildProfileSpan>)spans);
    }

    @Override
    public void setInitialMemorySampleForConfiguration(@NotNull GradleBuildMemorySample sample) {
        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
        this.resourceManager.setInitialMemorySample(sample);
    }

    @Override
    public void recordEvent(@NotNull AndroidStudioEvent.Builder event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.resourceManager.recordEvent(event);
    }

    private final WorkerProfilingRecord getWorkerRecord(String taskPath, String worker) {
        TaskProfilingRecord taskProfilingRecord = this.getTaskRecord(taskPath);
        return taskProfilingRecord != null ? taskProfilingRecord.get(worker) : null;
    }

    private final GradleBuildProfile.Builder reconstructProfileBuilder() {
        GradleBuildProfile.Builder builder = GradleBuildProfile.parseFrom((byte[])Base64.getDecoder().decode((String)((Params)this.getParameters()).getProfile().get())).toBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"toBuilder(...)");
        return builder;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u001e\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u001a\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0006R\u001e\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\rR\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0006R\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u001aX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d\u00c0\u0006\u0003"}, d2={"Lcom/android/build/gradle/internal/profile/AnalyticsService$Params;", "Lorg/gradle/api/services/BuildServiceParameters;", "profile", "Lorg/gradle/api/provider/Property;", "", "getProfile", "()Lorg/gradle/api/provider/Property;", "anonymizer", "getAnonymizer", "projects", "Lorg/gradle/api/provider/MapProperty;", "Lcom/android/build/gradle/internal/profile/ProjectData;", "getProjects", "()Lorg/gradle/api/provider/MapProperty;", "enableProfileJson", "", "getEnableProfileJson", "profileDir", "Ljava/io/File;", "getProfileDir", "taskMetadata", "Lcom/android/build/gradle/internal/profile/TaskMetadata;", "getTaskMetadata", "rootProjectPath", "getRootProjectPath", "applicationId", "Lorg/gradle/api/provider/SetProperty;", "getApplicationId", "()Lorg/gradle/api/provider/SetProperty;", "gradle-core"})
    public static interface Params
    extends BuildServiceParameters {
        @NotNull
        public Property<String> getProfile();

        @NotNull
        public Property<String> getAnonymizer();

        @NotNull
        public MapProperty<String, ProjectData> getProjects();

        @NotNull
        public Property<Boolean> getEnableProfileJson();

        @NotNull
        public Property<File> getProfileDir();

        @NotNull
        public MapProperty<String, TaskMetadata> getTaskMetadata();

        @NotNull
        public Property<String> getRootProjectPath();

        @NotNull
        public SetProperty<String> getApplicationId();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B/\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/profile/AnalyticsService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/profile/AnalyticsService;", "Lcom/android/build/gradle/internal/profile/AnalyticsService$Params;", "project", "Lorg/gradle/api/Project;", "configuratorService", "Lcom/android/build/gradle/internal/profile/AnalyticsConfiguratorService;", "listenerRegistry", "Lorg/gradle/build/event/BuildEventsListenerRegistry;", "configurationCacheActive", "", "projectIsolationActive", "<init>", "(Lorg/gradle/api/Project;Lcom/android/build/gradle/internal/profile/AnalyticsConfiguratorService;Lorg/gradle/build/event/BuildEventsListenerRegistry;ZZ)V", "getListenerRegistry", "()Lorg/gradle/build/event/BuildEventsListenerRegistry;", "configure", "", "parameters", "gradle-core"})
    public static final class RegistrationAction
    extends ServiceRegistrationAction<AnalyticsService, Params> {
        @NotNull
        private final AnalyticsConfiguratorService configuratorService;
        @NotNull
        private final BuildEventsListenerRegistry listenerRegistry;
        private final boolean configurationCacheActive;
        private final boolean projectIsolationActive;

        public RegistrationAction(@NotNull Project project, @NotNull AnalyticsConfiguratorService configuratorService2, @NotNull BuildEventsListenerRegistry listenerRegistry, boolean configurationCacheActive, boolean projectIsolationActive) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)configuratorService2, (String)"configuratorService");
            Intrinsics.checkNotNullParameter((Object)listenerRegistry, (String)"listenerRegistry");
            super(project, AnalyticsService.class, null, null, 12, null);
            this.configuratorService = configuratorService2;
            this.listenerRegistry = listenerRegistry;
            this.configurationCacheActive = configurationCacheActive;
            this.projectIsolationActive = projectIsolationActive;
        }

        @NotNull
        public final BuildEventsListenerRegistry getListenerRegistry() {
            return this.listenerRegistry;
        }

        @Override
        public void configure(@NotNull Params parameters) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            this.configuratorService.createAnalyticsService(this.getProject(), this.listenerRegistry, parameters, this.configurationCacheActive, this.projectIsolationActive);
        }
    }
}

