/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.api.dsl.BuildType;
import com.android.build.api.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.AbstractPublishing;
import com.android.build.gradle.internal.dsl.ApplicationPublishingImpl;
import com.android.build.gradle.internal.dsl.ApplicationSingleVariantImpl;
import com.android.build.gradle.internal.dsl.LibraryPublishingImpl;
import com.android.build.gradle.internal.dsl.LibrarySingleVariantImpl;
import com.android.build.gradle.internal.dsl.MultipleVariantsImpl;
import com.android.build.gradle.internal.publishing.ComponentPublishingInfo;
import com.android.build.gradle.internal.publishing.VariantPublishingInfo;
import com.android.builder.errors.IssueReporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.NamedDomainObjectContainer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aT\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\f2\u0006\u0010\u000e\u001a\u00020\u000f\u001a8\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00162\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u001a&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u001a\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a&\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u001e"}, d2={"createPublishingInfoForLibrary", "Lcom/android/build/gradle/internal/publishing/VariantPublishingInfo;", "publishing", "Lcom/android/build/gradle/internal/dsl/LibraryPublishingImpl;", "variantName", "", "buildType", "Lcom/android/build/api/dsl/BuildType;", "flavorList", "", "Lcom/android/build/api/dsl/ProductFlavor;", "buildTypes", "Lorg/gradle/api/NamedDomainObjectContainer;", "productFlavors", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "ensureUsersInputCorrectness", "", "multipleVariant", "Lcom/android/build/gradle/internal/dsl/MultipleVariantsImpl;", "computeBuildTypeAttribute", "computeFlavorDimensionAttribute", "", "allFlavors", "isVariantSelectedExplicitly", "", "ensureComponentNameUniqueness", "createPublishingInfoForApp", "Lcom/android/build/gradle/internal/dsl/ApplicationPublishingImpl;", "hasDynamicFeatures", "gradle-core"})
@JvmName(name="PublishingUtils")
@SourceDebugExtension(value={"SMAP\nPublishingUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PublishingUtil.kt\ncom/android/build/gradle/internal/utils/PublishingUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n1557#2:216\n1628#2,3:217\n774#2:220\n865#2,2:221\n1557#2:223\n1628#2,3:224\n1557#2:227\n1628#2,3:228\n1557#2:231\n1628#2,3:232\n1557#2:235\n1628#2,3:236\n1#3:239\n*S KotlinDebug\n*F\n+ 1 PublishingUtil.kt\ncom/android/build/gradle/internal/utils/PublishingUtils\n*L\n96#1:216\n96#1:217,3\n107#1:220\n107#1:221,2\n114#1:223\n114#1:224,3\n142#1:227\n142#1:228,3\n177#1:231\n177#1:232,3\n178#1:235\n178#1:236,3\n*E\n"})
public final class PublishingUtils {
    @NotNull
    public static final VariantPublishingInfo createPublishingInfoForLibrary(@NotNull LibraryPublishingImpl publishing, @NotNull String variantName, @NotNull BuildType buildType, @NotNull List<? extends ProductFlavor> flavorList, @NotNull NamedDomainObjectContainer<? extends BuildType> buildTypes, @NotNull NamedDomainObjectContainer<? extends ProductFlavor> productFlavors, @NotNull IssueReporter issueReporter2) {
        Object v0;
        List components2;
        block3: {
            Intrinsics.checkNotNullParameter((Object)publishing, (String)"publishing");
            Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
            Intrinsics.checkNotNullParameter((Object)buildType, (String)"buildType");
            Intrinsics.checkNotNullParameter(flavorList, (String)"flavorList");
            Intrinsics.checkNotNullParameter(buildTypes, (String)"buildTypes");
            Intrinsics.checkNotNullParameter(productFlavors, (String)"productFlavors");
            Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
            components2 = new ArrayList();
            PublishingUtils.ensureComponentNameUniqueness(publishing, issueReporter2);
            Iterable iterable = publishing.getSingleVariants();
            for (Object t : iterable) {
                LibrarySingleVariantImpl it = (LibrarySingleVariantImpl)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getVariantName(), (Object)variantName)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        LibrarySingleVariantImpl singleVariant2 = v0;
        if (singleVariant2 != null) {
            components2.add(new ComponentPublishingInfo(variantName, AbstractPublishing.Type.AAR, null, false, singleVariant2.getWithSourcesJar$gradle_core(), singleVariant2.getWithJavadocJar$gradle_core(), 12, null));
        }
        for (MultipleVariantsImpl multipleVariant : publishing.getMultipleVariantsContainer()) {
            boolean isClassifierRequired;
            PublishingUtils.ensureUsersInputCorrectness(multipleVariant, buildTypes, productFlavors, issueReporter2);
            String buildTypeAttribute = PublishingUtils.computeBuildTypeAttribute(multipleVariant, buildType);
            Set<String> flavorDimensionAttributes = PublishingUtils.computeFlavorDimensionAttribute(multipleVariant, flavorList);
            boolean bl = isClassifierRequired = buildTypeAttribute != null || !((Collection)flavorDimensionAttributes).isEmpty();
            boolean publishThisVariant = multipleVariant.getAllVariants$gradle_core() || PublishingUtils.isVariantSelectedExplicitly(multipleVariant, buildType, flavorList);
            if (!publishThisVariant) continue;
            components2.add(new ComponentPublishingInfo(multipleVariant.getComponentName(), AbstractPublishing.Type.AAR, new ComponentPublishingInfo.AttributesConfig(buildTypeAttribute, flavorDimensionAttributes), isClassifierRequired, multipleVariant.getWithSourcesJar$gradle_core(), multipleVariant.getWithJavadocJar$gradle_core()));
        }
        return new VariantPublishingInfo(components2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void ensureUsersInputCorrectness(MultipleVariantsImpl multipleVariant, NamedDomainObjectContainer<? extends BuildType> buildTypes, NamedDomainObjectContainer<? extends ProductFlavor> productFlavors, IssueReporter issueReporter2) {
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)buildTypes;
        boolean bl = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BuildType buildType = (BuildType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getName());
        }
        Set allBuildTypes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        for (String string : multipleVariant.getIncludedBuildTypes$gradle_core()) {
            if (allBuildTypes.contains(string)) continue;
            IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)PublishingUtils.ensureUsersInputCorrectness$computeErrorMessage("build type \"" + string + "\""), null, null, (int)12, null);
        }
        for (Map.Entry entry2 : multipleVariant.getIncludedFlavorDimensionAndValues$gradle_core().entrySet()) {
            void $this$mapTo$iv$iv2;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = (Iterable)productFlavors;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ProductFlavor it = (ProductFlavor)element$iv$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getDimension(), entry2.getKey())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List flavorsWithSpecifiedDimension = (List)destination$iv$iv2;
            if (flavorsWithSpecifiedDimension.isEmpty()) {
                IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)PublishingUtils.ensureUsersInputCorrectness$computeErrorMessage("dimension \"" + entry2.getKey() + "\""), null, null, (int)12, null);
            }
            Iterable $this$map$iv2 = flavorsWithSpecifiedDimension;
            boolean $i$f$map2 = false;
            destination$iv$iv2 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                ProductFlavor bl3 = (ProductFlavor)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl2 = false;
                collection.add(it.getName());
            }
            Set allFlavorValues = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
            for (String flavorValue : (Set)entry2.getValue()) {
                if (allFlavorValues.contains(flavorValue)) continue;
                IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)PublishingUtils.ensureUsersInputCorrectness$computeErrorMessage("flavor value \"" + flavorValue + "\""), null, null, (int)12, null);
            }
        }
    }

    private static final String computeBuildTypeAttribute(MultipleVariantsImpl multipleVariant, BuildType buildType) {
        return multipleVariant.getIncludedBuildTypes$gradle_core().size() > 1 || multipleVariant.getAllVariants$gradle_core() ? buildType.getName() : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<String> computeFlavorDimensionAttribute(MultipleVariantsImpl multipleVariant, List<? extends ProductFlavor> allFlavors) {
        Set flavorDimensionAttributes = new LinkedHashSet();
        if (multipleVariant.getAllVariants$gradle_core()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = allFlavors;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ProductFlavor productFlavor = (ProductFlavor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getDimension();
                Intrinsics.checkNotNull((Object)string);
                collection.add(flavorDimensionAttributes.add(string));
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
        } else {
            for (Map.Entry<String, Set<String>> entry2 : multipleVariant.getIncludedFlavorDimensionAndValues$gradle_core().entrySet()) {
                if (entry2.getValue().size() <= 1) continue;
                flavorDimensionAttributes.add(entry2.getKey());
            }
        }
        return flavorDimensionAttributes;
    }

    private static final boolean isVariantSelectedExplicitly(MultipleVariantsImpl multipleVariant, BuildType buildType, List<? extends ProductFlavor> flavorList) {
        if (!multipleVariant.getIncludedBuildTypes$gradle_core().contains(buildType.getName())) {
            return false;
        }
        for (ProductFlavor productFlavor : flavorList) {
            Set<String> dimensionValue = multipleVariant.getIncludedFlavorDimensionAndValues$gradle_core().get(productFlavor.getDimension());
            if (dimensionValue != null && dimensionValue.contains(productFlavor.getName())) continue;
            return false;
        }
        return true;
    }

    private static final void ensureComponentNameUniqueness(LibraryPublishingImpl publishing, IssueReporter issueReporter2) {
        MultipleVariantsImpl it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = publishing.getSingleVariants();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            LibrarySingleVariantImpl librarySingleVariantImpl = (LibrarySingleVariantImpl)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((LibrarySingleVariantImpl)((Object)it)).getVariantName());
        }
        Set singleVariantPubComponents = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$map$iv = publishing.getMultipleVariantsContainer();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (MultipleVariantsImpl)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (singleVariantPubComponents.contains(it.getComponentName())) {
                IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)("Publishing variants to the \"" + it.getComponentName() + "\" component using both singleVariant and multipleVariants publishing DSL is not allowed."), null, null, (int)12, null);
            }
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    @NotNull
    public static final VariantPublishingInfo createPublishingInfoForApp(@NotNull ApplicationPublishingImpl publishing, @NotNull String variantName, boolean hasDynamicFeatures, @NotNull IssueReporter issueReporter2) {
        List components2;
        block6: {
            Object v0;
            block5: {
                Intrinsics.checkNotNullParameter((Object)publishing, (String)"publishing");
                Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
                Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
                components2 = new ArrayList();
                Iterable iterable = publishing.getSingleVariants();
                for (Object t : iterable) {
                    ApplicationSingleVariantImpl it = (ApplicationSingleVariantImpl)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getVariantName(), (Object)variantName)) continue;
                    v0 = t;
                    break block5;
                }
                v0 = null;
            }
            ApplicationSingleVariantImpl applicationSingleVariantImpl = v0;
            if (applicationSingleVariantImpl == null) break block6;
            ApplicationSingleVariantImpl it = applicationSingleVariantImpl;
            boolean bl = false;
            if (it.getPublishVariantAsApk$gradle_core()) {
                if (hasDynamicFeatures) {
                    IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)"When dynamic feature modules exist, publishing APK is not allowed.", null, null, (int)12, null);
                } else {
                    components2.add(new ComponentPublishingInfo(variantName, AbstractPublishing.Type.APK, null, false, false, false, 60, null));
                }
            } else {
                components2.add(new ComponentPublishingInfo(variantName, AbstractPublishing.Type.AAB, null, false, false, false, 60, null));
            }
        }
        return new VariantPublishingInfo(components2);
    }

    private static final String ensureUsersInputCorrectness$computeErrorMessage(String element) {
        return "Using non-existing " + element + " when selecting variants to be published in multipleVariants publishing DSL.";
    }
}

