/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.api.variant.impl.AndroidVersionImpl;
import com.android.build.gradle.internal.dsl.CompileSdkVersionImpl;
import com.android.builder.core.DefaultApiVersion;
import com.android.sdklib.AndroidVersion;
import com.google.common.base.Splitter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u001a\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u0003\u001a#\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0000\u00a2\u0006\u0002\u0010\f\u001a;\u0010\r\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u0001H\u000f2\b\u0010\u0011\u001a\u0004\u0018\u0001H\u000f2\u0014\u0010\u0012\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\u000f\u0012\u0004\u0012\u00020\u000e0\u0013\u00a2\u0006\u0002\u0010\u0014\"\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0018\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0019\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"parseTargetHash", "Lcom/android/build/gradle/internal/dsl/CompileSdkVersionImpl;", "targetHash", "", "validateNamespaceValue", "value", "validatePreviewTargetValue", "createTargetSdkVersion", "Lcom/android/build/api/variant/impl/AndroidVersionImpl;", "targetSdk", "", "targetSdkPreview", "(Ljava/lang/Integer;Ljava/lang/String;)Lcom/android/build/api/variant/impl/AndroidVersionImpl;", "updateIfChanged", "", "T", "oldValue", "newValue", "setter", "Lkotlin/Function1;", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "API_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "FULL_PREVIEW_PATTERN", "ADDON_PATTERN", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nSdkUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkUtils.kt\ncom/android/build/gradle/internal/utils/SdkUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public final class SdkUtilsKt {
    private static final Pattern API_PATTERN = Pattern.compile("android-(\\d+)(?:\\.(\\d+))?(-ext(\\d+))?");
    private static final Pattern FULL_PREVIEW_PATTERN = Pattern.compile("android-([A-Z]\\w*)");
    private static final Pattern ADDON_PATTERN = Pattern.compile("([^:]+):([^:]+):(\\d+)");

    @NotNull
    public static final CompileSdkVersionImpl parseTargetHash(@NotNull String targetHash) {
        Intrinsics.checkNotNullParameter((Object)targetHash, (String)"targetHash");
        Matcher apiMatcher = API_PATTERN.matcher(targetHash);
        if (apiMatcher.matches()) {
            String string = apiMatcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            String string2 = apiMatcher.group(2);
            String string3 = apiMatcher.group(4);
            return new CompileSdkVersionImpl(Integer.parseInt(string), string2 != null ? StringsKt.toIntOrNull((String)string2) : null, string3 != null ? StringsKt.toIntOrNull((String)string3) : null, null, null, null, 56, null);
        }
        Matcher previewMatcher = FULL_PREVIEW_PATTERN.matcher(targetHash);
        if (previewMatcher.matches()) {
            return new CompileSdkVersionImpl(null, null, null, previewMatcher.group(1), null, null, 55, null);
        }
        Matcher addonMatcher = ADDON_PATTERN.matcher(targetHash);
        if (addonMatcher.matches()) {
            String string = addonMatcher.group(1);
            String string4 = addonMatcher.group(2);
            String string5 = addonMatcher.group(3);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"group(...)");
            int n = Integer.parseInt(string5);
            return new CompileSdkVersionImpl(n, null, null, null, string4, string, 14, null);
        }
        throw new RuntimeException(StringsKt.trimIndent((String)("\n                    Unsupported value: " + targetHash + ". Format must be one of:\n                    - android-31\n                    - android-36.2\n                    - android-31-ext2\n                    - android-36.2-ext2\n                    - android-T\n                    - vendorName:addonName:31\n                    ")));
    }

    @Nullable
    public static final String validateNamespaceValue(@Nullable String value) {
        CharSequence charSequence = value;
        if (charSequence == null || charSequence.length() == 0 || SourceVersion.isName(value)) {
            return null;
        }
        String msg = "Namespace '" + value + "' is not a valid Java package name";
        for (String segment : Splitter.on((char)'.').split((CharSequence)value)) {
            if (!SourceVersion.isIdentifier(segment)) {
                return msg + " as '" + segment + "' is not a valid Java identifier.";
            }
            if (!SourceVersion.isKeyword(segment)) continue;
            return msg + " as '" + segment + "' is a Java keyword.";
        }
        return msg + ".";
    }

    @Nullable
    public static final String validatePreviewTargetValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return AndroidVersion.PREVIEW_PATTERN.matcher(value).matches() ? value : null;
    }

    @Nullable
    public static final AndroidVersionImpl createTargetSdkVersion(@Nullable Integer targetSdk2, @Nullable String targetSdkPreview) {
        AndroidVersionImpl androidVersionImpl;
        if (targetSdk2 != null || targetSdkPreview != null) {
            DefaultApiVersion apiVersion;
            DefaultApiVersion defaultApiVersion;
            Integer n = targetSdk2;
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                defaultApiVersion = new DefaultApiVersion(it);
            } else {
                String string = targetSdkPreview;
                Intrinsics.checkNotNull((Object)string);
                defaultApiVersion = new DefaultApiVersion(string);
            }
            DefaultApiVersion $this$createTargetSdkVersion_u24lambda_u241 = apiVersion = defaultApiVersion;
            boolean bl = false;
            androidVersionImpl = new AndroidVersionImpl($this$createTargetSdkVersion_u24lambda_u241.getApiLevel(), $this$createTargetSdkVersion_u24lambda_u241.getCodename());
        } else {
            androidVersionImpl = null;
        }
        return androidVersionImpl;
    }

    public static final <T> void updateIfChanged(@Nullable T oldValue, @Nullable T newValue, @NotNull Function1<? super T, Unit> setter) {
        Intrinsics.checkNotNullParameter(setter, (String)"setter");
        if (!Intrinsics.areEqual(oldValue, newValue)) {
            setter.invoke(newValue);
        }
    }
}

