/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.dsl.NdkOptions;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.tasks.ExtractNativeDebugMetadataRunnable;
import com.android.build.gradle.internal.tasks.ExtractNativeDebugMetadataTask;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@VisibleForTesting
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataWorkAction;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataWorkAction$Parameters;", "()V", "logger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "getLogger", "()Lcom/android/build/gradle/internal/LoggerWrapper;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "getWorkerExecutor", "()Lorg/gradle/workers/WorkerExecutor;", "run", "", "Parameters", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nExtractNativeDebugMetadataTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractNativeDebugMetadataTask.kt\ncom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataWorkAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,363:1\n1477#2:364\n1502#2,3:365\n1505#2,3:375\n1855#2,2:378\n361#3,7:368\n*S KotlinDebug\n*F\n+ 1 ExtractNativeDebugMetadataTask.kt\ncom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataWorkAction\n*L\n286#1:364\n286#1:365,3\n286#1:375,3\n286#1:378,2\n286#1:368,7\n*E\n"})
public abstract class ExtractNativeDebugMetadataWorkAction
extends ProfileAwareWorkAction<Parameters> {
    @Inject
    @NotNull
    public abstract WorkerExecutor getWorkerExecutor();

    private final LoggerWrapper getLogger() {
        return new LoggerWrapper(Logging.getLogger(ExtractNativeDebugMetadataTask.class));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        void $this$groupByTo$iv$iv;
        Object outputFile;
        File outputDir = (File)((Parameters)this.getParameters()).getOutputDir().getAsFile().get();
        FileUtils.cleanOutputDir((File)outputDir);
        File inputDir = (File)((Parameters)this.getParameters()).getInputDir().getAsFile().get();
        File strippedNativeLibs = (File)((Parameters)this.getParameters()).getStrippedNativeLibs().getAsFile().get();
        List allRequests = new ArrayList();
        for (File inputFile : FileUtils.getAllFiles((File)inputDir)) {
            String string = inputFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"inputFile.name");
            if (!StringsKt.endsWith((String)string, (String)".so", (boolean)true)) continue;
            File strippedNativeLib = new File(strippedNativeLibs, ((Object)inputDir.toPath().relativize(inputFile.toPath())).toString());
            if (inputFile.length() == strippedNativeLib.length()) {
                this.getLogger().info("Unable to extract native debug metadata from " + inputFile.getAbsolutePath() + " because the native debug metadata has already been stripped.", new Object[0]);
                continue;
            }
            outputFile = null;
            List objcopyArgs = null;
            NdkOptions.DebugSymbolLevel debugSymbolLevel = (NdkOptions.DebugSymbolLevel)((Object)((Parameters)this.getParameters()).getDebugSymbolLevel().get());
            switch (debugSymbolLevel == null ? -1 : WhenMappings.$EnumSwitchMapping$0[debugSymbolLevel.ordinal()]) {
                case 1: {
                    outputFile = new File(outputDir, inputFile.getParentFile().getName() + "/" + inputFile.getName() + ".dbg");
                    objcopyArgs = CollectionsKt.listOf((Object)"--only-keep-debug");
                    break;
                }
                case 2: {
                    outputFile = new File(outputDir, inputFile.getParentFile().getName() + "/" + inputFile.getName() + ".sym");
                    objcopyArgs = CollectionsKt.listOf((Object)"--strip-debug");
                    break;
                }
                case 3: {
                    throw new RuntimeException("NativeDebugMetadataMode.NONE not supported in " + this.getClass().getName());
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            File objcopyExecutable = (File)((Map)((Parameters)this.getParameters()).getObjcopyExecutableMap().get()).get(inputFile.getParentFile().getName());
            if (objcopyExecutable == null) {
                this.getLogger().warning("Unable to extract native debug metadata from " + inputFile.getAbsolutePath() + " because unable to locate the objcopy executable for the " + inputFile.getParentFile().getName() + " ABI.", new Object[0]);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)inputFile, (String)"inputFile");
            allRequests.add(new ExtractNativeDebugMetadataRunnable.SingleRequest(inputFile, (File)outputFile, objcopyExecutable, objcopyArgs));
        }
        int ord = 0;
        Iterable $this$groupBy$iv = allRequests;
        boolean $i$f$groupBy = false;
        outputFile = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ExtractNativeDebugMetadataRunnable.SingleRequest it = (ExtractNativeDebugMetadataRunnable.SingleRequest)element$iv$iv;
            boolean bl = false;
            int n = ord;
            ord = n + 1;
            Object object2 = ((Parameters)this.getParameters()).getMaxWorkerCount().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.maxWorkerCount.get()");
            Integer key$iv$iv = n % ((Number)object2).intValue();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = destination$iv$iv.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List requests = (List)element$iv;
            boolean bl = false;
            if (!(!((Collection)requests).isEmpty())) continue;
            this.getWorkerExecutor().noIsolation().submit(ExtractNativeDebugMetadataRunnable.class, new Action(this, requests){
                final /* synthetic */ ExtractNativeDebugMetadataWorkAction this$0;
                final /* synthetic */ List<ExtractNativeDebugMetadataRunnable.SingleRequest> $requests;
                {
                    this.this$0 = $receiver;
                    this.$requests = $requests;
                }

                public final void execute(ExtractNativeDebugMetadataRunnable.Params it) {
                    WorkParameters workParameters = this.this$0.getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)workParameters, (String)"parameters");
                    it.initializeFromProfileAwareWorkAction((ProfileAwareWorkAction.Parameters)workParameters);
                    it.getRequests().set((Iterable)this.$requests);
                }
            });
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u001e\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000bR\u0012\u0010\u0017\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataWorkAction$Parameters;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "debugSymbolLevel", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/dsl/NdkOptions$DebugSymbolLevel;", "getDebugSymbolLevel", "()Lorg/gradle/api/provider/Property;", "inputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getInputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "maxWorkerCount", "", "getMaxWorkerCount", "objcopyExecutableMap", "Lorg/gradle/api/provider/MapProperty;", "", "Ljava/io/File;", "getObjcopyExecutableMap", "()Lorg/gradle/api/provider/MapProperty;", "outputDir", "getOutputDir", "strippedNativeLibs", "getStrippedNativeLibs", "gradle-core"})
    public static abstract class Parameters
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract DirectoryProperty getInputDir();

        @NotNull
        public abstract DirectoryProperty getStrippedNativeLibs();

        @NotNull
        public abstract DirectoryProperty getOutputDir();

        @NotNull
        public abstract MapProperty<String, File> getObjcopyExecutableMap();

        @NotNull
        public abstract Property<NdkOptions.DebugSymbolLevel> getDebugSymbolLevel();

        @NotNull
        public abstract Property<Integer> getMaxWorkerCount();
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NdkOptions.DebugSymbolLevel.values().length];
            try {
                nArray[NdkOptions.DebugSymbolLevel.FULL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NdkOptions.DebugSymbolLevel.SYMBOL_TABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NdkOptions.DebugSymbolLevel.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

