/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.factory;

import com.android.build.gradle.internal.tasks.factory.PreConfigAction;
import com.android.build.gradle.internal.tasks.factory.TaskConfigAction;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.TaskProviderCallback;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003BI\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0012\b\u0002\u0010\b\u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010\t\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0014\u0010\u001c\u001a\u00020\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eR\u0018\u0010\b\u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0004\u0018\u00018\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/build/gradle/internal/tasks/factory/TaskConfigurationActions;", "T", "Lorg/gradle/api/Task;", "Lorg/gradle/api/Action;", "creationAction", "Lcom/android/build/gradle/internal/tasks/factory/TaskCreationAction;", "preConfigAction", "Lcom/android/build/gradle/internal/tasks/factory/PreConfigAction;", "configureAction", "Lcom/android/build/gradle/internal/tasks/factory/TaskConfigAction;", "providerHandler", "Lcom/android/build/gradle/internal/tasks/factory/TaskProviderCallback;", "(Lcom/android/build/gradle/internal/tasks/factory/TaskCreationAction;Lcom/android/build/gradle/internal/tasks/factory/PreConfigAction;Lcom/android/build/gradle/internal/tasks/factory/TaskConfigAction;Lcom/android/build/gradle/internal/tasks/factory/TaskProviderCallback;)V", "delayedTask", "getDelayedTask", "()Lorg/gradle/api/Task;", "setDelayedTask", "(Lorg/gradle/api/Task;)V", "Lorg/gradle/api/Task;", "hasRunTaskProviderHandler", "", "getHasRunTaskProviderHandler", "()Z", "setHasRunTaskProviderHandler", "(Z)V", "execute", "", "task", "postRegisterHook", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
public final class TaskConfigurationActions<T extends Task>
implements Action<T> {
    @Nullable
    private final TaskCreationAction<T> creationAction;
    @Nullable
    private final PreConfigAction preConfigAction;
    @Nullable
    private final TaskConfigAction<? super T> configureAction;
    @Nullable
    private final TaskProviderCallback<T> providerHandler;
    private boolean hasRunTaskProviderHandler;
    @Nullable
    private T delayedTask;

    public TaskConfigurationActions(@Nullable TaskCreationAction<T> creationAction, @Nullable PreConfigAction preConfigAction, @Nullable TaskConfigAction<? super T> configureAction, @Nullable TaskProviderCallback<T> providerHandler) {
        this.creationAction = creationAction;
        this.preConfigAction = preConfigAction;
        this.configureAction = configureAction;
        this.providerHandler = providerHandler;
    }

    public /* synthetic */ TaskConfigurationActions(TaskCreationAction taskCreationAction, PreConfigAction preConfigAction, TaskConfigAction taskConfigAction, TaskProviderCallback taskProviderCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            taskCreationAction = null;
        }
        if ((n & 2) != 0) {
            preConfigAction = null;
        }
        if ((n & 4) != 0) {
            taskConfigAction = null;
        }
        if ((n & 8) != 0) {
            taskProviderCallback = null;
        }
        this(taskCreationAction, preConfigAction, taskConfigAction, taskProviderCallback);
    }

    public final boolean getHasRunTaskProviderHandler() {
        return this.hasRunTaskProviderHandler;
    }

    public final void setHasRunTaskProviderHandler(boolean bl) {
        this.hasRunTaskProviderHandler = bl;
    }

    @Nullable
    public final T getDelayedTask() {
        return this.delayedTask;
    }

    public final void setDelayedTask(@Nullable T t) {
        this.delayedTask = t;
    }

    public void execute(@NotNull T task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        if (this.hasRunTaskProviderHandler) {
            TaskCreationAction<T> taskCreationAction = this.creationAction;
            if (taskCreationAction != null) {
                taskCreationAction.configure(task);
            }
            TaskConfigAction<T> taskConfigAction = this.configureAction;
            if (taskConfigAction != null) {
                taskConfigAction.configure(task);
            }
        } else {
            this.delayedTask = task;
        }
    }

    public final void postRegisterHook(@NotNull TaskProvider<T> taskProvider) {
        Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
        TaskCreationAction<T> taskCreationAction = this.creationAction;
        if (taskCreationAction != null) {
            String string = taskProvider.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"taskProvider.name");
            taskCreationAction.preConfigure(string);
        }
        PreConfigAction preConfigAction = this.preConfigAction;
        if (preConfigAction != null) {
            String string = taskProvider.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"taskProvider.name");
            preConfigAction.preConfigure(string);
        }
        TaskCreationAction<T> taskCreationAction2 = this.creationAction;
        if (taskCreationAction2 != null) {
            taskCreationAction2.handleProvider(taskProvider);
        }
        TaskProviderCallback<T> taskProviderCallback = this.providerHandler;
        if (taskProviderCallback != null) {
            taskProviderCallback.handleProvider(taskProvider);
        }
        T t = this.delayedTask;
        if (t != null) {
            T it = t;
            boolean bl = false;
            TaskCreationAction<T> taskCreationAction3 = this.creationAction;
            if (taskCreationAction3 != null) {
                taskCreationAction3.configure(it);
            }
            TaskConfigAction<T> taskConfigAction = this.configureAction;
            if (taskConfigAction != null) {
                taskConfigAction.configure(it);
            }
        }
        this.hasRunTaskProviderHandler = true;
    }

    public TaskConfigurationActions() {
        this(null, null, null, null, 15, null);
    }
}

