/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.api.dsl.AndroidSourceDirectorySet;
import com.android.build.api.dsl.AndroidSourceSet;
import com.android.build.gradle.internal.api.DefaultAndroidSourceDirectorySet;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.LibraryCreationConfig;
import com.android.build.gradle.internal.profile.AnalyticsConfiguratorService;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.utils.StringHelper;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.KotlinVersion;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.ClasspathNormalizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.dsl.KotlinJvmOptions;
import org.jetbrains.kotlin.gradle.plugin.KotlinBasePluginWrapper;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\u001a&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a6\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u0016\u001a\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0001\u001a\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u00012\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d\u001a\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001f\u001a\u00020\nH\u0002\u001a\u0010\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010\"\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010#\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010$\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010%\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0010\u0010&\u001a\u0004\u0018\u00010!2\u0006\u0010'\u001a\u00020\u0001\u001a\u001c\u0010(\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u001a \u0010)\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u001e\u0010*\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020-0,\u001a\u001e\u0010.\u001a\u00020\b*\u00020\n2\b\u0010/\u001a\u0004\u0018\u00010!2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a$\u00100\u001a\u00020\b*\u00020\n2\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020\u00012\u0006\u00103\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00064\u00b2\u0006\u0012\u00105\u001a\n\u0012\u0004\u0012\u000206\u0018\u00010,X\u008a\u0084\u0002"}, d2={"KOTLIN_ANDROID_PLUGIN_ID", "", "KOTLIN_KAPT_PLUGIN_ID", "KOTLIN_MPP_PLUGIN_ID", "KOTLIN_MPP_PLUGIN_IDS", "", "KSP_PLUGIN_ID", "addComposeArgsToKotlinCompile", "", "task", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompile;", "creationConfig", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "compilerExtension", "Lorg/gradle/api/file/FileCollection;", "useLiveLiterals", "", "configureKotlinCompileTasks", "project", "Lorg/gradle/api/Project;", "creationConfigs", "action", "Lkotlin/Function2;", "findKaptOrKspConfigurationsForVariant", "Lorg/gradle/api/artifacts/Configuration;", "kaptOrKsp", "getKotlinAndroidPluginVersion", "getKotlinPluginVersionFromPlugin", "plugin", "Lorg/gradle/api/Plugin;", "getLanguageVersionUnsafe", "kotlinCompile", "getProjectKotlinPluginKotlinVersion", "Lkotlin/KotlinVersion;", "isKotlinAndroidPluginApplied", "isKotlinKaptPluginApplied", "isKotlinPluginAppliedInTheSameClassloader", "isKspPluginApplied", "parseKotlinVersion", "currVersion", "recordKgpPropertiesForAnalytics", "recordKotlinCompilePropertiesForAnalytics", "syncAgpAndKgpSources", "sourceSets", "Lorg/gradle/api/NamedDomainObjectContainer;", "Lcom/android/build/api/dsl/AndroidSourceSet;", "addPluginClasspath", "kotlinVersion", "addPluginOption", "pluginId", "key", "value", "gradle-core", "kotlinSourceSets", ""})
@JvmName(name="KgpUtils")
@SourceDebugExtension(value={"SMAP\nkgpUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 kgpUtils.kt\ncom/android/build/gradle/internal/utils/KgpUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,321:1\n1747#2,3:322\n1194#2,2:327\n1222#2,4:329\n1747#2,3:334\n1603#2,9:337\n1855#2:346\n1856#2:348\n1612#2:349\n1109#3,2:325\n1#4:333\n1#4:347\n*S KotlinDebug\n*F\n+ 1 kgpUtils.kt\ncom/android/build/gradle/internal/utils/KgpUtils\n*L\n66#1:322,3\n145#1:327,2\n145#1:329,4\n258#1:334,3\n313#1:337,9\n313#1:346\n313#1:348\n313#1:349\n114#1:325,2\n313#1:347\n*E\n"})
public final class KgpUtils {
    @NotNull
    public static final String KOTLIN_ANDROID_PLUGIN_ID = "org.jetbrains.kotlin.android";
    @NotNull
    public static final String KOTLIN_KAPT_PLUGIN_ID = "org.jetbrains.kotlin.kapt";
    @NotNull
    public static final String KSP_PLUGIN_ID = "com.google.devtools.ksp";
    @NotNull
    public static final String KOTLIN_MPP_PLUGIN_ID = "org.jetbrains.kotlin.multiplatform";
    @NotNull
    private static final List<String> KOTLIN_MPP_PLUGIN_IDS;

    public static final boolean isKotlinPluginAppliedInTheSameClassloader(@NotNull Project project) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            boolean bl2;
            block6: {
                PluginContainer pluginContainer = project.getPlugins();
                Intrinsics.checkNotNullExpressionValue((Object)pluginContainer, (String)"project.plugins");
                Iterable $this$any$iv = (Iterable)pluginContainer;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Plugin it = (Plugin)element$iv;
                        boolean bl3 = false;
                        if (!(it instanceof KotlinBasePluginWrapper)) continue;
                        bl2 = true;
                        break block6;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        }
        catch (Throwable e) {
            if (!(e instanceof ClassNotFoundException) && !(e instanceof NoClassDefFoundError)) {
                throw e;
            }
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final KotlinVersion getProjectKotlinPluginKotlinVersion(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = KgpUtils.getKotlinAndroidPluginVersion(project);
        if (string == null) {
            return null;
        }
        String currVersion = string;
        return KgpUtils.parseKotlinVersion(currVersion);
    }

    @Nullable
    public static final KotlinVersion parseKotlinVersion(@NotNull String currVersion) {
        Intrinsics.checkNotNullParameter((Object)currVersion, (String)"currVersion");
        try {
            String[] stringArray = new String[]{"."};
            List parts = StringsKt.split$default((CharSequence)currVersion, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String major = (String)parts.get(0);
            String minor = (String)parts.get(1);
            String patch = StringsKt.substringBefore$default((String)((String)parts.get(2)), (char)'-', null, (int)2, null);
            return new KotlinVersion(Integer.parseInt(major), Integer.parseInt(minor), Integer.parseInt(patch));
        }
        catch (Throwable e) {
            KotlinVersion kotlinVersion = null;
            return kotlinVersion;
        }
    }

    @Nullable
    public static final String getKotlinAndroidPluginVersion(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Plugin plugin = project.getPlugins().findPlugin("kotlin-android");
        if (plugin == null) {
            return null;
        }
        Plugin plugin2 = plugin;
        return KgpUtils.getKotlinPluginVersionFromPlugin(plugin2);
    }

    @Nullable
    public static final String getKotlinPluginVersionFromPlugin(@NotNull Plugin<?> plugin) {
        String string;
        Intrinsics.checkNotNullParameter(plugin, (String)"plugin");
        try {
            Object element$iv2;
            block4: {
                Method[] methodArray = plugin.getClass().getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"plugin.javaClass.methods");
                Object[] $this$first$iv = methodArray;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    Method it = (Method)element$iv2;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"getKotlinPluginVersion") || Intrinsics.areEqual((Object)it.getName(), (Object)"getPluginVersion"))) {
                        continue;
                    }
                    break block4;
                }
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            Method method = (Method)element$iv2;
            method.setAccessible(true);
            string = method.invoke(plugin, new Object[0]).toString();
        }
        catch (Throwable e) {
            string = null;
        }
        return string;
    }

    public static final boolean isKotlinAndroidPluginApplied(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return project.getPluginManager().hasPlugin(KOTLIN_ANDROID_PLUGIN_ID);
    }

    public static final boolean isKotlinKaptPluginApplied(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return project.getPluginManager().hasPlugin(KOTLIN_KAPT_PLUGIN_ID);
    }

    public static final boolean isKspPluginApplied(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return project.getPluginManager().hasPlugin(KSP_PLUGIN_ID);
    }

    /*
     * WARNING - void declaration
     */
    public static final void configureKotlinCompileTasks(@NotNull Project project, @NotNull List<? extends ComponentCreationConfig> creationConfigs, @NotNull Function2<? super KotlinCompile, ? super ComponentCreationConfig, Unit> action) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(creationConfigs, (String)"creationConfigs");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Iterable $this$associateBy$iv = creationConfigs;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ComponentCreationConfig componentCreationConfig = (ComponentCreationConfig)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.computeTaskName("compile", "Kotlin"), element$iv$iv);
        }
        Map taskNamePrefixToVariant = destination$iv$iv;
        project.getTasks().withType(KotlinCompile.class).configureEach(new Action(taskNamePrefixToVariant, action){
            final /* synthetic */ Map<String, ComponentCreationConfig> $taskNamePrefixToVariant;
            final /* synthetic */ Function2<KotlinCompile, ComponentCreationConfig, Unit> $action;
            {
                this.$taskNamePrefixToVariant = $taskNamePrefixToVariant;
                this.$action = $action;
            }

            public final void execute(KotlinCompile kotlinCompile) {
                block1: {
                    ComponentCreationConfig componentCreationConfig;
                    Map<String, ComponentCreationConfig> $this$filterKeys$iv = this.$taskNamePrefixToVariant;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<String, ComponentCreationConfig> result$iv = new LinkedHashMap<String, ComponentCreationConfig>();
                    for (Map.Entry<String, ComponentCreationConfig> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = entry$iv.getKey();
                        boolean bl = false;
                        String string = kotlinCompile.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinCompile.name");
                        if (!StringsKt.startsWith$default((String)string, (String)it, (boolean)false, (int)2, null)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    Map.Entry entry = (Map.Entry)CollectionsKt.singleOrNull((Iterable)((Map)result$iv).entrySet());
                    if (entry == null || (componentCreationConfig = (ComponentCreationConfig)entry.getValue()) == null) break block1;
                    ComponentCreationConfig componentCreationConfig2 = componentCreationConfig;
                    Function2<KotlinCompile, ComponentCreationConfig, Unit> function2 = this.$action;
                    ComponentCreationConfig it = componentCreationConfig2;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinCompile, (String)"kotlinCompile");
                    function2.invoke((Object)kotlinCompile, (Object)it);
                }
            }
        });
    }

    public static final void recordKgpPropertiesForAnalytics(@NotNull Project project, @NotNull List<? extends ComponentCreationConfig> creationConfigs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(creationConfigs, (String)"creationConfigs");
        KgpUtils.configureKotlinCompileTasks(project, creationConfigs, (Function2<? super KotlinCompile, ? super ComponentCreationConfig, Unit>)((Function2)new Function2<KotlinCompile, ComponentCreationConfig, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(2);
            }

            public final void invoke(@NotNull KotlinCompile kotlinCompile, @NotNull ComponentCreationConfig creationConfig) {
                Intrinsics.checkNotNullParameter((Object)kotlinCompile, (String)"kotlinCompile");
                Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
                KgpUtils.access$recordKotlinCompilePropertiesForAnalytics(kotlinCompile, creationConfig, this.$project);
            }
        }));
    }

    private static final void recordKotlinCompilePropertiesForAnalytics(KotlinCompile kotlinCompile, ComponentCreationConfig creationConfig, Project project) {
        block1: {
            String string = KgpUtils.getLanguageVersionUnsafe(kotlinCompile);
            if (string == null) break block1;
            String languageVersion = string;
            boolean bl = false;
            AnalyticsConfiguratorService analyticsConfiguratorService = (AnalyticsConfiguratorService)BuildServicesKt.getBuildService(creationConfig.getServices().getBuildServiceRegistry(), AnalyticsConfiguratorService.class).get();
            String string2 = project.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.path");
            GradleBuildVariant.Builder builder = analyticsConfiguratorService.getVariantBuilder(string2, creationConfig.getName());
            if (builder != null) {
                GradleBuildVariant.Builder builder2;
                GradleBuildVariant.Builder $this$recordKotlinCompilePropertiesForAnalytics_u24lambda_u244_u24lambda_u243 = builder2 = builder;
                boolean bl2 = false;
                $this$recordKotlinCompilePropertiesForAnalytics_u24lambda_u244_u24lambda_u243.setKotlinOptions(GradleBuildVariant.KotlinOptions.newBuilder().setLanguageVersion(languageVersion));
            }
        }
    }

    private static final String getLanguageVersionUnsafe(KotlinCompile kotlinCompile) {
        Object object;
        try {
            boolean bl = false;
            object = Result.constructor-impl((Object)kotlinCompile.getKotlinOptions().getLanguageVersion());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (String)(Result.isFailure-impl((Object)object) ? null : object);
    }

    public static final void addComposeArgsToKotlinCompile(@NotNull KotlinCompile task, @NotNull ComponentCreationConfig creationConfig, @NotNull FileCollection compilerExtension, boolean useLiveLiterals) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        Intrinsics.checkNotNullParameter((Object)compilerExtension, (String)"compilerExtension");
        boolean debuggable = creationConfig instanceof ApkCreationConfig || creationConfig instanceof LibraryCreationConfig ? creationConfig.getDebuggable() : false;
        Project project = task.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"task.project");
        KotlinVersion kotlinVersion = KgpUtils.getProjectKotlinPluginKotlinVersion(project);
        KgpUtils.addPluginClasspath(task, kotlinVersion, compilerExtension);
        KgpUtils.addPluginOption(task, "androidx.compose.plugins.idea", "enabled", "true");
        if (debuggable) {
            KgpUtils.addPluginOption(task, "androidx.compose.compiler.plugins.kotlin", "sourceInformation", "true");
            if (useLiveLiterals) {
                KgpUtils.addPluginOption(task, "androidx.compose.compiler.plugins.kotlin", "liveLiterals", "true");
            }
        }
        KotlinJvmOptions kotlinJvmOptions = task.getKotlinOptions();
        kotlinJvmOptions.setFreeCompilerArgs(CollectionsKt.plus((Collection)kotlinJvmOptions.getFreeCompilerArgs(), (Object)"-Xallow-unstable-dependencies"));
    }

    private static final void addPluginClasspath(KotlinCompile $this$addPluginClasspath, KotlinVersion kotlinVersion, FileCollection compilerExtension) {
        if (kotlinVersion == null || kotlinVersion.isAtLeast(1, 7)) {
            Object[] objectArray = new Object[]{compilerExtension};
            $this$addPluginClasspath.getPluginClasspath().from(objectArray);
        } else {
            Object[] objectArray = new Object[]{compilerExtension};
            $this$addPluginClasspath.getInputs().files(objectArray).withPropertyName("composeCompilerExtension").withNormalizer(ClasspathNormalizer.class);
            $this$addPluginClasspath.doFirst(new Action(compilerExtension){
                final /* synthetic */ FileCollection $compilerExtension;
                {
                    this.$compilerExtension = $compilerExtension;
                }

                public final void execute(Task it) {
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.gradle.tasks.KotlinCompile");
                    KotlinJvmOptions kotlinJvmOptions = ((KotlinCompile)it).getKotlinOptions();
                    Collection collection = kotlinJvmOptions.getFreeCompilerArgs();
                    Set set = this.$compilerExtension.getFiles();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"compilerExtension.files");
                    kotlinJvmOptions.setFreeCompilerArgs(CollectionsKt.plus((Collection)collection, (Object)("-Xplugin=" + ((File)CollectionsKt.single((Iterable)set)).getPath())));
                }
            });
        }
    }

    private static final void addPluginOption(KotlinCompile $this$addPluginOption, String pluginId, String key, String value) {
        KotlinJvmOptions kotlinJvmOptions = $this$addPluginOption.getKotlinOptions();
        Object[] objectArray = new String[]{"-P", "plugin:" + pluginId + ":" + key + "=" + value};
        kotlinJvmOptions.setFreeCompilerArgs(CollectionsKt.plus((Collection)kotlinJvmOptions.getFreeCompilerArgs(), (Iterable)CollectionsKt.listOf((Object[])objectArray)));
    }

    public static final void syncAgpAndKgpSources(@NotNull Project project, @NotNull NamedDomainObjectContainer<? extends AndroidSourceSet> sourceSets) {
        boolean bl;
        boolean $i$f$any;
        block5: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(sourceSets, (String)"sourceSets");
            Iterable $this$any$iv = KOTLIN_MPP_PLUGIN_IDS;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!project.getPluginManager().hasPlugin(it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        boolean hasMpp = bl;
        try {
            Class.forName("org.gradle.api.internal.HasConvention");
            $i$f$any = true;
        }
        catch (Throwable ignored) {
            $i$f$any = false;
        }
        boolean hasConventionSupport = $i$f$any;
        Lazy kotlinSourceSets$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NamedDomainObjectContainer<Object>>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(0);
            }

            @Nullable
            public final NamedDomainObjectContainer<Object> invoke() {
                Object object = this.$project.getExtensions().findByName("kotlin");
                if (object == null) {
                    return null;
                }
                Object kotlinExtension = object;
                Object object2 = kotlinExtension.getClass().getMethod("getSourceSets", new Class[0]).invoke(kotlinExtension, new Object[0]);
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.gradle.api.NamedDomainObjectContainer<kotlin.Any>");
                return (NamedDomainObjectContainer)object2;
            }
        }));
        sourceSets.all(new Action(hasMpp, hasConventionSupport, (Lazy<? extends NamedDomainObjectContainer<Object>>)kotlinSourceSets$delegate){
            final /* synthetic */ boolean $hasMpp;
            final /* synthetic */ boolean $hasConventionSupport;
            final /* synthetic */ Lazy<NamedDomainObjectContainer<Object>> $kotlinSourceSets$delegate;
            {
                this.$hasMpp = $hasMpp;
                this.$hasConventionSupport = $hasConventionSupport;
                this.$kotlinSourceSets$delegate = $kotlinSourceSets$delegate;
            }

            public final void execute(AndroidSourceSet it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                SourceDirectorySet kotlinSourceSet = KgpUtils.access$syncAgpAndKgpSources$findKotlinSourceSet(it, this.$hasMpp, this.$hasConventionSupport, this.$kotlinSourceSets$delegate);
                if (kotlinSourceSet != null) {
                    if (!this.$hasMpp) {
                        Object[] objectArray = new Object[1];
                        AndroidSourceDirectorySet androidSourceDirectorySet = it.getKotlin();
                        Intrinsics.checkNotNull((Object)androidSourceDirectorySet, (String)"null cannot be cast to non-null type com.android.build.gradle.internal.api.DefaultAndroidSourceDirectorySet");
                        objectArray[0] = ((DefaultAndroidSourceDirectorySet)androidSourceDirectorySet).getSrcDirs();
                        kotlinSourceSet.srcDirs(objectArray);
                    }
                    AndroidSourceDirectorySet androidSourceDirectorySet = it.getKotlin();
                    Set set = kotlinSourceSet.getSrcDirs();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"kotlinSourceSet.srcDirs");
                    androidSourceDirectorySet.setSrcDirs((Iterable)set);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Configuration> findKaptOrKspConfigurationsForVariant(@NotNull ComponentCreationConfig creationConfig, @NotNull String kaptOrKsp) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        Intrinsics.checkNotNullParameter((Object)kaptOrKsp, (String)"kaptOrKsp");
        Iterable $this$mapNotNull$iv = creationConfig.getSources().getSourceProviderNames();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Configuration it$iv$iv;
            String configurationName;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String sourceSetName = (String)element$iv$iv;
            boolean bl2 = false;
            String string = configurationName = !Intrinsics.areEqual((Object)sourceSetName, (Object)"main") ? StringHelper.appendCapitalized((String)kaptOrKsp, (String)sourceSetName) : kaptOrKsp;
            if ((Configuration)creationConfig.getServices().getConfigurations().findByName(configurationName) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final NamedDomainObjectContainer<Object> syncAgpAndKgpSources$lambda$7(Lazy<? extends NamedDomainObjectContainer<Object>> $kotlinSourceSets$delegate) {
        Lazy<? extends NamedDomainObjectContainer<Object>> lazy = $kotlinSourceSets$delegate;
        return (NamedDomainObjectContainer)lazy.getValue();
    }

    private static final SourceDirectorySet syncAgpAndKgpSources$findKotlinSourceSet(AndroidSourceSet $this$syncAgpAndKgpSources_u24findKotlinSourceSet, boolean hasMpp, boolean hasConventionSupport, Lazy<? extends NamedDomainObjectContainer<Object>> kotlinSourceSets$delegate) {
        if (hasMpp) {
            if (!hasConventionSupport) {
                return null;
            }
            Object extensions = $this$syncAgpAndKgpSources_u24findKotlinSourceSet.getClass().getMethod("getExtensions", new Class[0]).invoke((Object)$this$syncAgpAndKgpSources_u24findKotlinSourceSet, new Object[0]);
            Object object = extensions.getClass().getMethod("getAsMap", new Class[0]).invoke(extensions, new Object[0]);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            Map plugins = (Map)object;
            Object v = plugins.get("kotlin");
            if (v == null) {
                return null;
            }
            Object kotlinConvention = v;
            return (SourceDirectorySet)kotlinConvention;
        }
        NamedDomainObjectContainer<Object> namedDomainObjectContainer = KgpUtils.syncAgpAndKgpSources$lambda$7(kotlinSourceSets$delegate);
        Object object = namedDomainObjectContainer != null ? namedDomainObjectContainer.findByName($this$syncAgpAndKgpSources_u24findKotlinSourceSet.getName()) : null;
        if (object == null) {
            return null;
        }
        Object kotlinSourceSet = object;
        Object object2 = kotlinSourceSet.getClass().getMethod("getKotlin", new Class[0]).invoke(kotlinSourceSet, new Object[0]);
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.gradle.api.file.SourceDirectorySet");
        return (SourceDirectorySet)object2;
    }

    public static final /* synthetic */ void access$recordKotlinCompilePropertiesForAnalytics(KotlinCompile kotlinCompile, ComponentCreationConfig creationConfig, Project project) {
        KgpUtils.recordKotlinCompilePropertiesForAnalytics(kotlinCompile, creationConfig, project);
    }

    public static final /* synthetic */ SourceDirectorySet access$syncAgpAndKgpSources$findKotlinSourceSet(AndroidSourceSet $receiver, boolean hasMpp, boolean hasConventionSupport, Lazy kotlinSourceSets$delegate) {
        return KgpUtils.syncAgpAndKgpSources$findKotlinSourceSet($receiver, hasMpp, hasConventionSupport, (Lazy<? extends NamedDomainObjectContainer<Object>>)kotlinSourceSets$delegate);
    }

    static {
        Object[] objectArray = new String[]{"kotlin-multiplatform", KOTLIN_MPP_PLUGIN_ID};
        KOTLIN_MPP_PLUGIN_IDS = CollectionsKt.listOf((Object[])objectArray);
    }
}

