/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.VariantOutput;
import com.android.build.api.component.impl.UnitTestImpl;
import com.android.build.api.variant.impl.HasHostTests;
import com.android.build.api.variant.impl.InternalHasDeviceTests;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.TestedAndroidConfig;
import com.android.build.gradle.internal.api.ApkVariantOutputImpl;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.api.LibraryVariantOutputImpl;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.api.TestVariantImpl;
import com.android.build.gradle.internal.api.TestedVariant;
import com.android.build.gradle.internal.api.UnitTestVariantImpl;
import com.android.build.gradle.internal.component.AndroidTestCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.crash.ExternalApiUsageException;
import com.android.build.gradle.internal.dsl.VariantOutputFactory;
import com.android.build.gradle.internal.services.DslServices;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;

public class ApiObjectFactory {
    private final BaseExtension extension;
    private final VariantFactory<?, ?, ?> variantFactory;
    private final DslServices dslServices;
    private final ReadOnlyObjectProvider readOnlyObjectProvider = new ReadOnlyObjectProvider();

    public ApiObjectFactory(BaseExtension extension2, VariantFactory<?, ?, ?> variantFactory2, DslServices dslServices2) {
        this.extension = extension2;
        this.variantFactory = variantFactory2;
        this.dslServices = dslServices2;
    }

    public BaseVariantImpl create(VariantCreationConfig variant) {
        BaseVariantData variantData = variant.getOldVariantApiLegacySupport().getVariantData();
        BaseVariantImpl variantApi = this.variantFactory.createVariantApi(variant, variantData, this.readOnlyObjectProvider);
        if (variantApi == null) {
            return null;
        }
        if (this.variantFactory.getComponentType().getHasTestComponents()) {
            AndroidTestCreationConfig androidTestVariantProperties = null;
            if (variant instanceof InternalHasDeviceTests) {
                androidTestVariantProperties = (AndroidTestCreationConfig)((InternalHasDeviceTests)((Object)variant)).getDefaultDeviceTest();
            }
            if (androidTestVariantProperties != null) {
                TestVariantImpl androidTestVariant = this.dslServices.newInstance(TestVariantImpl.class, androidTestVariantProperties.getOldVariantApiLegacySupport().getVariantData(), androidTestVariantProperties, variantApi, this.dslServices, this.readOnlyObjectProvider, this.dslServices.domainObjectContainer(VariantOutput.class));
                this.createVariantOutput(androidTestVariantProperties, androidTestVariant);
                ((TestedAndroidConfig)((Object)this.extension)).getTestVariants().add((Object)androidTestVariant);
                ((TestedVariant)((Object)variantApi)).setTestVariant(androidTestVariant);
            }
            UnitTestImpl unitTestVariantProperties = null;
            if (variant instanceof HasHostTests) {
                unitTestVariantProperties = ((HasHostTests)((Object)variant)).getUnitTest();
            }
            if (unitTestVariantProperties != null) {
                UnitTestVariantImpl unitTestVariant = this.dslServices.newInstance(UnitTestVariantImpl.class, unitTestVariantProperties.getOldVariantApiLegacySupport().getVariantData(), unitTestVariantProperties, variantApi, this.dslServices, this.readOnlyObjectProvider, this.dslServices.domainObjectContainer(VariantOutput.class));
                ((TestedAndroidConfig)((Object)this.extension)).getUnitTestVariants().add((Object)unitTestVariant);
                ((TestedVariant)((Object)variantApi)).setUnitTestVariant(unitTestVariant);
            }
        }
        this.createVariantOutput(variant, variantApi);
        try {
            this.extension.addVariant(variantApi);
        }
        catch (Throwable t) {
            throw new ExternalApiUsageException(t);
        }
        return variantApi;
    }

    private void createVariantOutput(ComponentCreationConfig component2, BaseVariantImpl variantApi) {
        VariantOutputFactory variantOutputFactory = new VariantOutputFactory(component2.getComponentType().isAar() ? LibraryVariantOutputImpl.class : ApkVariantOutputImpl.class, this.dslServices, this.extension, variantApi, component2.getComponentType(), component2.getTaskContainer());
        component2.getOldVariantApiLegacySupport().getOutputs().forEach(variantOutputFactory::create);
    }
}

