/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.JdkImageTransformDelegateKt;
import com.android.ide.common.process.CachedProcessOutputHandler;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.JavaVersion;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003J\u001e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0003J\u001e\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Lcom/android/build/gradle/internal/dependency/JdkTools;", "", "javaHome", "Ljava/io/File;", "processExecutor", "Lcom/android/ide/common/process/ProcessExecutor;", "logger", "Lcom/android/utils/ILogger;", "(Ljava/io/File;Lcom/android/ide/common/process/ProcessExecutor;Lcom/android/utils/ILogger;)V", "getJavaHome", "()Ljava/io/File;", "jlinkVersion", "", "getJlinkVersion", "()Ljava/lang/String;", "jlinkVersion$delegate", "Lkotlin/Lazy;", "jrtFsLocation", "getJrtFsLocation", "getLogger", "()Lcom/android/utils/ILogger;", "getProcessExecutor", "()Lcom/android/ide/common/process/ProcessExecutor;", "compileModuleDescriptor", "", "moduleInfoJava", "systemModulesJar", "outDir", "createJmodFromModularJar", "jmodFile", "moduleJar", "linkJmodsIntoJdkImage", "jmodDir", "moduleName", "gradle-core"})
public final class JdkTools {
    @NotNull
    private final File javaHome;
    @NotNull
    private final ProcessExecutor processExecutor;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final File jrtFsLocation;
    @NotNull
    private final Lazy jlinkVersion$delegate;

    public JdkTools(@NotNull File javaHome, @NotNull ProcessExecutor processExecutor2, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)javaHome, (String)"javaHome");
        Intrinsics.checkNotNullParameter((Object)processExecutor2, (String)"processExecutor");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.javaHome = javaHome;
        this.processExecutor = processExecutor2;
        this.logger = logger;
        this.jrtFsLocation = FilesKt.resolve((File)FilesKt.resolve((File)this.javaHome, (String)"lib"), (String)"jrt-fs.jar");
        this.jlinkVersion$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ JdkTools this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke() {
                String string;
                ProcessInfoBuilder processInfoBuilder;
                File jlinkExecutable = FilesKt.resolve((File)FilesKt.resolve((File)this.this$0.getJavaHome(), (String)"bin"), (String)JdkImageTransformDelegateKt.optionalExe("jlink"));
                Preconditions.checkArgument((boolean)jlinkExecutable.exists(), (String)"jlink executable %s does not exist.", (Object)jlinkExecutable);
                ProcessInfoBuilder $this$invoke_u24lambda_u240 = processInfoBuilder = new ProcessInfoBuilder();
                boolean bl = false;
                $this$invoke_u24lambda_u240.setExecutable(jlinkExecutable);
                $this$invoke_u24lambda_u240.addArgs("--version");
                ProcessInfoBuilder pib = processInfoBuilder;
                CachedProcessOutputHandler processOutputHandler = new CachedProcessOutputHandler();
                this.this$0.getProcessExecutor().execute(pib.createProcess(), (ProcessOutputHandler)processOutputHandler).rethrowFailure().assertNormalExitValue();
                String string2 = processOutputHandler.getProcessOutput().getStandardOutputAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"processOutputHandler.pro\u2026ut.standardOutputAsString");
                String processOutput = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                try {
                    string = JavaVersion.toVersion((Object)processOutput).getMajorVersion();
                }
                catch (Throwable t) {
                    string = processOutput;
                }
                return string;
            }
        }));
    }

    @NotNull
    public final File getJavaHome() {
        return this.javaHome;
    }

    @NotNull
    public final ProcessExecutor getProcessExecutor() {
        return this.processExecutor;
    }

    @NotNull
    public final ILogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final File getJrtFsLocation() {
        return this.jrtFsLocation;
    }

    @NotNull
    public final String getJlinkVersion() {
        Lazy lazy = this.jlinkVersion$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-jlinkVersion>(...)");
        return (String)object;
    }

    public final void compileModuleDescriptor(@NotNull File moduleInfoJava, @NotNull File systemModulesJar, @NotNull File outDir) {
        ProcessInfoBuilder processInfoBuilder;
        Intrinsics.checkNotNullParameter((Object)moduleInfoJava, (String)"moduleInfoJava");
        Intrinsics.checkNotNullParameter((Object)systemModulesJar, (String)"systemModulesJar");
        Intrinsics.checkNotNullParameter((Object)outDir, (String)"outDir");
        String classpathArgValue = systemModulesJar.getAbsolutePath();
        File javacExecutable = FilesKt.resolve((File)FilesKt.resolve((File)this.javaHome, (String)"bin"), (String)JdkImageTransformDelegateKt.optionalExe("javac"));
        Preconditions.checkArgument((boolean)javacExecutable.exists(), (String)"javac executable %s does not exist.", (Object)javacExecutable);
        ProcessInfoBuilder $this$compileModuleDescriptor_u24lambda_u240 = processInfoBuilder = new ProcessInfoBuilder();
        boolean bl = false;
        $this$compileModuleDescriptor_u24lambda_u240.setExecutable(javacExecutable);
        $this$compileModuleDescriptor_u24lambda_u240.addArgs("--system=none");
        $this$compileModuleDescriptor_u24lambda_u240.addArgs("--patch-module=java.base=" + classpathArgValue);
        $this$compileModuleDescriptor_u24lambda_u240.addArgs("-d", outDir.getAbsolutePath());
        $this$compileModuleDescriptor_u24lambda_u240.addArgs(moduleInfoJava.getAbsolutePath());
        ProcessInfoBuilder pib = processInfoBuilder;
        this.processExecutor.execute(pib.createProcess(), (ProcessOutputHandler)new LoggedProcessOutputHandler(this.logger)).rethrowFailure().assertNormalExitValue();
    }

    public final void createJmodFromModularJar(@NotNull File jmodFile, @NotNull String jlinkVersion2, @NotNull File moduleJar) {
        ProcessInfoBuilder processInfoBuilder;
        Intrinsics.checkNotNullParameter((Object)jmodFile, (String)"jmodFile");
        Intrinsics.checkNotNullParameter((Object)jlinkVersion2, (String)"jlinkVersion");
        Intrinsics.checkNotNullParameter((Object)moduleJar, (String)"moduleJar");
        File jmodExecutable = FilesKt.resolve((File)FilesKt.resolve((File)this.javaHome, (String)"bin"), (String)JdkImageTransformDelegateKt.optionalExe("jmod"));
        Preconditions.checkArgument((boolean)jmodExecutable.exists(), (String)"jmod executable %s does not exist.", (Object)jmodExecutable);
        ProcessInfoBuilder $this$createJmodFromModularJar_u24lambda_u241 = processInfoBuilder = new ProcessInfoBuilder();
        boolean bl = false;
        $this$createJmodFromModularJar_u24lambda_u241.setExecutable(jmodExecutable);
        $this$createJmodFromModularJar_u24lambda_u241.addArgs("create");
        $this$createJmodFromModularJar_u24lambda_u241.addArgs("--module-version", jlinkVersion2);
        $this$createJmodFromModularJar_u24lambda_u241.addArgs("--target-platform", "LINUX-OTHER");
        $this$createJmodFromModularJar_u24lambda_u241.addArgs("--class-path", moduleJar.getAbsolutePath());
        $this$createJmodFromModularJar_u24lambda_u241.addArgs(jmodFile.getAbsolutePath());
        ProcessInfoBuilder pib = processInfoBuilder;
        this.processExecutor.execute(pib.createProcess(), (ProcessOutputHandler)new LoggedProcessOutputHandler(this.logger)).rethrowFailure().assertNormalExitValue();
    }

    public final void linkJmodsIntoJdkImage(@NotNull File jmodDir, @NotNull String moduleName, @NotNull File outDir) {
        ProcessInfoBuilder processInfoBuilder;
        Intrinsics.checkNotNullParameter((Object)jmodDir, (String)"jmodDir");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)outDir, (String)"outDir");
        File jlinkExecutable = FilesKt.resolve((File)FilesKt.resolve((File)this.javaHome, (String)"bin"), (String)JdkImageTransformDelegateKt.optionalExe("jlink"));
        Preconditions.checkArgument((boolean)jlinkExecutable.exists(), (String)"jlink executable %s does not exist.", (Object)jlinkExecutable);
        ProcessInfoBuilder $this$linkJmodsIntoJdkImage_u24lambda_u242 = processInfoBuilder = new ProcessInfoBuilder();
        boolean bl = false;
        $this$linkJmodsIntoJdkImage_u24lambda_u242.setExecutable(jlinkExecutable);
        $this$linkJmodsIntoJdkImage_u24lambda_u242.addArgs("--module-path", jmodDir.getAbsolutePath());
        $this$linkJmodsIntoJdkImage_u24lambda_u242.addArgs("--add-modules", moduleName);
        $this$linkJmodsIntoJdkImage_u24lambda_u242.addArgs("--output", outDir.getAbsolutePath());
        $this$linkJmodsIntoJdkImage_u24lambda_u242.addArgs("--disable-plugin", "system-modules");
        ProcessInfoBuilder pib = processInfoBuilder;
        this.processExecutor.execute(pib.createProcess(), (ProcessOutputHandler)new LoggedProcessOutputHandler(this.logger)).rethrowFailure().assertNormalExitValue();
    }
}

