/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res;

import com.android.build.api.artifact.ArtifactTransformationRequest;
import com.android.build.api.artifact.impl.InAndOutDirectoryOperationRequestImpl;
import com.android.build.api.variant.BuiltArtifact;
import com.android.build.api.variant.MultiOutputHandler;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.res.ConvertProtoResourcesAction;
import com.android.build.gradle.internal.res.ConvertProtoResourcesParams;
import com.android.build.gradle.internal.res.ConvertProtoResourcesTask;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.Aapt2Input;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.buildanalyzer.common.TaskCategory;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.workers.WorkQueue;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@BuildAnalyzer(primaryTaskCategory=TaskCategory.ANDROID_RESOURCES)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000bR\u0014\u0010\u0013\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/res/ConvertProtoResourcesTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "aapt2Input", "Lcom/android/build/gradle/internal/services/Aapt2Input;", "getAapt2Input", "()Lcom/android/build/gradle/internal/services/Aapt2Input;", "artifactTransformationRequest", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/api/artifact/ArtifactTransformationRequest;", "getArtifactTransformationRequest", "()Lorg/gradle/api/provider/Property;", "binaryResourcesOutputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getBinaryResourcesOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "multiOutputHandler", "Lcom/android/build/api/variant/MultiOutputHandler;", "getMultiOutputHandler", "protoResourcesInputDir", "getProtoResourcesInputDir", "doTaskAction", "", "CreationAction", "gradle-core"})
public abstract class ConvertProtoResourcesTask
extends NonIncrementalTask {
    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getProtoResourcesInputDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getBinaryResourcesOutputDir();

    @Internal
    @NotNull
    public abstract Property<ArtifactTransformationRequest<ConvertProtoResourcesTask>> getArtifactTransformationRequest();

    @Nested
    @NotNull
    public abstract Property<MultiOutputHandler> getMultiOutputHandler();

    @Nested
    @NotNull
    public abstract Aapt2Input getAapt2Input();

    @Override
    protected void doTaskAction() {
        ArtifactTransformationRequest artifactTransformationRequest = (ArtifactTransformationRequest)this.getArtifactTransformationRequest().get();
        Task task = (Task)this;
        WorkQueue workQueue2 = this.getWorkerExecutor().noIsolation();
        Intrinsics.checkNotNullExpressionValue((Object)workQueue2, (String)"noIsolation(...)");
        artifactTransformationRequest.submit(task, workQueue2, ConvertProtoResourcesAction.class, (Function3)new Function3<BuiltArtifact, Directory, ConvertProtoResourcesParams, File>(this){
            final /* synthetic */ ConvertProtoResourcesTask this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            @NotNull
            public final File invoke(@NotNull BuiltArtifact builtArtifact, @NotNull Directory outputDir, @NotNull ConvertProtoResourcesParams parameters) {
                Intrinsics.checkNotNullParameter((Object)builtArtifact, (String)"builtArtifact");
                Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                parameters.getProtoResourcesInputFile().set(new File(builtArtifact.getOutputFile()));
                parameters.getBinaryResourcesOutputFile().set(new File(outputDir.getAsFile(), ((MultiOutputHandler)this.this$0.getMultiOutputHandler().get()).getOutputNameForSplit("shrunk-resources", "binary-format.ap_", builtArtifact.getOutputType(), builtArtifact.getFilters())));
                parameters.getAapt2Input().set((Object)this.this$0.getAapt2Input());
                File file = ((RegularFile)parameters.getBinaryResourcesOutputFile().get()).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
                return file;
            }
        });
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0016\u0010\u0017\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/res/ConvertProtoResourcesTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/res/ConvertProtoResourcesTask;", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "transformationRequest", "Lcom/android/build/api/artifact/ArtifactTransformationRequest;", "getTransformationRequest", "()Lcom/android/build/api/artifact/ArtifactTransformationRequest;", "setTransformationRequest", "(Lcom/android/build/api/artifact/ArtifactTransformationRequest;)V", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ConvertProtoResourcesTask, ApkCreationConfig> {
        @NotNull
        private final Class<ConvertProtoResourcesTask> type;
        @NotNull
        private final String name;
        public ArtifactTransformationRequest<ConvertProtoResourcesTask> transformationRequest;

        public CreationAction(@NotNull ApkCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig, false, 2, null);
            this.type = ConvertProtoResourcesTask.class;
            this.name = this.computeTaskName("convert", "ProtoResources");
        }

        @Override
        @NotNull
        public Class<ConvertProtoResourcesTask> getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public final ArtifactTransformationRequest<ConvertProtoResourcesTask> getTransformationRequest() {
            ArtifactTransformationRequest<ConvertProtoResourcesTask> artifactTransformationRequest = this.transformationRequest;
            if (artifactTransformationRequest != null) {
                return artifactTransformationRequest;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"transformationRequest");
            return null;
        }

        public final void setTransformationRequest(@NotNull ArtifactTransformationRequest<ConvertProtoResourcesTask> artifactTransformationRequest) {
            Intrinsics.checkNotNullParameter(artifactTransformationRequest, (String)"<set-?>");
            this.transformationRequest = artifactTransformationRequest;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ConvertProtoResourcesTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.setTransformationRequest((ArtifactTransformationRequest<ConvertProtoResourcesTask>)((ArtifactTransformationRequest)InAndOutDirectoryOperationRequestImpl.toTransformMany$gradle_core$default((InAndOutDirectoryOperationRequestImpl)((ApkCreationConfig)this.creationConfig).getArtifacts().use((TaskProvider)taskProvider).wiredWithDirectories((Function1)handleProvider.1.INSTANCE, (Function1)handleProvider.2.INSTANCE), InternalArtifactType.SHRUNK_RESOURCES_PROTO_FORMAT.INSTANCE, InternalArtifactType.SHRUNK_RESOURCES_BINARY_FORMAT.INSTANCE, null, null, 12, null)));
        }

        @Override
        public void configure(@NotNull ConvertProtoResourcesTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            HasConfigurableValuesKt.setDisallowChanges(task.getArtifactTransformationRequest(), this.getTransformationRequest());
            HasConfigurableValuesKt.setDisallowChanges(task.getMultiOutputHandler(), MultiOutputHandler.Companion.create(this.creationConfig));
            ((ApkCreationConfig)this.creationConfig).getServices().initializeAapt2Input(task.getAapt2Input());
        }
    }
}

