/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.dsl.SigningConfig;
import com.android.build.api.variant.impl.SigningConfigImpl;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.packaging.GradleKeystoreHelper;
import com.android.build.gradle.internal.privaysandboxsdk.PrivacySandboxSdkVariantScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.AndroidLocationsBuildService;
import com.android.build.gradle.internal.services.BaseServices;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.signing.SigningConfigData;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.ValidateSigningTask;
import com.android.build.gradle.internal.tasks.factory.AndroidVariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.builder.utils.ExceptionConsumer;
import com.android.builder.utils.SynchronizedFile;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.util.concurrent.ExecutionException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.VERIFICATION)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b'\u0018\u00002\u00020\u0001:\u0003\u0017\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0007J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\u0013*\u0004\u0018\u00010\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/tasks/ValidateSigningTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "defaultDebugKeystoreLocation", "Lorg/gradle/api/provider/Property;", "Ljava/io/File;", "getDefaultDebugKeystoreLocation", "()Lorg/gradle/api/provider/Property;", "dummyOutputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getDummyOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "signingConfigData", "Lcom/android/build/gradle/internal/signing/SigningConfigData;", "getSigningConfigData", "createDefaultDebugKeystoreIfNeeded", "", "doTaskAction", "forceRerun", "", "isSigningConfigUsingTheDefaultDebugKeystore", "isSameFile", "other", "CreationAction", "CreationForAssetPackBundleAction", "PrivacySandboxSdkCreationAction", "gradle-core"})
public abstract class ValidateSigningTask
extends NonIncrementalTask {
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getDummyOutputDirectory();

    @Internal
    @NotNull
    public abstract Property<SigningConfigData> getSigningConfigData();

    @Internal
    @NotNull
    public abstract Property<File> getDefaultDebugKeystoreLocation();

    @Override
    protected void doTaskAction() {
        if (((SigningConfigData)this.getSigningConfigData().get()).getStoreFile() == null) {
            throw new InvalidUserDataException("Keystore file not set for signing config " + ((SigningConfigData)this.getSigningConfigData().get()).getName());
        }
        if (this.isSigningConfigUsingTheDefaultDebugKeystore()) {
            this.createDefaultDebugKeystoreIfNeeded();
        } else {
            File file = ((SigningConfigData)this.getSigningConfigData().get()).getStoreFile();
            if (!(file != null ? file.isFile() : false)) {
                File file2 = ((SigningConfigData)this.getSigningConfigData().get()).getStoreFile();
                throw new InvalidUserDataException("Keystore file '" + (file2 != null ? file2.getAbsolutePath() : null) + "' not found for signing config '" + ((SigningConfigData)this.getSigningConfigData().get()).getName() + "'.");
            }
        }
    }

    private final void createDefaultDebugKeystoreIfNeeded() throws ExecutionException, IOException {
        Preconditions.checkState((boolean)this.getDefaultDebugKeystoreLocation().isPresent(), (String)"Debug keystore location is not specified.", (Object[])new Object[0]);
        File location2 = (File)this.getDefaultDebugKeystoreLocation().get();
        FileUtils.mkdirs((File)location2.getParentFile());
        if (!location2.getParentFile().canWrite()) {
            throw new IOException("Unable to create debug keystore in " + location2.getParentFile().getAbsolutePath() + " because it is not writable.");
        }
        SynchronizedFile.getInstanceWithMultiProcessLocking((File)location2).createIfAbsent(new ExceptionConsumer(this){
            final /* synthetic */ ValidateSigningTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(File it) {
                Intrinsics.checkNotNull((Object)it);
                Logger logger = this.this$0.getLogger();
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                GradleKeystoreHelper.createDefaultDebugStore(it, logger);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSigningConfigUsingTheDefaultDebugKeystore() {
        SigningConfigData signingConfig2 = (SigningConfigData)this.getSigningConfigData().get();
        if (!Intrinsics.areEqual((Object)signingConfig2.getName(), (Object)"debug")) return false;
        if (!Intrinsics.areEqual((Object)signingConfig2.getKeyAlias(), (Object)"AndroidDebugKey")) return false;
        if (!Intrinsics.areEqual((Object)signingConfig2.getKeyPassword(), (Object)"android")) return false;
        if (!Intrinsics.areEqual((Object)signingConfig2.getStorePassword(), (Object)"android")) return false;
        if (!Intrinsics.areEqual((Object)signingConfig2.getStoreType(), (Object)KeyStore.getDefaultType())) return false;
        File file = signingConfig2.getStoreFile();
        if (file == null) return false;
        if (!this.isSameFile(file, (File)this.getDefaultDebugKeystoreLocation().get())) return false;
        return true;
    }

    private final boolean isSameFile(File $this$isSameFile, File other) {
        return $this$isSameFile != null && other != null && FileUtils.isSameFile((File)$this$isSameFile, (File)other);
    }

    @VisibleForTesting
    public final boolean forceRerun() {
        File storeFile2 = (File)this.getSigningConfigData().map((Transformer)forceRerun.storeFile.1.INSTANCE).getOrNull();
        return storeFile2 == null || !storeFile2.isFile();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0016\u0010\u0013\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/ValidateSigningTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ValidateSigningTask;", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "creationConfig", "defaultDebugKeystoreLocation", "Ljava/io/File;", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;Ljava/io/File;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ValidateSigningTask, ApkCreationConfig> {
        @NotNull
        private final File defaultDebugKeystoreLocation;

        public CreationAction(@NotNull ApkCreationConfig creationConfig, @NotNull File defaultDebugKeystoreLocation) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            Intrinsics.checkNotNullParameter((Object)defaultDebugKeystoreLocation, (String)"defaultDebugKeystoreLocation");
            super(creationConfig, false, 2, null);
            this.defaultDebugKeystoreLocation = defaultDebugKeystoreLocation;
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("validateSigning");
        }

        @Override
        @NotNull
        public Class<ValidateSigningTask> getType() {
            return ValidateSigningTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ValidateSigningTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).on(InternalArtifactType.VALIDATE_SIGNING_CONFIG.INSTANCE);
        }

        @Override
        public void configure(@NotNull ValidateSigningTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            SigningConfigImpl signingConfigImpl = ((ApkCreationConfig)this.creationConfig).getSigningConfig();
            if (signingConfigImpl == null) {
                throw new IllegalStateException("No signing config configured for variant " + ((ApkCreationConfig)this.creationConfig).getName());
            }
            SigningConfigImpl signingConfig2 = signingConfigImpl;
            task.getSigningConfigData().set(((ApkCreationConfig)this.creationConfig).getServices().provider((Function0)new Function0<SigningConfigData>(signingConfig2){
                final /* synthetic */ SigningConfigImpl $signingConfig;
                {
                    this.$signingConfig = $signingConfig;
                    super(0);
                }

                @Nullable
                public final SigningConfigData invoke() {
                    return SigningConfigData.Companion.fromSigningConfig(this.$signingConfig);
                }
            }));
            task.getDefaultDebugKeystoreLocation().set((Object)this.defaultDebugKeystoreLocation);
            task.getOutputs().upToDateWhen(new Spec(task){
                final /* synthetic */ ValidateSigningTask $task;
                {
                    this.$task = $task;
                }

                public final boolean isSatisfiedBy(Task it) {
                    return !this.$task.forceRerun();
                }
            });
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0016\u0010\u0013\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/ValidateSigningTask$CreationForAssetPackBundleAction;", "Lcom/android/build/gradle/internal/tasks/factory/TaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ValidateSigningTask;", "artifacts", "Lcom/android/build/api/artifact/impl/ArtifactsImpl;", "signingConfig", "Lcom/android/build/api/dsl/SigningConfig;", "(Lcom/android/build/api/artifact/impl/ArtifactsImpl;Lcom/android/build/api/dsl/SigningConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationForAssetPackBundleAction
    extends TaskCreationAction<ValidateSigningTask> {
        @NotNull
        private final ArtifactsImpl artifacts;
        @NotNull
        private final SigningConfig signingConfig;
        @NotNull
        private final Class<ValidateSigningTask> type;
        @NotNull
        private final String name;

        public CreationForAssetPackBundleAction(@NotNull ArtifactsImpl artifacts2, @NotNull SigningConfig signingConfig2) {
            Intrinsics.checkNotNullParameter((Object)artifacts2, (String)"artifacts");
            Intrinsics.checkNotNullParameter((Object)signingConfig2, (String)"signingConfig");
            this.artifacts = artifacts2;
            this.signingConfig = signingConfig2;
            this.type = ValidateSigningTask.class;
            this.name = "validateSigning";
        }

        @Override
        @NotNull
        public Class<ValidateSigningTask> getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ValidateSigningTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.artifacts.setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).on(InternalArtifactType.VALIDATE_SIGNING_CONFIG.INSTANCE);
        }

        @Override
        public void configure(@NotNull ValidateSigningTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            task.getSigningConfigData().set((Object)SigningConfigData.Companion.fromDslSigningConfig(this.signingConfig));
            task.getOutputs().upToDateWhen(new Spec(task){
                final /* synthetic */ ValidateSigningTask $task;
                {
                    this.$task = $task;
                }

                public final boolean isSatisfiedBy(Task it) {
                    return !this.$task.forceRerun();
                }
            });
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0015\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\u0016\u0010\u0019\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001bH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/tasks/ValidateSigningTask$PrivacySandboxSdkCreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/AndroidVariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ValidateSigningTask;", "config", "Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;", "(Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;)V", "scope", "Lcom/android/build/gradle/internal/privaysandboxsdk/PrivacySandboxSdkVariantScope;", "(Lcom/android/build/gradle/internal/privaysandboxsdk/PrivacySandboxSdkVariantScope;)V", "artifacts", "Lcom/android/build/api/artifact/impl/ArtifactsImpl;", "services", "Lcom/android/build/gradle/internal/services/BaseServices;", "(Lcom/android/build/api/artifact/impl/ArtifactsImpl;Lcom/android/build/gradle/internal/services/BaseServices;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class PrivacySandboxSdkCreationAction
    extends AndroidVariantTaskCreationAction<ValidateSigningTask> {
        @NotNull
        private final ArtifactsImpl artifacts;
        @NotNull
        private final BaseServices services;

        public PrivacySandboxSdkCreationAction(@NotNull ArtifactsImpl artifacts2, @NotNull BaseServices services) {
            Intrinsics.checkNotNullParameter((Object)artifacts2, (String)"artifacts");
            Intrinsics.checkNotNullParameter((Object)services, (String)"services");
            this.artifacts = artifacts2;
            this.services = services;
        }

        public PrivacySandboxSdkCreationAction(@NotNull GlobalTaskCreationConfig config2) {
            Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
            this(config2.getGlobalArtifacts(), config2.getServices());
        }

        public PrivacySandboxSdkCreationAction(@NotNull PrivacySandboxSdkVariantScope scope) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            this(scope.getArtifacts(), scope.getServices());
        }

        @Override
        @NotNull
        public String getName() {
            return "validatePrivacySandboxSdkSigning";
        }

        @Override
        @NotNull
        public Class<ValidateSigningTask> getType() {
            return ValidateSigningTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ValidateSigningTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.artifacts.setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).on(InternalArtifactType.VALIDATE_SIGNING_CONFIG.INSTANCE);
        }

        @Override
        public void configure(@NotNull ValidateSigningTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((AndroidVariantTask)task);
            Provider provider2 = BuildServicesKt.getBuildService(this.services.getBuildServiceRegistry(), AndroidLocationsBuildService.class).map((Transformer)configure.signingConfigDataProvider.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"map(...)");
            Provider signingConfigDataProvider2 = provider2;
            task.getSigningConfigData().set(signingConfigDataProvider2);
            task.getDefaultDebugKeystoreLocation().set(signingConfigDataProvider2.map((Transformer)configure.1.INSTANCE));
            task.getOutputs().upToDateWhen(new Spec(task){
                final /* synthetic */ ValidateSigningTask $task;
                {
                    this.$task = $task;
                }

                public final boolean isSatisfiedBy(Task it) {
                    return !this.$task.forceRerun();
                }
            });
        }
    }
}

