/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.ArtifactTransformationRequest;
import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.artifact.impl.InAndOutDirectoryOperationRequestImpl;
import com.android.build.api.variant.BuiltArtifact;
import com.android.build.api.variant.MultiOutputHandler;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.transforms.ShrinkProtoResourcesAction;
import com.android.build.gradle.internal.transforms.ShrinkProtoResourcesParams;
import com.android.build.gradle.internal.transforms.ShrinkResourcesNewShrinkerTask;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.PackageAndroidArtifact;
import com.android.buildanalyzer.common.TaskCategory;
import java.io.File;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.workers.WorkQueue;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@BuildAnalyzer(primaryTaskCategory=TaskCategory.OPTIMIZATION, secondaryTaskCategories={TaskCategory.ANDROID_RESOURCES})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0014R \u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0007R\u0014\u0010\u0017\u001a\u00020\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0013R\u0014\u0010\u0019\u001a\u00020\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0013R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0007\u00a8\u0006!"}, d2={"Lcom/android/build/gradle/internal/transforms/ShrinkResourcesNewShrinkerTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "artifactTransformationRequest", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/api/artifact/ArtifactTransformationRequest;", "getArtifactTransformationRequest", "()Lorg/gradle/api/provider/Property;", "dex", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getDex", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "mappingFileSrc", "Lorg/gradle/api/file/RegularFileProperty;", "getMappingFileSrc", "()Lorg/gradle/api/file/RegularFileProperty;", "originalResources", "Lorg/gradle/api/file/DirectoryProperty;", "getOriginalResources", "()Lorg/gradle/api/file/DirectoryProperty;", "outputsHandler", "Lcom/android/build/api/variant/MultiOutputHandler;", "getOutputsHandler", "resourceDir", "getResourceDir", "shrunkResources", "getShrunkResources", "usePreciseShrinking", "", "getUsePreciseShrinking", "doTaskAction", "", "CreationAction", "gradle-core"})
public abstract class ShrinkResourcesNewShrinkerTask
extends NonIncrementalTask {
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getShrunkResources();

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getOriginalResources();

    @Internal
    @NotNull
    public abstract Property<ArtifactTransformationRequest<ShrinkResourcesNewShrinkerTask>> getArtifactTransformationRequest();

    @Nested
    @NotNull
    public abstract Property<MultiOutputHandler> getOutputsHandler();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @Optional
    @NotNull
    public abstract RegularFileProperty getMappingFileSrc();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getResourceDir();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getDex();

    @Input
    @NotNull
    public abstract Property<Boolean> getUsePreciseShrinking();

    @Override
    protected void doTaskAction() {
        ArtifactTransformationRequest artifactTransformationRequest = (ArtifactTransformationRequest)this.getArtifactTransformationRequest().get();
        Task task = (Task)this;
        WorkQueue workQueue2 = this.getWorkerExecutor().noIsolation();
        Intrinsics.checkNotNullExpressionValue((Object)workQueue2, (String)"noIsolation(...)");
        artifactTransformationRequest.submit(task, workQueue2, ShrinkProtoResourcesAction.class, (Function3)new Function3<BuiltArtifact, Directory, ShrinkProtoResourcesParams, File>(this){
            final /* synthetic */ ShrinkResourcesNewShrinkerTask this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            @NotNull
            public final File invoke(@NotNull BuiltArtifact builtArtifact, @NotNull Directory directory2, @NotNull ShrinkProtoResourcesParams parameters) {
                Intrinsics.checkNotNullParameter((Object)builtArtifact, (String)"builtArtifact");
                Intrinsics.checkNotNullParameter((Object)directory2, (String)"directory");
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                parameters.getOriginalProtoFile().set(new File(builtArtifact.getOutputFile()));
                RegularFileProperty regularFileProperty = parameters.getShrunkProtoFile();
                File file = directory2.getAsFile();
                MultiOutputHandler multiOutputHandler = (MultiOutputHandler)this.this$0.getOutputsHandler().get();
                String string = InternalArtifactType.SHRUNK_RESOURCES_PROTO_FORMAT.INSTANCE.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                regularFileProperty.set(new File(file, multiOutputHandler.getOutputNameForSplit(StringsKt.replace$default((String)string, (String)"_", (String)"-", (boolean)false, (int)4, null), "", builtArtifact.getOutputType(), builtArtifact.getFilters()) + ".ap_"));
                parameters.getMappingFileSrc().set((Provider)this.this$0.getMappingFileSrc());
                if (this.this$0.getMappingFileSrc().isPresent()) {
                    File file2 = ((RegularFile)this.this$0.getMappingFileSrc().get()).getAsFile().getParentFile();
                    if (file2 != null) {
                        File it = file2;
                        boolean bl = false;
                        parameters.getReportFile().set(new File(it, "resources.txt"));
                    }
                }
                Object[] objectArray = new Object[]{this.this$0.getDex()};
                parameters.getDex().from(objectArray);
                parameters.getResourceDir().set((Provider)this.this$0.getResourceDir());
                parameters.getUsePreciseShrinking().set((Provider)this.this$0.getUsePreciseShrinking());
                File file3 = ((RegularFile)parameters.getShrunkProtoFile().get()).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getAsFile(...)");
                return file3;
            }
        });
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0016\u0010\u0017\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/transforms/ShrinkResourcesNewShrinkerTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/transforms/ShrinkResourcesNewShrinkerTask;", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "transformationRequest", "Lcom/android/build/api/artifact/ArtifactTransformationRequest;", "getTransformationRequest", "()Lcom/android/build/api/artifact/ArtifactTransformationRequest;", "setTransformationRequest", "(Lcom/android/build/api/artifact/ArtifactTransformationRequest;)V", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ShrinkResourcesNewShrinkerTask, ApkCreationConfig> {
        @NotNull
        private final Class<ShrinkResourcesNewShrinkerTask> type;
        @NotNull
        private final String name;
        public ArtifactTransformationRequest<ShrinkResourcesNewShrinkerTask> transformationRequest;

        public CreationAction(@NotNull ApkCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig, false, 2, null);
            this.type = ShrinkResourcesNewShrinkerTask.class;
            this.name = this.computeTaskName("shrink", "Res");
        }

        @Override
        @NotNull
        public Class<ShrinkResourcesNewShrinkerTask> getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public final ArtifactTransformationRequest<ShrinkResourcesNewShrinkerTask> getTransformationRequest() {
            ArtifactTransformationRequest<ShrinkResourcesNewShrinkerTask> artifactTransformationRequest = this.transformationRequest;
            if (artifactTransformationRequest != null) {
                return artifactTransformationRequest;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"transformationRequest");
            return null;
        }

        public final void setTransformationRequest(@NotNull ArtifactTransformationRequest<ShrinkResourcesNewShrinkerTask> artifactTransformationRequest) {
            Intrinsics.checkNotNullParameter(artifactTransformationRequest, (String)"<set-?>");
            this.transformationRequest = artifactTransformationRequest;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ShrinkResourcesNewShrinkerTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.setTransformationRequest((ArtifactTransformationRequest<ShrinkResourcesNewShrinkerTask>)((ArtifactTransformationRequest)InAndOutDirectoryOperationRequestImpl.toTransformMany$gradle_core$default((InAndOutDirectoryOperationRequestImpl)((ApkCreationConfig)this.creationConfig).getArtifacts().use((TaskProvider)taskProvider).wiredWithDirectories((Function1)handleProvider.1.INSTANCE, (Function1)handleProvider.2.INSTANCE), InternalArtifactType.LINKED_RESOURCES_PROTO_FORMAT.INSTANCE, InternalArtifactType.SHRUNK_RESOURCES_PROTO_FORMAT.INSTANCE, null, null, 12, null)));
        }

        @Override
        public void configure(@NotNull ShrinkResourcesNewShrinkerTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.getUsePreciseShrinking().set((Object)((ApkCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.ENABLE_NEW_RESOURCE_SHRINKER_PRECISE));
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct((Artifact.Single)SingleArtifact.OBFUSCATION_MAPPING_FILE.INSTANCE, (Property)task.getMappingFileSrc());
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.MERGED_NOT_COMPILED_RES.INSTANCE, (Property)task.getResourceDir());
            task.getArtifactTransformationRequest().set(this.getTransformationRequest());
            Object[] objectArray = new Object[]{PackageAndroidArtifact.CreationAction.Companion.getDexFolders((ApkCreationConfig)this.creationConfig)};
            task.getDex().from(objectArray);
            HasConfigurableValuesKt.setDisallowChanges(task.getOutputsHandler(), MultiOutputHandler.Companion.create(this.creationConfig));
        }
    }
}

