/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.api.variant.ApkInstallGroup;
import com.android.build.api.variant.DeviceSpec;
import com.android.build.api.variant.impl.BuiltArtifactsImpl;
import com.android.build.api.variant.impl.BuiltArtifactsLoaderImpl;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.tasks.BundleInstallUtils;
import com.android.build.gradle.internal.test.BuiltArtifactsSplitOutputMatcher;
import com.android.build.gradle.internal.utils.ApkSources;
import com.android.build.gradle.internal.utils.DefaultDeviceApkOutput;
import com.android.build.gradle.internal.utils.DeviceApkOutput;
import com.android.build.gradle.internal.utils.InstallApkUtilsKt;
import com.android.build.gradle.internal.utils.SdkApkInstallGroup;
import com.android.builder.internal.InstallUtils;
import com.android.sdklib.AndroidVersion;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0003\u0017\u0018\u0019B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/utils/DefaultDeviceApkOutput;", "Lcom/android/build/gradle/internal/utils/DeviceApkOutput;", "apkSources", "Lcom/android/build/gradle/internal/utils/ApkSources;", "supportedAbis", "", "", "minSdkVersion", "Lcom/android/sdklib/AndroidVersion;", "variantName", "projectPath", "iLogger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "(Lcom/android/build/gradle/internal/utils/ApkSources;Ljava/util/Set;Lcom/android/sdklib/AndroidVersion;Ljava/lang/String;Ljava/lang/String;Lcom/android/build/gradle/internal/LoggerWrapper;)V", "getApks", "", "Lcom/android/build/api/variant/ApkInstallGroup;", "deviceSpec", "Lcom/android/build/api/variant/DeviceSpec;", "getMainApks", "Ljava/io/File;", "mainApkDirectory", "Lorg/gradle/api/file/Directory;", "Companion", "DefaultApkInstallGroup", "DefaultSdkApkInstallGroup", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nDefaultDeviceApkOutput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultDeviceApkOutput.kt\ncom/android/build/gradle/internal/utils/DefaultDeviceApkOutput\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1855#2,2:133\n1549#2:135\n1620#2,3:136\n*S KotlinDebug\n*F\n+ 1 DefaultDeviceApkOutput.kt\ncom/android/build/gradle/internal/utils/DefaultDeviceApkOutput\n*L\n61#1:133,2\n83#1:135\n83#1:136,3\n*E\n"})
public final class DefaultDeviceApkOutput
implements DeviceApkOutput {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ApkSources apkSources;
    @Nullable
    private final Set<String> supportedAbis;
    @NotNull
    private final AndroidVersion minSdkVersion;
    @NotNull
    private final String variantName;
    @NotNull
    private final String projectPath;
    @NotNull
    private final LoggerWrapper iLogger;

    public DefaultDeviceApkOutput(@NotNull ApkSources apkSources, @Nullable Set<String> supportedAbis2, @NotNull AndroidVersion minSdkVersion2, @NotNull String variantName, @NotNull String projectPath, @NotNull LoggerWrapper iLogger) {
        Intrinsics.checkNotNullParameter((Object)apkSources, (String)"apkSources");
        Intrinsics.checkNotNullParameter((Object)minSdkVersion2, (String)"minSdkVersion");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)iLogger, (String)"iLogger");
        this.apkSources = apkSources;
        this.supportedAbis = supportedAbis2;
        this.minSdkVersion = minSdkVersion2;
        this.variantName = variantName;
        this.projectPath = projectPath;
        this.iLogger = iLogger;
    }

    public /* synthetic */ DefaultDeviceApkOutput(ApkSources apkSources, Set set, AndroidVersion androidVersion, String string, String string2, LoggerWrapper loggerWrapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            LoggerWrapper loggerWrapper2 = LoggerWrapper.getLogger(DefaultDeviceApkOutput.class);
            Intrinsics.checkNotNullExpressionValue((Object)loggerWrapper2, (String)"getLogger(...)");
            loggerWrapper = loggerWrapper2;
        }
        this(apkSources, set, androidVersion, string, string2, loggerWrapper);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ApkInstallGroup> getApks(@NotNull DeviceSpec deviceSpec) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$forEach$iv;
        List<File> mainApks;
        Intrinsics.checkNotNullParameter((Object)deviceSpec, (String)"deviceSpec");
        List apkInstallGroups = new ArrayList();
        LinkedList linkedList = Lists.newLinkedList();
        Intrinsics.checkNotNullExpressionValue((Object)linkedList, (String)"newLinkedList(...)");
        List apkFiles2 = linkedList;
        if (InstallUtils.checkDeviceApiLevel((String)deviceSpec.getName(), (int)deviceSpec.getApiLevel(), (String)deviceSpec.getCodeName(), (AndroidVersion)this.minSdkVersion, (ILogger)this.iLogger, (String)this.projectPath, (String)this.variantName)) {
            boolean privacySandboxSdksPresent;
            Object object = this.apkSources.getMainApkArtifact().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            mainApks = this.getMainApks((Directory)object, deviceSpec);
            if (!((Collection)mainApks).isEmpty()) {
                apkFiles2.addAll((Collection)mainApks);
            }
            boolean bl = privacySandboxSdksPresent = !this.apkSources.getPrivacySandboxSdksApksFiles().isEmpty() || this.apkSources.getAdditionalSupportedSdkApkSplits().isPresent();
            if (privacySandboxSdksPresent && deviceSpec.getSupportsPrivacySandbox()) {
                Set set = this.apkSources.getPrivacySandboxSdksApksFiles().getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
                $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File file = (File)element$iv;
                    boolean bl2 = false;
                    Path path = file.toPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                    List sdkApkFiles2 = BundleInstallUtils.extractApkFilesBypassingBundleTool(path).stream().map(getApks.1.sdkApkFiles.1.INSTANCE).map(getApks.1.sdkApkFiles.2.INSTANCE).collect(Collectors.toUnmodifiableList());
                    RegularFile regularFile = new RegularFile(file){
                        final /* synthetic */ File $file;
                        {
                            this.$file = $file;
                        }

                        public final File getAsFile() {
                            return this.$file;
                        }
                    };
                    Intrinsics.checkNotNull(sdkApkFiles2);
                    apkInstallGroups.add(new DefaultSdkApkInstallGroup(regularFile, sdkApkFiles2));
                }
                apkFiles2.addAll((Collection)InstallApkUtilsKt.getFiles(this.apkSources.getAdditionalSupportedSdkApkSplits()));
            } else {
                apkFiles2.addAll((Collection)InstallApkUtilsKt.getFiles(this.apkSources.getPrivacySandboxSdkSplitApksForLegacy()));
            }
            Provider<Directory> provider2 = this.apkSources.getDexMetadataDirectory();
            Object object2 = this.apkSources.getMainApkArtifact().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            InstallApkUtilsKt.addDexMetadataFiles(provider2, (Directory)object2, deviceSpec.getApiLevel(), apkFiles2, this.iLogger);
        }
        mainApks = apkFiles2;
        List list = apkInstallGroups;
        boolean $i$f$map = false;
        $this$forEach$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File bl2 = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((RegularFile)new RegularFile((File)it){
                final /* synthetic */ File $it;
                {
                    this.$it = $it;
                }

                public final File getAsFile() {
                    return this.$it;
                }
            });
        }
        String string = "Main Apk Group";
        List list2 = (List)destination$iv$iv;
        list.add(new DefaultApkInstallGroup(list2, string));
        return apkInstallGroups;
    }

    private final List<File> getMainApks(Directory mainApkDirectory, DeviceSpec deviceSpec) {
        BuiltArtifactsLoaderImpl builtArtifactsLoader = new BuiltArtifactsLoaderImpl();
        BuiltArtifactsImpl builtArtifacts = builtArtifactsLoader.load(mainApkDirectory);
        if (builtArtifacts != null) {
            Set<String> set = this.supportedAbis;
            return BuiltArtifactsSplitOutputMatcher.INSTANCE.computeBestOutput(deviceSpec.getAbis(), builtArtifacts, set != null ? (Collection)set : (Collection)SetsKt.emptySet());
        }
        return CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/utils/DefaultDeviceApkOutput$Companion;", "", "()V", "getApkInputs", "", "apkSources", "Lcom/android/build/gradle/internal/utils/ApkSources;", "deviceSpec", "Lcom/android/build/api/variant/DeviceSpec;", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nDefaultDeviceApkOutput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultDeviceApkOutput.kt\ncom/android/build/gradle/internal/utils/DefaultDeviceApkOutput$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1#2:133\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<Object> getApkInputs(@NotNull ApkSources apkSources, @NotNull DeviceSpec deviceSpec) {
            Intrinsics.checkNotNullParameter((Object)apkSources, (String)"apkSources");
            Intrinsics.checkNotNullParameter((Object)deviceSpec, (String)"deviceSpec");
            Object[] objectArray = new Object[]{apkSources.getMainApkArtifact()};
            Set taskInputs = SetsKt.mutableSetOf((Object[])objectArray);
            Provider<Directory> provider2 = apkSources.getDexMetadataDirectory();
            if (provider2 != null) {
                Provider<Directory> it = provider2;
                boolean bl = false;
                taskInputs.add(it);
            }
            if (deviceSpec.getSupportsPrivacySandbox()) {
                objectArray = new Object[]{apkSources.getPrivacySandboxSdksApksFiles(), apkSources.getAdditionalSupportedSdkApkSplits()};
                taskInputs.addAll(CollectionsKt.listOf((Object[])objectArray));
            } else {
                taskInputs.add(apkSources.getPrivacySandboxSdkSplitApksForLegacy());
            }
            return taskInputs;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/utils/DefaultDeviceApkOutput$DefaultApkInstallGroup;", "Lcom/android/build/api/variant/ApkInstallGroup;", "apks", "", "Lorg/gradle/api/file/RegularFile;", "description", "", "(Ljava/util/List;Ljava/lang/String;)V", "getApks", "()Ljava/util/List;", "getDescription", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "gradle-core"})
    public static final class DefaultApkInstallGroup
    implements ApkInstallGroup {
        @NotNull
        private final List<RegularFile> apks;
        @NotNull
        private final String description;

        public DefaultApkInstallGroup(@NotNull List<? extends RegularFile> apks, @NotNull String description) {
            Intrinsics.checkNotNullParameter(apks, (String)"apks");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            this.apks = apks;
            this.description = description;
        }

        @NotNull
        public List<RegularFile> getApks() {
            return this.apks;
        }

        @NotNull
        public String getDescription() {
            return this.description;
        }

        @NotNull
        public final List<RegularFile> component1() {
            return this.apks;
        }

        @NotNull
        public final String component2() {
            return this.description;
        }

        @NotNull
        public final DefaultApkInstallGroup copy(@NotNull List<? extends RegularFile> apks, @NotNull String description) {
            Intrinsics.checkNotNullParameter(apks, (String)"apks");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            return new DefaultApkInstallGroup(apks, description);
        }

        public static /* synthetic */ DefaultApkInstallGroup copy$default(DefaultApkInstallGroup defaultApkInstallGroup, List list, String string, int n, Object object) {
            if ((n & 1) != 0) {
                list = defaultApkInstallGroup.apks;
            }
            if ((n & 2) != 0) {
                string = defaultApkInstallGroup.description;
            }
            return defaultApkInstallGroup.copy(list, string);
        }

        @NotNull
        public String toString() {
            return "DefaultApkInstallGroup(apks=" + this.apks + ", description=" + this.description + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.apks).hashCode();
            result2 = result2 * 31 + this.description.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DefaultApkInstallGroup)) {
                return false;
            }
            DefaultApkInstallGroup defaultApkInstallGroup = (DefaultApkInstallGroup)other;
            if (!Intrinsics.areEqual(this.apks, defaultApkInstallGroup.apks)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.description, (Object)defaultApkInstallGroup.description);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/utils/DefaultDeviceApkOutput$DefaultSdkApkInstallGroup;", "Lcom/android/build/gradle/internal/utils/SdkApkInstallGroup;", "sdkFile", "Lorg/gradle/api/file/RegularFile;", "apks", "", "(Lorg/gradle/api/file/RegularFile;Ljava/util/List;)V", "getApks", "()Ljava/util/List;", "getSdkFile", "()Lorg/gradle/api/file/RegularFile;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "gradle-core"})
    public static final class DefaultSdkApkInstallGroup
    implements SdkApkInstallGroup {
        @NotNull
        private final RegularFile sdkFile;
        @NotNull
        private final List<RegularFile> apks;

        public DefaultSdkApkInstallGroup(@NotNull RegularFile sdkFile, @NotNull List<? extends RegularFile> apks) {
            Intrinsics.checkNotNullParameter((Object)sdkFile, (String)"sdkFile");
            Intrinsics.checkNotNullParameter(apks, (String)"apks");
            this.sdkFile = sdkFile;
            this.apks = apks;
        }

        @Override
        @NotNull
        public RegularFile getSdkFile() {
            return this.sdkFile;
        }

        @NotNull
        public List<RegularFile> getApks() {
            return this.apks;
        }

        @NotNull
        public final RegularFile component1() {
            return this.sdkFile;
        }

        @NotNull
        public final List<RegularFile> component2() {
            return this.apks;
        }

        @NotNull
        public final DefaultSdkApkInstallGroup copy(@NotNull RegularFile sdkFile, @NotNull List<? extends RegularFile> apks) {
            Intrinsics.checkNotNullParameter((Object)sdkFile, (String)"sdkFile");
            Intrinsics.checkNotNullParameter(apks, (String)"apks");
            return new DefaultSdkApkInstallGroup(sdkFile, apks);
        }

        public static /* synthetic */ DefaultSdkApkInstallGroup copy$default(DefaultSdkApkInstallGroup defaultSdkApkInstallGroup, RegularFile regularFile, List list, int n, Object object) {
            if ((n & 1) != 0) {
                regularFile = defaultSdkApkInstallGroup.sdkFile;
            }
            if ((n & 2) != 0) {
                list = defaultSdkApkInstallGroup.apks;
            }
            return defaultSdkApkInstallGroup.copy(regularFile, list);
        }

        @NotNull
        public String toString() {
            return "DefaultSdkApkInstallGroup(sdkFile=" + this.sdkFile + ", apks=" + this.apks + ")";
        }

        public int hashCode() {
            int result2 = this.sdkFile.hashCode();
            result2 = result2 * 31 + ((Object)this.apks).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DefaultSdkApkInstallGroup)) {
                return false;
            }
            DefaultSdkApkInstallGroup defaultSdkApkInstallGroup = (DefaultSdkApkInstallGroup)other;
            if (!Intrinsics.areEqual((Object)this.sdkFile, (Object)defaultSdkApkInstallGroup.sdkFile)) {
                return false;
            }
            return Intrinsics.areEqual(this.apks, defaultSdkApkInstallGroup.apks);
        }
    }
}

