/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.GradleLocalPropertiesFactory;
import com.android.build.gradle.internal.SdkLocation;
import com.android.build.gradle.internal.SdkLocationSourceSet;
import com.android.build.gradle.internal.SdkType;
import com.android.builder.errors.IssueReporter;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005\"#$%&B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J \u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tH\u0007J\u0018\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u001e\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u001f\u001a\u00020\u001dH\u0007J\u0018\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\tH\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006'"}, d2={"Lcom/android/build/gradle/internal/SdkLocator;", "", "()V", "ANDROID_HOME_SYSTEM_PROPERTY", "", "getANDROID_HOME_SYSTEM_PROPERTY$annotations", "cachedSdkLocation", "Lcom/android/build/gradle/internal/SdkLocation;", "cachedSdkLocationKey", "Lcom/android/build/gradle/internal/SdkLocationSourceSet;", "sdkTestDirectory", "Ljava/io/File;", "getSdkTestDirectory$annotations", "getSdkTestDirectory", "()Ljava/io/File;", "setSdkTestDirectory", "(Ljava/io/File;)V", "createWarningMessage", "failures", "", "Lcom/android/build/gradle/internal/SdkLocator$ValidationFailure;", "getSdkDirectory", "projectRootDir", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "sdkLocationSourceSet", "getSdkLocation", "sourceSet", "reportWarnings", "", "validationFailures", "resetCache", "updateCache", "sdkLocation", "PropertyLocation", "SdkLocationSource", "ValidationFailure", "ValidationProblem", "ValidationResult", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nSdkLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkLocator.kt\ncom/android/build/gradle/internal/SdkLocator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,418:1\n1789#2,3:419\n*S KotlinDebug\n*F\n+ 1 SdkLocator.kt\ncom/android/build/gradle/internal/SdkLocator\n*L\n338#1:419,3\n*E\n"})
public final class SdkLocator {
    @NotNull
    public static final SdkLocator INSTANCE = new SdkLocator();
    @Nullable
    private static File sdkTestDirectory;
    @NotNull
    public static final String ANDROID_HOME_SYSTEM_PROPERTY = "android.home";
    @Nullable
    private static SdkLocationSourceSet cachedSdkLocationKey;
    @Nullable
    private static SdkLocation cachedSdkLocation;

    private SdkLocator() {
    }

    @Nullable
    public static final File getSdkTestDirectory() {
        return sdkTestDirectory;
    }

    public static final void setSdkTestDirectory(@Nullable File file) {
        sdkTestDirectory = file;
    }

    @JvmStatic
    @VisibleForTesting
    public static /* synthetic */ void getSdkTestDirectory$annotations() {
    }

    @VisibleForTesting
    public static /* synthetic */ void getANDROID_HOME_SYSTEM_PROPERTY$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final File getSdkDirectory(@NotNull File projectRootDir, @NotNull IssueReporter issueReporter2, @NotNull SdkLocationSourceSet sdkLocationSourceSet) {
        File file;
        Intrinsics.checkNotNullParameter((Object)projectRootDir, (String)"projectRootDir");
        Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
        Intrinsics.checkNotNullParameter((Object)sdkLocationSourceSet, (String)"sdkLocationSourceSet");
        SdkLocation sdkLocation = SdkLocator.getSdkLocation(sdkLocationSourceSet, issueReporter2);
        if (sdkLocation.getType() == SdkType.MISSING) {
            file = new File(projectRootDir, "missingSdkDirectory");
        } else {
            file = sdkLocation.getDirectory();
            if (file == null) {
                throw new IllegalStateException(("Directory must not be null when type = " + sdkLocation.getType()).toString());
            }
        }
        return file;
    }

    @JvmStatic
    @NotNull
    public static final synchronized SdkLocation getSdkLocation(@NotNull SdkLocationSourceSet sourceSet2, @NotNull IssueReporter issueReporter2) {
        Intrinsics.checkNotNullParameter((Object)sourceSet2, (String)"sourceSet");
        Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
        SdkLocationSourceSet sdkLocationSourceSet = cachedSdkLocationKey;
        if (sdkLocationSourceSet != null) {
            SdkLocationSourceSet it = sdkLocationSourceSet;
            int n = 0;
            if (Intrinsics.areEqual((Object)it, (Object)sourceSet2)) {
                SdkLocation sdkLocation = cachedSdkLocation;
                Intrinsics.checkNotNull((Object)sdkLocation);
                return sdkLocation;
            }
        }
        List validationFailures = new ArrayList();
        for (SdkLocationSource source : SdkLocationSource.values()) {
            ValidationResult<SdkLocation> it;
            if (source.getSdkLocation(sourceSet2) == null) continue;
            boolean bl = false;
            validationFailures.addAll((Collection)it.getFailures());
            if (it.getValue() == null) continue;
            INSTANCE.reportWarnings(validationFailures, issueReporter2);
            INSTANCE.updateCache(it.getValue(), sourceSet2);
            return it.getValue();
        }
        SdkLocation it = new SdkLocation(null, SdkType.MISSING);
        boolean bl = false;
        INSTANCE.updateCache(it, sourceSet2);
        INSTANCE.reportWarnings(validationFailures, issueReporter2);
        String filePath = new File(sourceSet2.getProjectRoot(), "local.properties").getAbsolutePath();
        String message2 = "SDK location not found. Define a valid SDK location with an ANDROID_HOME environment variable or by setting the sdk.dir path in your project's local properties file at '" + filePath + "'.";
        IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.SDK_NOT_SET, (String)message2, (String)filePath, null, (int)8, null);
        return it;
    }

    private final void reportWarnings(List<ValidationFailure> validationFailures, IssueReporter issueReporter2) {
        if (!((Collection)validationFailures).isEmpty()) {
            IssueReporter.reportWarning$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)this.createWarningMessage(validationFailures), null, null, (int)12, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String createWarningMessage(List<ValidationFailure> failures) {
        void $this$fold$iv;
        Iterable iterable = failures;
        String initial$iv = "The following problems were found when resolving the SDK location:\n";
        boolean $i$f$fold = false;
        Object accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void e;
            ValidationFailure validationFailure = (ValidationFailure)element$iv;
            String acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc + "Where: " + e.getLocationDescription().getDescription() + " Problem: " + e.getProblem().getMessage() + "\n";
        }
        return accumulator$iv;
    }

    private final synchronized void updateCache(SdkLocation sdkLocation, SdkLocationSourceSet sourceSet2) {
        cachedSdkLocationKey = sourceSet2;
        cachedSdkLocation = sdkLocation;
    }

    @JvmStatic
    public static final synchronized void resetCache() {
        GradleLocalPropertiesFactory.INSTANCE.resetCache$gradle_core();
        cachedSdkLocationKey = null;
        cachedSdkLocation = null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/SdkLocator$PropertyLocation;", "", "description", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "SDK_DIR_PROPERTY_LOCATION", "ANDROID_DIR_PROPERTY_LOCATION", "SDK_TEST_DIRECTORY_LOCATION", "ANDROID_SDK_ROOT_LOCATION", "ANDROID_HOME_LOCATION", "ANDROID_HOME_SYSTEM_LOCATION", "gradle-core"})
    public static final class PropertyLocation
    extends Enum<PropertyLocation> {
        @NotNull
        private final String description;
        public static final /* enum */ PropertyLocation SDK_DIR_PROPERTY_LOCATION = new PropertyLocation("sdk.dir property in local.properties file.");
        public static final /* enum */ PropertyLocation ANDROID_DIR_PROPERTY_LOCATION = new PropertyLocation("Fallback android.dir property in local.properties file.");
        public static final /* enum */ PropertyLocation SDK_TEST_DIRECTORY_LOCATION = new PropertyLocation("sdkTestDirectory - set by test code.");
        public static final /* enum */ PropertyLocation ANDROID_SDK_ROOT_LOCATION = new PropertyLocation("ANDROID_SDK_ROOT environment variable.");
        public static final /* enum */ PropertyLocation ANDROID_HOME_LOCATION = new PropertyLocation("ANDROID_HOME environment variable.");
        public static final /* enum */ PropertyLocation ANDROID_HOME_SYSTEM_LOCATION = new PropertyLocation("android.home system property variable.");
        private static final /* synthetic */ PropertyLocation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private PropertyLocation(String description) {
            this.description = description;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        public static PropertyLocation[] values() {
            return (PropertyLocation[])$VALUES.clone();
        }

        public static PropertyLocation valueOf(String value) {
            return Enum.valueOf(PropertyLocation.class, value);
        }

        @NotNull
        public static EnumEntries<PropertyLocation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = propertyLocationArray = new PropertyLocation[]{PropertyLocation.SDK_DIR_PROPERTY_LOCATION, PropertyLocation.ANDROID_DIR_PROPERTY_LOCATION, PropertyLocation.SDK_TEST_DIRECTORY_LOCATION, PropertyLocation.ANDROID_SDK_ROOT_LOCATION, PropertyLocation.ANDROID_HOME_LOCATION, PropertyLocation.ANDROID_HOME_SYSTEM_LOCATION};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH&J&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource;", "", "sdkType", "Lcom/android/build/gradle/internal/SdkType;", "(Ljava/lang/String;ILcom/android/build/gradle/internal/SdkType;)V", "getSdkType", "()Lcom/android/build/gradle/internal/SdkType;", "getSdkLocation", "Lcom/android/build/gradle/internal/SdkLocator$ValidationResult;", "Lcom/android/build/gradle/internal/SdkLocation;", "sourceSet", "Lcom/android/build/gradle/internal/SdkLocationSourceSet;", "getSdkPathProperty", "Ljava/io/File;", "validateSdkPath", "path", "", "rootDir", "locationDescription", "Lcom/android/build/gradle/internal/SdkLocator$PropertyLocation;", "TEST_SDK_DIRECTORY", "LOCAL_SDK_DIR", "LOCAL_ANDROID_DIR", "INJECTED_SDK_HOME", "gradle-core"})
    public static final abstract class SdkLocationSource
    extends Enum<SdkLocationSource> {
        @NotNull
        private final SdkType sdkType;
        public static final /* enum */ SdkLocationSource TEST_SDK_DIRECTORY = new TEST_SDK_DIRECTORY("TEST_SDK_DIRECTORY", 0);
        public static final /* enum */ SdkLocationSource LOCAL_SDK_DIR = new LOCAL_SDK_DIR("LOCAL_SDK_DIR", 1);
        public static final /* enum */ SdkLocationSource LOCAL_ANDROID_DIR = new LOCAL_ANDROID_DIR("LOCAL_ANDROID_DIR", 2);
        public static final /* enum */ SdkLocationSource INJECTED_SDK_HOME = new INJECTED_SDK_HOME("INJECTED_SDK_HOME", 3);
        private static final /* synthetic */ SdkLocationSource[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private SdkLocationSource(SdkType sdkType) {
            this.sdkType = sdkType;
        }

        @NotNull
        public final SdkType getSdkType() {
            return this.sdkType;
        }

        @Nullable
        public final ValidationResult<SdkLocation> getSdkLocation(@NotNull SdkLocationSourceSet sourceSet2) {
            ValidationResult validationResult;
            Intrinsics.checkNotNullParameter((Object)sourceSet2, (String)"sourceSet");
            ValidationResult<File> validationResult2 = this.getSdkPathProperty(sourceSet2);
            if (validationResult2 != null) {
                ValidationResult<File> it = validationResult2;
                boolean bl = false;
                validationResult = it.map((Function1)new Function1<File, SdkLocation>(this){
                    final /* synthetic */ SdkLocationSource this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final SdkLocation invoke(File value) {
                        SdkLocation sdkLocation;
                        File file = value;
                        if (file != null) {
                            File file2 = file;
                            SdkLocationSource sdkLocationSource = this.this$0;
                            File it = file2;
                            boolean bl = false;
                            sdkLocation = new SdkLocation(value, sdkLocationSource.getSdkType());
                        } else {
                            sdkLocation = null;
                        }
                        return sdkLocation;
                    }
                });
            } else {
                validationResult = null;
            }
            return validationResult;
        }

        @Nullable
        public abstract ValidationResult<File> getSdkPathProperty(@NotNull SdkLocationSourceSet var1);

        @NotNull
        protected final ValidationResult<File> validateSdkPath(@NotNull String path, @NotNull File rootDir, @NotNull PropertyLocation locationDescription) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
            Intrinsics.checkNotNullParameter((Object)((Object)locationDescription), (String)"locationDescription");
            if (Intrinsics.areEqual((Object)path, (Object)"")) {
                return new ValidationResult<Object>(null, CollectionsKt.listOf((Object)new ValidationFailure(locationDescription, ValidationProblem.EMPTY_VALUE)));
            }
            File sdk = new File(path);
            if (!sdk.isAbsolute()) {
                File file = new File(rootDir, path).getCanonicalFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getCanonicalFile(...)");
                sdk = file;
            }
            return sdk.isDirectory() ? new ValidationResult<File>(sdk, null, 2, null) : new ValidationResult<Object>(null, CollectionsKt.listOf((Object)new ValidationFailure(locationDescription, sdk.exists() ? ValidationProblem.NOT_A_DIRECTORY : ValidationProblem.DOES_NOT_EXIST)));
        }

        public static SdkLocationSource[] values() {
            return (SdkLocationSource[])$VALUES.clone();
        }

        public static SdkLocationSource valueOf(String value) {
            return Enum.valueOf(SdkLocationSource.class, value);
        }

        @NotNull
        public static EnumEntries<SdkLocationSource> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ SdkLocationSource(String $enum$name, int $enum$ordinal, SdkType sdkType, DefaultConstructorMarker $constructor_marker) {
            this(sdkType);
        }

        static {
            $VALUES = sdkLocationSourceArray = new SdkLocationSource[]{SdkLocationSource.TEST_SDK_DIRECTORY, SdkLocationSource.LOCAL_SDK_DIR, SdkLocationSource.LOCAL_ANDROID_DIR, SdkLocationSource.INJECTED_SDK_HOME};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource$INJECTED_SDK_HOME;", "Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource;", "getSdkPathProperty", "Lcom/android/build/gradle/internal/SdkLocator$ValidationResult;", "Ljava/io/File;", "sourceSet", "Lcom/android/build/gradle/internal/SdkLocationSourceSet;", "gradle-core"})
        @SourceDebugExtension(value={"SMAP\nSdkLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkLocator.kt\ncom/android/build/gradle/internal/SdkLocator$SdkLocationSource$INJECTED_SDK_HOME\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,418:1\n1477#2:419\n1502#2,3:420\n1505#2,3:430\n1045#2:433\n372#3,7:423\n*S KotlinDebug\n*F\n+ 1 SdkLocator.kt\ncom/android/build/gradle/internal/SdkLocator$SdkLocationSource$INJECTED_SDK_HOME\n*L\n187#1:419\n187#1:420,3\n187#1:430,3\n201#1:433\n187#1:423,7\n*E\n"})
        static final class INJECTED_SDK_HOME
        extends SdkLocationSource {
            /*
             * WARNING - void declaration
             */
            INJECTED_SDK_HOME() {
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @Nullable
            public ValidationResult<File> getSdkPathProperty(@NotNull SdkLocationSourceSet sourceSet2) {
                void $this$groupByTo$iv$iv;
                ValidationResult<File> it;
                String path;
                Intrinsics.checkNotNullParameter((Object)sourceSet2, (String)"sourceSet");
                Map map = new LinkedHashMap();
                List validationFailures = new ArrayList();
                String string = sourceSet2.getEnvironmentProperties$gradle_core().getProperty("ANDROID_SDK_ROOT");
                if (string != null) {
                    path = string;
                    boolean bl = false;
                    it = this.validateSdkPath(path, sourceSet2.getProjectRoot(), PropertyLocation.ANDROID_SDK_ROOT_LOCATION);
                    boolean bl2 = false;
                    it.use((Function1<File, Unit>)((Function1)new Function1<File, Unit>((Map<String, File>)map){
                        final /* synthetic */ Map<String, File> $map;
                        {
                            this.$map = $map;
                            super(1);
                        }

                        public final void invoke(File value) {
                            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                            this.$map.put("ANDROID_SDK_ROOT", value);
                        }
                    }));
                    validationFailures.addAll((Collection)it.getFailures());
                }
                string = sourceSet2.getEnvironmentProperties$gradle_core().getProperty("ANDROID_HOME");
                if (string != null) {
                    path = string;
                    boolean bl = false;
                    it = this.validateSdkPath(path, sourceSet2.getProjectRoot(), PropertyLocation.ANDROID_HOME_LOCATION);
                    boolean bl3 = false;
                    it.use((Function1<File, Unit>)((Function1)new Function1<File, Unit>((Map<String, File>)map){
                        final /* synthetic */ Map<String, File> $map;
                        {
                            this.$map = $map;
                            super(1);
                        }

                        public final void invoke(File value) {
                            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                            this.$map.put("ANDROID_HOME", value);
                        }
                    }));
                    validationFailures.addAll((Collection)it.getFailures());
                }
                String string2 = sourceSet2.getSystemProperties$gradle_core().getProperty(SdkLocator.ANDROID_HOME_SYSTEM_PROPERTY);
                if (string2 != null) {
                    path = string2;
                    boolean bl = false;
                    it = this.validateSdkPath(path, sourceSet2.getProjectRoot(), PropertyLocation.ANDROID_HOME_SYSTEM_LOCATION);
                    boolean bl4 = false;
                    it.use((Function1<File, Unit>)((Function1)new Function1<File, Unit>((Map<String, File>)map){
                        final /* synthetic */ Map<String, File> $map;
                        {
                            this.$map = $map;
                            super(1);
                        }

                        public final void invoke(File value) {
                            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                            this.$map.put("android.home", value);
                        }
                    }));
                    validationFailures.addAll((Collection)it.getFailures());
                }
                if (map.isEmpty()) {
                    return null;
                }
                if (map.size() == 1) {
                    return new ValidationResult<Object>(CollectionsKt.single((Iterable)map.values()), validationFailures);
                }
                Iterable $this$groupBy$iv = map.entrySet();
                boolean $i$f$groupBy = false;
                Iterable bl = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object;
                    Map.Entry it2 = (Map.Entry)element$iv$iv;
                    boolean bl5 = false;
                    File key$iv$iv = (File)it2.getValue();
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl6 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                Map reverseMap = destination$iv$iv;
                if (reverseMap.size() == 1) {
                    return new ValidationResult<Object>(CollectionsKt.single((Iterable)reverseMap.keySet()), validationFailures);
                }
                Object message2 = ((Object)StringsKt.trimStart((CharSequence)"\nSeveral environment variables and/or system properties contain different paths to the SDK.\nPlease correct and use only one way to inject the SDK location.\n")).toString();
                Iterable $this$sortedBy$iv = map.entrySet();
                boolean $i$f$sortedBy = false;
                for (Map.Entry entry2 : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
                    }
                })) {
                    message2 = (String)message2 + "\n" + entry2.getKey() + ": " + entry2.getValue();
                }
                message2 = StringsKt.trimIndent((String)((String)message2 + "\n\nIt is recommended to use ANDROID_HOME as other methods are deprecated\n"));
                throw new RuntimeException((String)message2);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource$LOCAL_ANDROID_DIR;", "Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource;", "getSdkPathProperty", "Lcom/android/build/gradle/internal/SdkLocator$ValidationResult;", "Ljava/io/File;", "sourceSet", "Lcom/android/build/gradle/internal/SdkLocationSourceSet;", "gradle-core"})
        static final class LOCAL_ANDROID_DIR
        extends SdkLocationSource {
            /*
             * WARNING - void declaration
             */
            LOCAL_ANDROID_DIR() {
                void var1_1;
            }

            @Override
            @Nullable
            public ValidationResult<File> getSdkPathProperty(@NotNull SdkLocationSourceSet sourceSet2) {
                ValidationResult<File> validationResult;
                Intrinsics.checkNotNullParameter((Object)sourceSet2, (String)"sourceSet");
                String string = sourceSet2.getLocalProperties$gradle_core().getProperty("android.dir");
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    validationResult = this.validateSdkPath(it, sourceSet2.getProjectRoot(), PropertyLocation.ANDROID_DIR_PROPERTY_LOCATION);
                } else {
                    validationResult = null;
                }
                return validationResult;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource$LOCAL_SDK_DIR;", "Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource;", "getSdkPathProperty", "Lcom/android/build/gradle/internal/SdkLocator$ValidationResult;", "Ljava/io/File;", "sourceSet", "Lcom/android/build/gradle/internal/SdkLocationSourceSet;", "gradle-core"})
        static final class LOCAL_SDK_DIR
        extends SdkLocationSource {
            /*
             * WARNING - void declaration
             */
            LOCAL_SDK_DIR() {
                void var1_1;
            }

            @Override
            @Nullable
            public ValidationResult<File> getSdkPathProperty(@NotNull SdkLocationSourceSet sourceSet2) {
                ValidationResult<File> validationResult;
                Intrinsics.checkNotNullParameter((Object)sourceSet2, (String)"sourceSet");
                String string = sourceSet2.getLocalProperties$gradle_core().getProperty("sdk.dir");
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    validationResult = this.validateSdkPath(it, sourceSet2.getProjectRoot(), PropertyLocation.SDK_DIR_PROPERTY_LOCATION);
                } else {
                    validationResult = null;
                }
                return validationResult;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource$TEST_SDK_DIRECTORY;", "Lcom/android/build/gradle/internal/SdkLocator$SdkLocationSource;", "getSdkPathProperty", "Lcom/android/build/gradle/internal/SdkLocator$ValidationResult;", "Ljava/io/File;", "sourceSet", "Lcom/android/build/gradle/internal/SdkLocationSourceSet;", "gradle-core"})
        static final class TEST_SDK_DIRECTORY
        extends SdkLocationSource {
            /*
             * WARNING - void declaration
             */
            TEST_SDK_DIRECTORY() {
                void var1_1;
            }

            @Override
            @Nullable
            public ValidationResult<File> getSdkPathProperty(@NotNull SdkLocationSourceSet sourceSet2) {
                ValidationResult<File> validationResult;
                Intrinsics.checkNotNullParameter((Object)sourceSet2, (String)"sourceSet");
                Object object = SdkLocator.getSdkTestDirectory();
                if (object != null && (object = ((File)object).getAbsolutePath()) != null) {
                    Object it = object;
                    boolean bl = false;
                    validationResult = this.validateSdkPath((String)it, sourceSet2.getProjectRoot(), PropertyLocation.SDK_TEST_DIRECTORY_LOCATION);
                } else {
                    validationResult = null;
                }
                return validationResult;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/SdkLocator$ValidationFailure;", "", "locationDescription", "Lcom/android/build/gradle/internal/SdkLocator$PropertyLocation;", "problem", "Lcom/android/build/gradle/internal/SdkLocator$ValidationProblem;", "(Lcom/android/build/gradle/internal/SdkLocator$PropertyLocation;Lcom/android/build/gradle/internal/SdkLocator$ValidationProblem;)V", "getLocationDescription", "()Lcom/android/build/gradle/internal/SdkLocator$PropertyLocation;", "getProblem", "()Lcom/android/build/gradle/internal/SdkLocator$ValidationProblem;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "gradle-core"})
    public static final class ValidationFailure {
        @NotNull
        private final PropertyLocation locationDescription;
        @NotNull
        private final ValidationProblem problem;

        public ValidationFailure(@NotNull PropertyLocation locationDescription, @NotNull ValidationProblem problem) {
            Intrinsics.checkNotNullParameter((Object)((Object)locationDescription), (String)"locationDescription");
            Intrinsics.checkNotNullParameter((Object)((Object)problem), (String)"problem");
            this.locationDescription = locationDescription;
            this.problem = problem;
        }

        @NotNull
        public final PropertyLocation getLocationDescription() {
            return this.locationDescription;
        }

        @NotNull
        public final ValidationProblem getProblem() {
            return this.problem;
        }

        @NotNull
        public final PropertyLocation component1() {
            return this.locationDescription;
        }

        @NotNull
        public final ValidationProblem component2() {
            return this.problem;
        }

        @NotNull
        public final ValidationFailure copy(@NotNull PropertyLocation locationDescription, @NotNull ValidationProblem problem) {
            Intrinsics.checkNotNullParameter((Object)((Object)locationDescription), (String)"locationDescription");
            Intrinsics.checkNotNullParameter((Object)((Object)problem), (String)"problem");
            return new ValidationFailure(locationDescription, problem);
        }

        public static /* synthetic */ ValidationFailure copy$default(ValidationFailure validationFailure, PropertyLocation propertyLocation, ValidationProblem validationProblem, int n, Object object) {
            if ((n & 1) != 0) {
                propertyLocation = validationFailure.locationDescription;
            }
            if ((n & 2) != 0) {
                validationProblem = validationFailure.problem;
            }
            return validationFailure.copy(propertyLocation, validationProblem);
        }

        @NotNull
        public String toString() {
            return "ValidationFailure(locationDescription=" + this.locationDescription + ", problem=" + this.problem + ")";
        }

        public int hashCode() {
            int result2 = this.locationDescription.hashCode();
            result2 = result2 * 31 + this.problem.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ValidationFailure)) {
                return false;
            }
            ValidationFailure validationFailure = (ValidationFailure)other;
            if (this.locationDescription != validationFailure.locationDescription) {
                return false;
            }
            return this.problem == validationFailure.problem;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/SdkLocator$ValidationProblem;", "", "message", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "EMPTY_VALUE", "NOT_A_DIRECTORY", "DOES_NOT_EXIST", "gradle-core"})
    public static final class ValidationProblem
    extends Enum<ValidationProblem> {
        @NotNull
        private final String message;
        public static final /* enum */ ValidationProblem EMPTY_VALUE = new ValidationProblem("Set with empty value");
        public static final /* enum */ ValidationProblem NOT_A_DIRECTORY = new ValidationProblem("Path is pointing not to a directory");
        public static final /* enum */ ValidationProblem DOES_NOT_EXIST = new ValidationProblem("Directory does not exist");
        private static final /* synthetic */ ValidationProblem[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ValidationProblem(String message2) {
            this.message = message2;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public static ValidationProblem[] values() {
            return (ValidationProblem[])$VALUES.clone();
        }

        public static ValidationProblem valueOf(String value) {
            return Enum.valueOf(ValidationProblem.class, value);
        }

        @NotNull
        public static EnumEntries<ValidationProblem> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = validationProblemArray = new ValidationProblem[]{ValidationProblem.EMPTY_VALUE, ValidationProblem.NOT_A_DIRECTORY, ValidationProblem.DOES_NOT_EXIST};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J*\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0000\"\u0004\b\u0001\u0010\u000e2\u0016\u0010\u000f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0006\u0012\u0004\u0018\u0001H\u000e0\u0010J!\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00120\u0010\u00a2\u0006\u0002\u0010\u0013R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/SdkLocator$ValidationResult;", "T", "", "value", "failures", "", "Lcom/android/build/gradle/internal/SdkLocator$ValidationFailure;", "(Ljava/lang/Object;Ljava/util/List;)V", "getFailures", "()Ljava/util/List;", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "map", "Out", "f", "Lkotlin/Function1;", "use", "", "(Lkotlin/jvm/functions/Function1;)Lkotlin/Unit;", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nSdkLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkLocator.kt\ncom/android/build/gradle/internal/SdkLocator$ValidationResult\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,418:1\n1#2:419\n*E\n"})
    public static final class ValidationResult<T> {
        @Nullable
        private final T value;
        @NotNull
        private final List<ValidationFailure> failures;

        public ValidationResult(@Nullable T value, @NotNull List<ValidationFailure> failures) {
            Intrinsics.checkNotNullParameter(failures, (String)"failures");
            this.value = value;
            this.failures = failures;
        }

        public /* synthetic */ ValidationResult(Object object, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(object, list);
        }

        @Nullable
        public final T getValue() {
            return this.value;
        }

        @NotNull
        public final List<ValidationFailure> getFailures() {
            return this.failures;
        }

        @NotNull
        public final <Out> ValidationResult<Out> map(@NotNull Function1<? super T, ? extends Out> f) {
            Intrinsics.checkNotNullParameter(f, (String)"f");
            return new ValidationResult<Object>(f.invoke(this.value), this.failures);
        }

        @Nullable
        public final Unit use(@NotNull Function1<? super T, Unit> f) {
            Unit unit;
            Intrinsics.checkNotNullParameter(f, (String)"f");
            T t = this.value;
            if (t != null) {
                T it = t;
                boolean bl = false;
                f.invoke(this.value);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            return unit;
        }
    }
}

