/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.dependencies;

import com.android.build.gradle.internal.ide.DependencyFailureHandler;
import com.android.build.gradle.internal.ide.dependencies.ArtifactCollectionsInputs;
import com.android.build.gradle.internal.ide.dependencies.DependencyGraphBuilder;
import com.android.build.gradle.internal.ide.dependencies.DependencyModelBuilder;
import com.android.build.gradle.internal.ide.dependencies.Level1RuntimeArtifactCollections;
import com.android.build.gradle.internal.ide.dependencies.ResolvedArtifact;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.builder.errors.IssueReporter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;

class ArtifactDependencyGraph
implements DependencyGraphBuilder {
    private final DependencyFailureHandler dependencyFailureHandler = new DependencyFailureHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDependencies(DependencyModelBuilder<?> modelBuilder, ArtifactCollectionsInputs artifactCollectionsInputs, boolean withFullDependency, boolean ignoreUnexpectedArtifactTypes, IssueReporter issueReporter2) {
        try {
            Set<ResolvedArtifact> compileArtifacts = artifactCollectionsInputs.getAllArtifacts(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, this.dependencyFailureHandler, ignoreUnexpectedArtifactTypes);
            Set runtimeLintJars = artifactCollectionsInputs.getRuntimeLintJars().getArtifacts();
            Set compileLintJars = artifactCollectionsInputs.getCompileLintJars().getArtifacts();
            HashMap<ComponentIdentifier, File> mutableLintJarMap = new HashMap<ComponentIdentifier, File>();
            for (ResolvedArtifactResult artifact : compileLintJars) {
                mutableLintJarMap.put(artifact.getId().getComponentIdentifier(), artifact.getFile());
            }
            for (ResolvedArtifactResult artifact : runtimeLintJars) {
                mutableLintJarMap.put(artifact.getId().getComponentIdentifier(), artifact.getFile());
            }
            ImmutableMap lintJarMap = ImmutableMap.copyOf(mutableLintJarMap);
            if (withFullDependency && modelBuilder.getNeedFullRuntimeClasspath()) {
                Set<ResolvedArtifact> runtimeArtifacts = artifactCollectionsInputs.getAllArtifacts(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, this.dependencyFailureHandler, ignoreUnexpectedArtifactTypes);
                Set runtimeIds = runtimeArtifacts.stream().map(ResolvedArtifact::getComponentIdentifier).collect(Collectors.toSet());
                for (ResolvedArtifact artifact : compileArtifacts) {
                    modelBuilder.addArtifact(artifact, !runtimeIds.contains(artifact.getComponentIdentifier()), (Map<ComponentIdentifier, File>)lintJarMap, DependencyModelBuilder.ClasspathType.COMPILE);
                }
                for (ResolvedArtifact artifact : runtimeArtifacts) {
                    modelBuilder.addArtifact(artifact, false, (Map<ComponentIdentifier, File>)lintJarMap, DependencyModelBuilder.ClasspathType.RUNTIME);
                }
            } else {
                Level1RuntimeArtifactCollections level1RuntimeArtifactCollections = artifactCollectionsInputs.getLevel1RuntimeArtifactCollections();
                ImmutableSet<ComponentIdentifier> runtimeIds = ArtifactDependencyGraph.getRuntimeComponentIdentifiers(level1RuntimeArtifactCollections.getRuntimeArtifacts());
                for (ResolvedArtifact artifact : compileArtifacts) {
                    modelBuilder.addArtifact(artifact, !runtimeIds.contains((Object)artifact.getComponentIdentifier()), (Map<ComponentIdentifier, File>)lintJarMap, DependencyModelBuilder.ClasspathType.COMPILE);
                }
                if (modelBuilder.getNeedRuntimeOnlyClasspath()) {
                    modelBuilder.setRuntimeOnlyClasspath(ArtifactDependencyGraph.getRuntimeOnlyClasspath(level1RuntimeArtifactCollections, compileArtifacts, runtimeIds));
                }
            }
        }
        finally {
            this.dependencyFailureHandler.registerIssues(issueReporter2);
        }
    }

    private static ImmutableSet<ComponentIdentifier> getRuntimeComponentIdentifiers(ArtifactCollection runtimeArtifactCollection) {
        ImmutableSet.Builder runtimeIdentifiersBuilder = ImmutableSet.builder();
        for (ResolvedArtifactResult result2 : runtimeArtifactCollection.getArtifacts()) {
            runtimeIdentifiersBuilder.add((Object)result2.getId().getComponentIdentifier());
        }
        return runtimeIdentifiersBuilder.build();
    }

    private static ImmutableList<File> getRuntimeOnlyClasspath(Level1RuntimeArtifactCollections runtimeArtifactCollections, Set<ResolvedArtifact> artifacts2, ImmutableSet<ComponentIdentifier> runtimeIdentifiers) {
        Set compileIdentifiers = artifacts2.stream().map(ResolvedArtifact::getComponentIdentifier).collect(Collectors.toSet());
        ImmutableMultimap<ComponentIdentifier, ResolvedArtifactResult> externalRuntime = ArtifactDependencyGraph.asMultiMap(runtimeArtifactCollections.getRuntimeExternalJars());
        ImmutableList.Builder runtimeOnlyClasspathBuilder = ImmutableList.builder();
        for (ComponentIdentifier runtimeIdentifier : runtimeIdentifiers) {
            if (compileIdentifiers.contains(runtimeIdentifier)) continue;
            for (ResolvedArtifactResult resolvedArtifactResult : externalRuntime.get((Object)runtimeIdentifier)) {
                runtimeOnlyClasspathBuilder.add((Object)resolvedArtifactResult.getFile());
            }
        }
        return runtimeOnlyClasspathBuilder.build();
    }

    private static ImmutableMultimap<ComponentIdentifier, ResolvedArtifactResult> asMultiMap(ArtifactCollection collection) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (ResolvedArtifactResult artifact : collection.getArtifacts()) {
            builder.put((Object)artifact.getId().getComponentIdentifier(), (Object)artifact);
        }
        return builder.build();
    }

    ArtifactDependencyGraph() {
    }
}

