/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.tasks.DexMergingTask;
import com.android.build.gradle.internal.tasks.DexMergingTaskDelegate;
import com.android.build.gradle.internal.tasks.DexMergingWorkAction;
import com.android.builder.dexing.DexEntry;
import com.android.builder.dexing.DexEntryBucket;
import com.android.builder.dexing.DexUtilsKt;
import com.android.builder.files.SerializableChange;
import com.android.builder.files.SerializableFileChanges;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/tasks/DexMergingTaskDelegate;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/DexMergingTaskDelegate$Params;", "()V", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "getWorkerExecutor", "()Lorg/gradle/workers/WorkerExecutor;", "run", "", "Companion", "Params", "gradle-core"})
public abstract class DexMergingTaskDelegate
extends ProfileAwareWorkAction<Params> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Function1<String, Boolean> isDexFile = Companion.isDexFile.1.INSTANCE;

    @Inject
    @NotNull
    public abstract WorkerExecutor getWorkerExecutor();

    @Override
    public void run() {
        Params $this$run_u24lambda_u240 = (Params)this.getParameters();
        boolean bl = false;
        Object object = $this$run_u24lambda_u240.getDexDirsOrJars().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        List list = (List)object;
        Object object2 = $this$run_u24lambda_u240.getNumberOfBuckets().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        int n = ((Number)object2).intValue();
        Object object3 = $this$run_u24lambda_u240.getIncremental().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        Map buckets = DexMergingTaskDelegate.Companion.getBucketsToMerge(list, n, (Boolean)object3, (SerializableFileChanges)$this$run_u24lambda_u240.getFileChanges().getOrNull());
        WorkQueue workQueue2 = this.getWorkerExecutor().noIsolation();
        for (Map.Entry entry2 : buckets.entrySet()) {
            File file;
            int bucketNumber = ((Number)entry2.getKey()).intValue();
            DexEntryBucket bucket = (DexEntryBucket)entry2.getValue();
            Integer n2 = (Integer)$this$run_u24lambda_u240.getNumberOfBuckets().get();
            int n3 = 1;
            if (n2 != null && n2 == n3) {
                file = ((Directory)$this$run_u24lambda_u240.getOutputDir().get()).getAsFile();
            } else {
                File file2 = ((Directory)$this$run_u24lambda_u240.getOutputDir().get()).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAsFile(...)");
                file = FilesKt.resolve((File)file2, (String)String.valueOf(bucketNumber));
            }
            File outputDirForBucket = file;
            FileUtils.cleanOutputDir((File)outputDirForBucket);
            workQueue2.submit(DexMergingWorkAction.class, new Action($this$run_u24lambda_u240, bucket, outputDirForBucket){
                final /* synthetic */ Params $this_with;
                final /* synthetic */ DexEntryBucket $bucket;
                final /* synthetic */ File $outputDirForBucket;
                {
                    this.$this_with = $receiver;
                    this.$bucket = $bucket;
                    this.$outputDirForBucket = $outputDirForBucket;
                }

                public final void execute(DexMergingWorkAction.Params it) {
                    Params params = this.$this_with;
                    Intrinsics.checkNotNull((Object)params);
                    it.initializeFromProfileAwareWorkAction(params);
                    Property<DexMergingTask.SharedParams> property = this.$this_with.getSharedParams();
                    Integer n = (Integer)this.$this_with.getNumberOfBuckets().get();
                    int n2 = 1;
                    boolean bl = n != null && n == n2;
                    ConfigurableFileCollection configurableFileCollection = this.$this_with.getGlobalSynthetics();
                    File file = this.$outputDirForBucket;
                    Intrinsics.checkNotNull((Object)file);
                    RegularFile regularFile = (RegularFile)this.$this_with.getD8Metadata().getOrNull();
                    it.initialize(property, bl, this.$bucket, configurableFileCollection, file, (File)this.$this_with.getMainDexListOutput().getAsFile().getOrNull(), regularFile != null ? regularFile.getAsFile() : null, (File)this.$this_with.getInputProfileForDexStartupOptimization().getAsFile().getOrNull());
                }
            });
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000bH\u0007J<\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u000bH\u0002R)\u0010\u0003\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/tasks/DexMergingTaskDelegate$Companion;", "", "()V", "isDexFile", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "relativePath", "", "getBucketNumber", "", "numberOfBuckets", "getBucketsToMerge", "", "Lcom/android/builder/dexing/DexEntryBucket;", "dexDirsOrJars", "", "Ljava/io/File;", "incremental", "fileChanges", "Lcom/android/builder/files/SerializableFileChanges;", "getImpactedBuckets", "", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nDexMergingTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DexMergingTask.kt\ncom/android/build/gradle/internal/tasks/DexMergingTaskDelegate$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,934:1\n1549#2:935\n1620#2,3:936\n1549#2:944\n1620#2,3:945\n766#2:948\n857#2,2:949\n1360#2:951\n1446#2,5:952\n1549#2:957\n1620#2,3:958\n766#2:961\n857#2,2:962\n1549#2:964\n1620#2,3:965\n125#3:939\n152#3,3:940\n1#4:943\n*S KotlinDebug\n*F\n+ 1 DexMergingTask.kt\ncom/android/build/gradle/internal/tasks/DexMergingTaskDelegate$Companion\n*L\n710#1:935\n710#1:936,3\n744#1:944\n744#1:945,3\n744#1:948\n744#1:949,2\n746#1:951\n746#1:952,5\n748#1:957\n748#1:958,3\n748#1:961\n748#1:962,2\n751#1:964\n751#1:965,3\n724#1:939\n724#1:940,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final Map<Integer, DexEntryBucket> getBucketsToMerge(List<? extends File> dexDirsOrJars, int numberOfBuckets, boolean incremental, SerializableFileChanges fileChanges) {
            void $this$mapTo$iv$iv;
            Object dexEntryRelativePaths;
            Collection collection;
            Object object;
            Set<Integer> set;
            if (incremental) {
                SerializableFileChanges serializableFileChanges = fileChanges;
                Intrinsics.checkNotNull((Object)serializableFileChanges);
                set = this.getImpactedBuckets(serializableFileChanges, numberOfBuckets);
            } else {
                set = CollectionsKt.toSet((Iterable)((Iterable)RangesKt.until((int)0, (int)numberOfBuckets)));
            }
            Set<Integer> bucketsToMerge = set;
            Map bucketMap = new LinkedHashMap();
            Iterator<Comparable<Integer>> iterator2 = bucketsToMerge.iterator();
            while (iterator2.hasNext()) {
                int n = ((Number)iterator2.next()).intValue();
                Integer n2 = n;
                bucketMap.put(n2, (List)new ArrayList());
            }
            for (File file : dexDirsOrJars) {
                List list;
                Object $this$map$iv;
                if (file.isDirectory()) {
                    void $this$mapTo$iv$iv2;
                    Path path = file.toPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                    $this$map$iv = DexUtilsKt.getSortedFilesInDir((Path)path, (Function1)isDexFile);
                    boolean $i$f$map = false;
                    object = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it;
                        Path path2 = (Path)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(((Object)file.toPath().relativize((Path)it)).toString());
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = DexUtilsKt.getSortedRelativePathsInJar((File)file, (Function1)isDexFile);
                }
                dexEntryRelativePaths = list;
                $this$map$iv = dexEntryRelativePaths.iterator();
                while ($this$map$iv.hasNext()) {
                    String relativePath = (String)$this$map$iv.next();
                    int bucketNumber = this.getBucketNumber(relativePath, numberOfBuckets);
                    if (!bucketsToMerge.contains(bucketNumber)) continue;
                    Object v = bucketMap.get(bucketNumber);
                    Intrinsics.checkNotNull(v);
                    ((List)v).add(new DexEntry(file, relativePath));
                }
            }
            Map $this$map$iv = bucketMap;
            boolean bl = false;
            dexEntryRelativePaths = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            object = $this$mapTo$iv$iv.entrySet().iterator();
            while (object.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry $i$f$mapTo2 = item$iv$iv = (Map.Entry)object.next();
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(TuplesKt.to(it.getKey(), (Object)new DexEntryBucket((List)it.getValue())));
            }
            return MapsKt.toMap((Iterable)((List)destination$iv$iv));
        }

        /*
         * WARNING - void declaration
         */
        private final Set<Integer> getImpactedBuckets(SerializableFileChanges fileChanges, int numberOfBuckets) {
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$mapTo$iv$iv;
            void $this$flatMapTo$iv$iv;
            void $this$filterTo$iv$iv2;
            void $this$filter$iv2;
            File it;
            Collection collection;
            void $this$mapTo$iv$iv2;
            boolean hasModifiedRemovedJars;
            Object v0;
            Object object2;
            block8: {
                Iterable iterable = CollectionsKt.plus((Collection)fileChanges.getModifiedFiles(), (Iterable)fileChanges.getRemovedFiles());
                for (Object object2 : iterable) {
                    SerializableChange it2 = (SerializableChange)object2;
                    boolean bl = false;
                    if (!((Boolean)DexUtilsKt.isJarFile().invoke((Object)it2.getFile())).booleanValue()) continue;
                    v0 = object2;
                    break block8;
                }
                v0 = null;
            }
            boolean bl = hasModifiedRemovedJars = v0 != null;
            if (hasModifiedRemovedJars) {
                return CollectionsKt.toSet((Iterable)((Iterable)RangesKt.until((int)0, (int)numberOfBuckets)));
            }
            Iterable $this$map$iv = fileChanges.getAddedFiles();
            boolean $i$f$map = false;
            object2 = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                SerializableChange serializableChange = (SerializableChange)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getFile());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv2 = $this$filter$iv2;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (File)element$iv$iv;
                boolean bl3 = false;
                if (!((Boolean)DexUtilsKt.isJarFile().invoke((Object)it)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List addedJars = (List)destination$iv$iv;
            Iterable $this$flatMap$iv = addedJars;
            boolean $i$f$flatMap = false;
            destination$iv$iv = $this$flatMap$iv;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                File it3 = (File)element$iv$iv;
                boolean bl4 = false;
                Iterable list$iv$iv = DexUtilsKt.getSortedRelativePathsInJar((File)it3, (Function1)isDexFile);
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List relativePathsOfDexFilesInAddedJars = (List)destination$iv$iv2;
            Iterable $this$map$iv2 = fileChanges.getFileChanges();
            boolean $i$f$map2 = false;
            destination$iv$iv2 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it4;
                SerializableChange bl4 = (SerializableChange)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl5 = false;
                collection.add(it4.getNormalizedPath());
            }
            $this$map$iv2 = (List)destination$iv$iv3;
            boolean $i$f$filter2 = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it5 = (String)element$iv$iv;
                boolean bl6 = false;
                if (!((Boolean)isDexFile.invoke((Object)it5)).booleanValue()) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List relativePathsOfChangedDexFilesInDirs = (List)destination$iv$iv3;
            $this$filter$iv = CollectionsKt.plus((Collection)relativePathsOfDexFilesInAddedJars, (Iterable)relativePathsOfChangedDexFilesInDirs);
            $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv2;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String it5 = (String)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl7 = false;
                collection.add(Companion.getBucketNumber(it5, numberOfBuckets));
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
        }

        @VisibleForTesting
        public final int getBucketNumber(@NotNull String relativePath, int numberOfBuckets) {
            int n;
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            if (!(!new File(relativePath).isAbsolute())) {
                boolean $i$a$-check-DexMergingTaskDelegate$Companion$getBucketNumber$32 = false;
                String $i$a$-check-DexMergingTaskDelegate$Companion$getBucketNumber$32 = "Expected relative path but found absolute path: " + relativePath;
                throw new IllegalStateException($i$a$-check-DexMergingTaskDelegate$Companion$getBucketNumber$32.toString());
            }
            if (!StringsKt.endsWith((String)relativePath, (String)".dex", (boolean)true)) {
                boolean bl = false;
                String string = "Expected .dex file but found: " + relativePath;
                throw new IllegalStateException(string.toString());
            }
            String packagePath = new File(relativePath).getParent();
            CharSequence charSequence = packagePath;
            if (charSequence == null || charSequence.length() == 0) {
                n = 0;
            } else if (numberOfBuckets == 1) {
                n = 0;
            } else {
                String normalizedPackagePath = FilesKt.getInvariantSeparatorsPath((File)new File(packagePath));
                return Math.abs(normalizedPackagePath.hashCode()) % (numberOfBuckets - 1) + 1;
            }
            return n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Jh\u0010&\u001a\u00020'2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0(2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0004R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0010R\u0012\u0010\u0018\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0006R\u0012\u0010\u001a\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0006R\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0010R\u0012\u0010\u001f\u001a\u00020 X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0018\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0010\u00a8\u0006)"}, d2={"Lcom/android/build/gradle/internal/tasks/DexMergingTaskDelegate$Params;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "d8Metadata", "Lorg/gradle/api/file/RegularFileProperty;", "getD8Metadata", "()Lorg/gradle/api/file/RegularFileProperty;", "dexDirsOrJars", "Lorg/gradle/api/provider/ListProperty;", "Ljava/io/File;", "getDexDirsOrJars", "()Lorg/gradle/api/provider/ListProperty;", "fileChanges", "Lorg/gradle/api/provider/Property;", "Lcom/android/builder/files/SerializableFileChanges;", "getFileChanges", "()Lorg/gradle/api/provider/Property;", "globalSynthetics", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getGlobalSynthetics", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "incremental", "", "getIncremental", "inputProfileForDexStartupOptimization", "getInputProfileForDexStartupOptimization", "mainDexListOutput", "getMainDexListOutput", "numberOfBuckets", "", "getNumberOfBuckets", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "sharedParams", "Lcom/android/build/gradle/internal/tasks/DexMergingTask$SharedParams;", "getSharedParams", "initialize", "", "", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nDexMergingTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DexMergingTask.kt\ncom/android/build/gradle/internal/tasks/DexMergingTaskDelegate$Params\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,934:1\n1#2:935\n*E\n"})
    public static abstract class Params
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract Property<DexMergingTask.SharedParams> getSharedParams();

        @NotNull
        public abstract Property<Integer> getNumberOfBuckets();

        @NotNull
        public abstract ListProperty<File> getDexDirsOrJars();

        @NotNull
        public abstract ConfigurableFileCollection getGlobalSynthetics();

        @NotNull
        public abstract DirectoryProperty getOutputDir();

        @NotNull
        public abstract RegularFileProperty getInputProfileForDexStartupOptimization();

        @NotNull
        public abstract RegularFileProperty getD8Metadata();

        @NotNull
        public abstract RegularFileProperty getMainDexListOutput();

        @NotNull
        public abstract Property<Boolean> getIncremental();

        @NotNull
        public abstract Property<SerializableFileChanges> getFileChanges();

        public final void initialize(@NotNull DexMergingTask.SharedParams sharedParams, int numberOfBuckets, @NotNull List<? extends File> dexDirsOrJars, @NotNull ConfigurableFileCollection globalSynthetics, @NotNull DirectoryProperty outputDir, boolean incremental, @Nullable SerializableFileChanges fileChanges, @Nullable RegularFileProperty mainDexListOutput, @Nullable RegularFileProperty d8Metadata, @Nullable RegularFileProperty inputProfileForDexStartupOptimization) {
            block2: {
                RegularFileProperty it;
                Intrinsics.checkNotNullParameter((Object)sharedParams, (String)"sharedParams");
                Intrinsics.checkNotNullParameter(dexDirsOrJars, (String)"dexDirsOrJars");
                Intrinsics.checkNotNullParameter((Object)globalSynthetics, (String)"globalSynthetics");
                Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
                this.getSharedParams().set((Object)sharedParams);
                this.getNumberOfBuckets().set((Object)numberOfBuckets);
                this.getDexDirsOrJars().set((Iterable)dexDirsOrJars);
                Object[] objectArray = new Object[]{globalSynthetics};
                this.getGlobalSynthetics().from(objectArray);
                this.getOutputDir().set((Provider)outputDir);
                this.getIncremental().set((Object)incremental);
                this.getFileChanges().set((Object)fileChanges);
                RegularFileProperty regularFileProperty = mainDexListOutput;
                if (regularFileProperty != null) {
                    it = regularFileProperty;
                    boolean bl = false;
                    this.getMainDexListOutput().set((Provider)it);
                }
                RegularFileProperty regularFileProperty2 = d8Metadata;
                if (regularFileProperty2 != null) {
                    it = regularFileProperty2;
                    boolean bl = false;
                    this.getD8Metadata().set((Provider)it);
                }
                RegularFileProperty regularFileProperty3 = inputProfileForDexStartupOptimization;
                if (regularFileProperty3 == null) break block2;
                it = regularFileProperty3;
                boolean bl = false;
                this.getInputProfileForDexStartupOptimization().set((Provider)it);
            }
        }

        public static /* synthetic */ void initialize$default(Params params, DexMergingTask.SharedParams sharedParams, int n, List list, ConfigurableFileCollection configurableFileCollection, DirectoryProperty directoryProperty, boolean bl, SerializableFileChanges serializableFileChanges, RegularFileProperty regularFileProperty, RegularFileProperty regularFileProperty2, RegularFileProperty regularFileProperty3, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: initialize");
            }
            if ((n2 & 0x100) != 0) {
                regularFileProperty2 = null;
            }
            if ((n2 & 0x200) != 0) {
                regularFileProperty3 = null;
            }
            params.initialize(sharedParams, n, list, configurableFileCollection, directoryProperty, bl, serializableFileChanges, regularFileProperty, regularFileProperty2, regularFileProperty3);
        }
    }
}

