/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.plugins;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.dsl.AssetPackBundleExtension;
import com.android.build.api.dsl.SigningConfig;
import com.android.build.gradle.internal.BuildFeaturesUtils;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.errors.DeprecationReporterImpl;
import com.android.build.gradle.internal.errors.SyncIssueReporter;
import com.android.build.gradle.internal.errors.SyncIssueReporterImpl;
import com.android.build.gradle.internal.lint.LintFromMaven;
import com.android.build.gradle.internal.plugins.AssetPackBundlePlugin;
import com.android.build.gradle.internal.plugins.AssetPackBundlePluginKt;
import com.android.build.gradle.internal.profile.AnalyticsConfiguratorService;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.profile.NoOpAnalyticsService;
import com.android.build.gradle.internal.res.Aapt2FromMaven;
import com.android.build.gradle.internal.scope.ProjectInfo;
import com.android.build.gradle.internal.services.Aapt2DaemonBuildService;
import com.android.build.gradle.internal.services.Aapt2ThreadPoolBuildService;
import com.android.build.gradle.internal.services.AndroidLocationsBuildService;
import com.android.build.gradle.internal.services.DslServicesImpl;
import com.android.build.gradle.internal.services.ProjectServices;
import com.android.build.gradle.internal.tasks.AppMetadataTask;
import com.android.build.gradle.internal.tasks.AssetPackPreBundleTask;
import com.android.build.gradle.internal.tasks.AssetPackUtilKt;
import com.android.build.gradle.internal.tasks.FinalizeBundleTask;
import com.android.build.gradle.internal.tasks.LinkManifestForAssetPackTask;
import com.android.build.gradle.internal.tasks.PackageBundleTask;
import com.android.build.gradle.internal.tasks.ProcessAssetPackManifestTask;
import com.android.build.gradle.internal.tasks.ValidateSigningTask;
import com.android.build.gradle.internal.tasks.factory.TaskConfigAction;
import com.android.build.gradle.internal.tasks.factory.TaskFactory;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryImpl;
import com.android.build.gradle.options.ProjectOptionService;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.errors.IssueReporter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.configuration.BuildFeatures;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.build.event.BuildEventsListenerRegistry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u001a\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\u0004\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/plugins/AssetPackBundlePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "<init>", "()V", "listenerRegistry", "Lorg/gradle/build/event/BuildEventsListenerRegistry;", "getListenerRegistry$annotations", "getListenerRegistry", "()Lorg/gradle/build/event/BuildEventsListenerRegistry;", "buildFeatures", "Lorg/gradle/api/configuration/BuildFeatures;", "getBuildFeatures", "()Lorg/gradle/api/configuration/BuildFeatures;", "apply", "", "project", "registerServices", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "validateInput", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "extension", "Lcom/android/build/api/dsl/AssetPackBundleExtension;", "createTasks", "projectServices", "Lcom/android/build/gradle/internal/services/ProjectServices;", "gradle-core"})
public abstract class AssetPackBundlePlugin
implements Plugin<Project> {
    @Inject
    @NotNull
    public abstract BuildEventsListenerRegistry getListenerRegistry();

    public static /* synthetic */ void getListenerRegistry$annotations() {
    }

    @Inject
    @NotNull
    public abstract BuildFeatures getBuildFeatures();

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectOptions projectOptions = ((ProjectOptionService)new ProjectOptionService.RegistrationAction(project).execute().get()).getProjectOptions();
        SyncOptions.EvaluationMode evaluationMode = SyncOptions.getModelQueryMode(projectOptions);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)evaluationMode), (String)"getModelQueryMode(...)");
        SyncOptions.ErrorFormatMode errorFormatMode = SyncOptions.getErrorFormatMode(projectOptions);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)errorFormatMode), (String)"getErrorFormatMode(...)");
        Logger logger = project.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        SyncIssueReporterImpl syncIssueHandler = new SyncIssueReporterImpl(evaluationMode, errorFormatMode, logger);
        IssueReporter issueReporter2 = syncIssueHandler;
        String string = project.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        DeprecationReporterImpl deprecationReporter = new DeprecationReporterImpl(issueReporter2, projectOptions, string);
        SyncIssueReporter syncIssueReporter2 = syncIssueHandler;
        DeprecationReporter deprecationReporter2 = deprecationReporter;
        ObjectFactory objectFactory = project.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"getObjects(...)");
        Logger logger2 = project.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        ProviderFactory providerFactory = project.getProviders();
        Intrinsics.checkNotNullExpressionValue((Object)providerFactory, (String)"getProviders(...)");
        ProjectLayout projectLayout = project.getLayout();
        Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"getLayout(...)");
        BuildServiceRegistry buildServiceRegistry = project.getGradle().getSharedServices();
        Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"getSharedServices(...)");
        LintFromMaven lintFromMaven = LintFromMaven.Companion.from(project, projectOptions, syncIssueHandler);
        Aapt2FromMaven aapt2FromMaven = Aapt2FromMaven.Companion.create(project, (Function1<? super StringOption, String>)((Function1)new Function1<StringOption, String>((Object)projectOptions){

            public final String invoke(StringOption p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((ProjectOptions)this.receiver).get(p0);
            }
        }));
        int n = project.getGradle().getStartParameter().getMaxWorkerCount();
        ProjectInfo projectInfo = new ProjectInfo(project);
        Function1 function1 = (Function1)new Function1<Object, File>((Object)project){

            public final File invoke(Object p0) {
                return ((Project)this.receiver).file(p0);
            }
        };
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"getConfigurations(...)");
        DependencyHandler dependencyHandler = project.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependencyHandler, (String)"getDependencies(...)");
        ExtraPropertiesExtension extraPropertiesExtension = project.getExtensions().getExtraProperties();
        Intrinsics.checkNotNullExpressionValue((Object)extraPropertiesExtension, (String)"getExtraProperties(...)");
        Function1 function12 = new Function1<String, TaskProvider<?>>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final TaskProvider<?> invoke(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                TaskProvider taskProvider = this.$project.getTasks().register(name);
                Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
                return taskProvider;
            }
        };
        PluginManager pluginManager = project.getPluginManager();
        Intrinsics.checkNotNullExpressionValue((Object)pluginManager, (String)"getPluginManager(...)");
        ProjectServices projectServices2 = new ProjectServices(syncIssueReporter2, deprecationReporter2, objectFactory, logger2, providerFactory, projectLayout, projectOptions, buildServiceRegistry, lintFromMaven, aapt2FromMaven, n, projectInfo, (Function1<Object, ? extends File>)function1, configurationContainer, dependencyHandler, extraPropertiesExtension, function12, pluginManager);
        this.registerServices(project, projectOptions);
        Provider provider2 = projectServices2.getProviderFactory().provider((Callable)apply.dslServices.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"provider(...)");
        DslServicesImpl dslServices2 = new DslServicesImpl(projectServices2, provider2, null, null, 8, null);
        Object[] objectArray = new Object[]{dslServices2};
        AssetPackBundleExtension extension2 = dslServices2.newDecoratedInstance(AssetPackBundleExtension.class, objectArray);
        project.getExtensions().add(AssetPackBundleExtension.class, "bundle", (Object)extension2);
        objectArray = (Object[])new Function1<Project, Unit>(this, projectServices2, extension2, project){
            final /* synthetic */ AssetPackBundlePlugin this$0;
            final /* synthetic */ ProjectServices $projectServices;
            final /* synthetic */ AssetPackBundleExtension $extension;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$projectServices = $projectServices;
                this.$extension = $extension;
                this.$project = $project;
                super(1);
            }

            public final void invoke(Project it) {
                AssetPackBundlePlugin.access$validateInput(this.this$0, this.$projectServices.getIssueReporter(), this.$extension);
                AssetPackBundlePlugin.access$createTasks(this.this$0, this.$project, this.$projectServices, this.$extension);
            }
        };
        project.afterEvaluate(new Action((Function1)objectArray){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Object p0) {
                this.function.invoke(p0);
            }
        });
    }

    private final void registerServices(Project project, ProjectOptions projectOptions) {
        Provider provider2;
        if (projectOptions.isAnalyticsEnabled()) {
            AnalyticsConfiguratorService configuratorService2 = (AnalyticsConfiguratorService)new AnalyticsConfiguratorService.RegistrationAction(project).execute().get();
            Intrinsics.checkNotNull((Object)configuratorService2);
            provider2 = new AnalyticsService.RegistrationAction(project, configuratorService2, this.getListenerRegistry(), BuildFeaturesUtils.configurationCacheActive(this.getBuildFeatures()), BuildFeaturesUtils.projectIsolationActive(this.getBuildFeatures())).execute();
        } else {
            provider2 = new NoOpAnalyticsService.RegistrationAction(project).execute();
        }
        new Aapt2ThreadPoolBuildService.RegistrationAction(project, projectOptions).execute();
        new Aapt2DaemonBuildService.RegistrationAction(project, projectOptions).execute();
        SyncOptions.EvaluationMode evaluationMode = SyncOptions.getModelQueryMode(projectOptions);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)evaluationMode), (String)"getModelQueryMode(...)");
        SyncOptions.ErrorFormatMode errorFormatMode = SyncOptions.getErrorFormatMode(projectOptions);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)errorFormatMode), (String)"getErrorFormatMode(...)");
        new SyncIssueReporterImpl.GlobalSyncIssueService.RegistrationAction(project, evaluationMode, errorFormatMode).execute();
        new AndroidLocationsBuildService.RegistrationAction(project).execute();
        new SdkComponentsBuildService.RegistrationAction(project, projectOptions).execute();
    }

    private final void validateInput(IssueReporter issueReporter2, AssetPackBundleExtension extension2) {
        SigningConfig signingConfig2;
        ArrayList<String> errors = new ArrayList<String>();
        if (((CharSequence)extension2.getApplicationId()).length() == 0) {
            errors.add("'applicationId' must be specified for asset pack bundle.");
        }
        if (((CharSequence)extension2.getVersionTag()).length() == 0) {
            errors.add("'versionTag' must be specified for asset pack bundle.");
        }
        if (extension2.getVersionCodes().isEmpty()) {
            errors.add("Asset pack bundle must target at least one version code.");
        }
        if (extension2.getAssetPacks().isEmpty()) {
            errors.add("Asset pack bundle must contain at least one asset pack.");
        }
        if (AssetPackBundlePluginKt.access$isPresent(signingConfig2 = extension2.getSigningConfig()) && (signingConfig2.getStoreFile() == null || signingConfig2.getStorePassword() == null || signingConfig2.getKeyAlias() == null || signingConfig2.getKeyPassword() == null)) {
            errors.add("Signing config is specified but incomplete. To make it complete 'storeFile', 'storePassword', 'keyAlias', 'keyPassword' must be specified.");
        }
        if (!((Collection)errors).isEmpty()) {
            IssueReporter.reportWarning$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (List)errors, (int)4, null);
        }
    }

    private final void createTasks(Project project, ProjectServices projectServices2, AssetPackBundleExtension extension2) {
        Configuration assetPackFilesConfiguration = (Configuration)project.getConfigurations().maybeCreate("assetPackFiles");
        Configuration assetPackManifestConfiguration = (Configuration)project.getConfigurations().maybeCreate("assetPackManifest");
        IssueReporter issueReporter2 = projectServices2.getIssueReporter();
        Set set = extension2.getAssetPacks();
        Intrinsics.checkNotNull((Object)assetPackFilesConfiguration);
        Intrinsics.checkNotNull((Object)assetPackManifestConfiguration);
        AssetPackUtilKt.populateAssetPacksConfigurations(project, issueReporter2, set, assetPackFilesConfiguration, assetPackManifestConfiguration);
        TaskContainer taskContainer = project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
        TaskFactoryImpl tasks = new TaskFactoryImpl(taskContainer);
        ArtifactsImpl artifacts2 = new ArtifactsImpl(project, "global", null, 4, null);
        tasks.register(new AppMetadataTask.CreationForAssetPackBundleAction(artifacts2, projectServices2.getProjectOptions()));
        String string = extension2.getApplicationId();
        ArtifactCollection artifactCollection = assetPackManifestConfiguration.getIncoming().getArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)artifactCollection, (String)"getArtifacts(...)");
        tasks.register(new ProcessAssetPackManifestTask.CreationForAssetPackBundleAction(artifacts2, string, artifactCollection));
        tasks.register(new LinkManifestForAssetPackTask.CreationForAssetPackBundleAction(artifacts2, projectServices2, extension2.getCompileSdk()));
        tasks.register(new AssetPackPreBundleTask.CreationForAssetPackBundleAction(artifacts2, (FileCollection)assetPackFilesConfiguration));
        tasks.register(new PackageBundleTask.CreationForAssetPackBundleAction(projectServices2, artifacts2, extension2));
        if (AssetPackBundlePluginKt.access$isPresent(extension2.getSigningConfig())) {
            tasks.register(new ValidateSigningTask.CreationForAssetPackBundleAction(artifacts2, extension2.getSigningConfig()));
        }
        tasks.register(new FinalizeBundleTask.CreationForAssetPackBundleAction(projectServices2, artifacts2, extension2.getSigningConfig(), AssetPackBundlePluginKt.access$isPresent(extension2.getSigningConfig())));
        TaskFactory.register$default((TaskFactory)tasks, "bundle", null, (TaskConfigAction)new TaskConfigAction<Task>(artifacts2){
            final /* synthetic */ ArtifactsImpl $artifacts;
            {
                this.$artifacts = $artifacts;
            }

            public void configure(Task task) {
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                task.setDescription("Assembles asset pack bundle for asset only updates");
                Object[] objectArray = new Object[]{this.$artifacts.get((SingleArtifact)SingleArtifact.BUNDLE.INSTANCE)};
                task.dependsOn(objectArray);
            }
        }, null, 8, null);
    }

    public static final /* synthetic */ void access$validateInput(AssetPackBundlePlugin $this, IssueReporter issueReporter2, AssetPackBundleExtension extension2) {
        $this.validateInput(issueReporter2, extension2);
    }

    public static final /* synthetic */ void access$createTasks(AssetPackBundlePlugin $this, Project project, ProjectServices projectServices2, AssetPackBundleExtension extension2) {
        $this.createTasks(project, projectServices2, extension2);
    }
}

