/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.api.variant.AndroidVersion;
import com.android.build.api.variant.impl.VariantApiExtensionsKt;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.dependency.AndroidAttributes;
import com.android.build.gradle.internal.dependency.L8DesugarLibTransformRegistration;
import com.android.build.gradle.internal.services.TaskCreationServices;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.utils.DesugarConfigJson;
import com.android.build.gradle.internal.utils.DesugarLibConfigExtractor;
import com.android.build.gradle.internal.utils.DesugarLibLintExtractor;
import com.android.build.gradle.internal.utils.DesugarLibUtils;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.sdklib.AndroidTargetHash;
import java.io.File;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.transform.TransformSpec;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ValueSourceSpec;
import org.gradle.api.specs.Spec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u001a\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e\u001a&\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%\u001a\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0010\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020'H\u0002\u001a\u0010\u0010*\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020'H\u0002\u001a\u0010\u0010+\u001a\u00020,2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a \u0010-\u001a\u00020,2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0002\u001a \u00100\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020'2\u0006\u0010\"\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0002\u001a \u00101\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020'2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020.H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\"\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u00062"}, d2={"DESUGAR_LIB_CONFIG_FILE", "", "DESUGARED_DESUGAR_LIB", "DESUGAR_LIB_CONFIG", "DESUGAR_LIB_COMPONENT_NAME", "DESUGAR_LIB_LINT", "D8_DESUGAR_METHODS", "ATTR_LINT_MIN_SDK", "Lorg/gradle/api/attributes/Attribute;", "getATTR_LINT_MIN_SDK", "()Lorg/gradle/api/attributes/Attribute;", "ATTR_LINT_COMPILE_SDK", "ATTR_ENABLE_CORE_LIBRARY_DESUGARING", "getATTR_ENABLE_CORE_LIBRARY_DESUGARING", "getDesugarLibJarFromMaven", "Lorg/gradle/api/file/FileCollection;", "services", "Lcom/android/build/gradle/internal/services/TaskCreationServices;", "getDesugarLibDependencyGraph", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/artifacts/result/ResolvedComponentResult;", "getDesugaredDesugarLib", "creationConfig", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "getDesugarLibConfig", "getDesugarLibConfigFiles", "getDesugarLibConfigFile", "", "Ljava/io/File;", "project", "Lorg/gradle/api/Project;", "getDesugaredMethods", "coreLibDesugar", "", "minSdkVersion", "Lcom/android/build/api/variant/AndroidVersion;", "global", "Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;", "getDesugarLibConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "getDesugarLibConfigFromTransform", "configuration", "getArtifactCollection", "registerDesugarLibConfigExtractorTransformIfAbsent", "", "registerDesugarLibLintTransform", "", "compileSdkVersion", "getDesugarLibLintFromTransform", "getD8DesugarMethodFileFromTransform", "gradle-core"})
@JvmName(name="DesugarLibUtils")
public final class DesugarLibUtils {
    @NotNull
    private static final String DESUGAR_LIB_CONFIG_FILE = "desugar.json";
    @NotNull
    public static final String DESUGARED_DESUGAR_LIB = "_internal-desugared-desugar-lib";
    @NotNull
    public static final String DESUGAR_LIB_CONFIG = "_internal-desugar-lib-config";
    @NotNull
    private static final String DESUGAR_LIB_COMPONENT_NAME = "desugar_jdk_libs_configuration";
    @NotNull
    private static final String DESUGAR_LIB_LINT = "_internal-desugar-lib-lint";
    @NotNull
    public static final String D8_DESUGAR_METHODS = "_internal-d8-desugar-methods";
    @NotNull
    private static final Attribute<String> ATTR_LINT_MIN_SDK;
    @NotNull
    private static final Attribute<String> ATTR_LINT_COMPILE_SDK;
    @NotNull
    private static final Attribute<String> ATTR_ENABLE_CORE_LIBRARY_DESUGARING;

    @NotNull
    public static final Attribute<String> getATTR_LINT_MIN_SDK() {
        return ATTR_LINT_MIN_SDK;
    }

    @NotNull
    public static final Attribute<String> getATTR_ENABLE_CORE_LIBRARY_DESUGARING() {
        return ATTR_ENABLE_CORE_LIBRARY_DESUGARING;
    }

    @NotNull
    public static final FileCollection getDesugarLibJarFromMaven(@NotNull TaskCreationServices services) {
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        Configuration configuration = DesugarLibUtils.getDesugarLibConfiguration(services);
        return DesugarLibUtils.getArtifactCollection(configuration);
    }

    @NotNull
    public static final Provider<ResolvedComponentResult> getDesugarLibDependencyGraph(@NotNull TaskCreationServices services) {
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        Configuration configuration = DesugarLibUtils.getDesugarLibConfiguration(services);
        Provider provider2 = configuration.getIncoming().getResolutionResult().getRootComponent();
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"getRootComponent(...)");
        return provider2;
    }

    @NotNull
    public static final FileCollection getDesugaredDesugarLib(@NotNull ApkCreationConfig creationConfig) {
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        L8DesugarLibTransformRegistration.INSTANCE.registerTransformIfAbsent(creationConfig);
        Function1 function1 = (Function1)new Function1<ArtifactView.ViewConfiguration, Unit>(creationConfig){
            final /* synthetic */ ApkCreationConfig $creationConfig;
            {
                this.$creationConfig = $creationConfig;
                super(1);
            }

            public final void invoke(ArtifactView.ViewConfiguration it) {
                Function1 function1 = getDesugaredDesugarLib.1.INSTANCE;
                it.componentFilter(new Spec(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                        this.function = function;
                    }

                    public final /* synthetic */ boolean isSatisfiedBy(Object p0) {
                        return (Boolean)this.function.invoke(p0);
                    }
                });
                AndroidAttributes androidAttributes = L8DesugarLibTransformRegistration.INSTANCE.getOutputArtifactAttributes(this.$creationConfig);
                AttributeContainer attributeContainer = it.getAttributes();
                Intrinsics.checkNotNullExpressionValue((Object)attributeContainer, (String)"getAttributes(...)");
                androidAttributes.addAttributesToContainer(attributeContainer);
            }
        };
        FileCollection fileCollection2 = DesugarLibUtils.getDesugarLibConfiguration(creationConfig.getServices()).getIncoming().artifactView(new Action(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Object p0) {
                this.function.invoke(p0);
            }
        }).getArtifacts().getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"getArtifactFiles(...)");
        return fileCollection2;
    }

    @NotNull
    public static final Provider<String> getDesugarLibConfig(@NotNull TaskCreationServices services) {
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        Configuration configuration = services.getConfigurations().getByName("coreLibraryDesugaring");
        DesugarLibUtils.registerDesugarLibConfigExtractorTransformIfAbsent(services);
        Function1 function1 = (Function1)new Function1<ValueSourceSpec<DesugarConfigJson.Parameters>, Unit>(configuration){
            final /* synthetic */ Configuration $configuration;
            {
                this.$configuration = $configuration;
                super(1);
            }

            public final void invoke(ValueSourceSpec<DesugarConfigJson.Parameters> it) {
                ConfigurableFileCollection configurableFileCollection = ((DesugarConfigJson.Parameters)it.getParameters()).getDesugarJson();
                Configuration configuration = this.$configuration;
                Intrinsics.checkNotNull((Object)configuration);
                configurableFileCollection.setFrom((Iterable)DesugarLibUtils.access$getDesugarLibConfigFromTransform(configuration));
            }
        };
        return services.providerOf(DesugarConfigJson.class, (Action)new /* invalid duplicate definition of identical inner class */);
    }

    @NotNull
    public static final FileCollection getDesugarLibConfigFiles(@NotNull TaskCreationServices services) {
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        Configuration configuration = services.getConfigurations().getByName("coreLibraryDesugaring");
        DesugarLibUtils.registerDesugarLibConfigExtractorTransformIfAbsent(services);
        Intrinsics.checkNotNull((Object)configuration);
        return DesugarLibUtils.getDesugarLibConfigFromTransform(configuration);
    }

    @NotNull
    public static final List<File> getDesugarLibConfigFile(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = project.getConfigurations().findByName("coreLibraryDesugaring");
        Intrinsics.checkNotNull((Object)object);
        Configuration configuration = (Configuration)object;
        Set set = DesugarLibUtils.getDesugarLibConfigFromTransform(configuration).getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
        return CollectionsKt.toList((Iterable)set);
    }

    @NotNull
    public static final FileCollection getDesugaredMethods(@NotNull TaskCreationServices services, boolean coreLibDesugar, @NotNull AndroidVersion minSdkVersion2, @NotNull GlobalTaskCreationConfig global) {
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)minSdkVersion2, (String)"minSdkVersion");
        Intrinsics.checkNotNullParameter((Object)global, (String)"global");
        ConfigurableFileCollection desugaredMethodsFiles = services.fileCollection();
        int minSdk2 = VariantApiExtensionsKt.getFeatureLevel(minSdkVersion2);
        if (coreLibDesugar && global.getCompileSdkHashString() != null) {
            com.android.sdklib.AndroidVersion androidVersion = AndroidTargetHash.getPlatformVersion((String)global.getCompileSdkHashString());
            Intrinsics.checkNotNull((Object)androidVersion);
            int compileSdk = androidVersion.getFeatureLevel();
            DesugarLibUtils.registerDesugarLibLintTransform(services, minSdk2, compileSdk);
            Object[] objectArray = new Object[]{DesugarLibUtils.getDesugarLibLintFromTransform(DesugarLibUtils.getDesugarLibConfiguration(services), minSdk2, compileSdk)};
            desugaredMethodsFiles.from(objectArray);
        }
        Object[] objectArray = new Object[]{DesugarLibUtils.getD8DesugarMethodFileFromTransform(global.getFakeDependency(), coreLibDesugar, minSdk2)};
        HasConfigurableValuesKt.fromDisallowChanges(desugaredMethodsFiles, objectArray);
        return (FileCollection)desugaredMethodsFiles;
    }

    private static final Configuration getDesugarLibConfiguration(TaskCreationServices services) {
        Object object = services.getConfigurations().findByName("coreLibraryDesugaring");
        Intrinsics.checkNotNull((Object)object);
        Configuration configuration = (Configuration)object;
        if (configuration.getDependencies().isEmpty()) {
            throw new RuntimeException("coreLibraryDesugaring configuration contains no dependencies. If you intend to enable core library desugaring, please add dependencies to coreLibraryDesugaring configuration.");
        }
        return configuration;
    }

    private static final FileCollection getDesugarLibConfigFromTransform(Configuration configuration) {
        Function1 function1 = getDesugarLibConfigFromTransform.1.INSTANCE;
        FileCollection fileCollection2 = configuration.getIncoming().artifactView(new /* invalid duplicate definition of identical inner class */).getArtifacts().getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"getArtifactFiles(...)");
        return fileCollection2;
    }

    private static final FileCollection getArtifactCollection(Configuration configuration) {
        Function1 function1 = getArtifactCollection.1.INSTANCE;
        FileCollection fileCollection2 = configuration.getIncoming().artifactView(new /* invalid duplicate definition of identical inner class */).getArtifacts().getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"getArtifactFiles(...)");
        return fileCollection2;
    }

    private static final void registerDesugarLibConfigExtractorTransformIfAbsent(TaskCreationServices services) {
        String transformRegistered = "_agp_internal_" + Reflection.getOrCreateKotlinClass(DesugarLibConfigExtractor.class).getSimpleName() + "_registered";
        if (services.getExtraProperties().has(transformRegistered)) {
            return;
        }
        services.getExtraProperties().set(transformRegistered, (Object)true);
        Function1 function1 = registerDesugarLibConfigExtractorTransformIfAbsent.1.INSTANCE;
        services.getDependencies().registerTransform(DesugarLibConfigExtractor.class, new /* invalid duplicate definition of identical inner class */);
    }

    private static final void registerDesugarLibLintTransform(TaskCreationServices services, int minSdkVersion2, int compileSdkVersion2) {
        Function1 function1 = (Function1)new Function1<TransformSpec<DesugarLibLintExtractor.Parameters>, Unit>(minSdkVersion2, compileSdkVersion2){
            final /* synthetic */ int $minSdkVersion;
            final /* synthetic */ int $compileSdkVersion;
            {
                this.$minSdkVersion = $minSdkVersion;
                this.$compileSdkVersion = $compileSdkVersion;
                super(1);
            }

            public final void invoke(TransformSpec<DesugarLibLintExtractor.Parameters> spec) {
                Function1 function1 = (Function1)new Function1<DesugarLibLintExtractor.Parameters, Unit>(this.$minSdkVersion, this.$compileSdkVersion){
                    final /* synthetic */ int $minSdkVersion;
                    final /* synthetic */ int $compileSdkVersion;
                    {
                        this.$minSdkVersion = $minSdkVersion;
                        this.$compileSdkVersion = $compileSdkVersion;
                        super(1);
                    }

                    public final void invoke(DesugarLibLintExtractor.Parameters parameters) {
                        parameters.getMinSdkVersion().set((Object)this.$minSdkVersion);
                        parameters.getCompileSdkVersion().set((Object)this.$compileSdkVersion);
                    }
                };
                spec.parameters(new /* invalid duplicate definition of identical inner class */);
                spec.getFrom().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar");
                spec.getTo().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"_internal-desugar-lib-lint");
                spec.getFrom().attribute(DesugarLibUtils.getATTR_LINT_MIN_SDK(), (Object)String.valueOf(this.$minSdkVersion));
                spec.getTo().attribute(DesugarLibUtils.getATTR_LINT_MIN_SDK(), (Object)String.valueOf(this.$minSdkVersion));
                spec.getFrom().attribute(DesugarLibUtils.access$getATTR_LINT_COMPILE_SDK$p(), (Object)String.valueOf(this.$compileSdkVersion));
                spec.getTo().attribute(DesugarLibUtils.access$getATTR_LINT_COMPILE_SDK$p(), (Object)String.valueOf(this.$compileSdkVersion));
            }
        };
        services.getDependencies().registerTransform(DesugarLibLintExtractor.class, new /* invalid duplicate definition of identical inner class */);
    }

    private static final FileCollection getDesugarLibLintFromTransform(Configuration configuration, int minSdkVersion2, int compileSdkVersion2) {
        Function1 function1 = (Function1)new Function1<ArtifactView.ViewConfiguration, Unit>(minSdkVersion2, compileSdkVersion2){
            final /* synthetic */ int $minSdkVersion;
            final /* synthetic */ int $compileSdkVersion;
            {
                this.$minSdkVersion = $minSdkVersion;
                this.$compileSdkVersion = $compileSdkVersion;
                super(1);
            }

            public final void invoke(ArtifactView.ViewConfiguration configuration) {
                Function1 function1 = (Function1)new Function1<AttributeContainer, Unit>(this.$minSdkVersion, this.$compileSdkVersion){
                    final /* synthetic */ int $minSdkVersion;
                    final /* synthetic */ int $compileSdkVersion;
                    {
                        this.$minSdkVersion = $minSdkVersion;
                        this.$compileSdkVersion = $compileSdkVersion;
                        super(1);
                    }

                    public final void invoke(AttributeContainer it) {
                        it.attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"_internal-desugar-lib-lint");
                        it.attribute(DesugarLibUtils.getATTR_LINT_MIN_SDK(), (Object)String.valueOf(this.$minSdkVersion));
                        it.attribute(DesugarLibUtils.access$getATTR_LINT_COMPILE_SDK$p(), (Object)String.valueOf(this.$compileSdkVersion));
                    }
                };
                configuration.attributes(new /* invalid duplicate definition of identical inner class */);
            }
        };
        FileCollection fileCollection2 = configuration.getIncoming().artifactView(new /* invalid duplicate definition of identical inner class */).getArtifacts().getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"getArtifactFiles(...)");
        return fileCollection2;
    }

    private static final FileCollection getD8DesugarMethodFileFromTransform(Configuration configuration, boolean coreLibDesugar, int minSdkVersion2) {
        Function1 function1 = (Function1)new Function1<ArtifactView.ViewConfiguration, Unit>(coreLibDesugar, minSdkVersion2){
            final /* synthetic */ boolean $coreLibDesugar;
            final /* synthetic */ int $minSdkVersion;
            {
                this.$coreLibDesugar = $coreLibDesugar;
                this.$minSdkVersion = $minSdkVersion;
                super(1);
            }

            public final void invoke(ArtifactView.ViewConfiguration configuration) {
                Function1 function1 = (Function1)new Function1<AttributeContainer, Unit>(this.$coreLibDesugar, this.$minSdkVersion){
                    final /* synthetic */ boolean $coreLibDesugar;
                    final /* synthetic */ int $minSdkVersion;
                    {
                        this.$coreLibDesugar = $coreLibDesugar;
                        this.$minSdkVersion = $minSdkVersion;
                        super(1);
                    }

                    public final void invoke(AttributeContainer it) {
                        it.attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"_internal-d8-desugar-methods");
                        it.attribute(DesugarLibUtils.getATTR_ENABLE_CORE_LIBRARY_DESUGARING(), (Object)String.valueOf(this.$coreLibDesugar));
                        it.attribute(DesugarLibUtils.getATTR_LINT_MIN_SDK(), (Object)String.valueOf(this.$minSdkVersion));
                    }
                };
                configuration.attributes(new /* invalid duplicate definition of identical inner class */);
            }
        };
        FileCollection fileCollection2 = configuration.getIncoming().artifactView(new /* invalid duplicate definition of identical inner class */).getArtifacts().getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"getArtifactFiles(...)");
        return fileCollection2;
    }

    public static final /* synthetic */ FileCollection access$getDesugarLibConfigFromTransform(Configuration configuration) {
        return DesugarLibUtils.getDesugarLibConfigFromTransform(configuration);
    }

    public static final /* synthetic */ Attribute access$getATTR_LINT_COMPILE_SDK$p() {
        return ATTR_LINT_COMPILE_SDK;
    }

    static {
        Attribute attribute = Attribute.of((String)"lint-min-sdk", String.class);
        Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"of(...)");
        ATTR_LINT_MIN_SDK = attribute;
        Attribute attribute2 = Attribute.of((String)"lint-compile-sdk", String.class);
        Intrinsics.checkNotNullExpressionValue((Object)attribute2, (String)"of(...)");
        ATTR_LINT_COMPILE_SDK = attribute2;
        Attribute attribute3 = Attribute.of((String)"enable-core-library-desugaring", String.class);
        Intrinsics.checkNotNullExpressionValue((Object)attribute3, (String)"of(...)");
        ATTR_ENABLE_CORE_LIBRARY_DESUGARING = attribute3;
    }
}

