/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.generators;

import com.android.build.api.variant.BuildConfigField;
import com.android.build.gradle.internal.generators.BuildConfigData;
import com.android.build.gradle.internal.generators.BuildConfigFieldUtilsKt;
import com.android.builder.compiling.GeneratedCodeFileCreator;
import com.android.builder.packaging.JarFlinger;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0015\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015H\u0002\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/android/build/gradle/internal/generators/BuildConfigByteCodeGenerator;", "Lcom/android/builder/compiling/GeneratedCodeFileCreator;", "data", "Lcom/android/build/gradle/internal/generators/BuildConfigData;", "<init>", "(Lcom/android/build/gradle/internal/generators/BuildConfigData;)V", "fullyQualifiedBuildConfigClassName", "", "getFullyQualifiedBuildConfigClassName", "()Ljava/lang/String;", "fullyQualifiedBuildConfigClassName$delegate", "Lkotlin/Lazy;", "folderPath", "Ljava/io/File;", "getFolderPath", "()Ljava/io/File;", "generatedFilePath", "getGeneratedFilePath", "generate", "", "generateByteCode", "", "kotlin.jvm.PlatformType", "()[B", "generateUsingAsm", "Lorg/objectweb/asm/ClassWriter;", "writeToJar", "outputPath", "Ljava/nio/file/Path;", "buildConfigPackage", "bytecodeBuildConfig", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nBuildConfigByteCodeGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildConfigByteCodeGenerator.kt\ncom/android/build/gradle/internal/generators/BuildConfigByteCodeGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,98:1\n1#2:99\n216#3,2:100\n*S KotlinDebug\n*F\n+ 1 BuildConfigByteCodeGenerator.kt\ncom/android/build/gradle/internal/generators/BuildConfigByteCodeGenerator\n*L\n72#1:100,2\n*E\n"})
public final class BuildConfigByteCodeGenerator
implements GeneratedCodeFileCreator {
    @NotNull
    private final BuildConfigData data;
    @NotNull
    private final Lazy fullyQualifiedBuildConfigClassName$delegate;
    @NotNull
    private final File folderPath;
    @NotNull
    private final File generatedFilePath;

    /*
     * WARNING - void declaration
     */
    public BuildConfigByteCodeGenerator(@NotNull BuildConfigData data) {
        void it;
        File file;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.data = data;
        this.fullyQualifiedBuildConfigClassName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ BuildConfigByteCodeGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke() {
                return StringsKt.replace$default((String)BuildConfigByteCodeGenerator.access$getData$p(this.this$0).getNamespace(), (char)'.', (char)'/', (boolean)false, (int)4, null) + "/" + BuildConfigByteCodeGenerator.access$getData$p(this.this$0).getBuildConfigName();
            }
        }));
        File file2 = file = this.data.getOutputPath().toFile();
        BuildConfigByteCodeGenerator buildConfigByteCodeGenerator = this;
        boolean bl = false;
        it.mkdirs();
        File file3 = file;
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"also(...)");
        buildConfigByteCodeGenerator.folderPath = file3;
        this.generatedFilePath = new File(this.getFolderPath(), this.data.getBuildConfigName() + ".jar");
    }

    private final String getFullyQualifiedBuildConfigClassName() {
        Lazy lazy = this.fullyQualifiedBuildConfigClassName$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public File getFolderPath() {
        return this.folderPath;
    }

    @NotNull
    public File getGeneratedFilePath() {
        return this.generatedFilePath;
    }

    public void generate() {
        Path path = this.getGeneratedFilePath().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        String string = StringsKt.trimMargin$default((String)(StringsKt.replace$default((String)this.data.getNamespace(), (char)'.', (char)'/', (boolean)false, (int)4, null) + "/" + this.data.getBuildConfigName() + ".class"), null, (int)1, null);
        byte[] byArray = this.generateByteCode();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"generateByteCode(...)");
        this.writeToJar(path, string, byArray);
    }

    private final byte[] generateByteCode() {
        return this.generateUsingAsm().toByteArray();
    }

    private final ClassWriter generateUsingAsm() {
        ClassWriter cw = new ClassWriter(1);
        cw.visit(52, 49, this.getFullyQualifiedBuildConfigClassName(), null, "java/lang/Object", null);
        Map<String, BuildConfigField<? extends Serializable>> $this$forEach$iv = this.data.getBuildConfigFields();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, BuildConfigField<? extends Serializable>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, BuildConfigField<? extends Serializable>> element$iv;
            Map.Entry<String, BuildConfigField<? extends Serializable>> it = element$iv = iterator2.next();
            boolean bl = false;
            BuildConfigFieldUtilsKt.emit(it.getValue(), it.getKey(), cw);
        }
        Method constructorMethod = Method.getMethod((String)"void <init> ()");
        GeneratorAdapter cGen = new GeneratorAdapter(1, constructorMethod, null, null, (ClassVisitor)cw);
        cGen.loadThis();
        cGen.invokeConstructor(Type.getType(Object.class), constructorMethod);
        cGen.returnValue();
        cGen.endMethod();
        cw.visitEnd();
        return cw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeToJar(Path outputPath, String buildConfigPackage, byte[] bytecodeBuildConfig) throws IOException {
        outputPath.toFile().createNewFile();
        Closeable closeable = (Closeable)new JarFlinger(outputPath);
        Throwable throwable = null;
        try {
            JarFlinger jarCreator = (JarFlinger)closeable;
            boolean bl = false;
            jarCreator.setCompressionLevel(0);
            jarCreator.addEntry(buildConfigPackage, (InputStream)new ByteArrayInputStream(bytecodeBuildConfig));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final /* synthetic */ BuildConfigData access$getData$p(BuildConfigByteCodeGenerator $this) {
        return $this.data;
    }
}

