/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.services;

import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.UnmodifiableIterator;
import java.io.File;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b'\u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00060\u0003j\u0002`\u0004:\u0003'()B\u0011\b\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\t\b\u0017\u00a2\u0006\u0004\b\u0007\u0010\tJ\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\r\u0010!\u001a\u00020\"H\u0001\u00a2\u0006\u0002\b#J\r\u0010$\u001a\u00020\"H\u0001\u00a2\u0006\u0002\b%J\u0006\u0010&\u001a\u00020\"R\u0014\u0010\u0010\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0018\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/android/build/gradle/internal/services/SymbolTableBuildService;", "Lorg/gradle/api/services/BuildService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "cacheBuilderSpec", "Lcom/google/common/cache/CacheBuilderSpec;", "<init>", "(Lcom/google/common/cache/CacheBuilderSpec;)V", "()V", "loadClasspath", "", "Lcom/android/ide/common/symbols/SymbolTable;", "files", "", "Ljava/io/File;", "logger", "Lorg/gradle/api/logging/Logger;", "getLogger", "()Lorg/gradle/api/logging/Logger;", "logLevel", "Lorg/gradle/api/logging/LogLevel;", "symbolInternerReference", "Ljava/lang/ref/SoftReference;", "Lcom/google/common/collect/Interner;", "Lcom/android/ide/common/symbols/Symbol;", "symbolInterner", "getSymbolInterner", "()Lcom/google/common/collect/Interner;", "symbolTableCache", "Lcom/google/common/cache/LoadingCache;", "Lcom/android/build/gradle/internal/services/SymbolTableBuildService$FileCacheKey;", "getSymbolTablesCached", "dropSymbolInterner", "", "dropSymbolInterner$gradle_core", "dropSymbolTables", "dropSymbolTables$gradle_core", "close", "FileCacheKey", "RegistrationAction", "Companion", "gradle-core"})
@ThreadSafe
@SourceDebugExtension(value={"SMAP\nSymbolTableBuildService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymbolTableBuildService.kt\ncom/android/build/gradle/internal/services/SymbolTableBuildService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,173:1\n1557#2:174\n1628#2,3:175\n*S KotlinDebug\n*F\n+ 1 SymbolTableBuildService.kt\ncom/android/build/gradle/internal/services/SymbolTableBuildService\n*L\n143#1:174\n143#1:175,3\n*E\n"})
public abstract class SymbolTableBuildService
implements BuildService<BuildServiceParameters.None>,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final LogLevel logLevel;
    @Nullable
    private SoftReference<Interner<Symbol>> symbolInternerReference;
    @NotNull
    private final LoadingCache<FileCacheKey, SymbolTable> symbolTableCache;
    private static final CacheBuilderSpec SOFT_VALUES = CacheBuilderSpec.parse((String)"softValues");

    @VisibleForTesting
    public SymbolTableBuildService(@NotNull CacheBuilderSpec cacheBuilderSpec) {
        Intrinsics.checkNotNullParameter((Object)cacheBuilderSpec, (String)"cacheBuilderSpec");
        Logger logger = Logging.getLogger(SymbolTableBuildService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.logLevel = LogLevel.DEBUG;
        LoadingCache loadingCache = CacheBuilder.from((CacheBuilderSpec)cacheBuilderSpec).build((CacheLoader)new CacheLoader<FileCacheKey, SymbolTable>(this){
            final /* synthetic */ SymbolTableBuildService this$0;
            {
                this.this$0 = $receiver;
            }

            public SymbolTable load(FileCacheKey key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                SymbolTable result2 = new SymbolIo(SymbolTableBuildService.access$getSymbolInterner(this.this$0)).readSymbolListWithPackageName(key.getFile());
                Object[] objectArray = new Object[]{result2.getTablePackage()};
                this.this$0.getLogger().log(SymbolTableBuildService.access$getLogLevel$p(this.this$0), "SymbolTableBuildService: cache miss - loaded table '{}' from disk", objectArray);
                Intrinsics.checkNotNull((Object)result2);
                return result2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        this.symbolTableCache = loadingCache;
    }

    @Inject
    public SymbolTableBuildService() {
        CacheBuilderSpec cacheBuilderSpec = SOFT_VALUES;
        Intrinsics.checkNotNullExpressionValue((Object)cacheBuilderSpec, (String)"SOFT_VALUES");
        this(cacheBuilderSpec);
    }

    @NotNull
    public final List<SymbolTable> loadClasspath(@NotNull Iterable<? extends File> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.logger.log(this.logLevel, "SymbolTableBuildService: loadClasspath started");
        List<SymbolTable> result2 = this.getSymbolTablesCached(files2);
        boolean bl = false;
        Object[] objectArray = new Object[]{stopwatch.elapsed(), result2.size()};
        this.logger.log(this.logLevel, "SymbolTableBuildService: loadClasspath took {} to return {} tables", objectArray);
        return result2;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    private final synchronized Interner<Symbol> getSymbolInterner() {
        Interner interner = this.symbolInternerReference;
        if (interner == null || (interner = interner.get()) == null) {
            Interner interner2;
            Interner it = interner2 = Interners.newStrongInterner();
            boolean bl = false;
            this.symbolInternerReference = new SoftReference<Interner>(it);
            for (SymbolTable symbolTable : this.symbolTableCache.asMap().values()) {
                UnmodifiableIterator unmodifiableIterator;
                Intrinsics.checkNotNullExpressionValue((Object)symbolTable.getSymbols().values().iterator(), (String)"iterator(...)");
                while (unmodifiableIterator.hasNext()) {
                    Symbol symbol = (Symbol)unmodifiableIterator.next();
                    it.intern((Object)symbol);
                }
            }
            Interner interner3 = interner2;
            interner = interner3;
            Intrinsics.checkNotNullExpressionValue((Object)interner3, (String)"also(...)");
        }
        return interner;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SymbolTable> getSymbolTablesCached(Iterable<? extends File> files2) {
        void $this$mapTo$iv$iv;
        Iterable<? extends File> $this$map$iv = files2;
        boolean $i$f$map = false;
        Iterable<? extends File> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path = it.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            collection.add((SymbolTable)this.symbolTableCache.get((Object)new FileCacheKey(path, null, 2, null)));
        }
        return (List)destination$iv$iv;
    }

    @VisibleForTesting
    public final void dropSymbolInterner$gradle_core() {
        block0: {
            SoftReference<Interner<Symbol>> softReference = this.symbolInternerReference;
            if (softReference == null) break block0;
            softReference.clear();
        }
    }

    @VisibleForTesting
    public final void dropSymbolTables$gradle_core() {
        this.symbolTableCache.invalidateAll();
    }

    @Override
    public final void close() {
        this.dropSymbolInterner$gradle_core();
        this.dropSymbolTables$gradle_core();
    }

    public static final /* synthetic */ Interner access$getSymbolInterner(SymbolTableBuildService $this) {
        return $this.getSymbolInterner();
    }

    public static final /* synthetic */ LogLevel access$getLogLevel$p(SymbolTableBuildService $this) {
        return $this.logLevel;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/services/SymbolTableBuildService$Companion;", "", "<init>", "()V", "SOFT_VALUES", "Lcom/google/common/cache/CacheBuilderSpec;", "kotlin.jvm.PlatformType", "Lcom/google/common/cache/CacheBuilderSpec;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0001H\u00c2\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0001H\u00c6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/internal/services/SymbolTableBuildService$FileCacheKey;", "", "file", "Ljava/nio/file/Path;", "key", "<init>", "(Ljava/nio/file/Path;Ljava/lang/Object;)V", "getFile", "()Ljava/nio/file/Path;", "equals", "", "other", "hashCode", "", "component1", "component2", "copy", "toString", "", "gradle-core"})
    private static final class FileCacheKey {
        @NotNull
        private final Path file;
        @NotNull
        private final Object key;

        public FileCacheKey(@NotNull Path file, @NotNull Object key) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.file = file;
            this.key = key;
        }

        public /* synthetic */ FileCacheKey(Path path, Object object, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                Object object2 = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]).fileKey();
                if (object2 == null) {
                    String string = path.toUri().toString();
                    object2 = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                }
                object = object2;
            }
            this(path, object);
        }

        @NotNull
        public final Path getFile() {
            return this.file;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof FileCacheKey && Intrinsics.areEqual((Object)this.key, (Object)((FileCacheKey)other).key);
        }

        public int hashCode() {
            Object[] objectArray = new Object[]{this.key};
            return Objects.hash(objectArray);
        }

        @NotNull
        public final Path component1() {
            return this.file;
        }

        private final Object component2() {
            return this.key;
        }

        @NotNull
        public final FileCacheKey copy(@NotNull Path file, @NotNull Object key) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new FileCacheKey(file, key);
        }

        public static /* synthetic */ FileCacheKey copy$default(FileCacheKey fileCacheKey, Path path, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                path = fileCacheKey.file;
            }
            if ((n & 2) != 0) {
                object = fileCacheKey.key;
            }
            return fileCacheKey.copy(path, object);
        }

        @NotNull
        public String toString() {
            return "FileCacheKey(file=" + this.file + ", key=" + this.key + ")";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/services/SymbolTableBuildService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/services/SymbolTableBuildService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "project", "Lorg/gradle/api/Project;", "<init>", "(Lorg/gradle/api/Project;)V", "configure", "", "parameters", "gradle-core"})
    public static final class RegistrationAction
    extends ServiceRegistrationAction<SymbolTableBuildService, BuildServiceParameters.None> {
        public RegistrationAction(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(project, SymbolTableBuildService.class, null, null, 12, null);
        }

        @Override
        public void configure(@NotNull BuildServiceParameters.None parameters) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        }
    }
}

