/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.coverage.JacocoConfigurations;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.FileInfo;
import com.android.build.gradle.internal.tasks.JarsClasspathInputsWithIdentity;
import com.android.build.gradle.internal.tasks.JarsIdentityMapping;
import com.android.build.gradle.internal.tasks.NewIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.IncrementalChangesUtils;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.builder.files.SerializableChange;
import com.android.builder.files.SerializableFileChanges;
import com.android.utils.FileUtils;
import com.android.utils.PathUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;
import org.gradle.workers.ClassLoaderWorkerSpec;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.jacoco.core.instr.Instrumenter;
import org.jacoco.core.runtime.IExecutionDataAccessorGenerator;
import org.jacoco.core.runtime.OfflineInstrumentationAccessGenerator;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@BuildAnalyzer(primaryTaskCategory=TaskCategory.TEST)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b'\u0018\u0000 *2\u00020\u0001:\u0005&'()*B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0014\u0010\"\u001a\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006+"}, d2={"Lcom/android/build/gradle/internal/tasks/JacocoTask;", "Lcom/android/build/gradle/internal/tasks/NewIncrementalTask;", "<init>", "()V", "jacocoAntTaskConfiguration", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getJacocoAntTaskConfiguration", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "jarsWithIdentity", "Lcom/android/build/gradle/internal/tasks/JarsClasspathInputsWithIdentity;", "getJarsWithIdentity", "()Lcom/android/build/gradle/internal/tasks/JarsClasspathInputsWithIdentity;", "classesDir", "getClassesDir", "forceOutOfProcess", "Lorg/gradle/api/provider/Property;", "", "getForceOutOfProcess", "()Lorg/gradle/api/provider/Property;", "outputForDirs", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputForDirs", "()Lorg/gradle/api/file/DirectoryProperty;", "outputForJars", "getOutputForJars", "doTaskAction", "", "inputChanges", "Lorg/gradle/work/InputChanges;", "processDirectories", "processJars", "removeFile", "fileToRemove", "Lcom/android/builder/files/SerializableChange;", "workQueue", "Lorg/gradle/workers/WorkQueue;", "getWorkQueue", "()Lorg/gradle/workers/WorkQueue;", "Action", "InstrumentDirAction", "InstrumentJarAction", "CreationAction", "Companion", "gradle-core"})
public abstract class JacocoTask
extends NewIncrementalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Pattern CLASS_PATTERN = Pattern.compile(".*\\.class$");
    private static final Pattern ORG_JACOCO_PATTERN = Pattern.compile("^org/jacoco.*");
    private static final Pattern JUNIT_RUNLISTENER_PATTERN = Pattern.compile("^org/junit/runner/notification/RunListener.*");
    private static final Pattern R_CLASS_PATTERN = Pattern.compile(".+?/R\\$?.*?\\.class$");
    private static final Pattern MANIFEST_CLASS_PATTERN = Pattern.compile(".+?/Manifest\\$?.*?\\.class$");
    private static final Pattern BUILD_CONFIG_CLASS_PATTERN = Pattern.compile(".+?/BuildConfig.class$");
    private static final Pattern KOTLIN_MODULE_PATTERN = Pattern.compile("^META-INF/.*\\.kotlin_module$");

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getJacocoAntTaskConfiguration();

    @Nested
    @NotNull
    public abstract JarsClasspathInputsWithIdentity getJarsWithIdentity();

    @Classpath
    @Incremental
    @NotNull
    public abstract ConfigurableFileCollection getClassesDir();

    @Input
    @NotNull
    public abstract Property<Boolean> getForceOutOfProcess();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputForDirs();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputForJars();

    @Override
    public void doTaskAction(@NotNull InputChanges inputChanges) {
        Intrinsics.checkNotNullParameter((Object)inputChanges, (String)"inputChanges");
        this.processDirectories(inputChanges);
        this.processJars(inputChanges);
    }

    private final void processDirectories(InputChanges inputChanges) {
        Iterable iterable = inputChanges.getFileChanges((FileCollection)this.getClassesDir());
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getFileChanges(...)");
        SerializableFileChanges changes = IncrementalChangesUtils.toSerializable(iterable);
        Set filesToProcess = new HashSet(changes.getAddedFiles());
        for (SerializableChange removedFile : changes.getRemovedFiles()) {
            this.removeFile(removedFile);
        }
        for (Object modifiedFile : changes.getModifiedFiles()) {
            this.removeFile((SerializableChange)modifiedFile);
            filesToProcess.add(modifiedFile);
        }
        Map toProcess = new EnumMap(Action.class);
        for (SerializableChange change : filesToProcess) {
            Action action = Companion.calculateAction(change.getNormalizedPath());
            if (action == Action.IGNORE) continue;
            List byAction = toProcess.getOrDefault((Object)action, new ArrayList());
            byAction.add(change);
            toProcess.put(action, byAction);
        }
        WorkQueue workQueue2 = this.getWorkQueue();
        Function1 function1 = (Function1)new Function1<InstrumentDirAction.Parameters, Unit>((Map<Action, List<SerializableChange>>)toProcess, this){
            final /* synthetic */ Map<Action, List<SerializableChange>> $toProcess;
            final /* synthetic */ JacocoTask this$0;
            {
                this.$toProcess = $toProcess;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(InstrumentDirAction.Parameters params) {
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                params.getChangesToProcess().set(this.$toProcess);
                params.getOutput().set(this.this$0.getOutputForDirs().getAsFile());
            }
        };
        workQueue2.submit(InstrumentDirAction.class, new org.gradle.api.Action(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Object p0) {
                this.function.invoke(p0);
            }
        });
    }

    private final void processJars(InputChanges inputChanges) {
        JarsIdentityMapping mappingState = this.getJarsWithIdentity().getMappingState(inputChanges);
        if (mappingState.getReprocessAll()) {
            try {
                FileUtils.deleteDirectoryContents((File)((Directory)this.getOutputForJars().get()).getAsFile());
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        for (Map.Entry<File, FileInfo> entry2 : mappingState.getJarsInfo().entrySet()) {
            File key = entry2.getKey();
            FileInfo fileInfo = entry2.getValue();
            if (!fileInfo.getHasChanged()) continue;
            File file = ((Directory)this.getOutputForJars().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
            String string = Objects.requireNonNull(fileInfo.getIdentity());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"requireNonNull(...)");
            File instrumentedJar = JacocoTask.Companion.getCorrespondingInstrumentedJar(file, string);
            try {
                FileUtils.deleteIfExists((File)instrumentedJar);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            WorkQueue workQueue2 = this.getWorkQueue();
            Function1 function1 = (Function1)new Function1<InstrumentJarAction.Parameters, Unit>(key, instrumentedJar){
                final /* synthetic */ File $key;
                final /* synthetic */ File $instrumentedJar;
                {
                    this.$key = $key;
                    this.$instrumentedJar = $instrumentedJar;
                    super(1);
                }

                public final void invoke(InstrumentJarAction.Parameters params) {
                    Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                    params.getRoot().set((Object)this.$key);
                    params.getOutput().set((Object)this.$instrumentedJar);
                }
            };
            workQueue2.submit(InstrumentJarAction.class, new /* invalid duplicate definition of identical inner class */);
        }
    }

    private final void removeFile(SerializableChange fileToRemove) {
        Action action = Companion.calculateAction(fileToRemove.getNormalizedPath());
        if (action == Action.IGNORE) {
            return;
        }
        Path outputPath = ((Directory)this.getOutputForDirs().get()).getAsFile().toPath().resolve(fileToRemove.getNormalizedPath());
        try {
            PathUtils.deleteRecursivelyIfExists((Path)outputPath);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private final WorkQueue getWorkQueue() {
        WorkQueue workQueue2;
        if (((Boolean)this.getForceOutOfProcess().get()).booleanValue()) {
            Function1 function1 = (Function1)new Function1<ProcessWorkerSpec, Unit>(this){
                final /* synthetic */ JacocoTask this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(ProcessWorkerSpec spec) {
                    Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
                    Object[] objectArray = new Object[]{this.this$0.getJacocoAntTaskConfiguration()};
                    spec.getClasspath().from(objectArray);
                }
            };
            WorkQueue workQueue3 = this.getWorkerExecutor().processIsolation(new /* invalid duplicate definition of identical inner class */);
            Intrinsics.checkNotNull((Object)workQueue3);
            workQueue2 = workQueue3;
        } else {
            Function1 function1 = (Function1)new Function1<ClassLoaderWorkerSpec, Unit>(this){
                final /* synthetic */ JacocoTask this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(ClassLoaderWorkerSpec spec) {
                    Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
                    Object[] objectArray = new Object[]{this.this$0.getJacocoAntTaskConfiguration()};
                    spec.getClasspath().from(objectArray);
                }
            };
            WorkQueue workQueue4 = this.getWorkerExecutor().classLoaderIsolation(new /* invalid duplicate definition of identical inner class */);
            Intrinsics.checkNotNull((Object)workQueue4);
            workQueue2 = workQueue4;
        }
        return workQueue2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\b\u0002\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fj\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/tasks/JacocoTask$Action;", "", "patterns", "", "Ljava/util/regex/Pattern;", "<init>", "(Ljava/lang/String;I[Ljava/util/regex/Pattern;)V", "COPY", "IGNORE", "INSTRUMENT", "Lcom/google/common/collect/ImmutableList;", "getPatterns", "()Lcom/google/common/collect/ImmutableList;", "gradle-core"})
    public static final class Action
    extends Enum<Action> {
        @NotNull
        private final ImmutableList<Pattern> patterns;
        public static final /* enum */ Action COPY;
        public static final /* enum */ Action IGNORE;
        public static final /* enum */ Action INSTRUMENT;
        private static final /* synthetic */ Action[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Action(Pattern ... patterns) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (Pattern pattern : patterns) {
                Preconditions.checkNotNull((Object)pattern);
                builder.add((Object)pattern);
            }
            this.patterns = builder.build();
        }

        @NotNull
        public final ImmutableList<Pattern> getPatterns() {
            return this.patterns;
        }

        public static Action[] values() {
            return (Action[])$VALUES.clone();
        }

        public static Action valueOf(String value) {
            return Enum.valueOf(Action.class, value);
        }

        @NotNull
        public static EnumEntries<Action> getEntries() {
            return $ENTRIES;
        }

        static {
            Pattern[] patternArray = new Pattern[]{KOTLIN_MODULE_PATTERN, R_CLASS_PATTERN, MANIFEST_CLASS_PATTERN, BUILD_CONFIG_CLASS_PATTERN, ORG_JACOCO_PATTERN, JUNIT_RUNLISTENER_PATTERN};
            COPY = new Action(patternArray);
            IGNORE = new Action(new Pattern[0]);
            patternArray = new Pattern[]{CLASS_PATTERN};
            INSTRUMENT = new Action(patternArray);
            $VALUES = actionArray = new Action[]{Action.COPY, Action.IGNORE, Action.INSTRUMENT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0005H\u0002R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0018\u0010\f\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0018\u0010\r\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0018\u0010\u000e\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0018\u0010\u000f\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0018\u0010\u0010\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0018\u0010\u0011\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/android/build/gradle/internal/tasks/JacocoTask$Companion;", "", "<init>", "()V", "getJacocoVersion", "", "creationConfig", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "CLASS_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "ORG_JACOCO_PATTERN", "JUNIT_RUNLISTENER_PATTERN", "R_CLASS_PATTERN", "MANIFEST_CLASS_PATTERN", "BUILD_CONFIG_CLASS_PATTERN", "KOTLIN_MODULE_PATTERN", "calculateAction", "Lcom/android/build/gradle/internal/tasks/JacocoTask$Action;", "inputRelativePath", "getCorrespondingInstrumentedJar", "Ljava/io/File;", "outputFolder", "identity", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nJacocoTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JacocoTask.kt\ncom/android/build/gradle/internal/tasks/JacocoTask$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,391:1\n1755#2,3:392\n1755#2,3:395\n*S KotlinDebug\n*F\n+ 1 JacocoTask.kt\ncom/android/build/gradle/internal/tasks/JacocoTask$Companion\n*L\n376#1:392,3\n377#1:395,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getJacocoVersion(@NotNull ComponentCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            return creationConfig.getGlobal().getTestCoverage().getJacocoVersion();
        }

        @NotNull
        public final Action calculateAction(@NotNull String inputRelativePath) {
            Action action;
            Pattern it;
            boolean bl;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block8: {
                Intrinsics.checkNotNullParameter((Object)inputRelativePath, (String)"inputRelativePath");
                $this$any$iv = (Iterable)Action.COPY.getPatterns();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (Pattern)element$iv;
                        boolean bl2 = false;
                        if (!it.matcher(inputRelativePath).matches()) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                action = Action.COPY;
            } else {
                boolean bl3;
                block9: {
                    $this$any$iv = (Iterable)Action.INSTRUMENT.getPatterns();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (Pattern)element$iv;
                            boolean bl4 = false;
                            if (!it.matcher(inputRelativePath).matches()) continue;
                            bl3 = true;
                            break block9;
                        }
                        bl3 = false;
                    }
                }
                action = bl3 ? Action.INSTRUMENT : Action.IGNORE;
            }
            return action;
        }

        private final File getCorrespondingInstrumentedJar(File outputFolder, String identity) {
            return new File(outputFolder, identity + ".jar");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/tasks/JacocoTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/JacocoTask;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "creationConfig", "<init>", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<JacocoTask, ComponentCreationConfig> {
        public CreationAction(@NotNull ComponentCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig, false, 2, null);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("jacoco");
        }

        @Override
        @NotNull
        public Class<JacocoTask> getType() {
            return JacocoTask.class;
        }

        @Override
        public void configure(@NotNull JacocoTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            Object[] objectArray = new Object[]{JacocoConfigurations.getJacocoAntTaskConfiguration(task.getProject(), Companion.getJacocoVersion(this.creationConfig))};
            task.getJacocoAntTaskConfiguration().from(objectArray);
            task.getForceOutOfProcess().set((Object)this.creationConfig.getServices().getProjectOptions().get(BooleanOption.FORCE_JACOCO_OUT_OF_PROCESS));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0007\bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/tasks/JacocoTask$InstrumentDirAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/android/build/gradle/internal/tasks/JacocoTask$InstrumentDirAction$Parameters;", "<init>", "()V", "execute", "", "Parameters", "Companion", "gradle-core"})
    public static abstract class InstrumentDirAction
    implements WorkAction<Parameters> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final LoggerWrapper logger;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            WorkParameters workParameters = this.getParameters();
            Intrinsics.checkNotNull((Object)workParameters);
            Map inputs = (Map)((Parameters)workParameters).getChangesToProcess().get();
            WorkParameters workParameters2 = this.getParameters();
            Intrinsics.checkNotNull((Object)workParameters2);
            File outputDir = (File)((Parameters)workParameters2).getOutput().get();
            Instrumenter instrumenter = new Instrumenter((IExecutionDataAccessorGenerator)new OfflineInstrumentationAccessGenerator());
            for (SerializableChange toInstrument : (List)inputs.getOrDefault((Object)Action.INSTRUMENT, ImmutableList.of())) {
                logger.info("Instrumenting file: " + toInstrument.getFile().getAbsolutePath(), new Object[0]);
                try {
                    Closeable closeable = Files.asByteSource((File)toInstrument.getFile()).openBufferedStream();
                    Throwable throwable = null;
                    try {
                        InputStream inputStream = (InputStream)closeable;
                        boolean bl = false;
                        byte[] instrumented = instrumenter.instrument(inputStream, toInstrument.toString());
                        File outputFile = new File(outputDir, toInstrument.getNormalizedPath());
                        Files.createParentDirs((File)outputFile);
                        Files.write((byte[])instrumented, (File)outputFile);
                        inputStream = Unit.INSTANCE;
                    }
                    catch (Throwable inputStream) {
                        throwable = inputStream;
                        throw inputStream;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to instrument file with Jacoco: " + toInstrument.getFile(), e);
                }
            }
            for (SerializableChange serializableChange : (List)inputs.getOrDefault((Object)Action.COPY, ImmutableList.of())) {
                File file = serializableChange.component1();
                String normalizedPath = serializableChange.component3();
                File outputFile = new File(outputDir, normalizedPath);
                try {
                    Files.createParentDirs((File)outputFile);
                    Files.copy((File)file, (File)outputFile);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to copy file: " + file, e);
                }
            }
        }

        static {
            LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(InstrumentDirAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)loggerWrapper, (String)"getLogger(...)");
            logger = loggerWrapper;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/tasks/JacocoTask$InstrumentDirAction$Companion;", "", "<init>", "()V", "logger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "gradle-core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/tasks/JacocoTask$InstrumentDirAction$Parameters;", "Lorg/gradle/workers/WorkParameters;", "<init>", "()V", "changesToProcess", "Lorg/gradle/api/provider/MapProperty;", "Lcom/android/build/gradle/internal/tasks/JacocoTask$Action;", "", "Lcom/android/builder/files/SerializableChange;", "getChangesToProcess", "()Lorg/gradle/api/provider/MapProperty;", "output", "Lorg/gradle/api/provider/Property;", "Ljava/io/File;", "getOutput", "()Lorg/gradle/api/provider/Property;", "gradle-core"})
        public static abstract class Parameters
        implements WorkParameters {
            @NotNull
            public abstract MapProperty<Action, List<SerializableChange>> getChangesToProcess();

            @NotNull
            public abstract Property<File> getOutput();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0007\bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/tasks/JacocoTask$InstrumentJarAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/android/build/gradle/internal/tasks/JacocoTask$InstrumentJarAction$Parameters;", "<init>", "()V", "execute", "", "Parameters", "Companion", "gradle-core"})
    public static abstract class InstrumentJarAction
    implements WorkAction<Parameters> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final LoggerWrapper logger;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            File inputJar;
            File file = inputJar = (File)((Parameters)this.getParameters()).getRoot().get();
            logger.info("Instrumenting jar: " + (file != null ? file.getAbsolutePath() : null), new Object[0]);
            File instrumentedJar = (File)((Parameters)this.getParameters()).getOutput().get();
            Instrumenter instrumenter = new Instrumenter((IExecutionDataAccessorGenerator)new OfflineInstrumentationAccessGenerator());
            try {
                Closeable closeable = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(instrumentedJar)));
                Throwable throwable = null;
                try {
                    ZipOutputStream outputZip = (ZipOutputStream)closeable;
                    boolean bl = false;
                    Closeable closeable2 = new ZipFile(inputJar);
                    Throwable throwable2 = null;
                    try {
                        ZipFile zipFile = (ZipFile)closeable2;
                        boolean bl2 = false;
                        Enumeration<? extends ZipEntry> entries2 = zipFile.entries();
                        while (entries2.hasMoreElements()) {
                            ZipEntry entry2 = entries2.nextElement();
                            String entryName = entry2.getName();
                            Intrinsics.checkNotNull((Object)entryName);
                            Action entryAction = Companion.calculateAction(entryName);
                            if (entryAction == Action.IGNORE) continue;
                            InputStream classInputStream = zipFile.getInputStream(entry2);
                            byte[] data = null;
                            data = entryAction == Action.INSTRUMENT ? instrumenter.instrument(classInputStream, entryName) : ByteStreams.toByteArray((InputStream)classInputStream);
                            ZipEntry nextEntry = new ZipEntry(entryName);
                            nextEntry.setTime(-1L);
                            outputZip.putNextEntry(nextEntry);
                            outputZip.write(data);
                            outputZip.closeEntry();
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to instrument file with Jacoco: " + inputJar, e);
            }
        }

        static {
            LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(InstrumentJarAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)loggerWrapper, (String)"getLogger(...)");
            logger = loggerWrapper;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/tasks/JacocoTask$InstrumentJarAction$Companion;", "", "<init>", "()V", "logger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "gradle-core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/tasks/JacocoTask$InstrumentJarAction$Parameters;", "Lorg/gradle/workers/WorkParameters;", "<init>", "()V", "root", "Lorg/gradle/api/provider/Property;", "Ljava/io/File;", "getRoot", "()Lorg/gradle/api/provider/Property;", "output", "getOutput", "gradle-core"})
        public static abstract class Parameters
        implements WorkParameters {
            @NotNull
            public abstract Property<File> getRoot();

            @NotNull
            public abstract Property<File> getOutput();
        }
    }
}

