/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.SdkConstants;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.services.DslServices;
import com.android.build.gradle.internal.signing.SigningConfigData;
import com.android.build.gradle.internal.signing.SigningConfigVersions;
import com.android.build.gradle.internal.tasks.SigningConfigUtils;
import com.android.build.gradle.options.SigningOptions;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/android/build/gradle/internal/tasks/SigningConfigUtils;", "", "<init>", "()V", "Companion", "gradle-core"})
public final class SigningConfigUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<Gson> gson$delegate = LazyKt.lazy((Function0)Companion.gson.2.INSTANCE);

    @JvmStatic
    @NotNull
    public static final SigningConfigVersions loadSigningConfigVersions(@NotNull File input) {
        return Companion.loadSigningConfigVersions(input);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0007H\u0007J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/tasks/SigningConfigUtils$Companion;", "", "<init>", "()V", "saveSigningConfigData", "", "outputFile", "Ljava/io/File;", "signingConfigData", "Lcom/android/build/gradle/internal/signing/SigningConfigData;", "saveSigningConfigVersions", "signingConfigVersions", "Lcom/android/build/gradle/internal/signing/SigningConfigVersions;", "loadSigningConfigData", "input", "loadSigningConfigVersions", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "gson$delegate", "Lkotlin/Lazy;", "createSigningOverride", "Lcom/android/build/gradle/internal/dsl/SigningConfig;", "dslServices", "Lcom/android/build/gradle/internal/services/DslServices;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public final void saveSigningConfigData(@NotNull File outputFile, @Nullable SigningConfigData signingConfigData) {
            Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
            outputFile.createNewFile();
            if (SdkConstants.CURRENT_PLATFORM != 2) {
                HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
                perms.add(PosixFilePermission.OWNER_READ);
                perms.add(PosixFilePermission.OWNER_WRITE);
                Files.setPosixFilePermissions(outputFile.toPath(), (Set<PosixFilePermission>)perms);
            } else {
                AclFileAttributeView view = Files.getFileAttributeView(outputFile.toPath(), AclFileAttributeView.class, new LinkOption[0]);
                AclEntryPermission[] aclEntryPermissionArray = new AclEntryPermission[]{AclEntryPermission.READ_ACL, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.READ_DATA, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.WRITE_ACL, AclEntryPermission.WRITE_DATA, AclEntryPermission.APPEND_DATA, AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.WRITE_OWNER, AclEntryPermission.SYNCHRONIZE, AclEntryPermission.DELETE};
                AclEntry entry2 = AclEntry.newBuilder().setType(AclEntryType.ALLOW).setPrincipal(view.getOwner()).setPermissions(aclEntryPermissionArray).build();
                view.setAcl(CollectionsKt.listOf((Object)entry2));
            }
            FileUtils.write((File)outputFile, (CharSequence)this.getGson().toJson((Object)signingConfigData), (Charset)StandardCharsets.UTF_8);
        }

        public final void saveSigningConfigVersions(@NotNull File outputFile, @NotNull SigningConfigVersions signingConfigVersions) {
            Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
            Intrinsics.checkNotNullParameter((Object)signingConfigVersions, (String)"signingConfigVersions");
            FileUtils.write((File)outputFile, (CharSequence)this.getGson().toJson((Object)signingConfigVersions), (Charset)StandardCharsets.UTF_8);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final SigningConfigData loadSigningConfigData(@NotNull File input) {
            SigningConfigData signingConfigData;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Object object = input;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Object object2 = charset;
            int n = 8192;
            Object object3 = object;
            object3 = new InputStreamReader((InputStream)new FileInputStream((File)object3), (Charset)object2);
            object = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
            object2 = null;
            try {
                BufferedReader reader = (BufferedReader)object;
                boolean bl = false;
                signingConfigData = (SigningConfigData)Companion.getGson().fromJson((Reader)reader, SigningConfigData.class);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            return signingConfigData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final SigningConfigVersions loadSigningConfigVersions(@NotNull File input) {
            SigningConfigVersions signingConfigVersions;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Object object = input;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Object object2 = charset;
            int n = 8192;
            Object object3 = object;
            object3 = new InputStreamReader((InputStream)new FileInputStream((File)object3), (Charset)object2);
            object = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
            object2 = null;
            try {
                BufferedReader reader = (BufferedReader)object;
                boolean bl = false;
                SigningConfigVersions signingConfigVersions2 = (SigningConfigVersions)Companion.getGson().fromJson((Reader)reader, SigningConfigVersions.class);
                signingConfigVersions = signingConfigVersions2;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            Intrinsics.checkNotNullExpressionValue((Object)signingConfigVersions, (String)"use(...)");
            return signingConfigVersions;
        }

        private final Gson getGson() {
            Lazy lazy = gson$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (Gson)object;
        }

        @Nullable
        public final SigningConfig createSigningOverride(@NotNull DslServices dslServices2) {
            Intrinsics.checkNotNullParameter((Object)dslServices2, (String)"dslServices");
            SigningOptions signingOptions = SigningOptions.readSigningOptions(dslServices2.getProjectOptions());
            if (signingOptions != null) {
                SigningOptions signingOptions2 = signingOptions;
                boolean bl = false;
                Object[] objectArray = new Object[]{"externalOverride", dslServices2};
                SigningConfig signingConfigDsl = dslServices2.newDecoratedInstance(SigningConfig.class, objectArray);
                signingConfigDsl.storeFile(new File(signingOptions2.getStoreFile()));
                signingConfigDsl.storePassword(signingOptions2.getStorePassword());
                signingConfigDsl.keyAlias(signingOptions2.getKeyAlias());
                signingConfigDsl.keyPassword(signingOptions2.getKeyPassword());
                String string = signingOptions2.getStoreType();
                if (string != null) {
                    String it = string;
                    boolean bl2 = false;
                    signingConfigDsl.storeType(it);
                }
                Boolean bl3 = signingOptions2.getV1Enabled();
                if (bl3 != null) {
                    boolean it = bl3;
                    boolean bl4 = false;
                    signingConfigDsl.setEnableV1Signing(it);
                }
                Boolean bl5 = signingOptions2.getV2Enabled();
                if (bl5 != null) {
                    boolean it = bl5;
                    boolean bl6 = false;
                    signingConfigDsl.setEnableV2Signing(it);
                }
                return signingConfigDsl;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

