/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing.utp;

import com.android.build.gradle.internal.testing.utp.GradleAndroidTestResultListenerService;
import com.android.build.gradle.internal.testing.utp.UtpTestResultListener;
import com.google.common.annotations.VisibleForTesting;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyServerBuilder;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/testing/utp/UtpTestResultListenerServer;", "Ljava/io/Closeable;", "port", "", "listener", "Lcom/android/build/gradle/internal/testing/utp/UtpTestResultListener;", "serverFactory", "Lkotlin/Function1;", "Lio/grpc/ServerBuilder;", "<init>", "(ILcom/android/build/gradle/internal/testing/utp/UtpTestResultListener;Lkotlin/jvm/functions/Function1;)V", "getPort", "()I", "server", "Lio/grpc/Server;", "getServer$annotations", "()V", "getServer", "()Lio/grpc/Server;", "close", "", "Companion", "gradle-core"})
public final class UtpTestResultListenerServer
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int port;
    @NotNull
    private final Server server;
    private static final Logger logger = Logging.getLogger(UtpTestResultListenerServer.class);
    private static final int DEFAULT_GRPC_SERVER_PORT = 9624;
    private static final int DEFAULT_MAX_RETRY_ATTEMPT = 10;

    private UtpTestResultListenerServer(int port, UtpTestResultListener listener, Function1<? super Integer, ? extends ServerBuilder<?>> serverFactory) {
        this.port = port;
        Server server = ((ServerBuilder)serverFactory.invoke((Object)this.port)).addService((BindableService)new GradleAndroidTestResultListenerService(listener)).build().start();
        Intrinsics.checkNotNullExpressionValue((Object)server, (String)"start(...)");
        this.server = server;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final Server getServer() {
        return this.server;
    }

    @VisibleForTesting
    public static /* synthetic */ void getServer$annotations() {
    }

    @Override
    public void close() {
        this.server.shutdownNow().awaitTermination();
    }

    public /* synthetic */ UtpTestResultListenerServer(int port, UtpTestResultListener listener, Function1 serverFactory, DefaultConstructorMarker $constructor_marker) {
        this(port, listener, serverFactory);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JX\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0013\u001a\u00020\t2\b\b\u0002\u0010\u0014\u001a\u00020\t2\u0018\b\u0002\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016J,\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\tH\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/testing/utp/UtpTestResultListenerServer$Companion;", "", "<init>", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "Lorg/gradle/api/logging/Logger;", "DEFAULT_GRPC_SERVER_PORT", "", "DEFAULT_MAX_RETRY_ATTEMPT", "startServer", "Lcom/android/build/gradle/internal/testing/utp/UtpTestResultListenerServer;", "certChainFile", "Ljava/io/File;", "privateKeyFile", "trustCertCollectionFile", "listener", "Lcom/android/build/gradle/internal/testing/utp/UtpTestResultListener;", "defaultPort", "maxRetryAttempt", "serverFactory", "Lkotlin/Function1;", "Lio/grpc/ServerBuilder;", "createServerBuilder", "port", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final UtpTestResultListenerServer startServer(@NotNull File certChainFile, @NotNull File privateKeyFile, @NotNull File trustCertCollectionFile, @Nullable UtpTestResultListener listener, int defaultPort, int maxRetryAttempt, @NotNull Function1<? super Integer, ? extends ServerBuilder<?>> serverFactory) {
            Intrinsics.checkNotNullParameter((Object)certChainFile, (String)"certChainFile");
            Intrinsics.checkNotNullParameter((Object)privateKeyFile, (String)"privateKeyFile");
            Intrinsics.checkNotNullParameter((Object)trustCertCollectionFile, (String)"trustCertCollectionFile");
            Intrinsics.checkNotNullParameter(serverFactory, (String)"serverFactory");
            for (int attempt = 0; attempt < maxRetryAttempt; ++attempt) {
                int port = defaultPort + attempt;
                try {
                    return new UtpTestResultListenerServer(port, listener, serverFactory, null);
                }
                catch (IOException exception) {
                    logger.info("Failed to bind and start the gRPC server. Retrying with a different port number.");
                    continue;
                }
            }
            logger.error("Unable to start the gRPC server.");
            return null;
        }

        public static /* synthetic */ UtpTestResultListenerServer startServer$default(Companion companion, File file, File file2, File file3, UtpTestResultListener utpTestResultListener, int n, int n2, Function1 function1, int n3, Object object) {
            if ((n3 & 0x10) != 0) {
                n = 9624;
            }
            if ((n3 & 0x20) != 0) {
                n2 = 10;
            }
            if ((n3 & 0x40) != 0) {
                function1 = new Function1<Integer, ServerBuilder<?>>(file, file2, file3){
                    final /* synthetic */ File $certChainFile;
                    final /* synthetic */ File $privateKeyFile;
                    final /* synthetic */ File $trustCertCollectionFile;
                    {
                        this.$certChainFile = $certChainFile;
                        this.$privateKeyFile = $privateKeyFile;
                        this.$trustCertCollectionFile = $trustCertCollectionFile;
                        super(1);
                    }

                    public final ServerBuilder<?> invoke(int port) {
                        return com.android.build.gradle.internal.testing.utp.UtpTestResultListenerServer$Companion.access$createServerBuilder(UtpTestResultListenerServer.Companion, this.$certChainFile, this.$privateKeyFile, this.$trustCertCollectionFile, port);
                    }
                };
            }
            return companion.startServer(file, file2, file3, utpTestResultListener, n, n2, function1);
        }

        private final ServerBuilder<?> createServerBuilder(File certChainFile, File privateKeyFile, File trustCertCollectionFile, int port) {
            SslContextBuilder sslContextBuilder;
            SslContextBuilder $this$createServerBuilder_u24lambda_u240 = sslContextBuilder = SslContextBuilder.forServer((File)certChainFile, (File)privateKeyFile);
            boolean bl = false;
            $this$createServerBuilder_u24lambda_u240.trustManager(trustCertCollectionFile);
            $this$createServerBuilder_u24lambda_u240.clientAuth(ClientAuth.REQUIRE);
            GrpcSslContexts.configure((SslContextBuilder)$this$createServerBuilder_u24lambda_u240);
            SslContext sslContext = sslContextBuilder.build();
            NettyServerBuilder nettyServerBuilder = NettyServerBuilder.forPort((int)port).sslContext(sslContext);
            Intrinsics.checkNotNullExpressionValue((Object)nettyServerBuilder, (String)"sslContext(...)");
            return (ServerBuilder)nettyServerBuilder;
        }

        public static final /* synthetic */ ServerBuilder access$createServerBuilder(Companion $this, File certChainFile, File privateKeyFile, File trustCertCollectionFile, int port) {
            return $this.createServerBuilder(certChainFile, privateKeyFile, trustCertCollectionFile, port);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

