/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.ManagedVirtualDeviceLockManager;
import com.android.builder.utils.ExceptionConsumer;
import com.android.builder.utils.ExceptionFunction;
import com.android.builder.utils.SynchronizedFile;
import com.android.prefs.AndroidLocationsProvider;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002*+B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ/\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u00052\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u0002H\u00180\u001b\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0005H\u0002J\u0006\u0010#\u001a\u00020\tJ\u0010\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010(\u001a\u00020\t2\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/android/build/gradle/internal/ManagedVirtualDeviceLockManager;", "", "androidLocationsProvider", "Lcom/android/prefs/AndroidLocationsProvider;", "maxGMDs", "", "deviceLockWaitTimeoutSeconds", "retryWaitAction", "Lkotlin/Function0;", "", "<init>", "(Lcom/android/prefs/AndroidLocationsProvider;IILkotlin/jvm/functions/Function0;)V", "trackingFile", "Lcom/android/builder/utils/SynchronizedFile;", "trackedDevicesInProcess", "Ljava/util/concurrent/atomic/AtomicInteger;", "devicesInProcess", "getDevicesInProcess$annotations", "()V", "getDevicesInProcess", "()I", "logger", "Lorg/gradle/api/logging/Logger;", "lockAndExecute", "T", "lockCount", "onLockAcquired", "Lkotlin/Function1;", "Lcom/android/build/gradle/internal/ManagedVirtualDeviceLockManager$DeviceLock;", "(ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "releaseLocks", "locksToRelease", "tryToAcquireLocks", "Lcom/android/build/gradle/internal/ManagedVirtualDeviceLockManager$AcquireLocksResult;", "locksRequested", "deleteLockFile", "createDefaultLockFile", "file", "Ljava/io/File;", "getCurrentLockCount", "writeLockCount", "newLockCount", "AcquireLocksResult", "DeviceLock", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nManagedVirtualDeviceLockManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManagedVirtualDeviceLockManager.kt\ncom/android/build/gradle/internal/ManagedVirtualDeviceLockManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,277:1\n1869#2,2:278\n*S KotlinDebug\n*F\n+ 1 ManagedVirtualDeviceLockManager.kt\ncom/android/build/gradle/internal/ManagedVirtualDeviceLockManager\n*L\n265#1:278,2\n*E\n"})
public final class ManagedVirtualDeviceLockManager {
    private final int maxGMDs;
    private final int deviceLockWaitTimeoutSeconds;
    @NotNull
    private final Function0<Unit> retryWaitAction;
    @NotNull
    private final SynchronizedFile trackingFile;
    @NotNull
    private final AtomicInteger trackedDevicesInProcess;
    @NotNull
    private final Logger logger;

    public ManagedVirtualDeviceLockManager(@NotNull AndroidLocationsProvider androidLocationsProvider, int maxGMDs, int deviceLockWaitTimeoutSeconds, @NotNull Function0<Unit> retryWaitAction) {
        Intrinsics.checkNotNullParameter((Object)androidLocationsProvider, (String)"androidLocationsProvider");
        Intrinsics.checkNotNullParameter(retryWaitAction, (String)"retryWaitAction");
        this.maxGMDs = maxGMDs;
        this.deviceLockWaitTimeoutSeconds = deviceLockWaitTimeoutSeconds;
        this.retryWaitAction = retryWaitAction;
        File file = androidLocationsProvider.getGradleAvdLocation().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        File lockFile = FilesKt.resolve((File)file, (String)"active_gradle_devices");
        if (!lockFile.getParentFile().exists()) {
            lockFile.getParentFile().mkdirs();
        }
        this.trackedDevicesInProcess = new AtomicInteger();
        SynchronizedFile synchronizedFile = SynchronizedFile.getInstanceWithMultiProcessLocking((File)lockFile);
        Intrinsics.checkNotNullExpressionValue((Object)synchronizedFile, (String)"getInstanceWithMultiProcessLocking(...)");
        this.trackingFile = synchronizedFile;
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public final void run() {
                this.releaseLocks(trackedDevicesInProcess.get());
            }
        }));
        Logger logger = Logging.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    public /* synthetic */ ManagedVirtualDeviceLockManager(AndroidLocationsProvider androidLocationsProvider, int n, int n2, Function0 function0, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            function0 = 1.INSTANCE;
        }
        this(androidLocationsProvider, n, n2, (Function0<Unit>)function0);
    }

    public final int getDevicesInProcess() {
        return this.trackedDevicesInProcess.get();
    }

    @VisibleForTesting
    public static /* synthetic */ void getDevicesInProcess$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T lockAndExecute(int lockCount, @NotNull Function1<? super DeviceLock, ? extends T> onLockAcquired) {
        Intrinsics.checkNotNullParameter(onLockAcquired, (String)"onLockAcquired");
        long startSystemTime = System.currentTimeMillis();
        AcquireLocksResult locksAcquired = new AcquireLocksResult(0, 0);
        while ((locksAcquired = this.tryToAcquireLocks(lockCount)).getLocksToClaim() == 0) {
            if (this.deviceLockWaitTimeoutSeconds > 0 && System.currentTimeMillis() - startSystemTime > (long)(this.deviceLockWaitTimeoutSeconds * 1000)) {
                throw new TimeoutException(StringsKt.trimIndent((String)("\n                    Could not acquire device lock after waiting for " + this.deviceLockWaitTimeoutSeconds + " seconds.\n                    The limit of " + this.maxGMDs + " concurrent devices has been reached (" + locksAcquired.getCurrentTotalDevicesCount() + " are active).\n\n                    If this seems incorrect, you may have a stale lock file.\n                    Run the `./gradlew cleanManagedDevices` task to resolve the issue.\n                    ")));
            }
            this.retryWaitAction.invoke();
        }
        try {
            Object object = onLockAcquired.invoke((Object)new DeviceLock(locksAcquired.getLocksToClaim()));
            return (T)object;
        }
        finally {
            this.releaseLocks(locksAcquired.getLocksToClaim());
        }
    }

    public static /* synthetic */ Object lockAndExecute$default(ManagedVirtualDeviceLockManager managedVirtualDeviceLockManager, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return managedVirtualDeviceLockManager.lockAndExecute(n, function1);
    }

    private final void releaseLocks(int locksToRelease) {
        if (locksToRelease <= 0) {
            if (locksToRelease < 0) {
                this.logger.log(LogLevel.WARN, StringsKt.trimIndent((String)("\n                        Attempting to free a negative number of locks.\n                        Locks to release: " + locksToRelease + "\n                    ")));
            }
            return;
        }
        this.trackingFile.write(new ExceptionFunction(this, locksToRelease){
            final /* synthetic */ ManagedVirtualDeviceLockManager this$0;
            final /* synthetic */ int $locksToRelease;
            {
                this.this$0 = $receiver;
                this.$locksToRelease = $locksToRelease;
            }

            public final void accept(File file) {
                int n;
                Intrinsics.checkNotNull((Object)file);
                int currentTotalDeviceCount = ManagedVirtualDeviceLockManager.access$getCurrentLockCount(this.this$0, file);
                if (this.this$0.getDevicesInProcess() < this.$locksToRelease) {
                    ManagedVirtualDeviceLockManager.access$getLogger$p(this.this$0).log(LogLevel.WARN, StringsKt.trimIndent((String)("\n                        Attempting to free more locks than have been claimed by this lock manager.\n                        Locks to release: " + this.$locksToRelease + " Locks available In Process: " + this.this$0.getDevicesInProcess() + "\n                    ")));
                    n = currentTotalDeviceCount - ManagedVirtualDeviceLockManager.access$getTrackedDevicesInProcess$p(this.this$0).getAndSet(0);
                } else {
                    ManagedVirtualDeviceLockManager.access$getTrackedDevicesInProcess$p(this.this$0).addAndGet(-this.$locksToRelease);
                    n = currentTotalDeviceCount - this.$locksToRelease;
                }
                int newTotalDevicesCount = n;
                ManagedVirtualDeviceLockManager.access$writeLockCount(this.this$0, file, newTotalDevicesCount);
            }
        });
    }

    private final AcquireLocksResult tryToAcquireLocks(int locksRequested) {
        this.trackingFile.createIfAbsent(new ExceptionConsumer(this){
            final /* synthetic */ ManagedVirtualDeviceLockManager this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(File file) {
                Intrinsics.checkNotNull((Object)file);
                ManagedVirtualDeviceLockManager.access$createDefaultLockFile(this.this$0, file);
            }
        });
        Object object = this.trackingFile.write(new ExceptionFunction(this, locksRequested){
            final /* synthetic */ ManagedVirtualDeviceLockManager this$0;
            final /* synthetic */ int $locksRequested;
            {
                this.this$0 = $receiver;
                this.$locksRequested = $locksRequested;
            }

            public final AcquireLocksResult accept(File file) {
                Intrinsics.checkNotNull((Object)file);
                int currentTotalDevicesCount = ManagedVirtualDeviceLockManager.access$getCurrentLockCount(this.this$0, file);
                int locksToClaim = Math.max(Math.min(this.$locksRequested, ManagedVirtualDeviceLockManager.access$getMaxGMDs$p(this.this$0) - currentTotalDevicesCount), 0);
                if (locksToClaim != 0) {
                    ManagedVirtualDeviceLockManager.access$writeLockCount(this.this$0, file, currentTotalDevicesCount + locksToClaim);
                    ManagedVirtualDeviceLockManager.access$getTrackedDevicesInProcess$p(this.this$0).addAndGet(locksToClaim);
                }
                return new AcquireLocksResult(locksToClaim, currentTotalDevicesCount);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"write(...)");
        return (AcquireLocksResult)object;
    }

    public final void deleteLockFile() {
        this.trackingFile.write((ExceptionFunction)deleteLockFile.1.INSTANCE);
    }

    private final void createDefaultLockFile(File file) {
        this.logger.info("Creating default GMD lock tracking file at " + file.getAbsolutePath());
        FilesKt.writeText$default((File)file, (String)"MDLockCount 0", null, (int)2, null);
    }

    private final int getCurrentLockCount(File file) {
        if (file.exists()) {
            for (String line : FilesKt.readLines$default((File)file, null, (int)1, null)) {
                if (!StringsKt.startsWith$default((String)line, (String)"MDLockCount", (boolean)false, (int)2, null)) continue;
                String string = line.substring(11);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return Integer.parseInt(((Object)StringsKt.trim((CharSequence)string)).toString());
            }
            this.logger.error(" Failed to find MDLockCount in gmd lock file. File Contents:\n " + FilesKt.readLines$default((File)file, null, (int)1, null));
            this.writeLockCount(file, 0);
            throw new IllegalStateException("Failed to find the number of active Gradle Managed Devices.".toString());
        }
        return 0;
    }

    private final void writeLockCount(File file, int newLockCount) {
        List lines = FilesKt.readLines$default((File)file, null, (int)1, null);
        FilesKt.writeText$default((File)file, (String)"", null, (int)2, null);
        FilesKt.appendText$default((File)file, (String)("MDLockCount " + newLockCount), null, (int)2, null);
        Iterable $this$forEach$iv = lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)line, (String)"MDLockCount", (boolean)false, (int)2, null)) continue;
            FilesKt.appendText$default((File)file, (String)("\n" + line), null, (int)2, null);
        }
    }

    public static final /* synthetic */ int access$getCurrentLockCount(ManagedVirtualDeviceLockManager $this, File file) {
        return $this.getCurrentLockCount(file);
    }

    public static final /* synthetic */ Logger access$getLogger$p(ManagedVirtualDeviceLockManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$writeLockCount(ManagedVirtualDeviceLockManager $this, File file, int newLockCount) {
        $this.writeLockCount(file, newLockCount);
    }

    public static final /* synthetic */ void access$createDefaultLockFile(ManagedVirtualDeviceLockManager $this, File file) {
        $this.createDefaultLockFile(file);
    }

    public static final /* synthetic */ int access$getMaxGMDs$p(ManagedVirtualDeviceLockManager $this) {
        return $this.maxGMDs;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/internal/ManagedVirtualDeviceLockManager$AcquireLocksResult;", "", "locksToClaim", "", "currentTotalDevicesCount", "<init>", "(II)V", "getLocksToClaim", "()I", "getCurrentTotalDevicesCount", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "gradle-core"})
    private static final class AcquireLocksResult {
        private final int locksToClaim;
        private final int currentTotalDevicesCount;

        public AcquireLocksResult(int locksToClaim, int currentTotalDevicesCount) {
            this.locksToClaim = locksToClaim;
            this.currentTotalDevicesCount = currentTotalDevicesCount;
        }

        public final int getLocksToClaim() {
            return this.locksToClaim;
        }

        public final int getCurrentTotalDevicesCount() {
            return this.currentTotalDevicesCount;
        }

        public final int component1() {
            return this.locksToClaim;
        }

        public final int component2() {
            return this.currentTotalDevicesCount;
        }

        @NotNull
        public final AcquireLocksResult copy(int locksToClaim, int currentTotalDevicesCount) {
            return new AcquireLocksResult(locksToClaim, currentTotalDevicesCount);
        }

        public static /* synthetic */ AcquireLocksResult copy$default(AcquireLocksResult acquireLocksResult, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = acquireLocksResult.locksToClaim;
            }
            if ((n3 & 2) != 0) {
                n2 = acquireLocksResult.currentTotalDevicesCount;
            }
            return acquireLocksResult.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "AcquireLocksResult(locksToClaim=" + this.locksToClaim + ", currentTotalDevicesCount=" + this.currentTotalDevicesCount + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.locksToClaim);
            result2 = result2 * 31 + Integer.hashCode(this.currentTotalDevicesCount);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AcquireLocksResult)) {
                return false;
            }
            AcquireLocksResult acquireLocksResult = (AcquireLocksResult)other;
            if (this.locksToClaim != acquireLocksResult.locksToClaim) {
                return false;
            }
            return this.currentTotalDevicesCount == acquireLocksResult.currentTotalDevicesCount;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/ManagedVirtualDeviceLockManager$DeviceLock;", "", "lockCount", "", "<init>", "(I)V", "getLockCount", "()I", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "gradle-core"})
    public static final class DeviceLock {
        private final int lockCount;

        public DeviceLock(int lockCount) {
            this.lockCount = lockCount;
        }

        public final int getLockCount() {
            return this.lockCount;
        }

        public final int component1() {
            return this.lockCount;
        }

        @NotNull
        public final DeviceLock copy(int lockCount) {
            return new DeviceLock(lockCount);
        }

        public static /* synthetic */ DeviceLock copy$default(DeviceLock deviceLock, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = deviceLock.lockCount;
            }
            return deviceLock.copy(n);
        }

        @NotNull
        public String toString() {
            return "DeviceLock(lockCount=" + this.lockCount + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.lockCount);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeviceLock)) {
                return false;
            }
            DeviceLock deviceLock = (DeviceLock)other;
            return this.lockCount == deviceLock.lockCount;
        }
    }
}

