/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.logging;

import com.android.build.gradle.internal.cxx.logging.LoggingEnvironment;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.LoggingMessage;
import com.android.build.gradle.internal.cxx.logging.LoggingMessageKt;
import com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment;
import com.android.build.gradle.internal.cxx.string.StringEncoder;
import com.android.utils.ILogger;
import com.android.utils.cxx.CxxBugDiagnosticCode;
import com.android.utils.cxx.CxxDiagnosticCode;
import com.google.protobuf.GeneratedMessageV3;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment;", "Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "<init>", "()V", "close", "", "Companion", "gradle-core"})
public abstract class ThreadLoggingEnvironment
implements LoggingEnvironment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ThreadLocal<Companion.LoggerStack> loggerStack;
    @NotNull
    private static final Companion.BottomLoggingEnvironment BOTTOM_LOGGING_ENVIRONMENT;

    public ThreadLoggingEnvironment() {
        ThreadLoggingEnvironment.Companion.push(this);
    }

    @Override
    public void close() {
        ThreadLoggingEnvironment.Companion.pop();
    }

    @Override
    public void logStructured(@NotNull Function1<? super StringEncoder, ? extends GeneratedMessageV3> message2) {
        LoggingEnvironment.super.logStructured(message2);
    }

    @JvmStatic
    @NotNull
    public static final LoggingEnvironment parentLogger() {
        return Companion.parentLogger();
    }

    static {
        ThreadLocal threadLocal = ThreadLocal.withInitial(Companion.loggerStack.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(threadLocal, (String)"withInitial(...)");
        loggerStack = threadLocal;
        BOTTOM_LOGGING_ENVIRONMENT = new Companion.BottomLoggingEnvironment();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002&'B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0002J\b\u0010\u0011\u001a\u00020\nH\u0007J\u0016\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u000e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u001d\u001a\u00020\u000e2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001eJ\u0006\u0010!\u001a\u00020\u000eJ\u0016\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u0019R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006("}, d2={"Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion;", "", "<init>", "()V", "loggerStack", "Ljava/lang/ThreadLocal;", "Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion$LoggerStack;", "BOTTOM_LOGGING_ENVIRONMENT", "Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion$BottomLoggingEnvironment;", "logger", "Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "getLogger", "()Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "push", "", "Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment;", "pop", "parentLogger", "reportFormattedBugToCurrentLogger", "message", "", "bugCode", "Lcom/android/utils/cxx/CxxBugDiagnosticCode;", "reportFormattedErrorToCurrentLogger", "diagnosticCode", "Lcom/android/utils/cxx/CxxDiagnosticCode;", "reportFormattedWarningToCurrentLogger", "reportFormattedLifecycleToCurrentLogger", "reportFormattedInfoToCurrentLogger", "logStructuredMessageToCurrentLogger", "Lkotlin/Function1;", "Lcom/android/build/gradle/internal/cxx/string/StringEncoder;", "Lcom/google/protobuf/GeneratedMessageV3;", "requireExplicitLogger", "getILogger", "Lcom/android/utils/ILogger;", "warningDiagnosticCode", "errorDiagnosticCode", "LoggerStack", "BottomLoggingEnvironment", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        private final LoggingEnvironment getLogger() {
            Object object = (LoggerStack)loggerStack.get();
            if (object == null || (object = ((LoggerStack)object).getLogger()) == null) {
                object = BOTTOM_LOGGING_ENVIRONMENT;
            }
            return object;
        }

        private final void push(ThreadLoggingEnvironment logger) {
            loggerStack.set(new LoggerStack(logger, (LoggerStack)loggerStack.get()));
        }

        private final void pop() {
            LoggerStack next;
            LoggerStack loggerStack2 = (LoggerStack)loggerStack.get();
            LoggerStack loggerStack3 = next = loggerStack2 != null ? loggerStack2.getNext() : null;
            if (next != null) {
                loggerStack.set(next);
            } else {
                loggerStack.remove();
            }
        }

        @JvmStatic
        @NotNull
        public final LoggingEnvironment parentLogger() {
            Object object = (LoggerStack)loggerStack.get();
            if (object == null || (object = ((LoggerStack)object).getNext()) == null || (object = ((LoggerStack)object).getLogger()) == null) {
                object = BOTTOM_LOGGING_ENVIRONMENT;
            }
            return object;
        }

        public final void reportFormattedBugToCurrentLogger(@NotNull String message2, @NotNull CxxBugDiagnosticCode bugCode) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter((Object)bugCode, (String)"bugCode");
            this.getLogger().log(LoggingMessageKt.bugRecordOf(message2, bugCode));
        }

        public final void reportFormattedErrorToCurrentLogger(@NotNull String message2, @NotNull CxxDiagnosticCode diagnosticCode) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter((Object)diagnosticCode, (String)"diagnosticCode");
            this.getLogger().log(LoggingMessageKt.errorRecordOf(message2, diagnosticCode));
        }

        public final void reportFormattedWarningToCurrentLogger(@NotNull String message2, @Nullable CxxDiagnosticCode diagnosticCode) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            this.getLogger().log(LoggingMessageKt.warnRecordOf(message2, diagnosticCode));
        }

        public final void reportFormattedLifecycleToCurrentLogger(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            this.getLogger().log(LoggingMessageKt.lifecycleRecordOf(message2));
        }

        public final void reportFormattedInfoToCurrentLogger(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            this.getLogger().log(LoggingMessageKt.infoRecordOf(message2));
        }

        public final void logStructuredMessageToCurrentLogger(@NotNull Function1<? super StringEncoder, ? extends GeneratedMessageV3> message2) {
            Intrinsics.checkNotNullParameter(message2, (String)"message");
            this.getLogger().logStructured(message2);
        }

        public final void requireExplicitLogger() {
            if (Intrinsics.areEqual((Object)this.getLogger(), (Object)BOTTOM_LOGGING_ENVIRONMENT)) {
                throw new Exception("Non-default logger is required");
            }
        }

        @NotNull
        public final ILogger getILogger(@NotNull CxxDiagnosticCode warningDiagnosticCode, @NotNull CxxDiagnosticCode errorDiagnosticCode) {
            Intrinsics.checkNotNullParameter((Object)warningDiagnosticCode, (String)"warningDiagnosticCode");
            Intrinsics.checkNotNullParameter((Object)errorDiagnosticCode, (String)"errorDiagnosticCode");
            return new ILogger(errorDiagnosticCode, warningDiagnosticCode){
                final /* synthetic */ CxxDiagnosticCode $errorDiagnosticCode;
                final /* synthetic */ CxxDiagnosticCode $warningDiagnosticCode;
                {
                    this.$errorDiagnosticCode = $errorDiagnosticCode;
                    this.$warningDiagnosticCode = $warningDiagnosticCode;
                }

                public void error(Throwable t, String format, Object ... args) {
                    Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                    Throwable throwable = t;
                    if (throwable != null) {
                        throw throwable;
                    }
                    LoggingEnvironment loggingEnvironment = com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment$Companion.access$getLogger(ThreadLoggingEnvironment.Companion);
                    String string = format;
                    Intrinsics.checkNotNull((Object)string);
                    loggingEnvironment.log(LoggingMessageKt.errorRecordOf(LoggingEnvironmentKt.checkedFormat(string, args), this.$errorDiagnosticCode));
                }

                public void warning(String format, Object ... args) {
                    Intrinsics.checkNotNullParameter((Object)format, (String)"format");
                    Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                    com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment$Companion.access$getLogger(ThreadLoggingEnvironment.Companion).log(LoggingMessageKt.warnRecordOf(LoggingEnvironmentKt.checkedFormat(format, args), this.$warningDiagnosticCode));
                }

                public void info(String format, Object ... args) {
                    Intrinsics.checkNotNullParameter((Object)format, (String)"format");
                    Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                    com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment$Companion.access$getLogger(ThreadLoggingEnvironment.Companion).log(LoggingMessageKt.infoRecordOf(LoggingEnvironmentKt.checkedFormat(format, args)));
                }

                public void verbose(String format, Object ... args) {
                    Intrinsics.checkNotNullParameter((Object)format, (String)"format");
                    Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                    com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment$Companion.access$getLogger(ThreadLoggingEnvironment.Companion).log(LoggingMessageKt.infoRecordOf(LoggingEnvironmentKt.checkedFormat(format, args)));
                }
            };
        }

        public static final /* synthetic */ LoggingEnvironment access$getLogger(Companion $this) {
            return $this.getLogger();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion$BottomLoggingEnvironment;", "Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "<init>", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "log", "", "message", "Lcom/android/build/gradle/internal/cxx/logging/LoggingMessage;", "close", "gradle-core"})
        private static final class BottomLoggingEnvironment
        implements LoggingEnvironment {
            private final Logger logger = Logging.getLogger(BottomLoggingEnvironment.class);

            @Override
            public void log(@NotNull LoggingMessage message2) {
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                LoggingMessage.LoggingLevel loggingLevel = message2.getLevel();
                switch (loggingLevel == null ? -1 : WhenMappings.$EnumSwitchMapping$0[loggingLevel.ordinal()]) {
                    case 1: {
                        this.logger.error(LoggingMessageKt.text(message2));
                        break;
                    }
                    case 2: {
                        this.logger.warn(LoggingMessageKt.text(message2));
                        break;
                    }
                    case 3: {
                        this.logger.lifecycle(LoggingMessageKt.text(message2));
                        break;
                    }
                    case 4: {
                        this.logger.info(LoggingMessageKt.text(message2));
                        break;
                    }
                    case 5: 
                    case 6: {
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }

            @Override
            public void close() {
            }

            @Override
            public void logStructured(@NotNull Function1<? super StringEncoder, ? extends GeneratedMessageV3> message2) {
                LoggingEnvironment.super.logStructured(message2);
            }

            @Metadata(mv={2, 0, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[LoggingMessage.LoggingLevel.values().length];
                    try {
                        nArray[LoggingMessage.LoggingLevel.ERROR.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[LoggingMessage.LoggingLevel.WARN.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[LoggingMessage.LoggingLevel.LIFECYCLE.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[LoggingMessage.LoggingLevel.INFO.ordinal()] = 4;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[LoggingMessage.LoggingLevel.BUG.ordinal()] = 5;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[LoggingMessage.LoggingLevel.UNRECOGNIZED.ordinal()] = 6;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0000H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0000H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion$LoggerStack;", "", "logger", "Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "next", "<init>", "(Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion$LoggerStack;)V", "getLogger", "()Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "getNext", "()Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion$LoggerStack;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "gradle-core"})
        private static final class LoggerStack {
            @NotNull
            private final LoggingEnvironment logger;
            @Nullable
            private final LoggerStack next;

            public LoggerStack(@NotNull LoggingEnvironment logger, @Nullable LoggerStack next) {
                Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
                this.logger = logger;
                this.next = next;
            }

            @NotNull
            public final LoggingEnvironment getLogger() {
                return this.logger;
            }

            @Nullable
            public final LoggerStack getNext() {
                return this.next;
            }

            @NotNull
            public final LoggingEnvironment component1() {
                return this.logger;
            }

            @Nullable
            public final LoggerStack component2() {
                return this.next;
            }

            @NotNull
            public final LoggerStack copy(@NotNull LoggingEnvironment logger, @Nullable LoggerStack next) {
                Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
                return new LoggerStack(logger, next);
            }

            public static /* synthetic */ LoggerStack copy$default(LoggerStack loggerStack2, LoggingEnvironment loggingEnvironment, LoggerStack loggerStack3, int n, Object object) {
                if ((n & 1) != 0) {
                    loggingEnvironment = loggerStack2.logger;
                }
                if ((n & 2) != 0) {
                    loggerStack3 = loggerStack2.next;
                }
                return loggerStack2.copy(loggingEnvironment, loggerStack3);
            }

            @NotNull
            public String toString() {
                return "LoggerStack(logger=" + this.logger + ", next=" + this.next + ")";
            }

            public int hashCode() {
                int result2 = this.logger.hashCode();
                result2 = result2 * 31 + (this.next == null ? 0 : this.next.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LoggerStack)) {
                    return false;
                }
                LoggerStack loggerStack2 = (LoggerStack)other;
                if (!Intrinsics.areEqual((Object)this.logger, (Object)loggerStack2.logger)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.next, (Object)loggerStack2.next);
            }
        }
    }
}

