/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.api.AndroidSourceSetName;
import com.android.build.gradle.internal.api.LazyAndroidSourceSet;
import com.android.build.gradle.internal.dsl.AndroidSourceSetFactory;
import com.android.build.gradle.internal.scope.DelayedActionsExecutor;
import com.android.build.gradle.internal.services.DslServices;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.core.ComponentType;
import com.android.builder.errors.IssueReporter;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.plugins.PluginManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\"\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u00172\b\b\u0002\u0010%\u001a\u00020\u0005H\u0002J\u0018\u0010&\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u0017H\u0002J\u0006\u0010(\u001a\u00020!J\u001c\u0010)\u001a\u00020!2\u0014\u0010*\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r0+J'\u0010)\u001a\u00020!2\u001f\u0010*\u001a\u001b\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\u0012\u0004\u0012\u00020!0,\u00a2\u0006\u0002\b-J\u0006\u0010.\u001a\u00020!R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/android/build/gradle/internal/dependency/SourceSetManager;", "", "project", "Lorg/gradle/api/Project;", "publishPackage", "", "dslServices", "Lcom/android/build/gradle/internal/services/DslServices;", "buildArtifactActions", "Lcom/android/build/gradle/internal/scope/DelayedActionsExecutor;", "<init>", "(Lorg/gradle/api/Project;ZLcom/android/build/gradle/internal/services/DslServices;Lcom/android/build/gradle/internal/scope/DelayedActionsExecutor;)V", "sourceSetsContainer", "Lorg/gradle/api/NamedDomainObjectContainer;", "Lcom/android/build/gradle/api/AndroidSourceSet;", "getSourceSetsContainer", "()Lorg/gradle/api/NamedDomainObjectContainer;", "configurations", "Lorg/gradle/api/artifacts/ConfigurationContainer;", "logger", "Lorg/gradle/api/logging/Logger;", "configuredSourceSets", "", "", "pluginManager", "Lorg/gradle/api/plugins/PluginManager;", "kotlin.jvm.PlatformType", "setUpSourceSet", "Lcom/android/build/gradle/internal/api/LazyAndroidSourceSet;", "name", "componentType", "Lcom/android/builder/core/ComponentType;", "createConfigurationsForSourceSet", "", "createConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "description", "canBeResolved", "getConfigDesc", "sourceSetName", "checkForUnconfiguredSourceSets", "executeAction", "action", "Lorg/gradle/api/Action;", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "runBuildableArtifactsActions", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nSourceSetManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceSetManager.kt\ncom/android/build/gradle/internal/dependency/SourceSetManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,165:1\n1869#2,2:166\n*S KotlinDebug\n*F\n+ 1 SourceSetManager.kt\ncom/android/build/gradle/internal/dependency/SourceSetManager\n*L\n144#1:166,2\n*E\n"})
public final class SourceSetManager {
    @NotNull
    private final DslServices dslServices;
    @NotNull
    private final DelayedActionsExecutor buildArtifactActions;
    @NotNull
    private final NamedDomainObjectContainer<AndroidSourceSet> sourceSetsContainer;
    @NotNull
    private final ConfigurationContainer configurations;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Set<String> configuredSourceSets;
    private final PluginManager pluginManager;

    public SourceSetManager(@NotNull Project project, boolean publishPackage, @NotNull DslServices dslServices2, @NotNull DelayedActionsExecutor buildArtifactActions) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dslServices2, (String)"dslServices");
        Intrinsics.checkNotNullParameter((Object)buildArtifactActions, (String)"buildArtifactActions");
        this.dslServices = dslServices2;
        this.buildArtifactActions = buildArtifactActions;
        NamedDomainObjectContainer namedDomainObjectContainer = project.container(AndroidSourceSet.class, (NamedDomainObjectFactory)new AndroidSourceSetFactory(project, publishPackage, this.dslServices));
        Intrinsics.checkNotNullExpressionValue((Object)namedDomainObjectContainer, (String)"container(...)");
        this.sourceSetsContainer = namedDomainObjectContainer;
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"getConfigurations(...)");
        this.configurations = configurationContainer;
        Logger logger = Logging.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.configuredSourceSets = new LinkedHashSet();
        this.pluginManager = project.getPluginManager();
    }

    @NotNull
    public final NamedDomainObjectContainer<AndroidSourceSet> getSourceSetsContainer() {
        return this.sourceSetsContainer;
    }

    @JvmOverloads
    @NotNull
    public final LazyAndroidSourceSet setUpSourceSet(@NotNull String name, @NotNull ComponentType componentType) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        if (!this.configuredSourceSets.contains(name)) {
            this.createConfigurationsForSourceSet(name, componentType);
            this.configuredSourceSets.add(name);
        }
        return new LazyAndroidSourceSet(this.sourceSetsContainer, name);
    }

    private final void createConfigurationsForSourceSet(String name, ComponentType componentType) {
        AndroidSourceSetName sourceSetName = new AndroidSourceSetName(name);
        String apiName = sourceSetName.getApiConfigurationName();
        String implementationName = sourceSetName.getImplementationConfigurationName();
        String runtimeOnlyName = sourceSetName.getRuntimeOnlyConfigurationName();
        String compileOnlyName = sourceSetName.getCompileOnlyConfigurationName();
        String compileOnlyApiName = sourceSetName.getCompileOnlyApiConfigurationName();
        Configuration api = !componentType.isTestComponent() ? SourceSetManager.createConfiguration$default(this, apiName, this.getConfigDesc("API", name), false, 4, null) : null;
        Configuration implementation = SourceSetManager.createConfiguration$default(this, implementationName, this.getConfigDesc("Implementation only", name), false, 4, null);
        Configuration configuration = api;
        if (configuration != null) {
            Configuration it = configuration;
            boolean bl = false;
            Configuration[] configurationArray = new Configuration[]{it};
            implementation.extendsFrom(configurationArray);
        }
        SourceSetManager.createConfiguration$default(this, runtimeOnlyName, this.getConfigDesc("Runtime only", name), false, 4, null);
        SourceSetManager.createConfiguration$default(this, compileOnlyName, this.getConfigDesc("Compile only", name), false, 4, null);
        if (!componentType.isTestComponent()) {
            SourceSetManager.createConfiguration$default(this, compileOnlyApiName, this.getConfigDesc("Compile only API", name), false, 4, null);
        }
        SourceSetManager.createConfiguration$default(this, sourceSetName.getAnnotationProcessorConfigurationName(), "Classpath for the annotation processor for '" + name + "'.", false, 4, null);
        Function0 createKaptConfiguration2 = (Function0)new Function0<Unit>(this, sourceSetName, name){
            final /* synthetic */ SourceSetManager this$0;
            final /* synthetic */ AndroidSourceSetName $sourceSetName;
            final /* synthetic */ String $name;
            {
                this.this$0 = $receiver;
                this.$sourceSetName = $sourceSetName;
                this.$name = $name;
                super(0);
            }

            public final void invoke() {
                SourceSetManager.access$createConfiguration(this.this$0, this.$sourceSetName.getKaptConfigurationName(), "Classpath for the KAPT annotation processors for '" + this.$name + "'.", true);
            }
        };
        this.pluginManager.withPlugin("com.android.legacy-kapt", new Action((Function0<Unit>)createKaptConfiguration2){
            final /* synthetic */ Function0<Unit> $createKaptConfiguration;
            {
                this.$createKaptConfiguration = $createKaptConfiguration;
            }

            public final void execute(AppliedPlugin it) {
                this.$createKaptConfiguration.invoke();
            }
        });
        if (componentType.isForScreenshotPreview() || componentType.isTestFixturesComponent() && this.dslServices.getProjectOptions().get(BooleanOption.ENABLE_TEST_FIXTURES_KOTLIN_SUPPORT)) {
            this.pluginManager.withPlugin("org.jetbrains.kotlin.kapt", new Action((Function0<Unit>)createKaptConfiguration2){
                final /* synthetic */ Function0<Unit> $createKaptConfiguration;
                {
                    this.$createKaptConfiguration = $createKaptConfiguration;
                }

                public final void execute(AppliedPlugin it) {
                    this.$createKaptConfiguration.invoke();
                }
            });
        }
    }

    private final Configuration createConfiguration(String name, String description, boolean canBeResolved) {
        this.logger.debug("Creating configuration {}", (Object)name);
        Configuration configuration = (Configuration)this.configurations.maybeCreate(name);
        configuration.setVisible(false);
        configuration.setDescription(description);
        configuration.setCanBeConsumed(false);
        configuration.setCanBeResolved(canBeResolved);
        Intrinsics.checkNotNull((Object)configuration);
        return configuration;
    }

    static /* synthetic */ Configuration createConfiguration$default(SourceSetManager sourceSetManager, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return sourceSetManager.createConfiguration(string, string2, bl);
    }

    private final String getConfigDesc(String name, String sourceSetName) {
        return name + " dependencies for '" + sourceSetName + "' sources.";
    }

    public final void checkForUnconfiguredSourceSets() {
        Iterable $this$forEach$iv = (Iterable)this.sourceSetsContainer;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AndroidSourceSet sourceSet2 = (AndroidSourceSet)element$iv;
            boolean bl = false;
            if (this.configuredSourceSets.contains(sourceSet2.getName())) continue;
            String message2 = "The SourceSet '" + sourceSet2.getName() + "' is not recognized by the Android Gradle Plugin. Perhaps you misspelled something?";
            IssueReporter.reportError$default((IssueReporter)this.dslServices.getIssueReporter(), (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)message2, null, null, (int)12, null);
        }
    }

    public final void executeAction(@NotNull Action<NamedDomainObjectContainer<? extends AndroidSourceSet>> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        action.execute(this.sourceSetsContainer);
    }

    public final void executeAction(@NotNull Function1<? super NamedDomainObjectContainer<? extends AndroidSourceSet>, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        action.invoke(this.sourceSetsContainer);
    }

    public final void runBuildableArtifactsActions() {
        this.buildArtifactActions.runAll();
    }

    public static final /* synthetic */ Configuration access$createConfiguration(SourceSetManager $this, String name, String description, boolean canBeResolved) {
        return $this.createConfiguration(name, description, canBeResolved);
    }
}

