/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.level2;

import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.GraphItem;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;

public class FullDependencyGraphsImpl
implements DependencyGraphs,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<GraphItem> compileItems;
    private final List<GraphItem> packageItems;
    private final List<String> providedLibraries;
    private final List<String> skippedLibraries;
    private final int hashCode;

    public FullDependencyGraphsImpl(List<GraphItem> compileItems, List<GraphItem> packageItems, List<String> providedLibraries, List<String> skippedLibraries) {
        this.compileItems = compileItems;
        this.packageItems = packageItems;
        this.providedLibraries = ImmutableList.copyOf(providedLibraries);
        this.skippedLibraries = ImmutableList.copyOf(skippedLibraries);
        this.hashCode = this.computeHashCode();
    }

    public List<GraphItem> getCompileDependencies() {
        return this.compileItems;
    }

    public List<GraphItem> getPackageDependencies() {
        return this.packageItems;
    }

    public List<String> getProvidedLibraries() {
        return this.providedLibraries;
    }

    public List<String> getSkippedLibraries() {
        return this.skippedLibraries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FullDependencyGraphsImpl that = (FullDependencyGraphsImpl)o;
        if (!this.compileItems.equals(that.compileItems)) {
            return false;
        }
        if (!this.packageItems.equals(that.packageItems)) {
            return false;
        }
        if (!this.providedLibraries.equals(that.providedLibraries)) {
            return false;
        }
        return this.skippedLibraries.equals(that.skippedLibraries);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int result2 = this.compileItems.hashCode();
        result2 = 31 * result2 + this.packageItems.hashCode();
        result2 = 31 * result2 + this.providedLibraries.hashCode();
        result2 = 31 * result2 + this.skippedLibraries.hashCode();
        return result2;
    }
}

