/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.services;

import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.api.component.impl.DeviceTestImpl;
import com.android.build.api.component.impl.HostTestImpl;
import com.android.build.api.component.impl.KmpComponentImpl;
import com.android.build.api.component.impl.TestFixturesImpl;
import com.android.build.api.variant.impl.ApplicationVariantImpl;
import com.android.build.api.variant.impl.DynamicFeatureVariantImpl;
import com.android.build.api.variant.impl.FlatSourceDirectoriesImpl;
import com.android.build.api.variant.impl.LibraryVariantImpl;
import com.android.build.api.variant.impl.TestVariantImpl;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.services.BuiltInKotlinServices;
import com.android.build.gradle.internal.services.ProjectServices;
import com.android.build.gradle.internal.utils.GradlePluginUtils;
import com.android.build.gradle.internal.utils.KgpVersion;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.errors.IssueReporter;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinAndroidExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinAndroidProjectExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinBaseApiPlugin;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinAndroidTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinJvmAndroidCompilation;
import org.jetbrains.kotlin.gradle.plugin.sources.android.AndroidVariantType;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001c\u0010\u0007\u001a\u00020\u0001*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u001a\u000e\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u0011H\u0000\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0011H\u0002\u00a8\u0006\u0014"}, d2={"initBuiltInKotlinSupportIfRequired", "", "project", "Lorg/gradle/api/Project;", "projectServices", "Lcom/android/build/gradle/internal/services/ProjectServices;", "initBuiltInKotlinSupport", "setDefaults", "Lorg/jetbrains/kotlin/gradle/dsl/KotlinAndroidProjectExtension;", "projectName", "", "kotlinBaseApiPluginVersion", "initBuiltInKaptSupportIfRequired", "initBuiltInKaptSupport", "createKotlinCompilation", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;", "", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "toAndroidVariantType", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/AndroidVariantType;", "gradle-core"})
public final class BuiltInKotlinServicesKt {
    public static final void initBuiltInKotlinSupportIfRequired(@NotNull Project project, @NotNull ProjectServices projectServices2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectServices2, (String)"projectServices");
        if (projectServices2.getProjectOptions().get(BooleanOption.BUILT_IN_KOTLIN)) {
            BuiltInKotlinServicesKt.initBuiltInKotlinSupport(project);
            projectServices2.initBuiltInKotlinServices(BuiltInKotlinServices.AvailabilityReason.BuiltInKotlinBooleanOptionEnabled.INSTANCE);
        } else {
            project.getPluginManager().withPlugin("com.android.experimental.built-in-kotlin", new Action(project, projectServices2){
                final /* synthetic */ Project $project;
                final /* synthetic */ ProjectServices $projectServices;
                {
                    this.$project = $project;
                    this.$projectServices = $projectServices;
                }

                public final void execute(AppliedPlugin it) {
                    BuiltInKotlinServicesKt.access$initBuiltInKotlinSupport(this.$project);
                    this.$projectServices.initBuiltInKotlinServices(BuiltInKotlinServices.AvailabilityReason.BuiltInKotlinPluginApplied.INSTANCE);
                }
            });
        }
        project.getPluginManager().withPlugin("com.android.legacy-kapt", new Action(projectServices2, project){
            final /* synthetic */ ProjectServices $projectServices;
            final /* synthetic */ Project $project;
            {
                this.$projectServices = $projectServices;
                this.$project = $project;
            }

            public final void execute(AppliedPlugin it) {
                if (!this.$projectServices.getProjectOptions().get(BooleanOption.BUILT_IN_KOTLIN)) {
                    GradlePluginUtils.requirePlugin(this.$project, "com.android.legacy-kapt", "com.android.experimental.built-in-kotlin");
                }
            }
        });
        if (projectServices2.getProjectOptions().get(BooleanOption.ENABLE_TEST_FIXTURES_KOTLIN_SUPPORT) || projectServices2.getProjectOptions().get(BooleanOption.ENABLE_SCREENSHOT_TEST)) {
            project.getPluginManager().withPlugin("org.jetbrains.kotlin.android", new Action(project, projectServices2){
                final /* synthetic */ Project $project;
                final /* synthetic */ ProjectServices $projectServices;
                {
                    this.$project = $project;
                    this.$projectServices = $projectServices;
                }

                public final void execute(AppliedPlugin it) {
                    this.$project.getPlugins().apply(KotlinBaseApiPlugin.class);
                    this.$projectServices.initBuiltInKotlinServices(BuiltInKotlinServices.AvailabilityReason.KotlinAndroidPluginAppliedAndTestFixturesOrScreenshotTestEnabled.INSTANCE);
                }
            });
            try {
                Class.forName(KotlinBaseApiPlugin.class.getName());
            }
            catch (Throwable e) {
                if (e instanceof ClassNotFoundException || e instanceof NoClassDefFoundError) {
                    String message2 = StringsKt.trimIndent((String)("\n                    The Kotlin Gradle plugin was not found on the project's buildscript\n                    classpath. Add \"org.jetbrains.kotlin:kotlin-gradle-plugin:" + KgpVersion.Companion.getMINIMUM_BUILT_IN_KOTLIN_VERSION() + "\" to the\n                    buildscript classpath in order to use any of the following Gradle\n                    properties:\n\n                    " + BooleanOption.ENABLE_SCREENSHOT_TEST.getPropertyName() + ",\n                    " + BooleanOption.ENABLE_TEST_FIXTURES_KOTLIN_SUPPORT.getPropertyName() + "\n\n                    "));
                    IssueReporter.reportError$default((IssueReporter)projectServices2.getIssueReporter(), (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)message2, null, null, (int)12, null);
                }
                throw e;
            }
        }
    }

    private static final void initBuiltInKotlinSupport(Project project) {
        project.getPluginManager().withPlugin("org.jetbrains.kotlin.android", new Action(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public final void execute(AppliedPlugin it) {
                throw new IllegalStateException(StringsKt.trimIndent((String)("\n            The 'org.jetbrains.kotlin.android' plugin is no longer required for Kotlin support since AGP 9.0.\n            Remove the 'org.jetbrains.kotlin.android' plugin from this project's build file: " + this.$project.getBuildFile() + ".\n            For more info, see https://issuetracker.google.com/438678642.\n            ")).toString());
            }
        });
        project.getPluginManager().withPlugin("org.jetbrains.kotlin.kapt", new Action(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public final void execute(AppliedPlugin it) {
                throw new IllegalStateException(StringsKt.trimIndent((String)("\n            The 'org.jetbrains.kotlin.kapt' plugin is not compatible with built-in Kotlin support.\n            Replace the 'org.jetbrains.kotlin.kapt' plugin with the 'com.android.legacy-kapt' in this project's build file: " + this.$project.getBuildFile() + ".\n            For more info, see https://issuetracker.google.com/438678642.\n            ")).toString());
            }
        });
        KotlinBaseApiPlugin kotlinBaseApiPlugin = (KotlinBaseApiPlugin)project.getPlugins().apply(KotlinBaseApiPlugin.class);
        KotlinAndroidExtension kotlinAndroidExtension = kotlinBaseApiPlugin.createKotlinAndroidExtension();
        Intrinsics.checkNotNull((Object)kotlinAndroidExtension, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.gradle.dsl.KotlinAndroidProjectExtension");
        KotlinAndroidProjectExtension kotlinAndroidExtension2 = (KotlinAndroidProjectExtension)kotlinAndroidExtension;
        String string = project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        BuiltInKotlinServicesKt.setDefaults(kotlinAndroidExtension2, string, kotlinBaseApiPlugin.getPluginVersion());
        project.getExtensions().add("kotlin", (Object)kotlinAndroidExtension2);
        BuiltInKotlinServicesKt.initBuiltInKaptSupportIfRequired(project);
    }

    private static final void setDefaults(KotlinAndroidProjectExtension $this$setDefaults, String projectName, String kotlinBaseApiPluginVersion) {
        $this$setDefaults.setCoreLibrariesVersion(kotlinBaseApiPluginVersion);
        $this$setDefaults.getCompilerOptions().getModuleName().convention((Object)projectName);
    }

    public static final void initBuiltInKaptSupportIfRequired(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.getPluginManager().withPlugin("com.android.legacy-kapt", new Action(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public final void execute(AppliedPlugin it) {
                BuiltInKotlinServicesKt.access$initBuiltInKaptSupport(this.$project);
            }
        });
    }

    private static final void initBuiltInKaptSupport(Project project) {
        KotlinBaseApiPlugin kotlinBaseApiPlugin = (KotlinBaseApiPlugin)project.getPlugins().getPlugin(KotlinBaseApiPlugin.class);
        project.getExtensions().add("kapt", (Object)kotlinBaseApiPlugin.getKaptExtension());
    }

    @NotNull
    public static final KotlinCompilation<Object> createKotlinCompilation(@NotNull ComponentCreationConfig $this$createKotlinCompilation) {
        Intrinsics.checkNotNullParameter((Object)$this$createKotlinCompilation, (String)"<this>");
        BuiltInKotlinServices kotlinServices = $this$createKotlinCompilation.getServices().getBuiltInKotlinServices();
        KotlinBaseApiPlugin kotlinBaseApiPlugin = kotlinServices.getKotlinBaseApiPlugin();
        String string = $this$createKotlinCompilation.getName();
        KotlinAndroidTarget kotlinAndroidTarget = kotlinServices.getKotlinAndroidProjectExtension().getTarget();
        TaskProvider<? extends JavaCompile> taskProvider = $this$createKotlinCompilation.getTaskContainer().getJavacTask();
        Intrinsics.checkNotNull(taskProvider, (String)"null cannot be cast to non-null type org.gradle.api.tasks.TaskProvider<org.gradle.api.tasks.compile.JavaCompile>");
        KotlinJvmAndroidCompilation kotlinCompilation = kotlinBaseApiPlugin.createKotlinAndroidCompilation(string, kotlinAndroidTarget, taskProvider, BuiltInKotlinServicesKt.toAndroidVariantType($this$createKotlinCompilation));
        SourceDirectorySet sourceDirectorySet = kotlinCompilation.getDefaultSourceSet().getKotlin();
        FlatSourceDirectoriesImpl flatSourceDirectoriesImpl = $this$createKotlinCompilation.getSources().getKotlin();
        Intrinsics.checkNotNull((Object)flatSourceDirectoriesImpl);
        sourceDirectorySet.setSrcDirs((Iterable)CollectionsKt.listOf(flatSourceDirectoriesImpl.getDirectories$gradle_core()));
        NamedDomainObjectContainer namedDomainObjectContainer = kotlinServices.getKotlinAndroidProjectExtension().getTarget().getCompilations();
        Intrinsics.checkNotNull((Object)namedDomainObjectContainer, (String)"null cannot be cast to non-null type org.gradle.api.NamedDomainObjectContainer<org.jetbrains.kotlin.gradle.plugin.mpp.KotlinJvmAndroidCompilation>");
        namedDomainObjectContainer.add((Object)kotlinCompilation);
        return (KotlinCompilation)kotlinCompilation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final AndroidVariantType toAndroidVariantType(ComponentCreationConfig $this$toAndroidVariantType) {
        ComponentCreationConfig componentCreationConfig = $this$toAndroidVariantType;
        if (componentCreationConfig instanceof ComponentImpl) {
            AndroidVariantType androidVariantType;
            ComponentImpl componentImpl = (ComponentImpl)$this$toAndroidVariantType;
            if (componentImpl instanceof ApplicationVariantImpl) {
                androidVariantType = AndroidVariantType.Main;
                return androidVariantType;
            } else if (componentImpl instanceof DynamicFeatureVariantImpl) {
                androidVariantType = AndroidVariantType.Main;
                return androidVariantType;
            } else if (componentImpl instanceof LibraryVariantImpl) {
                androidVariantType = AndroidVariantType.Main;
                return androidVariantType;
            } else if (componentImpl instanceof TestVariantImpl) {
                androidVariantType = AndroidVariantType.Main;
                return androidVariantType;
            } else if (componentImpl instanceof HostTestImpl) {
                androidVariantType = Intrinsics.areEqual((Object)((HostTestImpl)$this$toAndroidVariantType).getHostTestName(), (Object)"UnitTest") ? AndroidVariantType.UnitTest : AndroidVariantType.Unknown;
                return androidVariantType;
            } else if (componentImpl instanceof DeviceTestImpl) {
                androidVariantType = AndroidVariantType.InstrumentedTest;
                return androidVariantType;
            } else {
                if (!(componentImpl instanceof TestFixturesImpl)) throw new IllegalStateException(("Unknown component: " + $this$toAndroidVariantType.getClass().getName()).toString());
                androidVariantType = AndroidVariantType.Unknown;
            }
            return androidVariantType;
        } else {
            if (!(componentCreationConfig instanceof KmpComponentImpl)) throw new IllegalStateException(("Unknown component: " + $this$toAndroidVariantType.getClass().getName()).toString());
            throw new IllegalStateException("KmpComponentImpl is not expected here (built-in Kotlin support is not available for KMP)".toString());
        }
    }

    public static final /* synthetic */ void access$initBuiltInKotlinSupport(Project project) {
        BuiltInKotlinServicesKt.initBuiltInKotlinSupport(project);
    }

    public static final /* synthetic */ void access$initBuiltInKaptSupport(Project project) {
        BuiltInKotlinServicesKt.initBuiltInKaptSupport(project);
    }
}

