/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.variant.impl.BuiltArtifactImpl;
import com.android.build.api.variant.impl.BuiltArtifactsImpl;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.ExtractApksTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.GuavaKtxKt;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.StringOption;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.bundle.Devices;
import com.android.tools.build.bundletool.commands.ExtractApksCommand;
import com.android.utils.FileUtils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.APK_PACKAGING)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\b'\u0018\u0000 (2\u00020\u0001:\u0005()*+,B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010&\u001a\u00020'H\u0014R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u0014\u0010\u0014\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00178gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u001c8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR \u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 8G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020 0\u00178gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001a\u00a8\u0006-"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractApksTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "<init>", "()V", "apkSetArchive", "Lorg/gradle/api/file/RegularFileProperty;", "getApkSetArchive", "()Lorg/gradle/api/file/RegularFileProperty;", "targetDeviceSpec", "getTargetDeviceSpec", "multipleDeviceConfigs", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getMultipleDeviceConfigs", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "deviceSpecToApksLocationMappingFile", "getDeviceSpecToApksLocationMappingFile", "apksFromBundleIdeModel", "getApksFromBundleIdeModel", "applicationId", "Lorg/gradle/api/provider/Property;", "", "getApplicationId", "()Lorg/gradle/api/provider/Property;", "dynamicModulesToInstall", "Lorg/gradle/api/provider/ListProperty;", "getDynamicModulesToInstall", "()Lorg/gradle/api/provider/ListProperty;", "value", "", "extractInstant", "getExtractInstant", "()Z", "setIncludeMetadata", "getSetIncludeMetadata", "doTaskAction", "", "Companion", "Params", "DeviceSpecInfo", "BundleToolRunnable", "CreationAction", "gradle-core"})
public abstract class ExtractApksTask
extends NonIncrementalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean extractInstant;
    @NotNull
    public static final String namePrefix = "extractApksFromBundleFor";

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getApkSetArchive();

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getTargetDeviceSpec();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract ConfigurableFileCollection getMultipleDeviceConfigs();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getDeviceSpecToApksLocationMappingFile();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getApksFromBundleIdeModel();

    @Input
    @NotNull
    public abstract Property<String> getApplicationId();

    @Input
    @Optional
    @NotNull
    public abstract ListProperty<String> getDynamicModulesToInstall();

    @Input
    public final boolean getExtractInstant() {
        return this.extractInstant;
    }

    @Input
    @NotNull
    public abstract Property<Boolean> getSetIncludeMetadata();

    @Override
    protected void doTaskAction() {
        this.getWorkerExecutor().noIsolation().submit(BundleToolRunnable.class, new Action(this){
            final /* synthetic */ ExtractApksTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(Params it) {
                it.initializeFromBaseTask(this.this$0);
                it.getApkSetArchive().set((Provider)this.this$0.getApkSetArchive());
                it.getMultipleDeviceConfigs().setFrom((Iterable)this.this$0.getMultipleDeviceConfigs());
                it.getTargetDeviceSpec().set((Provider)this.this$0.getTargetDeviceSpec());
                it.getOutputDir().set((Provider)this.this$0.getOutputDir());
                it.getDeviceSpecToApksLocationMappingFile().set((Provider)this.this$0.getDeviceSpecToApksLocationMappingFile());
                it.getExtractInstant().set((Object)this.this$0.getExtractInstant());
                it.getApksFromBundleIdeModel().set((Provider)this.this$0.getApksFromBundleIdeModel());
                it.getApplicationId().set((Provider)this.this$0.getApplicationId());
                it.getVariantName().set((Object)this.this$0.getVariantName());
                it.getOptionalListOfDynamicModulesToInstall().set(this.this$0.getDynamicModulesToInstall().orElse((Object)CollectionsKt.emptyList()));
                it.getSetIncludeMetadata().set((Provider)this.this$0.getSetIncludeMetadata());
            }
        });
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractApksTask$BundleToolRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/ExtractApksTask$Params;", "<init>", "()V", "run", "", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nExtractApksTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractApksTask.kt\ncom/android/build/gradle/internal/tasks/ExtractApksTask$BundleToolRunnable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,359:1\n1563#2:360\n1634#2,3:361\n1491#2:364\n1516#2,3:365\n1519#2,3:375\n1878#2,3:378\n1869#2,2:383\n382#3,7:368\n216#4,2:381\n*S KotlinDebug\n*F\n+ 1 ExtractApksTask.kt\ncom/android/build/gradle/internal/tasks/ExtractApksTask$BundleToolRunnable\n*L\n165#1:360\n165#1:361,3\n172#1:364\n172#1:365,3\n172#1:375,3\n177#1:378,3\n265#1:383,2\n172#1:368,7\n247#1:381,2\n*E\n"})
    public static abstract class BundleToolRunnable
    extends ProfileAwareWorkAction<Params> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            List list;
            Object metadataJson;
            List elementList;
            block36: {
                void $this$groupByTo$iv$iv;
                void $this$groupBy$iv;
                Throwable throwable;
                void $this$mapTo$iv$iv;
                FileUtils.cleanOutputDir((File)((File)((Params)this.getParameters()).getOutputDir().getAsFile().get()));
                RegularFile regularFile = (RegularFile)((Params)this.getParameters()).getTargetDeviceSpec().getOrNull();
                File targetDeviceSpec = regularFile != null ? regularFile.getAsFile() : null;
                Set multipleDeviceSpecs = ((Params)this.getParameters()).getMultipleDeviceConfigs().getFiles();
                if (targetDeviceSpec == null) {
                    throw new RuntimeException("Calling ExtractApk with no device config");
                }
                Intrinsics.checkNotNull((Object)multipleDeviceSpecs);
                List deviceSpecFiles = !((Collection)multipleDeviceSpecs).isEmpty() ? CollectionsKt.toList((Iterable)multipleDeviceSpecs) : CollectionsKt.listOf((Object)targetDeviceSpec);
                Iterable $this$map$iv = deviceSpecFiles;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void file;
                    Devices.DeviceSpec.Builder builder;
                    File file2 = (File)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Devices.DeviceSpec.Builder $this$run_u24lambda_u242_u24lambda_u241 = builder = Devices.DeviceSpec.newBuilder();
                    boolean bl2 = false;
                    Closeable closeable = Files.newBufferedReader(file.toPath(), Charsets.UTF_8);
                    throwable = null;
                    try {
                        BufferedReader reader = (BufferedReader)closeable;
                        boolean bl3 = false;
                        JsonFormat.parser().merge((Reader)reader, (Message.Builder)$this$run_u24lambda_u242_u24lambda_u241);
                        reader = Unit.INSTANCE;
                    }
                    catch (Throwable bl3) {
                        throwable = bl3;
                        throw bl3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    Devices.DeviceSpec spec = builder.build();
                    Path path = file.toPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                    Intrinsics.checkNotNull((Object)spec);
                    collection.add(new DeviceSpecInfo(path, spec));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$groupBy = false;
                $this$mapTo$iv$iv = $this$groupBy$iv;
                destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object;
                    DeviceSpecInfo it = (DeviceSpecInfo)element$iv$iv;
                    boolean bl = false;
                    Devices.DeviceSpec key$iv$iv = it.getDeviceSpec();
                    Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl4 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                Object specsToFiles = destination$iv$iv;
                elementList = new ArrayList();
                File extractApksDir = (File)((Params)this.getParameters()).getOutputDir().getAsFile().get();
                Iterable $this$forEachIndexed$iv = specsToFiles.entrySet();
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    File file;
                    int list$iv$iv;
                    if ((list$iv$iv = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Map.Entry bl = (Map.Entry)item$iv;
                    int index = list$iv$iv;
                    boolean bl5 = false;
                    Devices.DeviceSpec deviceSpec = (Devices.DeviceSpec)bl.getKey();
                    if (deviceSpecFiles.size() == 1) {
                        file = extractApksDir;
                    } else {
                        Intrinsics.checkNotNull((Object)extractApksDir);
                        file = FilesKt.resolve((File)extractApksDir, (String)String.valueOf(index));
                    }
                    File outputDir = file;
                    ExtractApksCommand.Builder builder = ExtractApksCommand.builder().setApksArchivePath(((File)((Params)this.getParameters()).getApkSetArchive().getAsFile().get()).toPath()).setDeviceSpec(deviceSpec).setOutputDirectory(outputDir.toPath());
                    Object object = ((Params)this.getParameters()).getExtractInstant().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                    Throwable it = throwable = builder.setInstant(((Boolean)object).booleanValue());
                    boolean bl6 = false;
                    Object object2 = ((Params)this.getParameters()).getOptionalListOfDynamicModulesToInstall().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                    if (!((Collection)object2).isEmpty()) {
                        Object object3 = ((Params)this.getParameters()).getOptionalListOfDynamicModulesToInstall().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
                        it.setModules(GuavaKtxKt.toImmutableSet((Iterable)object3));
                        Object object4 = ((Params)this.getParameters()).getSetIncludeMetadata().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
                        it.setIncludeMetadata((Boolean)object4);
                    }
                    Throwable command = throwable;
                    command.build().execute();
                }
                File file = ((RegularFile)((Params)this.getParameters()).getDeviceSpecToApksLocationMappingFile().get()).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
                FilesKt.writeText$default((File)file, (String)CollectionsKt.joinToString$default((Iterable)CollectionsKt.withIndex((Iterable)specsToFiles.entrySet()), (CharSequence)"\n", null, null, (int)0, null, (Function1)run.2.INSTANCE, (int)30, null), null, (int)2, null);
                if (!((Boolean)((Params)this.getParameters()).getSetIncludeMetadata().get()).booleanValue()) break block36;
                metadataJson = ((RegularFile)((Params)this.getParameters()).getOutputDir().file("metadata.json").get()).getAsFile();
                FileReader fileReader = new FileReader((File)metadataJson);
                JsonReader reader = new JsonReader((Reader)fileReader);
                Map deliveryTypeMap = new LinkedHashMap();
                String path = "";
                reader.beginObject();
                while (reader.hasNext() && reader.peek() != JsonToken.END_OBJECT) {
                    block37: {
                        String name = reader.nextName();
                        if (!Intrinsics.areEqual((Object)name, (Object)"apks")) break block37;
                        reader.beginArray();
                        while (reader.hasNext()) {
                            reader.beginObject();
                            while (reader.hasNext()) {
                                String bl = reader.nextName();
                                if (bl == null) continue;
                                int n = -1;
                                switch (bl.hashCode()) {
                                    case 3433509: {
                                        if (bl.equals("path")) {
                                            n = 1;
                                        }
                                        break;
                                    }
                                    case -870351081: {
                                        if (bl.equals("moduleName")) {
                                            n = 2;
                                        }
                                        break;
                                    }
                                    case 681968974: {
                                        if (bl.equals("deliveryType")) {
                                            n = 3;
                                        }
                                        break;
                                    }
                                }
                                switch (n) {
                                    case 2: {
                                        reader.nextString();
                                        break;
                                    }
                                    case 1: {
                                        Intrinsics.checkNotNullExpressionValue((Object)reader.nextString(), (String)"nextString(...)");
                                        break;
                                    }
                                    case 3: {
                                        deliveryTypeMap.put(path, reader.nextString());
                                    }
                                }
                            }
                            reader.endObject();
                        }
                        reader.endArray();
                        continue;
                    }
                    reader.skipValue();
                }
                reader.endObject();
                Map $this$forEach$iv = deliveryTypeMap;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator2.next();
                    boolean bl = false;
                    elementList.add(BuiltArtifactImpl.Companion.make$default(BuiltArtifactImpl.Companion, ((File)((Params)this.getParameters()).getOutputDir().getAsFile().get()).getAbsolutePath() + "/" + it.getKey(), null, null, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"deliveryType", it.getValue())), 14, null));
                }
                fileReader.close();
                FileUtils.deleteIfExists((File)metadataJson);
            }
            int n = 0;
            Artifact artifact = (Artifact)InternalArtifactType.EXTRACTED_APKS.INSTANCE;
            Object object = ((Params)this.getParameters()).getApplicationId().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            String string = (String)object;
            Object object5 = ((Params)this.getParameters()).getVariantName().get();
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
            String string2 = (String)object5;
            if (elementList.isEmpty()) {
                void $this$forEach$iv;
                Set set = ((Params)this.getParameters()).getOutputDir().getAsFileTree().getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
                metadataJson = set;
                String string3 = string2;
                String string4 = string;
                Artifact artifact2 = artifact;
                int n2 = n;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    String string5 = it.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getAbsolutePath(...)");
                    elementList.add(BuiltArtifactImpl.Companion.make$default(BuiltArtifactImpl.Companion, string5, null, null, null, null, 30, null));
                }
                n = n2;
                artifact = artifact2;
                string = string4;
                string2 = string3;
                list = elementList;
            } else {
                list = elementList;
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n3 = 225;
            Integer n4 = null;
            List list2 = null;
            String string6 = null;
            Collection collection = list;
            String string7 = string2;
            String string8 = string;
            Artifact artifact3 = artifact;
            int n5 = n;
            BuiltArtifactsImpl builtArtifactsImpl = new BuiltArtifactsImpl(n5, artifact3, string8, string7, collection, string6, list2, n4, n3, defaultConstructorMarker);
            Object object6 = ((Params)this.getParameters()).getApksFromBundleIdeModel().getAsFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get(...)");
            builtArtifactsImpl.saveToFile((File)object6);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractApksTask$Companion;", "", "<init>", "()V", "namePrefix", "", "getTaskName", "componentImpl", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTaskName(@NotNull ComponentCreationConfig componentImpl) {
            Intrinsics.checkNotNullParameter((Object)componentImpl, (String)"componentImpl");
            return componentImpl.computeTaskNameInternal(ExtractApksTask.namePrefix);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractApksTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ExtractApksTask;", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "creationConfig", "<init>", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "configure", "task", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nExtractApksTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractApksTask.kt\ncom/android/build/gradle/internal/tasks/ExtractApksTask$CreationAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,359:1\n1563#2:360\n1634#2,3:361\n1563#2:364\n1634#2,3:365\n*S KotlinDebug\n*F\n+ 1 ExtractApksTask.kt\ncom/android/build/gradle/internal/tasks/ExtractApksTask$CreationAction\n*L\n335#1:360\n335#1:361,3\n338#1:364\n338#1:365,3\n*E\n"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ExtractApksTask, ApkCreationConfig> {
        public CreationAction(@NotNull ApkCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig, false, 2, null);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName(ExtractApksTask.namePrefix);
        }

        @Override
        @NotNull
        public Class<ExtractApksTask> getType() {
            return ExtractApksTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ExtractApksTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).on(InternalArtifactType.EXTRACTED_APKS.INSTANCE);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.2.INSTANCE).withName("output-metadata.json").on(InternalArtifactType.APK_FROM_BUNDLE_IDE_MODEL.INSTANCE);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.3.INSTANCE).withName(InternalArtifactType.DEVICE_SPEC_PATH_MAP.INSTANCE.getFolderName() + ".txt").on(InternalArtifactType.DEVICE_SPEC_PATH_MAP.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void configure(@NotNull ExtractApksTask task) {
            Collection<File> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List list;
            Object object;
            String item$iv$iv;
            Object object2;
            List $i$a$-let-ExtractApksTask$CreationAction$configure$22;
            String targetDeviceSpecPath;
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.APKS_FROM_BUNDLE.INSTANCE, (Property)task.getApkSetArchive());
            String string = targetDeviceSpecPath = ((ApkCreationConfig)this.creationConfig).getServices().getProjectOptions().get(StringOption.IDE_APK_SELECT_CONFIG);
            if (string != null) {
                String it = string;
                boolean $i$a$-let-ExtractApksTask$CreationAction$configure$22 = false;
                HasConfigurableValuesKt.setDisallowChanges((Property)task.getTargetDeviceSpec(), ((ApkCreationConfig)this.creationConfig).getServices().fileProvider(((ApkCreationConfig)this.creationConfig).getServices().provider((Function0)new Function0<File>(it){
                    final /* synthetic */ String $it;
                    {
                        this.$it = $it;
                        super(0);
                    }

                    public final File invoke() {
                        return new File(this.$it);
                    }
                })));
            }
            task.getTargetDeviceSpec().disallowChanges();
            String multipleDeviceSpec = ((ApkCreationConfig)this.creationConfig).getServices().getProjectOptions().get(StringOption.IDE_APK_SELECT_MULTIPLE_DEVICE_SPECS);
            if (multipleDeviceSpec != null && ($i$a$-let-ExtractApksTask$CreationAction$configure$22 = StringsKt.split$default((CharSequence)multipleDeviceSpec, (String[])(object2 = new String[]{","}), (boolean)false, (int)0, (int)6, null)) != null) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Iterable iterable = $i$a$-let-ExtractApksTask$CreationAction$configure$22;
                boolean $i$f$map2 = false;
                void var9_13 = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
                while (iterator2.hasNext()) {
                    void p0;
                    String string2 = item$iv$iv = iterator2.next();
                    object = destination$iv$iv;
                    boolean bl = false;
                    object.add(((Object)StringsKt.trim((CharSequence)((CharSequence)p0))).toString());
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            List deviceSpecsPaths = list;
            Object[] $i$a$-let-ExtractApksTask$CreationAction$configure$22 = new Object[1];
            object2 = deviceSpecsPaths;
            int n = 0;
            Object[] objectArray = $i$a$-let-ExtractApksTask$CreationAction$configure$22;
            object = task.getMultipleDeviceConfigs();
            boolean $i$f$map = false;
            void $i$f$map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void p0;
                item$iv$iv = (String)item$iv$iv2;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new File((String)p0));
            }
            collection = (List)destination$iv$iv;
            objectArray[n] = collection;
            HasConfigurableValuesKt.fromDisallowChanges((ConfigurableFileCollection)object, $i$a$-let-ExtractApksTask$CreationAction$configure$22);
            task.extractInstant = ((ApkCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.IDE_EXTRACT_INSTANT);
            HasConfigurableValuesKt.setDisallowChanges(task.getApplicationId(), ((ApkCreationConfig)this.creationConfig).getApplicationId());
            String optionalListOfDynamicModulesToInstall = ((ApkCreationConfig)this.creationConfig).getServices().getProjectOptions().get(StringOption.IDE_INSTALL_DYNAMIC_MODULES_LIST);
            object2 = optionalListOfDynamicModulesToInstall;
            if (!(object2 == null || object2.length() == 0)) {
                object2 = new char[1];
                object2[0] = (String)44;
                task.getDynamicModulesToInstall().addAll((Iterable)StringsKt.split$default((CharSequence)optionalListOfDynamicModulesToInstall, (char[])object2, (boolean)false, (int)0, (int)6, null));
            }
            task.getDynamicModulesToInstall().disallowChanges();
            HasConfigurableValuesKt.setDisallowChanges(task.getSetIncludeMetadata(), ((ApkCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.ENABLE_LOCAL_TESTING));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractApksTask$DeviceSpecInfo;", "", "path", "Ljava/nio/file/Path;", "deviceSpec", "Lcom/android/bundle/Devices$DeviceSpec;", "<init>", "(Ljava/nio/file/Path;Lcom/android/bundle/Devices$DeviceSpec;)V", "getPath", "()Ljava/nio/file/Path;", "getDeviceSpec", "()Lcom/android/bundle/Devices$DeviceSpec;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "gradle-core"})
    private static final class DeviceSpecInfo {
        @NotNull
        private final Path path;
        @NotNull
        private final Devices.DeviceSpec deviceSpec;

        public DeviceSpecInfo(@NotNull Path path, @NotNull Devices.DeviceSpec deviceSpec) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)deviceSpec, (String)"deviceSpec");
            this.path = path;
            this.deviceSpec = deviceSpec;
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        @NotNull
        public final Devices.DeviceSpec getDeviceSpec() {
            return this.deviceSpec;
        }

        @NotNull
        public final Path component1() {
            return this.path;
        }

        @NotNull
        public final Devices.DeviceSpec component2() {
            return this.deviceSpec;
        }

        @NotNull
        public final DeviceSpecInfo copy(@NotNull Path path, @NotNull Devices.DeviceSpec deviceSpec) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)deviceSpec, (String)"deviceSpec");
            return new DeviceSpecInfo(path, deviceSpec);
        }

        public static /* synthetic */ DeviceSpecInfo copy$default(DeviceSpecInfo deviceSpecInfo, Path path, Devices.DeviceSpec deviceSpec, int n, Object object) {
            if ((n & 1) != 0) {
                path = deviceSpecInfo.path;
            }
            if ((n & 2) != 0) {
                deviceSpec = deviceSpecInfo.deviceSpec;
            }
            return deviceSpecInfo.copy(path, deviceSpec);
        }

        @NotNull
        public String toString() {
            return "DeviceSpecInfo(path=" + this.path + ", deviceSpec=" + this.deviceSpec + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.path).hashCode();
            result2 = result2 * 31 + this.deviceSpec.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeviceSpecInfo)) {
                return false;
            }
            DeviceSpecInfo deviceSpecInfo = (DeviceSpecInfo)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)deviceSpecInfo.path)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.deviceSpec, (Object)deviceSpecInfo.deviceSpec);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0007R\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0018R\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0018R\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0!X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0018\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0018\u00a8\u0006&"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractApksTask$Params;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "<init>", "()V", "apkSetArchive", "Lorg/gradle/api/file/RegularFileProperty;", "getApkSetArchive", "()Lorg/gradle/api/file/RegularFileProperty;", "multipleDeviceConfigs", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getMultipleDeviceConfigs", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "targetDeviceSpec", "getTargetDeviceSpec", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "deviceSpecToApksLocationMappingFile", "getDeviceSpecToApksLocationMappingFile", "extractInstant", "Lorg/gradle/api/provider/Property;", "", "getExtractInstant", "()Lorg/gradle/api/provider/Property;", "apksFromBundleIdeModel", "getApksFromBundleIdeModel", "applicationId", "", "getApplicationId", "variantName", "getVariantName", "optionalListOfDynamicModulesToInstall", "Lorg/gradle/api/provider/ListProperty;", "getOptionalListOfDynamicModulesToInstall", "()Lorg/gradle/api/provider/ListProperty;", "setIncludeMetadata", "getSetIncludeMetadata", "gradle-core"})
    public static abstract class Params
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract RegularFileProperty getApkSetArchive();

        @NotNull
        public abstract ConfigurableFileCollection getMultipleDeviceConfigs();

        @NotNull
        public abstract RegularFileProperty getTargetDeviceSpec();

        @NotNull
        public abstract DirectoryProperty getOutputDir();

        @NotNull
        public abstract RegularFileProperty getDeviceSpecToApksLocationMappingFile();

        @NotNull
        public abstract Property<Boolean> getExtractInstant();

        @NotNull
        public abstract RegularFileProperty getApksFromBundleIdeModel();

        @NotNull
        public abstract Property<String> getApplicationId();

        @NotNull
        public abstract Property<String> getVariantName();

        @NotNull
        public abstract ListProperty<String> getOptionalListOfDynamicModulesToInstall();

        @NotNull
        public abstract Property<Boolean> getSetIncludeMetadata();
    }
}

