/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.SingleArtifact;
import com.android.build.gradle.internal.component.ApplicationCreationConfig;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.ExtractVersionControlInfoTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.tools.idea.insights.proto.BuildStamp;
import com.android.tools.idea.insights.proto.RepositoryInfo;
import com.android.tools.idea.insights.proto.VersionControlSystem;
import com.android.utils.FileUtils;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.METADATA)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractVersionControlInfoTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "<init>", "()V", "gitHeadFile", "Lorg/gradle/api/file/RegularFileProperty;", "getGitHeadFile", "()Lorg/gradle/api/file/RegularFileProperty;", "gitRefsDir", "Lorg/gradle/api/file/DirectoryProperty;", "getGitRefsDir", "()Lorg/gradle/api/file/DirectoryProperty;", "vcInfoFile", "getVcInfoFile", "enabledByDefault", "Lorg/gradle/api/provider/Property;", "", "getEnabledByDefault", "()Lorg/gradle/api/provider/Property;", "doTaskAction", "", "writeErrorInOutput", "reason", "Lcom/android/tools/idea/insights/proto/BuildStamp$GenerateErrorReason;", "missingGitFileMessage", "", "filePath", "CreationAction", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nExtractVersionControlInfoTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractVersionControlInfoTask.kt\ncom/android/build/gradle/internal/tasks/ExtractVersionControlInfoTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1#2:166\n*E\n"})
public abstract class ExtractVersionControlInfoTask
extends NonIncrementalTask {
    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @Optional
    @NotNull
    public abstract RegularFileProperty getGitHeadFile();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    @NotNull
    public abstract DirectoryProperty getGitRefsDir();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getVcInfoFile();

    @Input
    @NotNull
    public abstract Property<Boolean> getEnabledByDefault();

    @Override
    protected void doTaskAction() {
        String string;
        Object branchFile;
        Object object;
        if (!((RegularFile)this.getGitHeadFile().get()).getAsFile().getParentFile().exists()) {
            String gitMissingMessage = "When VCS tagging is enabled (which is by default in release builds), the root project must be initialized with Git. Currently, Git is the only supported VCS for this feature.";
            if (((Boolean)this.getEnabledByDefault().get()).booleanValue()) {
                this.getLogger().debug(gitMissingMessage);
                this.writeErrorInOutput(BuildStamp.GenerateErrorReason.NO_SUPPORTED_VCS_FOUND);
                return;
            }
            throw new RuntimeException(gitMissingMessage);
        }
        if (!((RegularFile)this.getGitHeadFile().get()).getAsFile().exists()) {
            String headFileMissing = this.missingGitFileMessage("HEAD");
            if (((Boolean)this.getEnabledByDefault().get()).booleanValue()) {
                this.getLogger().debug(headFileMissing);
                this.writeErrorInOutput(BuildStamp.GenerateErrorReason.NO_VALID_GIT_FOUND);
                return;
            }
            throw new RuntimeException(headFileMissing);
        }
        File file = ((RegularFile)this.getGitHeadFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        String headFileContents = ((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)file, null, (int)1, null))).toString();
        if (StringsKt.startsWith$default((String)headFileContents, (String)"ref: ", (boolean)false, (int)2, null)) {
            String branchName = StringsKt.substringAfter$default((String)headFileContents, (String)"ref: refs/heads/", null, (int)2, null);
            object = new String[]{branchName};
            branchFile = FileUtils.join((File)((Directory)this.getGitRefsDir().get()).getAsFile(), (String[])object);
            if (branchFile == null || !((File)branchFile).exists()) {
                String branchFileMissing = this.missingGitFileMessage("refs/heads/" + branchName);
                if (((Boolean)this.getEnabledByDefault().get()).booleanValue()) {
                    this.getLogger().debug(branchFileMissing);
                    this.writeErrorInOutput(BuildStamp.GenerateErrorReason.NO_VALID_GIT_FOUND);
                    return;
                }
                throw new RuntimeException(branchFileMissing);
            }
            string = ((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)branchFile, null, (int)1, null))).toString();
        } else {
            string = headFileContents;
        }
        String sha = string;
        branchFile = RepositoryInfo.newBuilder();
        RepositoryInfo.Builder $this$doTaskAction_u24lambda_u240 = branchFile;
        boolean bl = false;
        $this$doTaskAction_u24lambda_u240.setSystem(VersionControlSystem.GIT);
        $this$doTaskAction_u24lambda_u240.setLocalRootPath("$PROJECT_DIR");
        $this$doTaskAction_u24lambda_u240.setRevision(sha);
        Object repositoryInfoBuilder = branchFile;
        Object $this$doTaskAction_u24lambda_u241 = object = BuildStamp.newBuilder();
        boolean bl2 = false;
        ((BuildStamp.Builder)$this$doTaskAction_u24lambda_u241).addRepositories(((RepositoryInfo.Builder)repositoryInfoBuilder).build());
        Object versionControlInfoBuilder = object;
        File file2 = ((RegularFile)this.getVcInfoFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAsFile(...)");
        String string2 = TextFormat.printer().printToString((MessageOrBuilder)((BuildStamp.Builder)versionControlInfoBuilder).build());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"printToString(...)");
        FilesKt.writeText$default((File)file2, (String)string2, null, (int)2, null);
    }

    private final void writeErrorInOutput(BuildStamp.GenerateErrorReason reason) {
        BuildStamp.Builder builder;
        BuildStamp.Builder $this$writeErrorInOutput_u24lambda_u242 = builder = BuildStamp.newBuilder();
        boolean bl = false;
        $this$writeErrorInOutput_u24lambda_u242.setGenerateErrorReason(reason);
        BuildStamp.Builder versionControlInfoBuilder = builder;
        File file = ((RegularFile)this.getVcInfoFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        String string = TextFormat.printer().printToString((MessageOrBuilder)versionControlInfoBuilder.build());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"printToString(...)");
        FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
    }

    private final String missingGitFileMessage(String filePath) {
        return "When VCS tagging is enabled (which is by default in release builds), the project must be initialized with Git. The file '.git/" + filePath + "' in the project root is missing, so the version control metadata cannot be included in the APK.";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractVersionControlInfoTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ExtractVersionControlInfoTask;", "Lcom/android/build/gradle/internal/component/ApplicationCreationConfig;", "creationConfig", "<init>", "(Lcom/android/build/gradle/internal/component/ApplicationCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "configure", "task", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ExtractVersionControlInfoTask, ApplicationCreationConfig> {
        public CreationAction(@NotNull ApplicationCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig, false, 2, null);
        }

        @Override
        @NotNull
        public String getName() {
            return ((ApplicationCreationConfig)this.creationConfig).computeTaskNameInternal("extract", "VersionControlInfo");
        }

        @Override
        @NotNull
        public Class<ExtractVersionControlInfoTask> getType() {
            return ExtractVersionControlInfoTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ExtractVersionControlInfoTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((ApplicationCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).on((Artifact.Single)SingleArtifact.VERSION_CONTROL_INFO_FILE.INSTANCE);
        }

        @Override
        public void configure(@NotNull ExtractVersionControlInfoTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            File rootDir = ((ApplicationCreationConfig)this.creationConfig).getServices().getProjectInfo().getRootDir();
            String[] stringArray = new String[]{".git", "HEAD"};
            task.getGitHeadFile().set(FileUtils.join((File)rootDir, (String[])stringArray));
            task.getGitHeadFile().disallowChanges();
            stringArray = new String[]{".git", "refs", "heads"};
            task.getGitRefsDir().set(FileUtils.join((File)rootDir, (String[])stringArray));
            task.getGitRefsDir().disallowChanges();
            HasConfigurableValuesKt.setDisallowChanges(task.getEnabledByDefault(), ((ApplicationCreationConfig)this.creationConfig).getIncludeVcsInfo() == null);
        }
    }
}

