/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.processor.transform.resource;

import com.android.tools.build.jetifier.core.type.JavaType;
import com.android.tools.build.jetifier.core.type.PackageName;
import com.android.tools.build.jetifier.core.utils.Log;
import com.android.tools.build.jetifier.processor.archive.ArchiveFile;
import com.android.tools.build.jetifier.processor.transform.TransformationContext;
import com.android.tools.build.jetifier.processor.transform.Transformer;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J6\u0010\u0012\u001a\u00020\u000b2\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u0018\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018H\u0002J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/build/jetifier/processor/transform/resource/XmlResourcesTransformer;", "Lcom/android/tools/build/jetifier/processor/transform/Transformer;", "context", "Lcom/android/tools/build/jetifier/processor/transform/TransformationContext;", "(Lcom/android/tools/build/jetifier/processor/transform/TransformationContext;)V", "packagePatterns", "", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "patterns", "canTransform", "", "file", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveFile;", "getCharset", "Ljava/nio/charset/Charset;", "data", "", "replaceWithPatterns", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "mappingFunction", "Lkotlin/Function1;", "", "rewritePackage", "packageName", "archiveName", "rewriteType", "typeName", "runTransform", "", "Companion", "jetifier-processor"})
public final class XmlResourcesTransformer
implements Transformer {
    private final List<Pattern> patterns;
    private final List<Pattern> packagePatterns;
    private final TransformationContext context;
    @NotNull
    public static final String TAG = "XmlResourcesTransformer";
    public static final int PATTERN_TYPE_GROUP = 1;
    @NotNull
    public static final String MANIFEST_FILE_NAME = "AndroidManifest.xml";
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean canTransform(@NotNull ArchiveFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return file.isXmlFile() && !file.isPomFile();
    }

    @Override
    public void runTransform(@NotNull ArchiveFile file) {
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        boolean isManifestFile = StringsKt.equals((String)file.getFileName(), (String)MANIFEST_FILE_NAME, (boolean)true);
        Charset charset = this.getCharset(file.getData());
        byte[] byArray = file.getData();
        Object object = stringBuilder;
        Object object2 = stringBuilder;
        String string = new String(byArray, charset);
        ((StringBuilder)object)(string);
        StringBuilder sb = object2;
        boolean changesDone2 = this.replaceWithPatterns(sb, this.patterns, (Function1<? super String, String>)((Function1)new Function1<String, String>(this){
            final /* synthetic */ XmlResourcesTransformer this$0;

            @NotNull
            public final String invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return XmlResourcesTransformer.access$rewriteType(this.this$0, it);
            }
            {
                this.this$0 = xmlResourcesTransformer;
                super(1);
            }
        }));
        if (isManifestFile && this.context.getRewritingSupportLib()) {
            boolean bl = changesDone2 = this.replaceWithPatterns(sb, this.packagePatterns, (Function1<? super String, String>)((Function1)new Function1<String, String>(this){
                final /* synthetic */ XmlResourcesTransformer this$0;

                @NotNull
                public final String invoke(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return XmlResourcesTransformer.access$rewritePackage(this.this$0, it, XmlResourcesTransformer.access$getContext$p(this.this$0).getLibraryName());
                }
                {
                    this.this$0 = xmlResourcesTransformer;
                    super(1);
                }
            })) || changesDone2;
        }
        if (changesDone2) {
            String string2 = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sb.toString()");
            String string3 = string2;
            object2 = file;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray2 = string4.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
            object = byArray2;
            ((ArchiveFile)object2).setNewData((byte[])object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Charset getCharset(@NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Object object = data;
        object = new ByteArrayInputStream((byte[])object);
        Throwable throwable = null;
        try {
            XMLStreamReader xmlReader;
            ByteArrayInputStream it = (ByteArrayInputStream)object;
            XMLStreamReader xMLStreamReader = xmlReader = XMLInputFactory.newInstance().createXMLStreamReader(it);
            Intrinsics.checkExpressionValueIsNotNull((Object)xMLStreamReader, (String)"xmlReader");
            if (xMLStreamReader.getEncoding() == null) {
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
                Charset charset2 = charset;
                return charset2;
            }
            Charset result = Charset.forName(xmlReader.getEncoding());
            if (result == null) {
                Log.INSTANCE.e(TAG, "Failed to find charset for encoding '%s'", new Object[]{xmlReader.getEncoding()});
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
                Charset charset3 = charset;
                return charset3;
            }
            Charset charset = result;
            return charset;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private final boolean replaceWithPatterns(StringBuilder sb, List<Pattern> patterns, Function1<? super String, String> mappingFunction) {
        boolean changesDone2 = false;
        for (Pattern pattern : patterns) {
            int lastSeenChar = 0;
            String processedInput = sb.toString();
            sb.setLength(0);
            Matcher matcher = pattern.matcher(processedInput);
            while (matcher.find()) {
                String string;
                if (lastSeenChar < matcher.start()) {
                    sb.append(processedInput, lastSeenChar, matcher.start());
                }
                String toReplace = matcher.group(1);
                String matched = matcher.group(0);
                String string2 = toReplace;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"toReplace");
                String replacement = (String)mappingFunction.invoke((Object)string2);
                changesDone2 = changesDone2 || Intrinsics.areEqual((Object)replacement, (Object)toReplace) ^ true;
                int localStart = matcher.start(1) - matcher.start();
                int localEnd = matcher.end(1) - matcher.start();
                Intrinsics.checkExpressionValueIsNotNull((Object)matched, (String)"matched");
                String string3 = string;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String result = ((Object)StringsKt.replaceRange((CharSequence)string3, (int)localStart, (int)localEnd, (CharSequence)replacement)).toString();
                sb.append(result);
                lastSeenChar = matcher.end();
            }
            if (lastSeenChar > processedInput.length() - 1) continue;
            sb.append(processedInput, lastSeenChar, processedInput.length());
        }
        return changesDone2;
    }

    private final String rewriteType(String typeName) {
        JavaType type = JavaType.Companion.fromDotVersion(typeName);
        JavaType result = this.context.getTypeRewriter().rewriteType(type);
        if (result != null) {
            return result.toDotNotation();
        }
        if (!this.context.getUseFallbackIfTypeIsMissing()) {
            this.context.reportNoMappingFoundFailure();
        }
        return typeName;
    }

    private final String rewritePackage(String packageName, String archiveName) {
        PackageName pckg = PackageName.Companion.fromDotVersion(packageName);
        PackageName result = this.context.getConfig().getPackageMap().getPackageFor(pckg, archiveName);
        if (result != null) {
            return result.toDotNotation();
        }
        if (this.context.getUseFallbackIfTypeIsMissing()) {
            Log.INSTANCE.i(TAG, "No mapping for package: '%s' in artifact: '%s' - using identity", new Object[]{pckg, archiveName});
            return packageName;
        }
        this.context.reportNoPackageMappingFoundFailure();
        Log.INSTANCE.e(TAG, "No mapping for package: '%s' in artifact: '%s'", new Object[]{pckg, archiveName});
        return packageName;
    }

    public XmlResourcesTransformer(@NotNull TransformationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.patterns = CollectionsKt.listOf((Object[])new Pattern[]{Pattern.compile("</?([a-zA-Z0-9.]+)"), Pattern.compile("<view[^>]*class=\"([a-zA-Z0-9.$_]+)\"[^>]*>")});
        this.packagePatterns = CollectionsKt.listOf((Object)Pattern.compile("<manifest[^>]*package=\"([a-zA-Z0-9._]+)\"[^>]*>"));
    }

    @NotNull
    public static final /* synthetic */ String access$rewriteType(XmlResourcesTransformer $this, @NotNull String typeName) {
        return $this.rewriteType(typeName);
    }

    @NotNull
    public static final /* synthetic */ String access$rewritePackage(XmlResourcesTransformer $this, @NotNull String packageName, @NotNull String archiveName) {
        return $this.rewritePackage(packageName, archiveName);
    }

    @NotNull
    public static final /* synthetic */ TransformationContext access$getContext$p(XmlResourcesTransformer $this) {
        return $this.context;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/build/jetifier/processor/transform/resource/XmlResourcesTransformer$Companion;", "", "()V", "MANIFEST_FILE_NAME", "", "PATTERN_TYPE_GROUP", "", "TAG", "jetifier-processor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

