/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.processor.archive;

import com.android.tools.build.jetifier.core.utils.Log;
import com.android.tools.build.jetifier.processor.archive.ArchiveFile;
import com.android.tools.build.jetifier.processor.archive.ArchiveItem;
import com.android.tools.build.jetifier.processor.archive.ArchiveItemVisitor;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 )2\u00020\u0001:\u0002()B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0001J\u000e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0001J\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0003J\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#H\u0016J\u000e\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020\u0003J\u000e\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020\u0003R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006*"}, d2={"Lcom/android/tools/build/jetifier/processor/archive/Archive;", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveItem;", "relativePath", "Ljava/nio/file/Path;", "files", "", "(Ljava/nio/file/Path;Ljava/util/List;)V", "_files", "", "fileName", "", "getFileName", "()Ljava/lang/String;", "getFiles", "()Ljava/util/List;", "getRelativePath", "()Ljava/nio/file/Path;", "targetPath", "wasChanged", "", "getWasChanged", "()Z", "accept", "", "visitor", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveItemVisitor;", "addItem", "item", "removeItem", "setTargetPath", "path", "writeSelf", "Ljava/io/File;", "writeSelfTo", "outputStream", "Ljava/io/OutputStream;", "writeSelfToDir", "outputDirPath", "writeSelfToFile", "outputPath", "Builder", "Companion", "jetifier-processor"})
public final class Archive
implements ArchiveItem {
    private final List<ArchiveItem> _files;
    @NotNull
    private final List<ArchiveItem> files;
    @NotNull
    private final String fileName;
    private Path targetPath;
    @NotNull
    private final Path relativePath;
    @NotNull
    private static final List<String> ARCHIVE_EXTENSIONS;
    @NotNull
    public static final String TAG = "Archive";
    public static final Companion Companion;

    @NotNull
    public final List<ArchiveItem> getFiles() {
        return this.files;
    }

    @Override
    @NotNull
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public boolean getWasChanged() {
        boolean bl;
        block3: {
            Iterable $receiver$iv = this.files;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    ArchiveItem it = (ArchiveItem)element$iv;
                    if (!it.getWasChanged()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void setTargetPath(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.targetPath = path;
    }

    @Override
    public void accept(@NotNull ArchiveItemVisitor visitor) {
        Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
        visitor.visit(this);
    }

    @NotNull
    public final File writeSelfToDir(@NotNull Path outputDirPath) throws IOException {
        Path outputPath;
        Intrinsics.checkParameterIsNotNull((Object)outputDirPath, (String)"outputDirPath");
        Path path = outputPath = Paths.get(((Object)outputDirPath).toString(), this.getFileName());
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"outputPath");
        return this.writeSelfToFile(path);
    }

    @NotNull
    public final File writeSelf() {
        return this.writeSelfToFile(this.targetPath);
    }

    public final void removeItem(@NotNull ArchiveItem item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        this._files.remove(item);
    }

    public final void addItem(@NotNull ArchiveItem item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        this._files.add(item);
    }

    @NotNull
    public final File writeSelfToFile(@NotNull Path outputPath) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)outputPath, (String)"outputPath");
        if (Files.exists(outputPath, new LinkOption[0])) {
            Log.INSTANCE.i(TAG, "Deleting old output file", new Object[0]);
            Files.delete(outputPath);
        }
        if (outputPath.getParent() != null) {
            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        }
        Log.INSTANCE.i(TAG, "Writing archive: %s", new Object[]{outputPath.toUri()});
        File file = outputPath.toFile();
        Files.createFile(outputPath, new FileAttribute[0]);
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));
        this.writeSelfTo(stream);
        stream.close();
        File file2 = file;
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
        return file2;
    }

    @Override
    public void writeSelfTo(@NotNull OutputStream outputStream) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
        ZipOutputStream out = new ZipOutputStream(outputStream);
        for (ArchiveItem file : this.files) {
            Log.INSTANCE.v(TAG, "Writing file: %s", new Object[]{file.getRelativePath()});
            String path = StringsKt.replace$default((String)((Object)file.getRelativePath()).toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
            ZipEntry entry = new ZipEntry(path);
            entry.setLastModifiedTime(FileTime.from(Instant.now()));
            out.putNextEntry(entry);
            file.writeSelfTo(out);
            out.closeEntry();
        }
        out.finish();
    }

    @Override
    @NotNull
    public Path getRelativePath() {
        return this.relativePath;
    }

    public Archive(@NotNull Path relativePath, @NotNull List<? extends ArchiveItem> files) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        this.relativePath = relativePath;
        this._files = CollectionsKt.toMutableList((Collection)files);
        this.files = this._files;
        this.fileName = ((Object)this.getRelativePath().getFileName()).toString();
        this.targetPath = this.getRelativePath();
    }

    static {
        Companion = new Companion(null);
        ARCHIVE_EXTENSIONS = CollectionsKt.listOf((Object[])new String[]{".jar", ".zip", ".aar"});
    }

    @Override
    public boolean isPomFile() {
        return ArchiveItem.DefaultImpls.isPomFile(this);
    }

    @Override
    public boolean isClassFile() {
        return ArchiveItem.DefaultImpls.isClassFile(this);
    }

    @Override
    public boolean isXmlFile() {
        return ArchiveItem.DefaultImpls.isXmlFile(this);
    }

    @Override
    public boolean isProGuardFile() {
        return ArchiveItem.DefaultImpls.isProGuardFile(this);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ \u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/build/jetifier/processor/archive/Archive$Builder;", "", "()V", "extract", "Lcom/android/tools/build/jetifier/processor/archive/Archive;", "archiveFile", "Ljava/io/File;", "recursive", "", "extractArchive", "inputStream", "Ljava/io/InputStream;", "relativePath", "Ljava/nio/file/Path;", "extractFile", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveFile;", "zipIn", "Ljava/util/zip/ZipInputStream;", "isArchive", "zipEntry", "Ljava/util/zip/ZipEntry;", "jetifier-processor"})
    public static final class Builder {
        public static final Builder INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Archive extract(@NotNull File archiveFile, boolean recursive) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)archiveFile, (String)"archiveFile");
            Log.INSTANCE.i(Archive.TAG, "Extracting: %s", new Object[]{archiveFile.getAbsolutePath()});
            FileInputStream inputStream = new FileInputStream(archiveFile);
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)closeable;
                InputStream inputStream2 = it;
                Path path = archiveFile.toPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"archiveFile.toPath()");
                Archive archive = INSTANCE.extractArchive(inputStream2, path, recursive);
                return archive;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Archive extract$default(Builder builder, File file, boolean bl, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                bl = true;
            }
            return builder.extract(file, bl);
        }

        private final Archive extractArchive(InputStream inputStream, Path relativePath, boolean recursive) throws IOException {
            ZipInputStream zipIn = new ZipInputStream(inputStream);
            List files = new ArrayList();
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    Path entryPath = Paths.get(entry.getName(), new String[0]);
                    if (this.isArchive(entry) && recursive) {
                        Log.INSTANCE.i(Archive.TAG, "Extracting nested: %s", new Object[]{entryPath});
                        InputStream inputStream2 = zipIn;
                        Path path = entryPath;
                        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"entryPath");
                        files.add(this.extractArchive(inputStream2, path, recursive));
                    } else {
                        Path path = entryPath;
                        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"entryPath");
                        files.add(this.extractFile(zipIn, path));
                    }
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
            return new Archive(relativePath, CollectionsKt.toList((Iterable)files));
        }

        private final ArchiveFile extractFile(ZipInputStream zipIn, Path relativePath) throws IOException {
            Log.INSTANCE.v(Archive.TAG, "Extracting archive: %s", new Object[]{relativePath});
            byte[] data = ByteStreamsKt.readBytes$default((InputStream)zipIn, (int)0, (int)1, null);
            return new ArchiveFile(relativePath, data);
        }

        private final boolean isArchive(ZipEntry zipEntry) {
            boolean bl;
            block3: {
                Iterable $receiver$iv = Companion.getARCHIVE_EXTENSIONS();
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        String it = (String)element$iv;
                        String string = zipEntry.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"zipEntry.name");
                        if (!StringsKt.endsWith((String)string, (String)it, (boolean)true)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private Builder() {
        }

        static {
            Builder builder;
            INSTANCE = builder = new Builder();
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/build/jetifier/processor/archive/Archive$Companion;", "", "()V", "ARCHIVE_EXTENSIONS", "", "", "getARCHIVE_EXTENSIONS", "()Ljava/util/List;", "TAG", "jetifier-processor"})
    public static final class Companion {
        @NotNull
        public final List<String> getARCHIVE_EXTENSIONS() {
            return ARCHIVE_EXTENSIONS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

