/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.manifmerger.Actions;
import com.android.manifmerger.AttributeModel;
import com.android.manifmerger.AttributeOperationType;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.NodeOperationType;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import com.android.manifmerger.XmlNode;
import com.android.utils.XmlUtils;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PostValidator {
    public static void validate(XmlDocument xmlDocument, MergingReport.Builder mergingReport) {
        Preconditions.checkNotNull((Object)xmlDocument);
        Preconditions.checkNotNull((Object)mergingReport);
        PostValidator.enforceAndroidNamespaceDeclaration(xmlDocument);
        PostValidator.reOrderElements(xmlDocument.getRootNode());
        PostValidator.validate(xmlDocument.getRootNode(), mergingReport.getActionRecorder().build(), mergingReport);
    }

    private static void enforceAndroidNamespaceDeclaration(XmlDocument xmlDocument) {
        Element rootElement = xmlDocument.getRootNode().getXml();
        XmlUtils.lookupNamespacePrefix((Node)rootElement, (String)"http://schemas.android.com/apk/res/android", (String)"android", (boolean)true);
    }

    protected static void enforceToolsNamespaceDeclaration(XmlDocument xmlDocument) {
        Element rootElement = xmlDocument.getRootNode().getXml();
        if ("tools".equals(XmlUtils.lookupNamespacePrefix((Node)rootElement, (String)"http://schemas.android.com/tools", null, (boolean)false))) {
            return;
        }
        if (PostValidator.elementUsesNamespacePrefix(rootElement, "tools")) {
            XmlUtils.lookupNamespacePrefix((Node)rootElement, (String)"http://schemas.android.com/tools", (String)"tools", (boolean)true);
        }
    }

    static boolean elementUsesNamespacePrefix(Element element, String prefix) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node attribute = namedNodeMap.item(i);
            if (!prefix.equals(attribute.getPrefix())) continue;
            return true;
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element) || !PostValidator.elementUsesNamespacePrefix((Element)childNode, prefix)) continue;
            return true;
        }
        return false;
    }

    private static void reOrderElements(XmlElement xmlElement) {
        PostValidator.reOrderActivityAlias(xmlElement);
        PostValidator.reOrderApplication(xmlElement);
        PostValidator.reOrderUsesSdk(xmlElement);
    }

    private static void reOrderActivityAlias(XmlElement xmlElement) {
        Optional<XmlElement> element = xmlElement.getNodeByTypeAndKey(ManifestModel.NodeTypes.APPLICATION, null);
        if (!element.isPresent()) {
            return;
        }
        XmlElement applicationElement = (XmlElement)element.get();
        ImmutableList<XmlElement> activityAliasElements = applicationElement.getAllNodesByType(ManifestModel.NodeTypes.ACTIVITY_ALIAS);
        for (XmlElement activityAlias : activityAliasElements) {
            String targetActivity;
            Optional<XmlAttribute> attribute = activityAlias.getAttribute(XmlNode.fromNSName("http://schemas.android.com/apk/res/android", "android", "targetActivity"));
            if (!attribute.isPresent() || !(element = applicationElement.getNodeByTypeAndKey(ManifestModel.NodeTypes.ACTIVITY, targetActivity = ((XmlAttribute)attribute.get()).getValue())).isPresent()) continue;
            XmlElement activity = (XmlElement)element.get();
            Node nextSibling = activity.getXml().getNextSibling();
            List<Node> comments = XmlElement.getLeadingComments(activityAlias.getXml());
            if (!comments.isEmpty() && !comments.get(0).equals(nextSibling)) {
                for (Node comment : comments) {
                    applicationElement.getXml().removeChild(comment);
                    applicationElement.getXml().insertBefore(comment, nextSibling);
                }
            }
            if (activityAlias.getXml().equals(nextSibling) || !comments.isEmpty() && comments.get(0).equals(nextSibling)) continue;
            applicationElement.getXml().removeChild(activityAlias.getXml());
            applicationElement.getXml().insertBefore(activityAlias.getXml(), nextSibling);
        }
    }

    private static void reOrderApplication(XmlElement xmlElement) {
        Optional<XmlElement> element = xmlElement.getNodeByTypeAndKey(ManifestModel.NodeTypes.APPLICATION, null);
        if (!element.isPresent()) {
            return;
        }
        XmlElement applicationElement = (XmlElement)element.get();
        List<Node> comments = XmlElement.getLeadingComments(applicationElement.getXml());
        for (Node comment : comments) {
            xmlElement.getXml().removeChild(comment);
            xmlElement.getXml().appendChild(comment);
        }
        xmlElement.getXml().removeChild(applicationElement.getXml());
        xmlElement.getXml().appendChild(applicationElement.getXml());
    }

    private static void reOrderUsesSdk(XmlElement xmlElement) {
        Optional<XmlElement> element = xmlElement.getNodeByTypeAndKey(ManifestModel.NodeTypes.USES_SDK, null);
        if (!element.isPresent()) {
            return;
        }
        XmlElement usesSdk = (XmlElement)element.get();
        Node firstChild = xmlElement.getXml().getFirstChild();
        if (firstChild == usesSdk.getXml()) {
            return;
        }
        List<Node> comments = XmlElement.getLeadingComments(usesSdk.getXml());
        for (Node comment : comments) {
            xmlElement.getXml().removeChild(comment);
            xmlElement.getXml().insertBefore(comment, firstChild);
        }
        xmlElement.getXml().removeChild(usesSdk.getXml());
        xmlElement.getXml().insertBefore(usesSdk.getXml(), firstChild);
    }

    private static void validate(XmlElement xmlElement, Actions actions, MergingReport.Builder mergingReport) {
        NodeOperationType operationType = xmlElement.getOperationType();
        switch (operationType) {
            case REPLACE: {
                if (PostValidator.isNodeOperationPresent(xmlElement, actions, Actions.ActionType.REJECTED)) break;
                mergingReport.addMessage(xmlElement, MergingReport.Record.Severity.WARNING, String.format("%1$s was tagged at %2$s:%3$d to replace another declaration but no other declaration present", xmlElement.getId(), xmlElement.getDocument().getSourceFile().print(true), xmlElement.getPosition().getStartLine() + 1));
                break;
            }
            case REMOVE: 
            case REMOVE_ALL: {
                if (PostValidator.isNodeOperationPresent(xmlElement, actions, Actions.ActionType.REJECTED)) break;
                mergingReport.addMessage(xmlElement, MergingReport.Record.Severity.WARNING, String.format("%1$s was tagged at %2$s:%3$d to remove other declarations but no other declaration present", xmlElement.getId(), xmlElement.getDocument().getSourceFile().print(true), xmlElement.getPosition().getStartLine() + 1));
            }
        }
        PostValidator.validateAttributes(xmlElement, actions, mergingReport);
        PostValidator.validateAndroidAttributes(xmlElement, mergingReport);
        for (XmlElement child : xmlElement.getMergeableElements()) {
            PostValidator.validate(child, actions, mergingReport);
        }
    }

    private static void validateAttributes(XmlElement xmlElement, Actions actions, MergingReport.Builder mergingReport) {
        Collection<Map.Entry<XmlNode.NodeName, AttributeOperationType>> attributeOperations = xmlElement.getAttributeOperations();
        for (Map.Entry<XmlNode.NodeName, AttributeOperationType> attributeOperation : attributeOperations) {
            switch (attributeOperation.getValue()) {
                case REMOVE: {
                    if (PostValidator.isAttributeOperationPresent(xmlElement, attributeOperation, actions, Actions.ActionType.REJECTED)) break;
                    mergingReport.addMessage(xmlElement, MergingReport.Record.Severity.WARNING, String.format("%1$s@%2$s was tagged at %3$s:%4$d to remove other declarations but no other declaration present", xmlElement.getId(), attributeOperation.getKey(), xmlElement.getDocument().getSourceFile().print(true), xmlElement.getPosition().getStartLine() + 1));
                    break;
                }
                case REPLACE: {
                    if (PostValidator.isAttributeOperationPresent(xmlElement, attributeOperation, actions, Actions.ActionType.REJECTED)) break;
                    mergingReport.addMessage(xmlElement, MergingReport.Record.Severity.WARNING, String.format("%1$s@%2$s was tagged at %3$s:%4$d to replace other declarations but no other declaration present", xmlElement.getId(), attributeOperation.getKey(), xmlElement.getDocument().getSourceFile().print(true), xmlElement.getPosition().getStartLine() + 1));
                }
            }
        }
    }

    private static boolean isNodeOperationPresent(XmlElement xmlElement, Actions actions, Actions.ActionType action) {
        for (Actions.NodeRecord nodeRecord : actions.getNodeRecords(xmlElement.getId())) {
            if (nodeRecord.getActionType() != action) continue;
            return true;
        }
        return false;
    }

    private static boolean isAttributeOperationPresent(XmlElement xmlElement, Map.Entry<XmlNode.NodeName, AttributeOperationType> attributeOperation, Actions actions, Actions.ActionType action) {
        for (Actions.AttributeRecord attributeRecord : actions.getAttributeRecords(xmlElement.getId(), attributeOperation.getKey())) {
            if (attributeRecord.getActionType() != action) continue;
            return true;
        }
        return false;
    }

    private static void validateAndroidAttributes(XmlElement xmlElement, MergingReport.Builder mergingReport) {
        for (XmlAttribute xmlAttribute : xmlElement.getAttributes()) {
            AttributeModel.Validator onWriteValidator;
            if (xmlAttribute.getModel() == null || (onWriteValidator = xmlAttribute.getModel().getOnWriteValidator()) == null) continue;
            onWriteValidator.validates(mergingReport, xmlAttribute, xmlAttribute.getValue());
        }
    }
}

