/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.manifmerger.DocumentModel;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.OrphanXmlElement;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class XmlNode {
    protected static final Function<Node, String> NODE_TO_NAME = Node::getNodeName;
    private final Supplier<NodeKey> mOriginalId = Suppliers.memoize(this::getId);

    public synchronized NodeKey getOriginalId() {
        return this.mOriginalId.get();
    }

    public abstract NodeKey getId();

    public abstract SourcePosition getPosition();

    public abstract SourceFile getSourceFile();

    public SourceFilePosition getSourceFilePosition() {
        return new SourceFilePosition(this.getSourceFile(), this.getPosition());
    }

    public abstract Node getXml();

    public abstract NodeName getName();

    public static NodeName unwrapName(Node node) {
        return node.getNamespaceURI() == null ? new Name(node.getNodeName()) : new NamespaceAwareName(node);
    }

    public static NodeName fromXmlName(String name) {
        if (name.contains(":")) {
            String prefix = name.substring(0, name.indexOf(58));
            return new NamespaceAwareName("xmlns".equals(prefix) ? "http://www.w3.org/2000/xmlns/" : "http://schemas.android.com/apk/res/android", prefix, name.substring(name.indexOf(58) + 1));
        }
        return new Name(name);
    }

    public static NodeName fromNSName(String namespaceUri, String prefix, String localName) {
        return new NamespaceAwareName(namespaceUri, prefix, localName);
    }

    public String printPosition() {
        return this.getSourceFilePosition().print(true);
    }

    public static class NodeKey {
        private final String mKey;

        NodeKey(String key) {
            this.mKey = key;
        }

        public static NodeKey fromXml(Element element, DocumentModel<ManifestModel.NodeTypes> model) {
            return new OrphanXmlElement(element, model).getId();
        }

        public String toString() {
            return this.mKey;
        }

        public boolean equals(Object o) {
            return o instanceof NodeKey && ((NodeKey)o).mKey.equals(this.mKey);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.mKey});
        }
    }

    public static final class NamespaceAwareName
    implements NodeName {
        private final String mNamespaceURI;
        private final String mPrefix;
        private final String mLocalName;

        private NamespaceAwareName(Node node) {
            this.mNamespaceURI = (String)Preconditions.checkNotNull((Object)node.getNamespaceURI());
            this.mPrefix = (String)Preconditions.checkNotNull((Object)node.getPrefix());
            this.mLocalName = (String)Preconditions.checkNotNull((Object)node.getLocalName());
        }

        private NamespaceAwareName(String namespaceURI, String prefix, String localName) {
            this.mNamespaceURI = (String)Preconditions.checkNotNull((Object)namespaceURI);
            this.mPrefix = (String)Preconditions.checkNotNull((Object)prefix);
            this.mLocalName = (String)Preconditions.checkNotNull((Object)localName);
        }

        @Override
        public boolean isInNamespace(String namespaceURI) {
            return this.mNamespaceURI.equals(namespaceURI);
        }

        @Override
        public void addToNode(Element to, String withValue) {
            to.setAttributeNS(this.mNamespaceURI, this.mPrefix + ":" + this.mLocalName, withValue);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.mNamespaceURI, this.mLocalName});
        }

        public boolean equals(Object o) {
            return o instanceof NamespaceAwareName && ((NamespaceAwareName)o).mLocalName.equals(this.mLocalName) && ((NamespaceAwareName)o).mNamespaceURI.equals(this.mNamespaceURI);
        }

        public String toString() {
            return this.mPrefix + ":" + this.mLocalName;
        }

        @Override
        public String getLocalName() {
            return this.mLocalName;
        }
    }

    public static final class Name
    implements NodeName {
        private final String mName;

        private Name(String name) {
            this.mName = (String)Preconditions.checkNotNull((Object)name);
        }

        @Override
        public boolean isInNamespace(String namespaceURI) {
            return false;
        }

        @Override
        public void addToNode(Element to, String withValue) {
            to.setAttribute(this.mName, withValue);
        }

        public boolean equals(Object o) {
            return o instanceof Name && ((Name)o).mName.equals(this.mName);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.mName});
        }

        public String toString() {
            return this.mName;
        }

        @Override
        public String getLocalName() {
            return this.mName;
        }
    }

    public static interface NodeName {
        public boolean isInNamespace(String var1);

        public void addToNode(Element var1, String var2);

        public String getLocalName();
    }
}

