/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.SdkConstants;
import com.android.ide.common.xml.XmlFormatPreferences;
import com.android.ide.common.xml.XmlFormatStyle;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.manifmerger.ActionRecorder;
import com.android.manifmerger.DocumentModel;
import com.android.manifmerger.ElementsTrimmer;
import com.android.manifmerger.KeyResolver;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.ManifestProvider;
import com.android.manifmerger.ManifestSystemProperty;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.NavGraphExpander;
import com.android.manifmerger.NavigationXmlDocument;
import com.android.manifmerger.NavigationXmlDocumentData;
import com.android.manifmerger.NavigationXmlLoader;
import com.android.manifmerger.PlaceholderEncoder;
import com.android.manifmerger.PlaceholderHandler;
import com.android.manifmerger.PostValidator;
import com.android.manifmerger.PreValidator;
import com.android.manifmerger.ToolsInstructionsCleaner;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import com.android.manifmerger.XmlLoader;
import com.android.manifmerger.XmlNode;
import com.android.sdklib.SdkVersionInfo;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManifestMerger2 {
    public static final String COMPATIBLE_SCREENS_SUB_MANIFEST = "Compatible-Screens sub-manifest";
    public static final String WEAR_APP_SUB_MANIFEST = "Wear App sub-manifest";
    private static final String SPLIT_IN_DYNAMIC_FEATURE = "https://d.android.com/r/studio-ui/dynamic-delivery/dynamic-feature-manifest";
    private final File mManifestFile;
    private final Map<String, Object> mPlaceHolderValues;
    private final PlaceholderHandler.KeyBasedValueResolver<ManifestSystemProperty> mSystemPropertyResolver;
    private final ILogger mLogger;
    private final ImmutableList<Pair<String, File>> mLibraryFiles;
    private final ImmutableList<File> mFlavorsAndBuildTypeFiles;
    private final ImmutableList<Invoker.Feature> mOptionalFeatures;
    private final MergeType mMergeType;
    private final XmlDocument.Type mDocumentType;
    private final Optional<File> mReportFile;
    private final String mFeatureName;
    private final String mNamespace;
    private final FileStreamProvider mFileStreamProvider;
    private final ImmutableList<File> mNavigationFiles;
    private final ImmutableList<File> mNavigationJsons;
    private final DocumentModel<ManifestModel.NodeTypes> mModel;
    private final ImmutableList<String> mDependencyFeatureNames;
    private final ImmutableList<String> mAllowedNonUniqueNamespaces;

    private ManifestMerger2(ILogger logger, File mainManifestFile, ImmutableList<Pair<String, File>> libraryFiles, ImmutableList<File> flavorsAndBuildTypeFiles, ImmutableList<Invoker.Feature> optionalFeatures, Map<String, Object> placeHolderValues, PlaceholderHandler.KeyBasedValueResolver<ManifestSystemProperty> systemPropertiesResolver, MergeType mergeType, XmlDocument.Type documentType, Optional<File> reportFile, String featureName, String namespace, FileStreamProvider fileStreamProvider, ImmutableList<File> navigationFiles, ImmutableList<File> navigationJsons, ImmutableList<String> dependencyFeatureNames, ImmutableList<String> allowedNonUniqueNamespaces) {
        this.mSystemPropertyResolver = systemPropertiesResolver;
        this.mPlaceHolderValues = placeHolderValues;
        this.mManifestFile = mainManifestFile;
        this.mLogger = logger;
        this.mLibraryFiles = libraryFiles;
        this.mFlavorsAndBuildTypeFiles = flavorsAndBuildTypeFiles;
        this.mOptionalFeatures = optionalFeatures;
        this.mMergeType = mergeType;
        this.mDocumentType = documentType;
        this.mReportFile = reportFile;
        this.mFeatureName = featureName;
        this.mNamespace = namespace;
        this.mFileStreamProvider = fileStreamProvider;
        this.mNavigationFiles = navigationFiles;
        this.mNavigationJsons = navigationJsons;
        this.mDependencyFeatureNames = dependencyFeatureNames;
        this.mModel = new ManifestModel(this.mOptionalFeatures.contains((Object)Invoker.Feature.HANDLE_VALUE_CONFLICTS_AUTOMATICALLY));
        this.mAllowedNonUniqueNamespaces = allowedNonUniqueNamespaces;
    }

    private MergingReport merge() throws MergeFailureException {
        Object mainManifestPackageName;
        MergingReport.Builder mergingReportBuilder = new MergingReport.Builder(this.mLogger);
        SelectorResolver selectors = new SelectorResolver();
        LoadedManifestInfo loadedMainManifestInfo = this.load(new ManifestInfo(this.mManifestFile.getName(), this.mManifestFile, this.mDocumentType), selectors, mergingReportBuilder, this.mNamespace);
        if (!loadedMainManifestInfo.getXmlDocument().checkTopLevelDeclarations(this.mPlaceHolderValues, mergingReportBuilder, this.mDocumentType)) {
            return mergingReportBuilder.build();
        }
        if (!this.mFeatureName.isEmpty()) {
            loadedMainManifestInfo = ManifestMerger2.removeDynamicFeatureManifestSplitAttributeIfSpecified(loadedMainManifestInfo, mergingReportBuilder);
        }
        Optional<XmlAttribute> mainPackageAttribute = loadedMainManifestInfo.getXmlDocument().getPackage();
        String originalMainManifestPackageName = mainPackageAttribute.map(XmlAttribute::getValue).orElse(null);
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.WARN_IF_PACKAGE_IN_SOURCE_MANIFEST) && originalMainManifestPackageName != null) {
            this.mLogger.warning(String.format("package=\"%1$s\" found in source AndroidManifest.xml: %2$s.\nSetting the namespace via a source AndroidManifest.xml's package attribute is deprecated.\nPlease instead set the namespace (or testNamespace) in the module's build.gradle file, as described here: https://developer.android.com/studio/build/configure-app-module#set-namespace\nThis migration can be done automatically using the AGP Upgrade Assistant, please refer to https://developer.android.com/studio/build/agp-upgrade-assistant for more information.", originalMainManifestPackageName, loadedMainManifestInfo.getLocation().getAbsolutePath()), new Object[0]);
        }
        List<LoadedManifestInfo> loadedLibraryDocuments = this.loadLibraries(selectors, mergingReportBuilder, originalMainManifestPackageName);
        ManifestMerger2.checkUniqueNamespaces(loadedMainManifestInfo, loadedLibraryDocuments, this.mAllowedNonUniqueNamespaces, mergingReportBuilder, this.mOptionalFeatures.contains((Object)Invoker.Feature.ENFORCE_UNIQUE_PACKAGE_NAME));
        this.performSystemPropertiesInjection(mergingReportBuilder, loadedMainManifestInfo.getXmlDocument());
        loadedMainManifestInfo = new LoadedManifestInfo(loadedMainManifestInfo, loadedMainManifestInfo.getXmlDocument().reparse());
        XmlDocument xmlDocumentOptional = null;
        for (File inputFile : this.mFlavorsAndBuildTypeFiles) {
            this.mLogger.verbose("Merging flavors and build manifest %s \n", new Object[]{inputFile.getPath()});
            LoadedManifestInfo overlayDocument = this.load(new ManifestInfo(null, inputFile, XmlDocument.Type.OVERLAY), selectors, mergingReportBuilder, this.mNamespace);
            if (!this.mFeatureName.isEmpty()) {
                overlayDocument = ManifestMerger2.removeDynamicFeatureManifestSplitAttributeIfSpecified(overlayDocument, mergingReportBuilder);
            }
            Optional<XmlAttribute> packageAttribute = overlayDocument.getXmlDocument().getPackage();
            if (!Strings.isNullOrEmpty((String)loadedMainManifestInfo.getNamespace()) && packageAttribute.isPresent() && !loadedMainManifestInfo.getNamespace().equals(packageAttribute.get().getValue())) {
                String message = this.mMergeType == MergeType.APPLICATION ? String.format("Overlay manifest:package attribute declared at %1$s value=(%2$s)\n\tdoes not match the module's namespace (%3$s).\n\tSuggestion: remove the overlay declaration at %4$s.\n\tIf you want to customize the applicationId for a buildType or productFlavor, consider setting applicationIdSuffix or using the Variant API.\n\tFor more information, see https://developer.android.com/studio/build/build-variants", packageAttribute.get().printPosition(), packageAttribute.get().getValue(), loadedMainManifestInfo.getNamespace(), packageAttribute.get().getSourceFile().print(true)) : String.format("Overlay manifest:package attribute declared at %1$s value=(%2$s)\n\tdoes not match the module's namespace (%3$s).\n\tSuggestion: remove the overlay declaration at %4$s.", packageAttribute.get().printPosition(), packageAttribute.get().getValue(), loadedMainManifestInfo.getNamespace(), packageAttribute.get().getSourceFile().print(true));
                mergingReportBuilder.addMessage(overlayDocument.getXmlDocument().getSourceFile(), MergingReport.Record.Severity.ERROR, message);
                return mergingReportBuilder.build();
            }
            if (mainPackageAttribute.isPresent()) {
                overlayDocument.getXmlDocument().getRootNode().getXml().setAttribute("package", mainPackageAttribute.get().getValue());
            }
            Optional<XmlDocument> newMergedDocument = this.merge(xmlDocumentOptional, overlayDocument, mergingReportBuilder);
            xmlDocumentOptional = newMergedDocument.orElse(null);
            if (newMergedDocument.isPresent()) continue;
            return mergingReportBuilder.build();
        }
        this.mLogger.verbose("Merging main manifest %s\n", new Object[]{this.mManifestFile.getPath()});
        Optional<XmlDocument> newMergedDocument = this.merge(xmlDocumentOptional, loadedMainManifestInfo, mergingReportBuilder);
        if (!newMergedDocument.isPresent()) {
            return mergingReportBuilder.build();
        }
        xmlDocumentOptional = newMergedDocument.get();
        if (this.mMergeType == MergeType.LIBRARY && !Strings.isNullOrEmpty((String)(mainManifestPackageName = loadedMainManifestInfo.getXmlDocument().getRootNode().getXml().getAttribute("package")))) {
            xmlDocumentOptional.getRootNode().getXml().setAttribute("package", (String)mainManifestPackageName);
        }
        for (LoadedManifestInfo libraryDocument : loadedLibraryDocuments) {
            this.mLogger.verbose("Merging library manifest " + libraryDocument.getLocation(), new Object[0]);
            newMergedDocument = this.merge(xmlDocumentOptional, libraryDocument, mergingReportBuilder);
            if (!newMergedDocument.isPresent()) {
                return mergingReportBuilder.build();
            }
            xmlDocumentOptional = newMergedDocument.get();
        }
        if (this.mMergeType == MergeType.APPLICATION) {
            Map<String, NavigationXmlDocument> loadedNavigationMap = this.createNavigationMap();
            xmlDocumentOptional = NavGraphExpander.INSTANCE.expandNavGraphs(xmlDocumentOptional, loadedNavigationMap, mergingReportBuilder);
        }
        if (mergingReportBuilder.hasErrors()) {
            return mergingReportBuilder.build();
        }
        ElementsTrimmer.trim(xmlDocumentOptional, mergingReportBuilder);
        if (mergingReportBuilder.hasErrors()) {
            return mergingReportBuilder.build();
        }
        if (!this.mOptionalFeatures.contains((Object)Invoker.Feature.NO_PLACEHOLDER_REPLACEMENT)) {
            MergingReport.Record.Severity severity = this.mMergeType == MergeType.LIBRARY ? MergingReport.Record.Severity.INFO : MergingReport.Record.Severity.ERROR;
            this.performPlaceHolderSubstitution(xmlDocumentOptional, originalMainManifestPackageName, mergingReportBuilder, severity);
            if (mergingReportBuilder.hasErrors()) {
                return mergingReportBuilder.build();
            }
        }
        this.performSystemPropertiesInjection(mergingReportBuilder, xmlDocumentOptional);
        XmlDocument finalMergedDocument = xmlDocumentOptional;
        Optional<XmlAttribute> packageAttr = finalMergedDocument.getPackage();
        if (this.mMergeType != MergeType.LIBRARY && packageAttr.isPresent()) {
            XmlAttribute packageNameAttribute = packageAttr.get();
            String packageName = packageNameAttribute.getValue();
            if (!(this.mOptionalFeatures.contains((Object)Invoker.Feature.NO_PLACEHOLDER_REPLACEMENT) && PlaceholderHandler.isPlaceHolder(packageName) || packageName.contains("."))) {
                mergingReportBuilder.addMessage(loadedMainManifestInfo.getXmlDocument().getSourceFile(), MergingReport.Record.Severity.ERROR, String.format("Package name '%1$s' at position %2$s should contain at least one '.' (dot) character", packageName, packageNameAttribute.printPosition()));
                return mergingReportBuilder.build();
            }
        }
        if (!this.mOptionalFeatures.contains((Object)Invoker.Feature.REMOVE_TOOLS_DECLARATIONS)) {
            PostValidator.enforceToolsNamespaceDeclaration(finalMergedDocument);
        }
        finalMergedDocument.originalNodeOperation.forEach((k, v) -> k.setAttributeNS("http://schemas.android.com/tools", "tools:node", v.toXmlName()));
        PostValidator.validate(finalMergedDocument, mergingReportBuilder);
        if (mergingReportBuilder.hasErrors()) {
            mergingReportBuilder.addMessage(finalMergedDocument.getRootNode(), MergingReport.Record.Severity.WARNING, "Post merge validation failed");
        }
        finalMergedDocument.clearNodeNamespaces();
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.EXTRACT_FQCNS)) {
            String namespace = this.mNamespace != null ? this.mNamespace : (originalMainManifestPackageName != null ? originalMainManifestPackageName : "");
            ManifestMerger2.extractFqcns(namespace, finalMergedDocument.getRootNode());
        }
        this.processOptionalFeatures(finalMergedDocument.getXml(), mergingReportBuilder);
        this.checkExportedDeclaration(finalMergedDocument, mergingReportBuilder);
        if (mergingReportBuilder.hasErrors()) {
            return mergingReportBuilder.build();
        }
        mergingReportBuilder.setMergedDocument(MergingReport.MergedManifestKind.MERGED, ManifestMerger2.prettyPrint(finalMergedDocument.getXml()));
        if (!this.mOptionalFeatures.contains((Object)Invoker.Feature.SKIP_BLAME)) {
            try {
                mergingReportBuilder.setMergedDocument(MergingReport.MergedManifestKind.BLAME, mergingReportBuilder.blame(finalMergedDocument));
            }
            catch (Exception e) {
                this.mLogger.error((Throwable)e, "Error while saving blame file, build will continue", new Object[0]);
            }
        }
        mergingReportBuilder.setMergedXmlDocument(finalMergedDocument);
        MergingReport mergingReport = mergingReportBuilder.build();
        if (this.mReportFile.isPresent()) {
            this.writeReport(mergingReport);
        }
        return mergingReport;
    }

    private Map<String, NavigationXmlDocument> createNavigationMap() throws MergeFailureException {
        HashMap<String, NavigationXmlDocument> loadedNavigationMap = new HashMap<String, NavigationXmlDocument>();
        for (File navigationFile : this.mNavigationFiles) {
            String navigationId = navigationFile.getName().replaceAll("\\.xml$", "");
            if (loadedNavigationMap.get(navigationId) != null) continue;
            try {
                InputStream inputStream = this.mFileStreamProvider.getInputStream(navigationFile);
                try {
                    loadedNavigationMap.put(navigationId, NavigationXmlLoader.INSTANCE.load(navigationId, navigationFile, inputStream));
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (Exception e) {
                throw new MergeFailureException(e);
            }
        }
        Gson gson = new GsonBuilder().create();
        for (File navigationJson : this.mNavigationJsons) {
            try {
                NavigationXmlDocumentData[] navDatas;
                String jsonText = FileUtils.loadFileWithUnixLineSeparators((File)navigationJson);
                for (NavigationXmlDocumentData navData : navDatas = (NavigationXmlDocumentData[])gson.fromJson(jsonText, NavigationXmlDocumentData[].class)) {
                    String navigationId = navData.getName();
                    if (loadedNavigationMap.get(navigationId) != null) {
                        this.mLogger.info("Navigation file %s from %s is ignored (skipped).", new Object[]{navigationId, navigationJson});
                        continue;
                    }
                    loadedNavigationMap.put(navigationId, new NavigationXmlDocument(navData));
                }
            }
            catch (IOException e) {
                throw new MergeFailureException(e);
            }
        }
        return loadedNavigationMap;
    }

    private static LoadedManifestInfo removeDynamicFeatureManifestSplitAttributeIfSpecified(LoadedManifestInfo dynamicFeatureManifest, MergingReport.Builder mergingReportBuilder) {
        Optional<XmlAttribute> splitAttribute = dynamicFeatureManifest.getXmlDocument().getRootNode().getAttribute(XmlNode.fromXmlName("split"));
        if (splitAttribute.isPresent()) {
            String message = String.format("Attribute '%1$s' was removed from %2$s.\nThe Android Gradle plugin includes it for you when building your project.\nSee %3$s for details.", "split", splitAttribute.get().printPosition(), SPLIT_IN_DYNAMIC_FEATURE);
            mergingReportBuilder.addMessage(dynamicFeatureManifest.getXmlDocument().getSourceFile(), MergingReport.Record.Severity.WARNING, message);
            dynamicFeatureManifest.getXmlDocument().getXml().getDocumentElement().removeAttribute("split");
            return new LoadedManifestInfo(dynamicFeatureManifest, dynamicFeatureManifest.getXmlDocument().reparse());
        }
        return dynamicFeatureManifest;
    }

    private void processOptionalFeatures(Document document, MergingReport.Builder mergingReport) throws MergeFailureException {
        if (document == null) {
            return;
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.REMOVE_TOOLS_DECLARATIONS)) {
            ToolsInstructionsCleaner.cleanToolsReferences(this.mMergeType, document, this.mLogger);
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.ADVANCED_PROFILING)) {
            ManifestMerger2.addInternetPermission(document);
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.TEST_ONLY)) {
            ManifestMerger2.addTestOnlyAttribute(document);
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.DEBUGGABLE)) {
            ManifestMerger2.addDebuggableAttribute(document);
        }
        if (this.mMergeType == MergeType.APPLICATION) {
            ManifestMerger2.optionalAddApplicationTagIfMissing(document);
        }
        if (this.mMergeType == MergeType.APPLICATION && this.mOptionalFeatures.contains((Object)Invoker.Feature.DO_NOT_EXTRACT_NATIVE_LIBS)) {
            ManifestMerger2.maybeAddExtractNativeLibAttribute(document);
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.ADD_ANDROIDX_MULTIDEX_APPLICATION_IF_NO_NAME)) {
            ManifestMerger2.addMultiDexApplicationIfNoName(document, SdkConstants.MULTI_DEX_APPLICATION.newName());
        } else if (this.mOptionalFeatures.contains((Object)Invoker.Feature.ADD_SUPPORT_MULTIDEX_APPLICATION_IF_NO_NAME)) {
            ManifestMerger2.addMultiDexApplicationIfNoName(document, SdkConstants.MULTI_DEX_APPLICATION.oldName());
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.ADD_DYNAMIC_FEATURE_ATTRIBUTES)) {
            ManifestMerger2.addFeatureSplitAttribute(document, this.mFeatureName);
            ManifestMerger2.adjustInstantAppFeatureSplitInfo(document, this.mFeatureName);
            ManifestMerger2.addUsesSplitTagsForDependencies(document, this.mDependencyFeatureNames);
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.MAKE_AAPT_SAFE)) {
            ManifestMerger2.createAaptSafeManifest(document, mergingReport);
        }
    }

    private static void createAaptSafeManifest(Document document, MergingReport.Builder mergingReport) throws MergeFailureException {
        Document clonedDocument = ManifestMerger2.cloneDocument(document);
        PlaceholderEncoder.visit(clonedDocument);
        ManifestMerger2.removeNavGraphs(clonedDocument);
        mergingReport.setMergedDocument(MergingReport.MergedManifestKind.AAPT_SAFE, ManifestMerger2.prettyPrint(clonedDocument));
    }

    private static void addTestOnlyAttribute(Document document) {
        Element manifest = document.getDocumentElement();
        ImmutableList<Element> applicationElements = ManifestMerger2.getChildElementsByName(manifest, "application");
        if (!applicationElements.isEmpty()) {
            Element application = (Element)applicationElements.get(0);
            ManifestMerger2.setAndroidAttribute(application, "testOnly", "true");
        }
    }

    private static void addDebuggableAttribute(Document document) {
        Element manifest = document.getDocumentElement();
        ImmutableList<Element> applicationElements = ManifestMerger2.getChildElementsByName(manifest, "application");
        if (!applicationElements.isEmpty()) {
            Element application = (Element)applicationElements.get(0);
            ManifestMerger2.setAndroidAttribute(application, "debuggable", "true");
        }
    }

    private static void addMultiDexApplicationIfNoName(Document document, String multiDexApplicationName) {
        Element manifest = document.getDocumentElement();
        ImmutableList<Element> applicationElements = ManifestMerger2.getChildElementsByName(manifest, "application");
        if (!applicationElements.isEmpty()) {
            Element application = (Element)applicationElements.get(0);
            ManifestMerger2.setAndroidAttributeIfMissing(application, "name", multiDexApplicationName);
        }
    }

    private static void maybeAddExtractNativeLibAttribute(Document document) {
        Element manifest = document.getDocumentElement();
        ImmutableList<Element> applicationElements = ManifestMerger2.getChildElementsByName(manifest, "application");
        if (!applicationElements.isEmpty()) {
            Element application = (Element)applicationElements.get(0);
            ManifestMerger2.setAndroidAttributeIfMissing(application, "extractNativeLibs", "false");
        }
    }

    private static void addFeatureSplitAttribute(Document document, String featureName) {
        Element manifest = document.getDocumentElement();
        if (manifest == null) {
            return;
        }
        String attributeName = "featureSplit";
        manifest.setAttribute(attributeName, featureName);
    }

    private static void adjustInstantAppFeatureSplitInfo(Document document, String featureName) {
        Element manifest = document.getDocumentElement();
        if (manifest == null) {
            return;
        }
        ImmutableList<Element> applicationElements = ManifestMerger2.getChildElementsByName(manifest, "application");
        if (applicationElements.isEmpty()) {
            return;
        }
        Element application = (Element)applicationElements.get(0);
        List<String> elementNamesToUpdate = Arrays.asList("activity", "service", "provider");
        for (String elementName : elementNamesToUpdate) {
            for (Element elementToUpdate : ManifestMerger2.getChildElementsByName(application, elementName)) {
                ManifestMerger2.setAndroidAttribute(elementToUpdate, "splitName", featureName);
            }
        }
    }

    public static String setManifestAndroidAttribute(Document document, String attribute, String value) {
        Element manifest = document.getDocumentElement();
        if (manifest == null) {
            return null;
        }
        String previousValue = manifest.hasAttributeNS("http://schemas.android.com/apk/res/android", attribute) ? manifest.getAttributeNS("http://schemas.android.com/apk/res/android", attribute) : null;
        ManifestMerger2.setAndroidAttribute(manifest, attribute, value);
        return previousValue;
    }

    private static void addInternetPermission(Document document) {
        String permission = "android.permission.INTERNET";
        Element manifest = document.getDocumentElement();
        ImmutableList<Element> usesPermissions = ManifestMerger2.getChildElementsByName(manifest, "uses-permission");
        for (Element usesPermission : usesPermissions) {
            if (!permission.equals(usesPermission.getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
            return;
        }
        Element uses = document.createElement("uses-permission");
        document.getDocumentElement().appendChild(uses);
        ManifestMerger2.setAndroidAttribute(uses, "name", permission);
    }

    private static void addUsesSplitTagsForDependencies(Document document, ImmutableList<String> dependencyFeatureNames) {
        Element manifest = document.getDocumentElement();
        for (String usedSplitName : dependencyFeatureNames) {
            Element usesSplit = document.createElement("uses-split");
            ManifestMerger2.setAndroidAttribute(usesSplit, "name", usedSplitName);
            manifest.appendChild(usesSplit);
        }
    }

    private static void optionalAddApplicationTagIfMissing(Document document) {
        Element manifest = document.getDocumentElement();
        if (manifest.getElementsByTagName("application").getLength() > 0) {
            return;
        }
        Element application = document.createElement("application");
        manifest.appendChild(application);
    }

    public static void setAndroidAttribute(Element node, String localName, String value) {
        String prefix = XmlUtils.lookupNamespacePrefix((Node)node, (String)"http://schemas.android.com/apk/res/android", (String)"android", (boolean)true);
        node.setAttributeNS("http://schemas.android.com/apk/res/android", prefix + ":" + localName, value);
    }

    private static void setAndroidAttributeIfMissing(Element node, String localName, String value) {
        if (!node.hasAttributeNS("http://schemas.android.com/apk/res/android", localName)) {
            ManifestMerger2.setAndroidAttribute(node, localName, value);
        }
    }

    public static ImmutableList<Element> getChildElementsByName(Element element, String name) {
        ImmutableList.Builder childListBuilder = ImmutableList.builder();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element) || !name.equals(childNode.getNodeName())) continue;
            childListBuilder.add((Object)((Element)childNode));
        }
        return childListBuilder.build();
    }

    private static String prettyPrint(Document document) {
        return XmlPrettyPrinter.prettyPrint((Node)document, (XmlFormatPreferences)XmlFormatPreferences.defaults(), (XmlFormatStyle)XmlFormatStyle.get((Node)document.getDocumentElement()), null, (boolean)false);
    }

    private static Document cloneDocument(Document document) throws MergeFailureException {
        try {
            DOMResult domResult = new DOMResult();
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(document), domResult);
            return (Document)domResult.getNode();
        }
        catch (Exception e) {
            throw new MergeFailureException(e);
        }
    }

    public static void removeNavGraphs(Document document) {
        ManifestMerger2.removeNavGraphs(document.getDocumentElement());
    }

    private static void removeNavGraphs(Element element) {
        if ("nav-graph".equals(element.getTagName())) {
            element.getParentNode().removeChild(element);
            return;
        }
        NodeList childNodes = element.getChildNodes();
        ImmutableList.Builder childElements = ImmutableList.builder();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            childElements.add((Object)((Element)node));
        }
        for (Element childElement : childElements.build()) {
            ManifestMerger2.removeNavGraphs(childElement);
        }
    }

    public FileStreamProvider getFileStreamProvider() {
        return this.mFileStreamProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeReport(MergingReport mergingReport) {
        OutputStreamWriter fileWriter = null;
        if (!this.mReportFile.isPresent() || !this.mReportFile.get().getParentFile().exists() && !this.mReportFile.get().getParentFile().mkdirs()) {
            this.mLogger.warning(String.format("Cannot create %1$s manifest merger report file,build will continue but merging activities will not be documented", this.mReportFile.get().getAbsolutePath()), new Object[0]);
        } else {
            fileWriter = new FileWriter(this.mReportFile.get());
            mergingReport.getActions().log((FileWriter)fileWriter);
        }
        if (fileWriter == null) return;
        try {
            fileWriter.close();
            return;
        }
        catch (IOException e) {
            this.mLogger.warning(String.format("Error '%1$s' while closing the merger report file, build can continue but merging activities will not be documented ", e.getMessage()), new Object[0]);
        }
        return;
        catch (IOException e) {
            try {
                this.mLogger.warning(String.format("Error '%1$s' while writing the merger report file, build can continue but merging activities will not be documented ", e.getMessage()), new Object[0]);
                if (fileWriter == null) return;
            }
            catch (Throwable throwable) {
                if (fileWriter == null) throw throwable;
                try {
                    fileWriter.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    this.mLogger.warning(String.format("Error '%1$s' while closing the merger report file, build can continue but merging activities will not be documented ", e2.getMessage()), new Object[0]);
                }
                throw throwable;
            }
            try {
                fileWriter.close();
                return;
            }
            catch (IOException e3) {
                this.mLogger.warning(String.format("Error '%1$s' while closing the merger report file, build can continue but merging activities will not be documented ", e3.getMessage()), new Object[0]);
            }
            return;
        }
    }

    private static void extractFqcns(String namespace, XmlElement xmlElement) {
        for (XmlAttribute xmlAttribute : xmlElement.getAttributes()) {
            String value;
            if (xmlAttribute.getModel() == null || !xmlAttribute.getModel().isPackageDependent() || !(value = xmlAttribute.getValue()).startsWith(namespace + ".")) continue;
            xmlAttribute.getXml().setValue(value.substring(namespace.length()));
        }
        for (XmlElement child : xmlElement.getMergeableElements()) {
            ManifestMerger2.extractFqcns(namespace, child);
        }
    }

    private LoadedManifestInfo load(ManifestInfo manifestInfo, KeyResolver<String> selectors, MergingReport.Builder mergingReportBuilder, String namespace) throws MergeFailureException {
        XmlDocument xmlDocument;
        boolean rewriteNamespaces = this.mOptionalFeatures.contains((Object)Invoker.Feature.FULLY_NAMESPACE_LOCAL_RESOURCES);
        File xmlFile = manifestInfo.mLocation;
        try {
            InputStream inputStream = this.mFileStreamProvider.getInputStream(xmlFile);
            xmlDocument = XmlLoader.load(selectors, this.mSystemPropertyResolver, manifestInfo.mName, xmlFile, inputStream, manifestInfo.getType(), namespace, this.mModel, rewriteNamespaces);
        }
        catch (Exception e) {
            throw new MergeFailureException("Error parsing " + xmlFile.getAbsolutePath(), e);
        }
        MergingReport.Builder builder = manifestInfo.getType() == XmlDocument.Type.MAIN ? mergingReportBuilder : new MergingReport.Builder(mergingReportBuilder.getLogger());
        MergingReport.Record.Severity severity = this.mMergeType == MergeType.LIBRARY ? MergingReport.Record.Severity.INFO : MergingReport.Record.Severity.ERROR;
        this.performPlaceHolderSubstitution(xmlDocument, xmlDocument.getPackage().map(XmlAttribute::getValue).orElse(null), builder, severity);
        builder.getActionRecorder().recordAddedNodeAction(xmlDocument.getRootNode(), false);
        return new LoadedManifestInfo(manifestInfo, xmlDocument);
    }

    private void performPlaceHolderSubstitution(XmlDocument xmlDocument, String originalMainManifestPackageName, MergingReport.Builder mergingReportBuilder, MergingReport.Record.Severity severity) {
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.NO_PLACEHOLDER_REPLACEMENT)) {
            return;
        }
        ImmutableMap finalPlaceHolderValues = this.mPlaceHolderValues;
        if (!this.mPlaceHolderValues.containsKey("applicationId") && this.mMergeType != MergeType.LIBRARY && originalMainManifestPackageName != null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<String, Object> entry : this.mPlaceHolderValues.entrySet()) {
                if (entry.getKey().equals("packageName")) continue;
                builder.put(entry);
            }
            builder.put((Object)"packageName", (Object)originalMainManifestPackageName);
            builder.put((Object)"applicationId", (Object)originalMainManifestPackageName);
            finalPlaceHolderValues = builder.build();
        }
        MapBasedKeyBasedValueResolver<String> placeHolderValueResolver = new MapBasedKeyBasedValueResolver<String>((Map<String, Object>)finalPlaceHolderValues);
        PlaceholderHandler.visit(severity, xmlDocument, placeHolderValueResolver, mergingReportBuilder);
    }

    private Optional<XmlDocument> merge(XmlDocument xmlDocument, LoadedManifestInfo lowerPriorityDocument, MergingReport.Builder mergingReportBuilder) {
        Optional<XmlDocument> result;
        MergingReport.Result validationResult = PreValidator.validate(mergingReportBuilder, lowerPriorityDocument.getXmlDocument());
        if (validationResult == MergingReport.Result.ERROR) {
            mergingReportBuilder.addMessage(lowerPriorityDocument.getXmlDocument().getSourceFile(), MergingReport.Record.Severity.ERROR, "Validation failed, exiting");
            return Optional.empty();
        }
        if (xmlDocument != null) {
            result = xmlDocument.merge(lowerPriorityDocument.getXmlDocument(), mergingReportBuilder, !this.mOptionalFeatures.contains((Object)Invoker.Feature.NO_IMPLICIT_PERMISSION_ADDITION), this.mOptionalFeatures.contains((Object)Invoker.Feature.DISABLE_MINSDKLIBRARY_CHECK));
        } else {
            mergingReportBuilder.getActionRecorder().recordAddedNodeAction(lowerPriorityDocument.getXmlDocument().getRootNode(), true);
            result = Optional.of(lowerPriorityDocument.getXmlDocument());
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.KEEP_INTERMEDIARY_STAGES) && result.isPresent()) {
            mergingReportBuilder.addMergingStage(result.get().prettyPrint());
        }
        return result;
    }

    private List<LoadedManifestInfo> loadLibraries(SelectorResolver selectors, MergingReport.Builder mergingReportBuilder, String originalMainManifestPackageName) throws MergeFailureException {
        ImmutableList.Builder loadedLibraryDocuments = ImmutableList.builder();
        for (Pair libraryFile : Sets.newLinkedHashSet(this.mLibraryFiles)) {
            XmlDocument libraryDocument;
            this.mLogger.verbose("Loading library manifest " + ((File)libraryFile.getSecond()).getPath(), new Object[0]);
            ManifestInfo manifestInfo = new ManifestInfo((String)libraryFile.getFirst(), (File)libraryFile.getSecond(), XmlDocument.Type.LIBRARY);
            File xmlFile = manifestInfo.mLocation;
            try {
                InputStream inputStream = this.mFileStreamProvider.getInputStream(xmlFile);
                libraryDocument = XmlLoader.load(selectors, this.mSystemPropertyResolver, manifestInfo.mName, xmlFile, inputStream, XmlDocument.Type.LIBRARY, null, this.mModel, false);
            }
            catch (Exception e) {
                throw new MergeFailureException(e);
            }
            String libraryNamespace = libraryDocument.getNamespace();
            if (!Strings.isNullOrEmpty((String)libraryNamespace)) {
                selectors.addSelector(libraryNamespace, (String)libraryFile.getFirst());
            }
            MergingReport.Builder builder = new MergingReport.Builder(mergingReportBuilder.getLogger());
            builder.getActionRecorder().recordAddedNodeAction(libraryDocument.getRootNode(), false);
            this.performPlaceHolderSubstitution(libraryDocument, originalMainManifestPackageName, builder, MergingReport.Record.Severity.INFO);
            if (builder.hasErrors()) {
                builder.build().log(this.mLogger);
            }
            LoadedManifestInfo info = new LoadedManifestInfo(manifestInfo, libraryDocument);
            loadedLibraryDocuments.add((Object)info);
        }
        return loadedLibraryDocuments.build();
    }

    private static void checkUniqueNamespaces(LoadedManifestInfo loadedMainManifestInfo, List<LoadedManifestInfo> libraries, List<String> allowedNonUniqueNamespaces, MergingReport.Builder mergingReportBuilder, boolean strictUniqueNamespaceCheck) {
        ArrayListMultimap uniqueNamespaceMap = ArrayListMultimap.create();
        if (!Strings.isNullOrEmpty((String)loadedMainManifestInfo.getNamespace())) {
            uniqueNamespaceMap.put((Object)loadedMainManifestInfo.getNamespace(), (Object)loadedMainManifestInfo);
        }
        libraries.stream().filter(l -> !Strings.isNullOrEmpty((String)l.getNamespace())).forEach(arg_0 -> ManifestMerger2.lambda$checkUniqueNamespaces$2((Multimap)uniqueNamespaceMap, arg_0));
        uniqueNamespaceMap.asMap().entrySet().stream().filter(e -> ((Collection)e.getValue()).size() > 1).forEach(e -> {
            Collection offendingTargets = ((Collection)e.getValue()).stream().map(ManifestInfo::getName).collect(Collectors.toList());
            String repeatedNamespaceMessage = "Namespace '" + (String)e.getKey() + "' used in: " + Joiner.on((String)", ").join((Iterable)offendingTargets) + ".";
            LoadedManifestInfo info = (LoadedManifestInfo)((Collection)e.getValue()).stream().findFirst().get();
            mergingReportBuilder.addMessage(info.getXmlDocument().getSourceFile(), ManifestMerger2.getNonUniqueNamespaceSeverity(allowedNonUniqueNamespaces, (String)e.getKey(), strictUniqueNamespaceCheck), repeatedNamespaceMessage);
        });
    }

    private static MergingReport.Record.Severity getNonUniqueNamespaceSeverity(List<String> allowedNonUniqueNamespaces, String namespace, boolean strictMode) {
        if (allowedNonUniqueNamespaces.contains(namespace)) {
            return MergingReport.Record.Severity.INFO;
        }
        return strictMode ? MergingReport.Record.Severity.ERROR : MergingReport.Record.Severity.WARNING;
    }

    public static Invoker newMerger(File mainManifestFile, ILogger logger, MergeType mergeType) {
        return new Invoker(mainManifestFile, logger, mergeType, XmlDocument.Type.MAIN);
    }

    protected void performSystemPropertiesInjection(MergingReport.Builder mergingReport, XmlDocument xmlDocument) {
        for (ManifestSystemProperty manifestSystemProperty : ManifestSystemProperty.getValues()) {
            String propertyOverride = this.mSystemPropertyResolver.getValue(manifestSystemProperty);
            if (propertyOverride == null) continue;
            manifestSystemProperty.addTo(mergingReport.getActionRecorder(), xmlDocument, propertyOverride);
        }
    }

    private void checkExportedDeclaration(XmlDocument finalMergedDocument, MergingReport.Builder mergingReportBuilder) {
        int targetSdkApi;
        String targetSdkVersion = finalMergedDocument.getTargetSdkVersion();
        int n = targetSdkApi = Character.isDigit(targetSdkVersion.charAt(0)) ? Integer.parseInt(targetSdkVersion) : SdkVersionInfo.getApiByPreviewName((String)targetSdkVersion, (boolean)true);
        if (targetSdkApi > 30) {
            Optional<XmlElement> element = finalMergedDocument.getRootNode().getNodeByTypeAndKey(ManifestModel.NodeTypes.APPLICATION, null);
            if (!element.isPresent()) {
                return;
            }
            XmlElement applicationElement = element.get();
            this.checkIfExportedIsNeeded((List<XmlElement>)applicationElement.getAllNodesByType(ManifestModel.NodeTypes.ACTIVITY), mergingReportBuilder);
            this.checkIfExportedIsNeeded((List<XmlElement>)applicationElement.getAllNodesByType(ManifestModel.NodeTypes.SERVICE), mergingReportBuilder);
            this.checkIfExportedIsNeeded((List<XmlElement>)applicationElement.getAllNodesByType(ManifestModel.NodeTypes.RECEIVER), mergingReportBuilder);
        }
    }

    private void checkIfExportedIsNeeded(List<XmlElement> list, MergingReport.Builder mergingReportBuilder) {
        for (XmlElement element : list) {
            if (element.getAllNodesByType(ManifestModel.NodeTypes.INTENT_FILTER).size() <= 0 || element.getXml().hasAttributeNS("http://schemas.android.com/apk/res/android", "exported")) continue;
            mergingReportBuilder.addMessage(element, MergingReport.Record.Severity.ERROR, String.format("android:exported needs to be explicitly specified for element <%s>. Apps targeting Android 12 and higher are required to specify an explicit value for `android:exported` when the corresponding component has an intent filter defined. See https://developer.android.com/guide/topics/manifest/activity-element#exported for details.", element.getId()));
        }
    }

    private static /* synthetic */ void lambda$checkUniqueNamespaces$2(Multimap uniqueNamespaceMap, LoadedManifestInfo l) {
        uniqueNamespaceMap.put((Object)l.getNamespace(), (Object)l);
    }

    public static class MergeFailureException
    extends Exception {
        protected MergeFailureException(String msg, Exception cause) {
            super(msg, cause);
        }

        protected MergeFailureException(Exception cause) {
            super(cause);
        }
    }

    public static class SelectorResolver
    implements KeyResolver<String> {
        private final Map<String, String> mSelectors = new HashMap<String, String>();

        protected void addSelector(String key, String value) {
            this.mSelectors.put(key, value);
        }

        @Override
        public String resolve(String key) {
            return this.mSelectors.get(key);
        }

        @Override
        public Iterable<String> getKeys() {
            return this.mSelectors.keySet();
        }
    }

    private static class LoadedManifestInfo
    extends ManifestInfo {
        private final XmlDocument mXmlDocument;

        private LoadedManifestInfo(ManifestInfo manifestInfo, XmlDocument xmlDocument) {
            super(manifestInfo.mName, manifestInfo.mLocation, manifestInfo.mType);
            this.mXmlDocument = xmlDocument;
        }

        public XmlDocument getXmlDocument() {
            return this.mXmlDocument;
        }

        public String getNamespace() {
            return this.mXmlDocument.getNamespace();
        }
    }

    private static class ManifestInfo {
        private final String mName;
        private final File mLocation;
        private final XmlDocument.Type mType;

        private ManifestInfo(String name, File location, XmlDocument.Type type) {
            this.mName = name;
            this.mLocation = location;
            this.mType = type;
        }

        String getName() {
            return this.mName;
        }

        File getLocation() {
            return this.mLocation;
        }

        XmlDocument.Type getType() {
            return this.mType;
        }
    }

    public static class MapBasedKeyBasedValueResolver<T>
    implements PlaceholderHandler.KeyBasedValueResolver<T> {
        private final ImmutableMap<T, Object> keyValues;

        public MapBasedKeyBasedValueResolver(Map<T, Object> keyValues) {
            this.keyValues = ImmutableMap.copyOf(keyValues);
        }

        @Override
        public String getValue(T key) {
            Object value = this.keyValues.get(key);
            return value == null ? null : value.toString();
        }
    }

    public static class Invoker {
        protected final File mMainManifestFile;
        protected final ImmutableMap.Builder<ManifestSystemProperty, Object> mSystemProperties = new ImmutableMap.Builder();
        protected final ILogger mLogger;
        protected final ImmutableMap.Builder<String, Object> mPlaceholders = new ImmutableMap.Builder();
        private final ImmutableList.Builder<Pair<String, File>> mLibraryFilesBuilder = new ImmutableList.Builder();
        private final ImmutableList.Builder<File> mFlavorsAndBuildTypeFiles = new ImmutableList.Builder();
        private final ImmutableList.Builder<Feature> mFeaturesBuilder = new ImmutableList.Builder();
        private final MergeType mMergeType;
        private XmlDocument.Type mDocumentType;
        private File mReportFile;
        private FileStreamProvider mFileStreamProvider;
        private String mFeatureName;
        private String mNamespace;
        private final ImmutableList.Builder<File> mNavigationFilesBuilder = new ImmutableList.Builder();
        private final ImmutableList.Builder<File> mNavigationJsonsBuilder = new ImmutableList.Builder();
        private final ImmutableList.Builder<String> mDependencyFetureNamesBuilder = new ImmutableList.Builder();
        private final ImmutableList.Builder<String> mAllowedNonUniqueNamespaces = new ImmutableList.Builder();
        private static final Pattern FEATURE_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9][a-zA-Z0-9_]*");

        public Invoker setOverride(ManifestSystemProperty override, String value) {
            this.mSystemProperties.put((Object)override, (Object)value);
            return this;
        }

        public Invoker setPlaceHolderValues(Map<String, Object> keyValuePairs) {
            this.mPlaceholders.putAll(keyValuePairs);
            return this;
        }

        public Invoker setPlaceHolderValue(String placeHolderName, String value) {
            this.mPlaceholders.put((Object)placeHolderName, (Object)value);
            return this;
        }

        private Invoker(File mainManifestFile, ILogger logger, MergeType mergeType, XmlDocument.Type documentType) {
            this.mMainManifestFile = (File)Preconditions.checkNotNull((Object)mainManifestFile);
            this.mLogger = logger;
            this.mMergeType = mergeType;
            this.mDocumentType = documentType;
            this.mFeatureName = "";
        }

        public Invoker setMergeReportFile(File mergeReport) {
            this.mReportFile = mergeReport;
            return this;
        }

        public Invoker addLibraryManifest(File file) {
            this.addLibraryManifest(file.getName(), file);
            return this;
        }

        public Invoker addLibraryManifest(String name, File file) {
            if (this.mMergeType == MergeType.LIBRARY) {
                throw new IllegalStateException("Cannot add library dependencies manifests when creating a library");
            }
            this.mLibraryFilesBuilder.add((Object)Pair.of((Object)name, (Object)file));
            return this;
        }

        @Deprecated
        public Invoker addBundleManifests(List<Pair<String, File>> namesAndFiles) {
            if (this.mMergeType == MergeType.LIBRARY && !namesAndFiles.isEmpty()) {
                throw new IllegalStateException("Cannot add library dependencies manifests when creating a library");
            }
            this.mLibraryFilesBuilder.addAll(namesAndFiles);
            return this;
        }

        public Invoker addManifestProviders(Iterable<? extends ManifestProvider> providers) {
            for (ManifestProvider manifestProvider : providers) {
                this.mLibraryFilesBuilder.add((Object)Pair.of((Object)manifestProvider.getName(), (Object)manifestProvider.getManifest()));
            }
            return this;
        }

        public Invoker addLibraryManifests(File ... files) {
            for (File file : files) {
                this.addLibraryManifest(file);
            }
            return this;
        }

        public Invoker addFlavorAndBuildTypeManifest(File file) {
            this.mFlavorsAndBuildTypeFiles.add((Object)file);
            return this;
        }

        public Invoker addFlavorAndBuildTypeManifests(File ... files) {
            this.mFlavorsAndBuildTypeFiles.add((Object[])files);
            return this;
        }

        public Invoker withFeatures(Feature ... features) {
            this.mFeaturesBuilder.add((Object[])features);
            return this;
        }

        public Invoker withFileStreamProvider(FileStreamProvider provider) {
            assert (this.mFileStreamProvider == null || provider == null);
            this.mFileStreamProvider = provider;
            return this;
        }

        public Invoker setFeatureName(String featureName) {
            if (featureName != null) {
                this.mFeatureName = featureName;
                if (!FEATURE_NAME_PATTERN.matcher(this.mFeatureName).matches()) {
                    throw new IllegalArgumentException("FeatureName must follow " + FEATURE_NAME_PATTERN.pattern() + " regex, found " + featureName);
                }
            }
            return this;
        }

        public Invoker setNamespace(String namespace) {
            this.mNamespace = namespace;
            return this;
        }

        public Invoker addNavigationFiles(Iterable<File> files) {
            this.mNavigationFilesBuilder.addAll(files);
            return this;
        }

        public Invoker addNavigationJsons(Iterable<File> files) {
            this.mNavigationJsonsBuilder.addAll(files);
            return this;
        }

        public Invoker asType(XmlDocument.Type type) {
            this.mDocumentType = type;
            return this;
        }

        public Invoker addDependencyFeatureNames(Iterable<String> names) {
            this.mDependencyFetureNamesBuilder.addAll(names);
            return this;
        }

        public Invoker addAllowedNonUniqueNamespace(String namespace) {
            this.mAllowedNonUniqueNamespaces.add((Object)namespace);
            return this;
        }

        public MergingReport merge() throws MergeFailureException {
            ImmutableMap systemProperties = this.mSystemProperties.build();
            if (systemProperties.containsKey((Object)ManifestSystemProperty.Document.PACKAGE)) {
                this.mPlaceholders.put((Object)"packageName", systemProperties.get((Object)ManifestSystemProperty.Document.PACKAGE));
                if (this.mMergeType != MergeType.LIBRARY) {
                    this.mPlaceholders.put((Object)"applicationId", systemProperties.get((Object)ManifestSystemProperty.Document.PACKAGE));
                }
            }
            FileStreamProvider fileStreamProvider = this.mFileStreamProvider != null ? this.mFileStreamProvider : new FileStreamProvider();
            this.addAllowedNonUniqueNamespace("androidx.test");
            ManifestMerger2 manifestMerger = new ManifestMerger2(this.mLogger, this.mMainManifestFile, this.mLibraryFilesBuilder.build(), this.mFlavorsAndBuildTypeFiles.build(), this.mFeaturesBuilder.build(), (Map)this.mPlaceholders.build(), new MapBasedKeyBasedValueResolver(systemProperties), this.mMergeType, this.mDocumentType, Optional.ofNullable(this.mReportFile), this.mFeatureName, this.mNamespace, fileStreamProvider, this.mNavigationFilesBuilder.build(), this.mNavigationJsonsBuilder.build(), this.mDependencyFetureNamesBuilder.build(), this.mAllowedNonUniqueNamespaces.build());
            return manifestMerger.merge();
        }

        public static enum Feature {
            KEEP_INTERMEDIARY_STAGES,
            PRINT_SIMPLE_FILENAMES,
            EXTRACT_FQCNS,
            REMOVE_TOOLS_DECLARATIONS,
            NO_PLACEHOLDER_REPLACEMENT,
            MAKE_AAPT_SAFE,
            SKIP_BLAME,
            SKIP_XML_STRING,
            TEST_ONLY,
            NO_IMPLICIT_PERMISSION_ADDITION,
            ADVANCED_PROFILING,
            ADD_DYNAMIC_FEATURE_ATTRIBUTES,
            DEBUGGABLE,
            HANDLE_VALUE_CONFLICTS_AUTOMATICALLY,
            ADD_ANDROIDX_MULTIDEX_APPLICATION_IF_NO_NAME,
            ADD_SUPPORT_MULTIDEX_APPLICATION_IF_NO_NAME,
            FULLY_NAMESPACE_LOCAL_RESOURCES,
            ENFORCE_UNIQUE_PACKAGE_NAME,
            DO_NOT_EXTRACT_NATIVE_LIBS,
            DISABLE_MINSDKLIBRARY_CHECK,
            WARN_IF_PACKAGE_IN_SOURCE_MANIFEST;

        }
    }

    public static class FileStreamProvider {
        protected InputStream getInputStream(File file) throws IOException {
            return new BufferedInputStream(new FileInputStream(file));
        }
    }

    public static interface AutoAddingProperty {
        public void addTo(ActionRecorder var1, XmlDocument var2, String var3);
    }

    public static enum MergeType {
        APPLICATION,
        LIBRARY;

    }
}

