/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.manifmerger.Actions;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import com.android.manifmerger.XmlNode;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.w3c.dom.Attr;

public class ElementsTrimmer {
    public static void trim(XmlDocument xmlDocument, MergingReport.Builder mergingReport) {
        NavigableMap<Integer, XmlElement> glEsVersionDeclarations = new TreeMap();
        for (XmlElement childElement : xmlDocument.getRootNode().getMergeableElements()) {
            Integer value;
            if (!childElement.getType().equals((Object)ManifestModel.NodeTypes.USES_FEATURE) || (value = ElementsTrimmer.getGlEsVersion(childElement, mergingReport)) == null) continue;
            glEsVersionDeclarations.put(value, childElement);
        }
        glEsVersionDeclarations = glEsVersionDeclarations.descendingMap();
        boolean doneWithAboveTwoTrue = false;
        boolean doneWithAboveTwoFalse = false;
        boolean doneWithBelowTwoTrue = false;
        boolean doneWithBelowTwoFalse = false;
        for (Map.Entry glEsVersionDeclaration : glEsVersionDeclarations.entrySet()) {
            boolean removeElement;
            boolean isRequired;
            Attr requiredAttribute = ((XmlElement)glEsVersionDeclaration.getValue()).getXml().getAttributeNodeNS("http://schemas.android.com/apk/res/android", "required");
            boolean bl = isRequired = requiredAttribute == null || Boolean.parseBoolean(requiredAttribute.getValue());
            if ((Integer)glEsVersionDeclaration.getKey() < 131072) {
                boolean bl2 = removeElement = doneWithBelowTwoFalse && doneWithBelowTwoTrue || isRequired && doneWithBelowTwoTrue || !isRequired && doneWithBelowTwoFalse;
                if (!removeElement) {
                    doneWithBelowTwoFalse = true;
                    doneWithBelowTwoTrue = isRequired;
                }
            } else {
                boolean bl3 = removeElement = doneWithAboveTwoFalse && doneWithAboveTwoTrue || isRequired && doneWithAboveTwoTrue || !isRequired && doneWithAboveTwoFalse;
                if (!removeElement) {
                    doneWithAboveTwoFalse = true;
                    doneWithAboveTwoTrue = isRequired;
                }
            }
            if (!removeElement) continue;
            if (((XmlElement)glEsVersionDeclaration.getValue()).getXml().getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name") != null) {
                ((XmlElement)glEsVersionDeclaration.getValue()).getXml().removeAttributeNS("http://schemas.android.com/apk/res/android", "glEsVersion");
                mergingReport.getActionRecorder().recordAttributeAction(((XmlElement)glEsVersionDeclaration.getValue()).getAttribute(XmlNode.fromXmlName("android:glEsVersion")).get(), Actions.ActionType.REJECTED, null);
                continue;
            }
            xmlDocument.getRootNode().getXml().removeChild(((XmlElement)glEsVersionDeclaration.getValue()).getXml());
            mergingReport.getActionRecorder().recordNodeAction((XmlElement)glEsVersionDeclaration.getValue(), Actions.ActionType.REJECTED);
        }
    }

    private static Integer getGlEsVersion(XmlElement xmlElement, MergingReport.Builder mergingReport) {
        Attr glEsVersion = xmlElement.getXml().getAttributeNodeNS("http://schemas.android.com/apk/res/android", "glEsVersion");
        if (glEsVersion == null) {
            return null;
        }
        try {
            return ElementsTrimmer.getHexValue(glEsVersion);
        }
        catch (NumberFormatException e) {
            String message = String.format("Invalid value for attribute:%1$s, value:%2$s", "glEsVersion", glEsVersion.getValue());
            mergingReport.addMessage(xmlElement, MergingReport.Record.Severity.ERROR, message);
            return null;
        }
    }

    private static Integer getHexValue(Attr attribute) {
        try {
            return Integer.decode(attribute.getValue());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

