/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.manifmerger.DocumentModel;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.OrphanXmlElement;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class XmlNode {
    protected static final Function<Node, String> NODE_TO_NAME = Node::getNodeName;
    @NotNull
    private final Supplier<NodeKey> mOriginalId = Suppliers.memoize(this::getId);

    @NotNull
    public synchronized NodeKey getOriginalId() {
        return this.mOriginalId.get();
    }

    @NotNull
    public abstract NodeKey getId();

    @NotNull
    public abstract SourcePosition getPosition();

    @NotNull
    public abstract SourceFile getSourceFile();

    @NotNull
    public SourceFilePosition getSourceFilePosition() {
        return new SourceFilePosition(this.getSourceFile(), this.getPosition());
    }

    @NotNull
    public abstract Node getXml();

    @NotNull
    public abstract NodeName getName();

    @NotNull
    public static NodeName unwrapName(@NotNull Node node) {
        return node.getNamespaceURI() == null ? new Name(node.getNodeName()) : new NamespaceAwareName(node);
    }

    @NotNull
    public static NodeName fromXmlName(@NotNull String name) {
        if (name.contains(":")) {
            String prefix = name.substring(0, name.indexOf(58));
            return new NamespaceAwareName("xmlns".equals(prefix) ? "http://www.w3.org/2000/xmlns/" : "http://schemas.android.com/apk/res/android", prefix, name.substring(name.indexOf(58) + 1));
        }
        return new Name(name);
    }

    @NotNull
    public static NodeName fromNSName(@NotNull String namespaceUri, @NotNull String prefix, @NotNull String localName) {
        return new NamespaceAwareName(namespaceUri, prefix, localName);
    }

    @NotNull
    public String printPosition() {
        return this.getSourceFilePosition().print(true);
    }

    public static class NodeKey {
        @NotNull
        private final String mKey;

        NodeKey(@NotNull String key) {
            this.mKey = key;
        }

        public static NodeKey fromXml(@NotNull Element element, @NotNull DocumentModel<ManifestModel.NodeTypes> model) {
            return new OrphanXmlElement(element, model).getId();
        }

        @NotNull
        public String toString() {
            return this.mKey;
        }

        public boolean equals(@Nullable Object o) {
            return o instanceof NodeKey && ((NodeKey)o).mKey.equals(this.mKey);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.mKey});
        }
    }

    public static final class Name
    implements NodeName {
        private final String mName;

        private Name(@NotNull String name) {
            this.mName = (String)Preconditions.checkNotNull((Object)name);
        }

        @Override
        public boolean isInNamespace(@NotNull String namespaceURI) {
            return false;
        }

        @Override
        public void addToNode(@NotNull Element to, String withValue) {
            to.setAttribute(this.mName, withValue);
        }

        public boolean equals(@Nullable Object o) {
            return o instanceof Name && ((Name)o).mName.equals(this.mName);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.mName});
        }

        public String toString() {
            return this.mName;
        }

        @Override
        public String getLocalName() {
            return this.mName;
        }
    }

    public static final class NamespaceAwareName
    implements NodeName {
        @NotNull
        private final String mNamespaceURI;
        @NotNull
        private final String mPrefix;
        @NotNull
        private final String mLocalName;

        private NamespaceAwareName(@NotNull Node node) {
            this.mNamespaceURI = (String)Preconditions.checkNotNull((Object)node.getNamespaceURI());
            this.mPrefix = (String)Preconditions.checkNotNull((Object)node.getPrefix());
            this.mLocalName = (String)Preconditions.checkNotNull((Object)node.getLocalName());
        }

        private NamespaceAwareName(@NotNull String namespaceURI, @NotNull String prefix, @NotNull String localName) {
            this.mNamespaceURI = (String)Preconditions.checkNotNull((Object)namespaceURI);
            this.mPrefix = (String)Preconditions.checkNotNull((Object)prefix);
            this.mLocalName = (String)Preconditions.checkNotNull((Object)localName);
        }

        @Override
        public boolean isInNamespace(@NotNull String namespaceURI) {
            return this.mNamespaceURI.equals(namespaceURI);
        }

        @Override
        public void addToNode(@NotNull Element to, String withValue) {
            to.setAttributeNS(this.mNamespaceURI, this.mPrefix + ":" + this.mLocalName, withValue);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.mNamespaceURI, this.mLocalName});
        }

        public boolean equals(@Nullable Object o) {
            return o instanceof NamespaceAwareName && ((NamespaceAwareName)o).mLocalName.equals(this.mLocalName) && ((NamespaceAwareName)o).mNamespaceURI.equals(this.mNamespaceURI);
        }

        @NotNull
        public String toString() {
            return this.mPrefix + ":" + this.mLocalName;
        }

        @Override
        @NotNull
        public String getLocalName() {
            return this.mLocalName;
        }
    }

    public static interface NodeName {
        public boolean isInNamespace(@NotNull String var1);

        public void addToNode(@NotNull Element var1, String var2);

        public String getLocalName();
    }
}

