/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.NodeOperationType;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import com.android.manifmerger.XmlNode;
import com.android.utils.ILogger;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import kotlin.Pair;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ToolsInstructionsCleaner {
    private static final String REMOVE_OPERATION_XML_MAME = NodeOperationType.REMOVE.toCamelCaseName();
    private static final String REMOVE_ALL_OPERATION_XML_MAME = NodeOperationType.REMOVE_ALL.toCamelCaseName();

    public static Optional<Document> cleanToolsReferences(ManifestMerger2.MergeType mergeType, XmlDocument document, ILogger logger) {
        Preconditions.checkNotNull((Object)document);
        Preconditions.checkNotNull((Object)logger);
        MergingReport.Result result = (MergingReport.Result)((Object)ToolsInstructionsCleaner.cleanToolsReferences(mergeType, document.getXml().getDocumentElement(), logger).getFirst());
        if (result == MergingReport.Result.SUCCESS) {
            document.resetRootNode();
            return Optional.of((Object)document.getXml());
        }
        return Optional.absent();
    }

    private static Pair<MergingReport.Result, Boolean> cleanToolsReferences(ManifestMerger2.MergeType mergeType, Element element, ILogger logger) {
        if ("http://schemas.android.com/tools".equals(element.getNamespaceURI())) {
            element.getParentNode().removeChild(element);
            return new Pair((Object)MergingReport.Result.SUCCESS, (Object)false);
        }
        boolean needsToolsNamespace = false;
        NodeList childNodes = element.getChildNodes();
        ImmutableList.Builder childElements = ImmutableList.builder();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            childElements.add((Object)((Element)node));
        }
        for (Element childElement : childElements.build()) {
            Pair<MergingReport.Result, Boolean> result = ToolsInstructionsCleaner.cleanToolsReferences(mergeType, childElement, logger);
            needsToolsNamespace |= ((Boolean)result.getSecond()).booleanValue();
            if (result.getFirst() != MergingReport.Result.ERROR) continue;
            return new Pair((Object)MergingReport.Result.ERROR, (Object)needsToolsNamespace);
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            ArrayList<Node> attributes = new ArrayList<Node>();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                attributes.add(namedNodeMap.item(i));
            }
            for (Node attribute : attributes) {
                if ("http://schemas.android.com/tools".equals(attribute.getNamespaceURI())) {
                    boolean hasSelector;
                    boolean bl = hasSelector = namedNodeMap.getNamedItemNS("http://schemas.android.com/tools", "selector") != null;
                    if (attribute.getLocalName().equals("node") && (attribute.getNodeValue().equals(REMOVE_ALL_OPERATION_XML_MAME) || attribute.getNodeValue().equals(REMOVE_OPERATION_XML_MAME) && !hasSelector)) {
                        if (element.getParentNode().getNodeType() == 9) {
                            logger.error(null, String.format("tools:node=\"%1$s\" not allowed on top level %2$s element", attribute.getNodeValue(), XmlNode.unwrapName(element)), new Object[0]);
                            return new Pair((Object)MergingReport.Result.ERROR, (Object)needsToolsNamespace);
                        }
                        for (Node comment : XmlElement.getLeadingComments(element)) {
                            comment.getParentNode().removeChild(comment);
                        }
                        element.getParentNode().removeChild(element);
                    } else if (mergeType.isKeepToolsAttributeRequired(attribute.getLocalName(), attribute.getNodeValue())) {
                        element.removeAttributeNS(attribute.getNamespaceURI(), attribute.getLocalName());
                    } else {
                        needsToolsNamespace = true;
                    }
                }
                if (!attribute.getNodeName().startsWith("xmlns:") || !"http://schemas.android.com/tools".equals(attribute.getNodeValue()) || needsToolsNamespace) continue;
                element.removeAttribute(attribute.getNodeName());
            }
        }
        return new Pair((Object)MergingReport.Result.SUCCESS, (Object)needsToolsNamespace);
    }
}

