/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils.concurrency;

import com.android.utils.concurrency.AsyncSupplier;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/utils/concurrency/AsyncSupplierRefresher;", "V", "Lcom/android/utils/concurrency/AsyncSupplier;", "", "asyncSupplier", "refreshDuration", "Ljava/time/Duration;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "(Lcom/android/utils/concurrency/AsyncSupplier;Ljava/time/Duration;Ljava/util/concurrent/ScheduledExecutorService;)V", "expensiveValueRef", "Ljava/lang/ref/WeakReference;", "scheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "scheduledFutureLock", "Ljava/util/concurrent/locks/ReentrantLock;", "cancel", "", "refresh", "reschedule", "common"})
public final class AsyncSupplierRefresher<V extends AsyncSupplier<?>> {
    @NotNull
    private final Duration refreshDuration;
    @NotNull
    private final ScheduledExecutorService executor;
    @NotNull
    private final WeakReference<V> expensiveValueRef;
    @NotNull
    private final ReentrantLock scheduledFutureLock;
    @Nullable
    private ScheduledFuture<?> scheduledFuture;

    public AsyncSupplierRefresher(@NotNull V asyncSupplier, @NotNull Duration refreshDuration, @NotNull ScheduledExecutorService executor) {
        Intrinsics.checkNotNullParameter(asyncSupplier, (String)"asyncSupplier");
        Intrinsics.checkNotNullParameter((Object)refreshDuration, (String)"refreshDuration");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.refreshDuration = refreshDuration;
        this.executor = executor;
        this.expensiveValueRef = new WeakReference<V>(asyncSupplier);
        this.scheduledFutureLock = new ReentrantLock();
        this.reschedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reschedule() {
        Lock lock = this.scheduledFutureLock;
        lock.lock();
        try {
            boolean bl = false;
            ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
            if (scheduledFuture == null ? false : scheduledFuture.isCancelled()) {
                return;
            }
            this.scheduledFuture = this.executor.schedule(new Runnable(this){
                final /* synthetic */ AsyncSupplierRefresher<V> $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final void run() {
                    AsyncSupplierRefresher.access$refresh(this.$tmp0);
                }
            }, this.refreshDuration.toMillis(), TimeUnit.MILLISECONDS);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void refresh() {
        AsyncSupplier expensiveValue = (AsyncSupplier)this.expensiveValueRef.get();
        if (expensiveValue != null) {
            expensiveValue.get();
            this.reschedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        Lock lock = this.scheduledFutureLock;
        lock.lock();
        try {
            boolean bl = false;
            ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
            Boolean bl2 = scheduledFuture == null ? null : Boolean.valueOf(scheduledFuture.cancel(true));
        }
        finally {
            lock.unlock();
        }
    }

    public static final /* synthetic */ void access$refresh(AsyncSupplierRefresher $this) {
        $this.refresh();
    }
}

