/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.SdkConstants;
import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AdbDelegateUsageTracker;
import com.android.ddmlib.AdbDevice;
import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.AdbInitOptions;
import com.android.ddmlib.AdbVersion;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.AndroidDebugBridgeBase;
import com.android.ddmlib.Client;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IDeviceUsageTracker;
import com.android.ddmlib.Log;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.TimeoutRemainder;
import com.android.ddmlib.clientmanager.ClientManager;
import com.android.ddmlib.idevicemanager.IDeviceManager;
import com.android.ddmlib.idevicemanager.IDeviceManagerFactory;
import com.android.ddmlib.idevicemanager.IDeviceManagerUtils;
import com.android.ddmlib.internal.DeviceMonitor;
import com.android.ddmlib.internal.MonitorThread;
import com.android.ddmlib.internal.jdwp.chunkhandler.HandleARTT;
import com.android.ddmlib.internal.jdwp.chunkhandler.HandleAppName;
import com.android.ddmlib.internal.jdwp.chunkhandler.HandleHeap;
import com.android.ddmlib.internal.jdwp.chunkhandler.HandleHello;
import com.android.ddmlib.internal.jdwp.chunkhandler.HandleNativeHeap;
import com.android.ddmlib.internal.jdwp.chunkhandler.HandleProfiling;
import com.android.ddmlib.internal.jdwp.chunkhandler.HandleSTAG;
import com.android.ddmlib.internal.jdwp.chunkhandler.HandleTest;
import com.android.ddmlib.internal.jdwp.chunkhandler.HandleThread;
import com.android.ddmlib.internal.jdwp.chunkhandler.HandleViewDebug;
import com.android.ddmlib.internal.jdwp.chunkhandler.HandleWait;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closeables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.SettableFuture;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class AndroidDebugBridgeImpl
extends AndroidDebugBridgeBase {
    public static final int DEFAULT_START_ADB_TIMEOUT_MILLIS = 20000;
    private static final String ADB = "adb";
    private static final String DDMS = "ddms";
    private static final String SERVER_PORT_ENV_VAR = "ANDROID_ADB_SERVER_PORT";
    public static final int DEFAULT_ADB_PORT = 5037;
    private static final int STATUS_DLL_NOT_FOUND = -1073741515;
    private static boolean sUnitTestMode;
    private static int sAdbServerPort;
    private static boolean sUserManagedAdbMode;
    private static final Object sLastKnownGoodAddressLock;
    private static InetSocketAddress sLastKnownGoodAddress;
    private volatile AndroidDebugBridge sThis;
    private static boolean sInitialized;
    private static boolean sClientSupport;
    private static ClientManager sClientManager;
    private static IDeviceManagerFactory sIDeviceManagerFactory;
    private static IDeviceUsageTracker iDeviceUsageTracker;
    private static AdbDelegateUsageTracker adbDelegateUsageTracker;
    private static Map<String, String> sAdbEnvVars;
    private String mAdbOsLocation = null;
    private AdbVersion mAdbVersion;
    private boolean mVersionCheck;
    private boolean mStarted = false;
    private DeviceMonitor mDeviceMonitor;
    private IDeviceManager mIDeviceManager;
    private static final Object sLock;

    AndroidDebugBridgeImpl() {
    }

    @Override
    @Deprecated
    public synchronized void initIfNeeded(boolean clientSupport) {
        this.logRun(AdbDelegateUsageTracker.Method.INIT_IF_NEEDED, () -> {
            if (sInitialized) {
                return;
            }
            this.init(clientSupport);
        });
    }

    @Override
    public synchronized void init(boolean clientSupport) {
        this.logRun(AdbDelegateUsageTracker.Method.INIT_1, () -> this.init(clientSupport, false, (Map<String, String>)ImmutableMap.of()));
    }

    @Override
    public synchronized void init(boolean clientSupport, boolean useLibusb, Map<String, String> env) {
        this.logRun(AdbDelegateUsageTracker.Method.INIT_2, () -> this.init(AdbInitOptions.builder().withEnv(env).setClientSupportEnabled(clientSupport).withEnv("ADB_LIBUSB", useLibusb ? "1" : "0").build()));
    }

    @Override
    public synchronized void init(AdbInitOptions options) {
        this.logRun(AdbDelegateUsageTracker.Method.INIT_3, () -> {
            Preconditions.checkState((!sInitialized ? 1 : 0) != 0, (Object)"AndroidDebugBridge.init() has already been called.");
            sInitialized = true;
            sIDeviceManagerFactory = options.iDeviceManagerFactory;
            iDeviceUsageTracker = options.iDeviceUsageTracker;
            adbDelegateUsageTracker = options.adbDelegateUsageTracker;
            sClientSupport = options.clientSupport;
            sClientManager = options.clientManager;
            if (sClientManager != null) {
                sClientSupport = false;
            }
            if (sIDeviceManagerFactory != null) {
                sClientManager = null;
                sClientSupport = false;
            }
            sAdbEnvVars = options.adbEnvVars;
            sUserManagedAdbMode = options.userManagedAdbMode;
            sLastKnownGoodAddress = null;
            DdmPreferences.enableJdwpProxyService(options.useJdwpProxyService);
            DdmPreferences.enableDdmlibCommandService(options.useDdmlibCommandService);
            DdmPreferences.setsJdwpMaxPacketSize(options.maxJdwpPacketSize);
            AndroidDebugBridgeImpl.initAdbPort(options.userManagedAdbPort);
            MonitorThread monitorThread = MonitorThread.createInstance();
            monitorThread.start();
            HandleHello.register(monitorThread);
            HandleAppName.register(monitorThread);
            HandleTest.register(monitorThread);
            HandleThread.register(monitorThread);
            HandleHeap.register(monitorThread);
            HandleWait.register(monitorThread);
            HandleProfiling.register(monitorThread);
            HandleNativeHeap.register(monitorThread);
            HandleViewDebug.register(monitorThread);
            HandleARTT.register(monitorThread);
            HandleSTAG.register(monitorThread);
        });
    }

    @Override
    public synchronized boolean optionsChanged(AdbInitOptions options, String osLocation, boolean forceNewBridge, long terminateTimeout, long initTimeout, TimeUnit unit) {
        return this.logCall(AdbDelegateUsageTracker.Method.OPTIONS_CHANGED, () -> {
            boolean bridgeNeedsRestart;
            if (!sInitialized) {
                return true;
            }
            boolean bl = bridgeNeedsRestart = this.getBridge() != null;
            if (bridgeNeedsRestart && !this.disconnectBridge(terminateTimeout, unit)) {
                Log.e(DDMS, "Could not disconnect bridge prior to restart when options changed.");
                return false;
            }
            this.terminate();
            this.init(options);
            if (bridgeNeedsRestart && this.createBridge(osLocation, forceNewBridge, initTimeout, unit) == null) {
                Log.e(DDMS, "Could not recreate the bridge after options changed.");
                return false;
            }
            return true;
        });
    }

    @Override
    @VisibleForTesting
    public void enableFakeAdbServerMode(int port) {
        this.logRun(AdbDelegateUsageTracker.Method.ENABLE_FAKE_ADB_SERVER_MODE, () -> {
            Preconditions.checkState((!sInitialized ? 1 : 0) != 0, (Object)"AndroidDebugBridge.init() has already been called or terminate() has not been called yet.");
            sUnitTestMode = true;
            sAdbServerPort = port;
        });
    }

    @Override
    @VisibleForTesting
    public void disableFakeAdbServerMode() {
        this.logRun(AdbDelegateUsageTracker.Method.DISABLE_FAKE_ADB_SERVER_MODE, () -> {
            Preconditions.checkState((!sInitialized ? 1 : 0) != 0, (Object)"AndroidDebugBridge.init() has already been called or terminate() has not been called yet.");
            sUnitTestMode = false;
            sAdbServerPort = 0;
        });
    }

    @Override
    public synchronized void terminate() {
        this.logRun(AdbDelegateUsageTracker.Method.TERMINATE, () -> {
            MonitorThread monitorThread;
            if (this.sThis != null) {
                this.killMonitoringServices();
            }
            if ((monitorThread = MonitorThread.getInstance()) != null) {
                monitorThread.quit();
            }
            sInitialized = false;
            this.sThis = null;
            sLastKnownGoodAddress = null;
        });
    }

    @Override
    public boolean getClientSupport() {
        return this.logCall(AdbDelegateUsageTracker.Method.GET_CLIENT_SUPPORT, () -> sClientSupport);
    }

    @Override
    public ClientManager getClientManager() {
        return this.logCall(AdbDelegateUsageTracker.Method.GET_CLIENT_MANAGER, () -> sClientManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public InetSocketAddress getSocketAddress() {
        if (!sUnitTestMode) {
            Object object = sLastKnownGoodAddressLock;
            synchronized (object) {
                InetSocketAddress inetSocketAddress;
                block14: {
                    if (sLastKnownGoodAddress != null) {
                        return sLastKnownGoodAddress;
                    }
                    SocketChannel adbChannel = this.openConnection();
                    try {
                        inetSocketAddress = sLastKnownGoodAddress = (InetSocketAddress)adbChannel.getRemoteAddress();
                        if (adbChannel == null) break block14;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (adbChannel != null) {
                                try {
                                    adbChannel.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException iOException) {
                        }
                    }
                    adbChannel.close();
                }
                return inetSocketAddress;
            }
        }
        return new InetSocketAddress(InetAddress.getLoopbackAddress(), sAdbServerPort);
    }

    @Override
    public SocketChannel openConnection() throws IOException {
        return this.logCall1(AdbDelegateUsageTracker.Method.OPEN_CONNECTION, () -> {
            SocketChannel adbChannel;
            try {
                adbChannel = SocketChannel.open(new InetSocketAddress("127.0.0.1", sAdbServerPort));
            }
            catch (IOException ipv4Exception) {
                try {
                    adbChannel = SocketChannel.open(new InetSocketAddress("::1", sAdbServerPort));
                }
                catch (IOException ipv6Exception) {
                    IOException combinedException = new IOException("Can't find adb server on port " + sAdbServerPort + ", IPv4 attempt: " + ipv4Exception.getMessage() + ", IPv6 attempt: " + ipv6Exception.getMessage(), ipv4Exception);
                    combinedException.addSuppressed(ipv6Exception);
                    throw combinedException;
                }
            }
            adbChannel.socket().setTcpNoDelay(true);
            return adbChannel;
        });
    }

    @Override
    public AndroidDebugBridge createBridge() {
        return this.logCall(AdbDelegateUsageTracker.Method.CREATE_BRIDGE_1, () -> this.createBridge(Long.MAX_VALUE, TimeUnit.MILLISECONDS));
    }

    @Override
    public AndroidDebugBridge createBridge(long timeout, TimeUnit unit) {
        return this.logCall(AdbDelegateUsageTracker.Method.CREATE_BRIDGE_2, () -> {
            AndroidDebugBridge localThis;
            Object object = sLock;
            synchronized (object) {
                if (this.sThis != null) {
                    return this.sThis;
                }
                try {
                    localThis = new AndroidDebugBridge();
                    if (!this.start(localThis, timeout, unit)) {
                        return null;
                    }
                }
                catch (InvalidParameterException e) {
                    return null;
                }
                this.sThis = localThis;
            }
            adbChangeEvents.notifyBridgeChanged(localThis);
            return localThis;
        });
    }

    @Override
    @Deprecated
    public AndroidDebugBridge createBridge(String osLocation, boolean forceNewBridge) {
        return this.logCall(AdbDelegateUsageTracker.Method.CREATE_BRIDGE_3, () -> this.createBridge(osLocation, forceNewBridge, Long.MAX_VALUE, TimeUnit.MILLISECONDS));
    }

    @Override
    public AndroidDebugBridge createBridge(String osLocation, boolean forceNewBridge, long timeout, TimeUnit unit) {
        return this.logCall(AdbDelegateUsageTracker.Method.CREATE_BRIDGE_4, () -> {
            AndroidDebugBridge localThis;
            Object object = sLock;
            synchronized (object) {
                TimeoutRemainder rem = new TimeoutRemainder(timeout, unit);
                if (!sUnitTestMode && this.sThis != null) {
                    if (this.mAdbOsLocation != null && this.mAdbOsLocation.equals(osLocation) && !forceNewBridge) {
                        return this.sThis;
                    }
                    if (!this.stop(rem.getRemainingNanos(), TimeUnit.NANOSECONDS)) {
                        return null;
                    }
                    this.sThis = null;
                }
                try {
                    localThis = new AndroidDebugBridge();
                    this.initOsLocationAndCheckVersion(osLocation);
                    if (!this.start(localThis, rem.getRemainingNanos(), TimeUnit.NANOSECONDS)) {
                        localThis = null;
                    }
                }
                catch (InvalidParameterException e) {
                    localThis = null;
                }
                this.sThis = localThis;
            }
            adbChangeEvents.notifyBridgeChanged(localThis);
            return localThis;
        });
    }

    @Override
    public AndroidDebugBridge getBridge() {
        return this.sThis;
    }

    @Override
    @Deprecated
    public void disconnectBridge() {
        this.logRun(AdbDelegateUsageTracker.Method.DISCONNECT_BRIDGE_1, () -> this.disconnectBridge(Long.MAX_VALUE, TimeUnit.MILLISECONDS));
    }

    @Override
    public boolean disconnectBridge(long timeout, TimeUnit unit) {
        return this.logCall(AdbDelegateUsageTracker.Method.DISCONNECT_BRIDGE_2, () -> {
            Object object = sLock;
            synchronized (object) {
                if (this.sThis != null) {
                    if (!this.stop(timeout, unit)) {
                        return false;
                    }
                    this.sThis = null;
                }
            }
            adbChangeEvents.notifyBridgeChanged(null);
            return true;
        });
    }

    @Override
    public void addDebugBridgeChangeListener(AndroidDebugBridge.IDebugBridgeChangeListener listener) {
        this.logRun(AdbDelegateUsageTracker.Method.ADD_DEBUG_BRIDGE_CHANGE_LISTENER, () -> {
            adbChangeEvents.addDebugBridgeChangeListener(listener);
            AndroidDebugBridge localThis = this.sThis;
            if (localThis != null) {
                try {
                    listener.bridgeChanged(localThis);
                }
                catch (Throwable t) {
                    Log.e(DDMS, t);
                }
            }
        });
    }

    @Override
    public void removeDebugBridgeChangeListener(AndroidDebugBridge.IDebugBridgeChangeListener listener) {
        this.logRun(AdbDelegateUsageTracker.Method.REMOVE_DEBUG_BRIDGE_CHANGE_LISTENER, () -> adbChangeEvents.removeDebugBridgeChangeListener(listener));
    }

    @Override
    @VisibleForTesting
    public int getDebugBridgeChangeListenerCount() {
        return this.logCall(AdbDelegateUsageTracker.Method.GET_DEBUG_BRIDGE_CHANGE_LISTENER_COUNT, adbChangeEvents::debugBridgeChangeListenerCount);
    }

    @Override
    public void addDeviceChangeListener(AndroidDebugBridge.IDeviceChangeListener listener) {
        this.logRun(AdbDelegateUsageTracker.Method.ADD_DEVICE_CHANGE_LISTENER, () -> adbChangeEvents.addDeviceChangeListener(listener));
    }

    @Override
    public void removeDeviceChangeListener(AndroidDebugBridge.IDeviceChangeListener listener) {
        this.logRun(AdbDelegateUsageTracker.Method.REMOVE_DEVICE_CHANGE_LISTENER, () -> adbChangeEvents.removeDeviceChangeListener(listener));
    }

    @Override
    @VisibleForTesting
    public int getDeviceChangeListenerCount() {
        return this.logCall(AdbDelegateUsageTracker.Method.GET_DEVICE_CHANGE_LISTENER_COUNT, adbChangeEvents::deviceChangeListenerCount);
    }

    @Override
    public void addClientChangeListener(AndroidDebugBridge.IClientChangeListener listener) {
        this.logRun(AdbDelegateUsageTracker.Method.ADD_CLIENT_CHANGE_LISTENER, () -> adbChangeEvents.addClientChangeListener(listener));
    }

    @Override
    public void removeClientChangeListener(AndroidDebugBridge.IClientChangeListener listener) {
        this.logRun(AdbDelegateUsageTracker.Method.REMOVE_CLIENT_CHANGE_LISTENER, () -> adbChangeEvents.removeClientChangeListener(listener));
    }

    @Override
    public AdbVersion getCurrentAdbVersion() {
        return this.logCall(AdbDelegateUsageTracker.Method.GET_CURRENT_ADB_VERSION, () -> this.mAdbVersion);
    }

    @Override
    public IDevice[] getDevices() {
        return this.logCall(AdbDelegateUsageTracker.Method.GET_DEVICES, () -> {
            if (this.mIDeviceManager != null) {
                return this.mIDeviceManager.getDevices().toArray(new IDevice[0]);
            }
            Object object = sLock;
            synchronized (object) {
                if (this.mDeviceMonitor != null) {
                    return this.mDeviceMonitor.getDevices();
                }
            }
            return new IDevice[0];
        });
    }

    @Override
    public boolean hasInitialDeviceList() {
        return this.logCall(AdbDelegateUsageTracker.Method.HAS_INITIAL_DEVICE_LIST, () -> {
            if (this.mIDeviceManager != null) {
                return this.mIDeviceManager.hasInitialDeviceList();
            }
            if (this.mDeviceMonitor != null) {
                return this.mDeviceMonitor.hasInitialDeviceList();
            }
            return false;
        });
    }

    @Override
    public boolean isConnected() {
        MonitorThread monitorThread = MonitorThread.getInstance();
        if (this.mDeviceMonitor != null && monitorThread != null) {
            return this.mDeviceMonitor.isMonitoring() && monitorThread.getState() != Thread.State.TERMINATED;
        }
        return false;
    }

    @Override
    public IDeviceUsageTracker getiDeviceUsageTracker() {
        return iDeviceUsageTracker;
    }

    private void initOsLocationAndCheckVersion(String osLocation) {
        if (osLocation == null || osLocation.isEmpty()) {
            throw new InvalidParameterException();
        }
        this.mAdbOsLocation = osLocation;
        try {
            this.mAdbVersion = this.fetchAdbVersion();
            this.mVersionCheck = AndroidDebugBridgeImpl.checkAdbVersion(this.mAdbVersion);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private AdbVersion fetchAdbVersion() throws IOException {
        if (this.mAdbOsLocation == null) {
            return null;
        }
        File adb = new File(this.mAdbOsLocation);
        ListenableFuture<AdbVersion> future = this.getAdbVersion(adb);
        try {
            return (AdbVersion)future.get(20000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (java.util.concurrent.TimeoutException e) {
            String msg = "Unable to obtain result of 'adb version'";
            Log.logAndDisplay(Log.LogLevel.ERROR, ADB, msg);
            return null;
        }
        catch (ExecutionException e) {
            Log.logAndDisplay(Log.LogLevel.ERROR, ADB, e.getCause().getMessage());
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), IOException.class);
            return null;
        }
    }

    private static boolean checkAdbVersion(AdbVersion adbVersion) {
        boolean passes = false;
        if (adbVersion == null) {
            Log.logAndDisplay(Log.LogLevel.ERROR, ADB, "Could not determine adb version.");
        } else if (adbVersion.compareTo(AndroidDebugBridge.MIN_ADB_VERSION) > 0) {
            passes = true;
        } else {
            String message = String.format("Required minimum version of adb: %1$s.Current version is %2$s", AndroidDebugBridge.MIN_ADB_VERSION, adbVersion);
            Log.logAndDisplay(Log.LogLevel.ERROR, ADB, message);
        }
        return passes;
    }

    @Deprecated
    private static <T> ListenableFuture<T> runAdb(File adb, AndroidDebugBridge.AdbOutputProcessor<T> resultParser, String ... command) {
        SettableFuture future = SettableFuture.create();
        new Thread(() -> {
            Process p;
            ArrayList<String> args = new ArrayList<String>();
            args.add(adb.getPath());
            args.addAll(Arrays.asList(command));
            ProcessBuilder pb = new ProcessBuilder(args);
            pb.redirectErrorStream(true);
            try {
                p = pb.start();
            }
            catch (IOException e) {
                future.setException((Throwable)e);
                return;
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                future.set(resultParser.process(p, br));
            }
            catch (IOException e) {
                future.setException((Throwable)e);
                return;
            }
            catch (RuntimeException e) {
                future.setException((Throwable)e);
            }
        }, "Running adb").start();
        return future;
    }

    @Override
    public ListenableFuture<AdbVersion> getAdbVersion(File adb) {
        return this.logCall(AdbDelegateUsageTracker.Method.GET_ADB_VERSION, () -> AndroidDebugBridgeImpl.runAdb(adb, (process, br) -> {
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                AdbVersion version = AdbVersion.parseFrom(line);
                if (version != AdbVersion.UNKNOWN) {
                    return version;
                }
                sb.append(line);
                sb.append('\n');
            }
            Object errorMessage = "Unable to detect adb version";
            int exitValue = process.exitValue();
            if (exitValue != 0) {
                errorMessage = (String)errorMessage + ", exit value: 0x" + Integer.toHexString(exitValue);
                if (exitValue == -1073741515 && SdkConstants.currentPlatform() == 2) {
                    errorMessage = (String)errorMessage + ". ADB depends on the Windows Universal C Runtime, which is usually installed by default via Windows Update. You may need to manually fetch and install the runtime package here: https://support.microsoft.com/en-ca/help/2999226/update-for-universal-c-runtime-in-windows";
                    throw new RuntimeException((String)errorMessage);
                }
            }
            if (sb.length() > 0) {
                errorMessage = (String)errorMessage + ", adb output: " + sb.toString();
            }
            throw new RuntimeException((String)errorMessage);
        }, "version"));
    }

    private ListenableFuture<List<AdbDevice>> getRawDeviceList(File adb) {
        return AndroidDebugBridgeImpl.runAdb(adb, (process, br) -> {
            String line;
            br.readLine();
            ArrayList<AdbDevice> result = new ArrayList<AdbDevice>();
            while ((line = br.readLine()) != null) {
                AdbDevice device = AdbDevice.parseAdbLine(line);
                if (device == null) continue;
                result.add(device);
            }
            return result;
        }, "devices", "-l");
    }

    @Override
    public ListenableFuture<String> getVirtualDeviceId(ListeningExecutorService service, File adb, IDevice device) {
        return this.logCall(AdbDelegateUsageTracker.Method.GET_VIRTUAL_DEVICE_ID, () -> {
            List<String> command = Arrays.asList(adb.toString(), "-s", device.getSerialNumber(), "emu", "avd", "id");
            return AndroidDebugBridgeImpl.execute(service, command, AndroidDebugBridgeImpl::processVirtualDeviceIdCommandOutput);
        });
    }

    private static String processVirtualDeviceIdCommandOutput(Process process, BufferedReader reader) {
        List lines = reader.lines().collect(Collectors.toList());
        if (lines.size() != 2) {
            return "";
        }
        if (!((String)lines.get(1)).equals("OK")) {
            return "";
        }
        String result = (String)lines.get(0);
        assert (!result.isEmpty());
        return result;
    }

    private static <T> ListenableFuture<T> execute(ListeningExecutorService service, List<String> command, AndroidDebugBridge.AdbOutputProcessor<T> processor) {
        return service.submit(() -> {
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.redirectErrorStream(true);
            Process process = builder.start();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                Object t = processor.process(process, in);
                return t;
            }
        });
    }

    @Override
    public ListenableFuture<List<AdbDevice>> getRawDeviceList() {
        return this.logCall(AdbDelegateUsageTracker.Method.GET_RAW_DEVICE_LIST, () -> {
            if (this.mAdbOsLocation == null) {
                SettableFuture result = SettableFuture.create();
                result.set(Collections.emptyList());
                return result;
            }
            File adb = new File(this.mAdbOsLocation);
            return this.getRawDeviceList(adb);
        });
    }

    private boolean start(AndroidDebugBridge localThis, long timeout, TimeUnit unit) {
        if (!sUserManagedAdbMode && this.mAdbOsLocation != null && sAdbServerPort != 0) {
            if (!this.mVersionCheck) {
                return false;
            }
            if (!this.startAdb(timeout, unit)) {
                return false;
            }
        }
        this.mStarted = true;
        this.startMonitoringServices(localThis);
        return true;
    }

    private void startMonitoringServices(AndroidDebugBridge localThis) {
        assert (localThis != null);
        if (sIDeviceManagerFactory != null) {
            this.mIDeviceManager = sIDeviceManagerFactory.createIDeviceManager(localThis, IDeviceManagerUtils.createIDeviceManagerListener());
        }
        boolean emitDeviceListUpdates = this.mIDeviceManager == null;
        this.mDeviceMonitor = new DeviceMonitor(localThis, new MonitorErrorHandler(), emitDeviceListUpdates);
        this.mDeviceMonitor.start();
    }

    private boolean stop(long timeout, TimeUnit unit) {
        if (!this.mStarted) {
            return true;
        }
        TimeoutRemainder rem = new TimeoutRemainder(timeout, unit);
        this.killMonitoringServices();
        if (sUserManagedAdbMode) {
            Log.i(DDMS, "User managed ADB mode: Not stopping ADB server");
        } else if (!this.stopAdb(rem.getRemainingNanos(), TimeUnit.NANOSECONDS)) {
            return false;
        }
        this.mStarted = false;
        return true;
    }

    private void killMonitoringServices() {
        if (this.mDeviceMonitor != null) {
            this.mDeviceMonitor.stop();
            this.mDeviceMonitor = null;
        }
        if (this.mIDeviceManager != null) {
            try {
                this.mIDeviceManager.close();
            }
            catch (Exception e) {
                Log.e(DDMS, "Could not close IDeviceManager:");
                Log.e(DDMS, e);
            }
            finally {
                this.mIDeviceManager = null;
            }
        }
    }

    @Override
    @Deprecated
    public boolean restart() {
        return this.logCall(AdbDelegateUsageTracker.Method.RESTART_1, () -> this.restart(Long.MAX_VALUE, TimeUnit.MILLISECONDS));
    }

    @Override
    public boolean restart(long timeout, TimeUnit unit) {
        return this.logCall(AdbDelegateUsageTracker.Method.RESTART_2, () -> {
            boolean isSuccessful;
            if (sUserManagedAdbMode) {
                Log.e(ADB, "Cannot restart adb when using user managed ADB server.");
                return false;
            }
            if (this.mAdbOsLocation == null) {
                Log.e(ADB, "Cannot restart adb when AndroidDebugBridge is created without the location of adb.");
                return false;
            }
            if (sAdbServerPort == 0) {
                Log.e(ADB, "ADB server port for restarting AndroidDebugBridge is not set.");
                return false;
            }
            if (!this.mVersionCheck) {
                Log.logAndDisplay(Log.LogLevel.ERROR, ADB, "Attempting to restart adb, but version check failed!");
                return false;
            }
            TimeoutRemainder rem = new TimeoutRemainder(timeout, unit);
            adbChangeEvents.notifyBridgeRestartInitiated();
            AndroidDebugBridgeImpl androidDebugBridgeImpl = this;
            synchronized (androidDebugBridgeImpl) {
                isSuccessful = this.stopAdb(rem.getRemainingNanos(), TimeUnit.NANOSECONDS);
                if (!isSuccessful) {
                    Log.w(ADB, "Error stopping ADB without specified timeout");
                }
                if (isSuccessful) {
                    isSuccessful = this.startAdb(rem.getRemainingNanos(), TimeUnit.NANOSECONDS);
                }
                if (isSuccessful && this.mDeviceMonitor == null && this.mIDeviceManager == null) {
                    assert (this.sThis != null);
                    this.startMonitoringServices(this.sThis);
                }
            }
            adbChangeEvents.notifyBridgeRestartCompleted(isSuccessful);
            return isSuccessful;
        });
    }

    @Override
    public void deviceConnected(IDevice device) {
        this.logRun(AdbDelegateUsageTracker.Method.DEVICE_CONNECTED, () -> adbChangeEvents.notifyDeviceConnected(device));
    }

    @Override
    public void deviceDisconnected(IDevice device) {
        this.logRun(AdbDelegateUsageTracker.Method.DEVICE_DISCONNECTED, () -> adbChangeEvents.notifyDeviceDisconnected(device));
    }

    @Override
    public void deviceChanged(IDevice device, int changeMask) {
        this.logRun(AdbDelegateUsageTracker.Method.DEVICE_CHANGED, () -> adbChangeEvents.notifyDeviceChanged(device, changeMask));
    }

    @Override
    public void clientChanged(Client client, int changeMask) {
        this.logRun(AdbDelegateUsageTracker.Method.CLIENT_CHANGED, () -> adbChangeEvents.notifyClientChanged(client, changeMask));
    }

    @Override
    public boolean isUserManagedAdbMode() {
        return sUserManagedAdbMode;
    }

    @Override
    public String queryFeatures(String adbFeaturesRequest) throws TimeoutException, AdbCommandRejectedException, IOException {
        try (SocketChannel adbChan = AndroidDebugBridge.openConnection();){
            adbChan.configureBlocking(false);
            byte[] request = AdbHelper.formAdbRequest(adbFeaturesRequest);
            AdbHelper.write(adbChan, request);
            AdbHelper.AdbResponse resp = AdbHelper.readAdbResponse(adbChan, true);
            if (!resp.okay) {
                Log.w("features", "Error querying features: " + resp.message);
                throw new AdbCommandRejectedException(resp.message);
            }
            String string = resp.message;
            return string;
        }
    }

    @Override
    public synchronized boolean startAdb(long timeout, TimeUnit unit) {
        return this.logCall(AdbDelegateUsageTracker.Method.START_ADB, () -> {
            if (sUserManagedAdbMode) {
                Log.e(ADB, "startADB should never be called when using user managed ADB server.");
                return false;
            }
            if (sUnitTestMode) {
                return true;
            }
            if (this.mAdbOsLocation == null) {
                Log.e(ADB, "Cannot start adb when AndroidDebugBridge is created without the location of adb.");
                return false;
            }
            if (sAdbServerPort == 0) {
                Log.w(ADB, "ADB server port for starting AndroidDebugBridge is not set.");
                return false;
            }
            int status = -1;
            Object[] command = this.getAdbLaunchCommand("start-server");
            String commandString = Joiner.on((char)' ').join(command);
            try {
                String adbHostValue;
                Log.d(DDMS, String.format("Launching '%1$s' to ensure ADB is running.", commandString));
                ProcessBuilder processBuilder = new ProcessBuilder((String[])command);
                Map<String, String> env = processBuilder.environment();
                sAdbEnvVars.forEach(env::put);
                if (DdmPreferences.getUseAdbHost() && (adbHostValue = DdmPreferences.getAdbHostValue()) != null && !adbHostValue.isEmpty()) {
                    env.put("ADBHOST", adbHostValue);
                }
                processBuilder.directory(new File(this.mAdbOsLocation).getParentFile());
                Process proc = processBuilder.start();
                ArrayList<String> errorOutput = new ArrayList<String>();
                ArrayList<String> stdOutput = new ArrayList<String>();
                status = AndroidDebugBridgeImpl.grabProcessOutput(proc, errorOutput, stdOutput, false, timeout, unit);
            }
            catch (IOException | InterruptedException ioe) {
                Log.e(DDMS, "Unable to run 'adb': " + ioe.getMessage());
            }
            if (status != 0) {
                Log.e(DDMS, String.format("'%1$s' failed -- run manually if necessary", commandString));
                return false;
            }
            Log.d(DDMS, String.format("'%1$s' succeeded", commandString));
            return true;
        });
    }

    private String[] getAdbLaunchCommand(String option) {
        ArrayList<String> command = new ArrayList<String>(4);
        command.add(this.mAdbOsLocation);
        if (sAdbServerPort != 5037) {
            command.add("-P");
            command.add(Integer.toString(sAdbServerPort));
        }
        command.add(option);
        return command.toArray(new String[0]);
    }

    @Override
    public synchronized boolean stopAdb(long timeout, TimeUnit unit) {
        if (sUserManagedAdbMode) {
            Log.e(ADB, "stopADB should never be called when using user managed ADB server.");
            return false;
        }
        if (this.mAdbOsLocation == null) {
            Log.e(ADB, "Cannot stop adb when AndroidDebugBridge is created without the location of adb.");
            return false;
        }
        if (sAdbServerPort == 0) {
            Log.e(ADB, "ADB server port for restarting AndroidDebugBridge is not set");
            return false;
        }
        int status = -1;
        Object[] command = this.getAdbLaunchCommand("kill-server");
        try {
            Process proc = Runtime.getRuntime().exec((String[])command);
            if (proc.waitFor(timeout, unit)) {
                status = proc.exitValue();
            } else {
                proc.destroy();
                status = -1;
            }
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String commandString = Joiner.on((char)' ').join(command);
        if (status != 0) {
            Log.w(DDMS, String.format("'%1$s' failed -- run manually if necessary", commandString));
            return false;
        }
        Log.d(DDMS, String.format("'%1$s' succeeded", commandString));
        return true;
    }

    private static int grabProcessOutput(final Process process, final ArrayList<String> errorOutput, final ArrayList<String> stdOutput, boolean waitForReaders, long timeout, TimeUnit unit) throws InterruptedException {
        assert (errorOutput != null);
        assert (stdOutput != null);
        TimeoutRemainder rem = new TimeoutRemainder(timeout, unit);
        Thread t1 = new Thread("adb:stderr reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InputStreamReader is = new InputStreamReader(process.getErrorStream(), Charsets.UTF_8);
                BufferedReader errReader = new BufferedReader(is);
                try {
                    String line;
                    while ((line = errReader.readLine()) != null) {
                        Log.e(AndroidDebugBridgeImpl.ADB, line);
                        errorOutput.add(line);
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    Closeables.closeQuietly((Reader)errReader);
                }
            }
        };
        Thread t2 = new Thread("adb:stdout reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InputStreamReader is = new InputStreamReader(process.getInputStream(), Charsets.UTF_8);
                BufferedReader outReader = new BufferedReader(is);
                try {
                    String line;
                    while ((line = outReader.readLine()) != null) {
                        Log.d(AndroidDebugBridgeImpl.ADB, line);
                        stdOutput.add(line);
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    Closeables.closeQuietly((Reader)outReader);
                }
            }
        };
        t1.start();
        t2.start();
        if (waitForReaders) {
            long remMillis;
            try {
                remMillis = rem.getRemainingUnits(TimeUnit.MILLISECONDS);
                if (remMillis > 0L) {
                    t1.join(remMillis);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            remMillis = rem.getRemainingUnits(TimeUnit.MILLISECONDS);
            try {
                if (remMillis > 0L) {
                    t2.join(remMillis);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (process.waitFor(rem.getRemainingNanos(), TimeUnit.NANOSECONDS)) {
            return process.exitValue();
        }
        Log.w(ADB, "Process did not terminate within specified timeout, killing it");
        process.destroyForcibly();
        return -1;
    }

    private static void initAdbPort(int userManagedAdbPort) {
        if (!sUnitTestMode) {
            sAdbServerPort = sUserManagedAdbMode ? userManagedAdbPort : AndroidDebugBridgeImpl.getAdbServerPort();
        }
    }

    private static int getAdbServerPort() {
        String msg;
        Integer prop = Integer.getInteger(SERVER_PORT_ENV_VAR);
        if (prop != null) {
            try {
                return AndroidDebugBridgeImpl.validateAdbServerPort(prop.toString());
            }
            catch (IllegalArgumentException e) {
                msg = String.format("Invalid value (%1$s) for ANDROID_ADB_SERVER_PORT system property.", prop);
                Log.w(DDMS, msg);
            }
        }
        try {
            String env = System.getenv(SERVER_PORT_ENV_VAR);
            if (env != null) {
                return AndroidDebugBridgeImpl.validateAdbServerPort(env);
            }
        }
        catch (SecurityException ex) {
            Log.w(DDMS, "No access to env variables allowed by current security manager. If you've set ANDROID_ADB_SERVER_PORT: it's being ignored.");
        }
        catch (IllegalArgumentException e) {
            msg = String.format("Invalid value (%1$s) for ANDROID_ADB_SERVER_PORT environment variable (%2$s).", prop, e.getMessage());
            Log.w(DDMS, msg);
        }
        return 5037;
    }

    private static int validateAdbServerPort(String adbServerPort) throws IllegalArgumentException {
        try {
            int port = Integer.decode(adbServerPort);
            if (port <= 0 || port >= 65535) {
                throw new IllegalArgumentException("Should be > 0 and < 65535");
            }
            return port;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Not a valid port number");
        }
    }

    private void logRun(AdbDelegateUsageTracker.Method method, Runnable block) {
        try {
            block.run();
            this.maybeLogUsage(method, false);
        }
        catch (Throwable t) {
            this.maybeLogUsage(method, true);
            throw t;
        }
    }

    private <R> R logCall(AdbDelegateUsageTracker.Method method, Supplier<R> block) {
        try {
            R result = block.get();
            this.maybeLogUsage(method, false);
            return result;
        }
        catch (Throwable t) {
            this.maybeLogUsage(method, true);
            throw t;
        }
    }

    private <R> R logCall1(AdbDelegateUsageTracker.Method method, ThrowingSupplier1<R> block) throws IOException {
        try {
            R result = block.get();
            this.maybeLogUsage(method, false);
            return result;
        }
        catch (Throwable t) {
            this.maybeLogUsage(method, true);
            throw t;
        }
    }

    private void maybeLogUsage(AdbDelegateUsageTracker.Method method, boolean isException) {
        if (adbDelegateUsageTracker != null) {
            adbDelegateUsageTracker.logUsage(method, isException);
        }
    }

    static {
        sAdbServerPort = 0;
        sUserManagedAdbMode = false;
        sLastKnownGoodAddressLock = new Object();
        sInitialized = false;
        sLock = new Object();
    }

    @FunctionalInterface
    private static interface ThrowingSupplier1<T> {
        public T get() throws IOException;
    }

    private static class MonitorErrorHandler
    implements DeviceMonitor.MonitorErrorHandler {
        private MonitorErrorHandler() {
        }

        @Override
        public void initializationError(Exception e) {
            AndroidDebugBridgeBase.adbChangeEvents.notifyBridgeInitializationError(e);
        }
    }

    static interface AdbOutputProcessor<T> {
        public T process(Process var1, BufferedReader var2) throws IOException;
    }
}

